/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.run.deployable.SwappableProcessHandler;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSessionInfo {
    public static final Key<AndroidSessionInfo> KEY = new Key("KEY");
    public static final Key<AndroidVersion> ANDROID_DEVICE_API_LEVEL = new Key("ANDROID_DEVICE_API_LEVEL");
    @NotNull
    private final ProcessHandler myProcessHandler;
    @NotNull
    private final String myExecutorId;
    @Nullable
    private final RunConfiguration myRunConfiguration;
    @NotNull
    private final ExecutionTarget myExecutionTarget;

    @NotNull
    public static AndroidSessionInfo create(@NotNull ProcessHandler processHandler2, @Nullable RunConfiguration runConfiguration, @NotNull String executorId, @NotNull ExecutionTarget executionTarget) {
        AndroidSessionInfo result2 = new AndroidSessionInfo(processHandler2, runConfiguration, executorId, executionTarget);
        processHandler2.putUserData(KEY, (Object)result2);
        return result2;
    }

    private AndroidSessionInfo(@NotNull ProcessHandler processHandler2, @Nullable RunConfiguration runConfiguration, @NotNull String executorId, @NotNull ExecutionTarget executionTarget) {
        this.myProcessHandler = processHandler2;
        this.myRunConfiguration = runConfiguration;
        this.myExecutorId = executorId;
        this.myExecutionTarget = executionTarget;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @NotNull
    public String getExecutorId() {
        return this.myExecutorId;
    }

    @Nullable
    public Executor getExecutor() {
        return ExecutorRegistry.getInstance().getExecutorById(this.getExecutorId());
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        return this.myExecutionTarget;
    }

    @Nullable
    public RunConfiguration getRunConfiguration() {
        return this.myRunConfiguration;
    }

    @Nullable
    public static List<AndroidSessionInfo> findActiveSession(@NotNull Project project) {
        return Arrays.stream(ExecutionManager.getInstance((Project)project).getRunningProcesses()).map(handler2 -> (AndroidSessionInfo)handler2.getUserData(KEY)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static AndroidSessionInfo findOldSession(@NotNull Project project, @Nullable Executor executor2, @NotNull RunConfiguration runConfiguration, @NotNull ExecutionTarget executionTarget) {
        List infos = Arrays.stream(ExecutionManager.getInstance((Project)project).getRunningProcesses()).filter(handler2 -> !handler2.isProcessTerminating() && !handler2.isProcessTerminated()).map(handler2 -> (AndroidSessionInfo)handler2.getUserData(KEY)).filter(info2 -> info2 != null && runConfiguration == info2.getRunConfiguration() && (executor2 == null || executor2.getId().equals(info2.getExecutorId()))).collect(Collectors.toList());
        if (executionTarget instanceof AndroidExecutionTarget) {
            for (AndroidSessionInfo info3 : infos) {
                ExecutionTarget sessionExecutionTarget = info3.getExecutionTarget();
                if (!(sessionExecutionTarget instanceof AndroidExecutionTarget ? sessionExecutionTarget.getId().equals(executionTarget.getId()) : AndroidSessionInfo.checkIfIDeviceRunningInProcessHandler(runConfiguration, (AndroidExecutionTarget)executionTarget, info3.getProcessHandler()))) continue;
                return info3;
            }
            return null;
        }
        for (AndroidSessionInfo info4 : infos) {
            ExecutionTarget sessionExecutionTarget = info4.getExecutionTarget();
            if (sessionExecutionTarget instanceof AndroidExecutionTarget) {
                assert (info4.myRunConfiguration != null);
                if (!AndroidSessionInfo.checkIfIDeviceRunningInProcessHandler(info4.myRunConfiguration, (AndroidExecutionTarget)sessionExecutionTarget, info4.getProcessHandler())) continue;
                return info4;
            }
            return info4;
        }
        return null;
    }

    private static boolean checkIfIDeviceRunningInProcessHandler(@NotNull RunConfiguration runConfiguration, @NotNull AndroidExecutionTarget executionTarget, @NotNull ProcessHandler processHandler2) {
        if (processHandler2 instanceof SwappableProcessHandler) {
            return ((SwappableProcessHandler)processHandler2).isRunningWith(runConfiguration, executionTarget);
        }
        return false;
    }
}

