/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableListener;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableRowSorter;
import com.android.tools.idea.editors.strings.table.GridPasteUtils;
import com.android.tools.idea.editors.strings.table.SubTable;
import com.android.tools.idea.editors.strings.table.SubTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntUnaryOperator;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenColumnTable<M extends TableModel> {
    private M myModel;
    private final int myFrozenColumnCount;
    private final Collection<FrozenColumnTableListener> myListeners;
    private SubTable myFrozenTable;
    private SubTable myScrollableTable;
    private JScrollPane myScrollPane;
    private int rowHeight;
    private int mySelectedRow;
    private int mySelectedColumn;
    @Nullable
    private FrozenColumnTableRowSorter<M> myRowSorter;

    FrozenColumnTable(@NotNull M model2, int frozenColumnCount) {
        this.myModel = model2;
        this.myFrozenColumnCount = frozenColumnCount;
        this.myListeners = new ArrayList<FrozenColumnTableListener>();
        this.initFrozenTable();
        this.initScrollableTable();
        this.initScrollPane();
        this.mySelectedRow = -1;
        this.mySelectedColumn = -1;
    }

    private void initFrozenTable() {
        this.myFrozenTable = new SubTable(new SubTableModel((TableModel)this.myModel, () -> 0, () -> this.myFrozenColumnCount), this);
        this.myFrozenTable.setName("frozenTable");
        IntUnaryOperator converter = IntUnaryOperator.identity();
        this.myFrozenTable.getTableHeader().addMouseListener(new HeaderPopupTriggerListener(converter));
        this.myFrozenTable.getSelectionModel().addListSelectionListener(event -> {
            this.myScrollableTable.setSelectedRow(this.myFrozenTable.getSelectedRow());
            this.fireSelectedCellChanged();
        });
        this.myFrozenTable.getColumnModel().getSelectionModel().addListSelectionListener(event -> {
            if (this.myFrozenTable.getSelectedColumn() == -1) {
                return;
            }
            this.myScrollableTable.getColumnModel().getSelectionModel().clearSelection();
            this.fireSelectedCellChanged();
        });
        this.myFrozenTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@NotNull ComponentEvent event) {
                JViewport header = FrozenColumnTable.this.myScrollPane.getRowHeader();
                Dimension size = ((Component)header).getPreferredSize();
                size.width = FrozenColumnTable.this.myFrozenTable.getWidth();
                ((Component)header).setPreferredSize(size);
                FrozenColumnTable.this.myScrollPane.revalidate();
            }
        });
        this.myFrozenTable.addMouseListener(new CellPopupTriggerListener(converter));
    }

    private void initScrollableTable() {
        this.myScrollableTable = new SubTable(new SubTableModel((TableModel)this.myModel, () -> this.myFrozenColumnCount, () -> this.myModel.getColumnCount()), this);
        this.myScrollableTable.setName("scrollableTable");
        IntUnaryOperator converter = viewColumnIndex -> this.myFrozenTable.getColumnCount() + viewColumnIndex;
        this.myScrollableTable.getTableHeader().addMouseListener(new HeaderPopupTriggerListener(converter));
        this.myScrollableTable.getSelectionModel().addListSelectionListener(event -> {
            this.myFrozenTable.setSelectedRow(this.myScrollableTable.getSelectedRow());
            this.fireSelectedCellChanged();
        });
        this.myScrollableTable.getColumnModel().getSelectionModel().addListSelectionListener(event -> {
            if (this.myScrollableTable.getSelectedColumn() == -1) {
                return;
            }
            this.myFrozenTable.getColumnModel().getSelectionModel().clearSelection();
            this.fireSelectedCellChanged();
        });
        this.myScrollableTable.addMouseListener(new CellPopupTriggerListener(converter));
    }

    private void fireSelectedCellChanged() {
        int selectedRow = this.getSelectedRow();
        int selectedColumn = this.getSelectedColumn();
        if (this.mySelectedRow == selectedRow && this.mySelectedColumn == selectedColumn) {
            return;
        }
        this.mySelectedRow = selectedRow;
        this.mySelectedColumn = selectedColumn;
        this.myListeners.forEach(FrozenColumnTableListener::selectedCellChanged);
    }

    private void initScrollPane() {
        this.myScrollPane = new JBScrollPane((Component)((Object)this.myScrollableTable));
        this.myScrollPane.setCorner("UPPER_LEFT_CORNER", this.myFrozenTable.getTableHeader());
        this.myScrollPane.setRowHeaderView((Component)((Object)this.myFrozenTable));
    }

    boolean includeColumn(int modelColumnIndex) {
        return true;
    }

    @NotNull
    TableColumn createColumn(int modelColumnIndex) {
        return new TableColumn(modelColumnIndex);
    }

    public final void selectCellAt(int viewRowIndex, int viewColumnIndex) {
        int count2 = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count2) {
            this.myFrozenTable.setRowSelectionInterval(viewRowIndex, viewRowIndex);
            this.myFrozenTable.setColumnSelectionInterval(viewColumnIndex, viewColumnIndex);
            return;
        }
        this.myScrollableTable.setRowSelectionInterval(viewRowIndex, viewRowIndex);
        this.myScrollableTable.setColumnSelectionInterval(viewColumnIndex -= count2, viewColumnIndex);
    }

    public final int getSelectedModelRowIndex() {
        int index2 = this.myFrozenTable.getSelectedModelRowIndex();
        assert (index2 == this.myScrollableTable.getSelectedModelRowIndex());
        return index2;
    }

    public final int getSelectedModelColumnIndex() {
        int index2 = this.myFrozenTable.getSelectedModelColumnIndex();
        return index2 == -1 ? this.myScrollableTable.getSelectedModelColumnIndex() : index2;
    }

    public final int getFrozenColumnCount() {
        return this.myFrozenTable.getColumnCount();
    }

    @NotNull
    public final TableColumn getColumn(int viewColumnIndex) {
        if (viewColumnIndex < this.myFrozenTable.getColumnCount()) {
            return this.myFrozenTable.getColumnModel().getColumn(viewColumnIndex);
        }
        return this.myScrollableTable.getColumnModel().getColumn(viewColumnIndex - this.myFrozenTable.getColumnCount());
    }

    final int convertRowIndexToModel(int viewRowIndex) {
        int modelRowIndex = this.myFrozenTable.convertRowIndexToModel(viewRowIndex);
        assert (modelRowIndex == this.myScrollableTable.convertRowIndexToModel(viewRowIndex));
        return modelRowIndex;
    }

    final int convertColumnIndexToModel(int viewColumnIndex) {
        SubTable table2;
        int count2 = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count2) {
            table2 = this.myFrozenTable;
        } else {
            table2 = this.myScrollableTable;
            viewColumnIndex -= count2;
        }
        return ((SubTableModel)((JTable)((Object)table2)).getModel()).convertColumnIndexToDelegate(((JTable)((Object)table2)).convertColumnIndexToModel(viewColumnIndex));
    }

    @NotNull
    final TableCellRenderer getDefaultTableHeaderRenderer() {
        return this.myFrozenTable.getTableHeader().getDefaultRenderer();
    }

    @NotNull
    final TableCellRenderer getCellRenderer(int viewRowIndex, int viewColumnIndex) {
        int count2 = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count2) {
            return this.myFrozenTable.getCellRenderer(viewRowIndex, viewColumnIndex);
        }
        return this.myScrollableTable.getCellRenderer(viewRowIndex, viewColumnIndex - count2);
    }

    final int getPreferredWidth(@NotNull TableCellRenderer renderer2, @NotNull Object value2, int viewRowIndex, int viewColumnIndex) {
        SubTable table2;
        int count2 = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count2) {
            table2 = this.myFrozenTable;
        } else {
            table2 = this.myScrollableTable;
            viewColumnIndex -= count2;
        }
        return renderer2.getTableCellRendererComponent((JTable)((Object)table2), (Object)value2, (boolean)false, (boolean)false, (int)viewRowIndex, (int)viewColumnIndex).getPreferredSize().width + 2;
    }

    @NotNull
    public final JTable getFrozenTable() {
        return this.myFrozenTable;
    }

    @NotNull
    public final JTable getScrollableTable() {
        return this.myScrollableTable;
    }

    @NotNull
    public final Component getScrollPane() {
        return this.myScrollPane;
    }

    final int getRowHeight() {
        return this.rowHeight;
    }

    final void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    final void putInInputMap(@NotNull KeyStroke keyStroke, @NotNull Object actionMapKey) {
        this.myFrozenTable.getInputMap().put(keyStroke, actionMapKey);
        this.myScrollableTable.getInputMap().put(keyStroke, actionMapKey);
    }

    public final void putInActionMap(@NotNull Object key, @NotNull Action action2) {
        this.myFrozenTable.getActionMap().put(key, action2);
        this.myScrollableTable.getActionMap().put(key, action2);
    }

    public final void addFrozenColumnTableListener(@NotNull FrozenColumnTableListener listener2) {
        this.myListeners.add(listener2);
    }

    @NotNull
    final Iterable<FrozenColumnTableListener> getListeners() {
        return this.myListeners;
    }

    boolean isPastePossible() {
        return false;
    }

    final void paste(@NotNull Transferable transferable2) {
        if (!this.hasSelectedCell() || !transferable2.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        int row2 = this.getSelectedRow();
        int rowCount = this.getRowCount();
        int selectedColumn = this.getSelectedColumn();
        int columnCount = this.getColumnCount();
        List<List<String>> grid = GridPasteUtils.splitIntoGrid(FrozenColumnTable.getTransferDataAsString(transferable2));
        for (List<String> gridRow : grid) {
            if (row2 >= rowCount) break;
            int column2 = selectedColumn;
            for (String gridCell : gridRow) {
                if (column2 >= columnCount) break;
                this.setValueAt(gridCell, row2, column2++);
            }
            ++row2;
        }
    }

    @NotNull
    private static String getTransferDataAsString(@NotNull Transferable transferable2) {
        try {
            return (String)transferable2.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logger.getInstance(FrozenColumnTable.class).warn((Throwable)exception);
            return "";
        }
    }

    final void createDefaultColumnsFromModel() {
        this.myFrozenTable.createDefaultColumnsFromModel();
        this.myScrollableTable.createDefaultColumnsFromModel();
    }

    final void setDefaultRenderer(@NotNull Class<?> c, @NotNull TableCellRenderer renderer2) {
        this.myFrozenTable.setDefaultRenderer(c, renderer2);
        this.myScrollableTable.setDefaultRenderer(c, renderer2);
    }

    final void setDefaultEditor(@NotNull Class<?> c, @NotNull TableCellEditor editor) {
        this.myFrozenTable.setDefaultEditor(c, editor);
        this.myScrollableTable.setDefaultEditor(c, editor);
    }

    @Nullable
    final FrozenColumnTableRowSorter<M> getRowSorter() {
        return this.myRowSorter;
    }

    final void setRowSorter(@Nullable FrozenColumnTableRowSorter<M> rowSorter) {
        if (rowSorter == null) {
            this.myFrozenTable.setRowSorter(null);
            this.myScrollableTable.setRowSorter(null);
        } else {
            this.myFrozenTable.setRowSorter(rowSorter.getFrozenTableRowSorter());
            this.myScrollableTable.setRowSorter(rowSorter.getScrollableTableRowSorter());
        }
        this.myRowSorter = rowSorter;
    }

    public final boolean hasSelectedCell() {
        return this.myFrozenTable.hasSelectedCell() || this.myScrollableTable.hasSelectedCell();
    }

    public final int getSelectedRow() {
        int row2 = this.myFrozenTable.getSelectedRow();
        assert (row2 == this.myScrollableTable.getSelectedRow());
        return row2;
    }

    public final int getSelectedColumn() {
        int column2 = this.myFrozenTable.getSelectedColumn();
        if (column2 != -1) {
            return column2;
        }
        column2 = this.myScrollableTable.getSelectedColumn();
        if (column2 != -1) {
            return this.myFrozenTable.getColumnCount() + column2;
        }
        return -1;
    }

    public final int getRowCount() {
        int count2 = this.myFrozenTable.getRowCount();
        assert (count2 == this.myScrollableTable.getRowCount());
        return count2;
    }

    public final int getColumnCount() {
        return this.myFrozenTable.getColumnCount() + this.myScrollableTable.getColumnCount();
    }

    @NotNull
    public final String getColumnName(int viewColumnIndex) {
        int count2 = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count2) {
            return this.myFrozenTable.getColumnName(viewColumnIndex);
        }
        return this.myScrollableTable.getColumnName(viewColumnIndex - count2);
    }

    @VisibleForTesting
    @NotNull
    public final List<Object> getColumnAt(int viewColumnIndex) {
        int count2 = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count2) {
            return this.myFrozenTable.getColumnAt(viewColumnIndex);
        }
        return this.myScrollableTable.getColumnAt(viewColumnIndex - count2);
    }

    @NotNull
    public final Object getValueAt(int viewRowIndex, int viewColumnIndex) {
        int count2 = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count2) {
            return this.myFrozenTable.getValueAt(viewRowIndex, viewColumnIndex);
        }
        return this.myScrollableTable.getValueAt(viewRowIndex, viewColumnIndex - count2);
    }

    private void setValueAt(@NotNull Object value2, int viewRowIndex, int viewColumnIndex) {
        int count2 = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count2) {
            this.myFrozenTable.setValueAt(value2, viewRowIndex, viewColumnIndex);
            return;
        }
        this.myScrollableTable.setValueAt(value2, viewRowIndex, viewColumnIndex - count2);
    }

    public final boolean editCellAt(int viewRowIndex, int viewColumnIndex) {
        int count2 = this.myFrozenTable.getColumnCount();
        if (viewColumnIndex < count2) {
            return this.myFrozenTable.editCellAt(viewRowIndex, viewColumnIndex);
        }
        return this.myScrollableTable.editCellAt(viewRowIndex, viewColumnIndex - count2);
    }

    @NotNull
    public final M getModel() {
        return this.myModel;
    }

    public void setModel(@NotNull M model2) {
        this.myModel = model2;
        this.myFrozenTable.setModel(new SubTableModel((TableModel)model2, () -> 0, () -> this.myFrozenColumnCount));
        this.myScrollableTable.setModel(new SubTableModel((TableModel)model2, () -> this.myFrozenColumnCount, () -> model2.getColumnCount()));
    }

    @Nullable
    public final TableCellEditor getCellEditor() {
        if (this.myFrozenTable.isEditing()) {
            return this.myFrozenTable.getCellEditor();
        }
        return this.myScrollableTable.getCellEditor();
    }

    @NotNull
    final Font getFont() {
        Font font = this.myFrozenTable.getFont();
        assert (font.equals(this.myScrollableTable.getFont()));
        return font;
    }

    private static final class CellPopupTriggerListener<M extends TableModel>
    extends MouseAdapter {
        private final IntUnaryOperator myConverter;

        private CellPopupTriggerListener(@NotNull IntUnaryOperator converter) {
            this.myConverter = converter;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        private void mousePressedOrReleased(@NotNull MouseEvent event) {
            if (!event.isPopupTrigger()) {
                return;
            }
            SubTable subTable = (SubTable)((Object)event.getSource());
            Point point = event.getPoint();
            FrozenColumnTable source = subTable.getFrozenColumnTable();
            int viewRowIndex = subTable.rowAtPoint(point);
            int viewColumnIndex = this.myConverter.applyAsInt(subTable.columnAtPoint(point));
            FrozenColumnTableEvent frozenColumnTableEvent = new FrozenColumnTableEvent(source, viewRowIndex, viewColumnIndex, point, (Component)((Object)subTable));
            source.getListeners().forEach(listener2 -> listener2.cellPopupTriggered(frozenColumnTableEvent));
        }
    }

    private static final class HeaderPopupTriggerListener<M extends TableModel>
    extends MouseAdapter {
        private final IntUnaryOperator myConverter;

        private HeaderPopupTriggerListener(@NotNull IntUnaryOperator converter) {
            this.myConverter = converter;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            this.mousePressedOrReleased(event);
        }

        private void mousePressedOrReleased(@NotNull MouseEvent event) {
            Point point;
            if (!event.isPopupTrigger()) {
                return;
            }
            JTableHeader header = (JTableHeader)event.getSource();
            int subTableIndex = header.columnAtPoint(point = event.getPoint());
            if (subTableIndex == -1) {
                return;
            }
            SubTable subTable = (SubTable)((Object)header.getTable());
            FrozenColumnTable source = subTable.getFrozenColumnTable();
            int frozenColumnTableIndex = this.myConverter.applyAsInt(subTableIndex);
            FrozenColumnTableEvent frozenColumnTableEvent = new FrozenColumnTableEvent(source, -1, frozenColumnTableIndex, point, header);
            source.getListeners().forEach(listener2 -> listener2.headerPopupTriggered(frozenColumnTableEvent));
        }
    }
}

