/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.Locale;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.editors.strings.DeleteStringAction;
import com.android.tools.idea.editors.strings.GoToDeclarationAction;
import com.android.tools.idea.editors.strings.MultilineStringEditorDialog;
import com.android.tools.idea.editors.strings.RemoveLocaleMouseListener;
import com.android.tools.idea.editors.strings.ResourceLoadingTask;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceEditor;
import com.android.tools.idea.editors.strings.TranslationsEditorTextField;
import com.android.tools.idea.editors.strings.action.AddKeyAction;
import com.android.tools.idea.editors.strings.action.AddLocaleAction;
import com.android.tools.idea.editors.strings.action.FilterKeysAction;
import com.android.tools.idea.editors.strings.action.FilterLocalesAction;
import com.android.tools.idea.editors.strings.action.ReloadStringResourcesAction;
import com.android.tools.idea.editors.strings.action.RemoveKeysAction;
import com.android.tools.idea.editors.strings.action.TranslationsEditorPasteAction;
import com.android.tools.idea.editors.strings.model.StringResourceKey;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableListener;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceViewPanel
implements Disposable {
    private final AndroidFacet myFacet;
    private StringResourceTable myTable;
    @Nullable
    private Component myToolbar;
    @Nullable
    private Component myScrollPane;
    @NotNull
    private final JComponent myXmlLabel;
    @VisibleForTesting
    final JTextComponent myXmlTextField;
    @NotNull
    private final Component myKeyLabel;
    private JTextComponent myKeyTextField;
    @NotNull
    private final Component myDefaultValueLabel;
    @VisibleForTesting
    TextFieldWithBrowseButton myDefaultValueTextField;
    @NotNull
    private final Component myTranslationLabel;
    private TextFieldWithBrowseButton myTranslationTextField;
    @Nullable
    private Container myPanel;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    private GoToDeclarationAction myGoToAction;
    private DeleteStringAction myDeleteAction;

    StringResourceViewPanel(AndroidFacet facet2, Disposable parentDisposable) {
        this.myFacet = facet2;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.initTable();
        this.initToolbar();
        this.myXmlLabel = new JBLabel("XML:", 4);
        this.myXmlTextField = new JBTextField();
        this.myXmlTextField.setEnabled(false);
        this.myXmlTextField.setName("xmlTextField");
        this.myKeyLabel = new JBLabel("Key:", 4);
        this.initKeyTextField();
        this.myDefaultValueLabel = new JBLabel("Default value:", 4);
        this.initDefaultValueTextField();
        this.myTranslationLabel = new JBLabel("Translation:", 4);
        this.initTranslationTextField();
        this.initPanel();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 200);
        this.myLoadingPanel.setLoadingText("Loading string resource data");
        this.myLoadingPanel.setName("translationsEditor");
        this.myLoadingPanel.add((Component)this.myPanel);
        this.myLoadingPanel.startLoading();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            new ResourceLoadingTask(this).queue();
        }
    }

    public void dispose() {
    }

    private void initTable() {
        this.myDeleteAction = new DeleteStringAction(this);
        this.myGoToAction = new GoToDeclarationAction(this.myFacet.getModule().getProject());
        this.myTable = new StringResourceTable();
        this.myTable.putInActionMap("delete", this.myDeleteAction);
        this.myTable.addFrozenColumnTableListener(new CellSelectionListener());
        this.myTable.addFrozenColumnTableListener(new RemoveLocaleMouseListener(this));
        final JPopupMenu menu = new JPopupMenu();
        final JMenuItem goTo = menu.add(this.myGoToAction);
        final JMenuItem delete2 = menu.add(this.myDeleteAction);
        this.myTable.addFrozenColumnTableListener(new FrozenColumnTableListener(){

            @Override
            public void cellPopupTriggered(@NotNull FrozenColumnTableEvent event) {
                StringResourceViewPanel.this.myGoToAction.update(goTo, event);
                StringResourceViewPanel.this.myDeleteAction.update(delete2, event);
                if (goTo.isVisible() || delete2.isVisible()) {
                    Point point = event.getPoint();
                    menu.show(event.getSubcomponent(), point.x, point.y);
                }
            }
        });
        this.myScrollPane = this.myTable.getScrollPane();
    }

    private void initToolbar() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new AddKeyAction());
        group2.add((AnAction)new RemoveKeysAction());
        group2.add((AnAction)new AddLocaleAction());
        group2.add((AnAction)new FilterKeysAction());
        group2.add((AnAction)new FilterLocalesAction());
        group2.add((AnAction)new ReloadStringResourcesAction());
        group2.add((AnAction)new BrowserHelpAction("Translations editor", "https://developer.android.com/r/studio-ui/translations-editor.html"));
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("TranslationsEditorToolbar", (ActionGroup)group2, true);
        this.myToolbar = toolbar2.getComponent();
        this.myToolbar.setName("toolbar");
    }

    private void initKeyTextField() {
        this.myKeyTextField = new TranslationsEditorTextField(this.myTable, () -> 0);
        this.myKeyTextField.setEnabled(false);
        this.myKeyTextField.setName("keyTextField");
    }

    private void initDefaultValueTextField() {
        TranslationsEditorTextField textField2 = new TranslationsEditorTextField(this.myTable, () -> 3);
        new TranslationsEditorPasteAction().registerCustomShortcutSet((JComponent)((Object)textField2), this);
        this.myDefaultValueTextField = new TextFieldWithBrowseButton((JTextField)((Object)textField2), (ActionListener)new ShowMultilineActionListener(), (Disposable)this);
        this.myDefaultValueTextField.setButtonIcon(AllIcons.Actions.ShowViewer);
        this.myDefaultValueTextField.setName("defaultValueTextField");
    }

    private void initTranslationTextField() {
        TranslationsEditorTextField textField2 = new TranslationsEditorTextField(this.myTable, this.myTable::getSelectedModelColumnIndex);
        new TranslationsEditorPasteAction().registerCustomShortcutSet((JComponent)((Object)textField2), this);
        this.myTranslationTextField = new TextFieldWithBrowseButton((JTextField)((Object)textField2), (ActionListener)new ShowMultilineActionListener(), (Disposable)this);
        this.myTranslationTextField.setButtonIcon(AllIcons.Actions.ShowViewer);
        this.myTranslationTextField.setEnabled(false);
        this.myTranslationTextField.setName("translationTextField");
    }

    private void initPanel() {
        this.myPanel = new JBPanel();
        GroupLayout layout = new GroupLayout(this.myPanel);
        layout.linkSize(0, this.myXmlLabel, this.myKeyLabel, this.myDefaultValueLabel, this.myTranslationLabel);
        layout.linkSize(1, this.myXmlLabel, this.myXmlTextField);
        layout.linkSize(1, this.myKeyLabel, this.myKeyTextField);
        layout.linkSize(1, new Component[]{this.myDefaultValueLabel, this.myDefaultValueTextField});
        layout.linkSize(1, new Component[]{this.myTranslationLabel, this.myTranslationTextField});
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup().addComponent(this.myToolbar).addComponent(this.myScrollPane).addGroup(layout.createSequentialGroup().addComponent(this.myXmlLabel).addComponent(this.myXmlTextField)).addGroup(layout.createSequentialGroup().addComponent(this.myKeyLabel).addComponent(this.myKeyTextField)).addGroup(layout.createSequentialGroup().addComponent(this.myDefaultValueLabel).addComponent((Component)this.myDefaultValueTextField)).addGroup(layout.createSequentialGroup().addComponent(this.myTranslationLabel).addComponent((Component)this.myTranslationTextField));
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addComponent(this.myToolbar, -2, -1, -2).addComponent(this.myScrollPane).addGroup(layout.createParallelGroup().addComponent(this.myXmlLabel).addComponent(this.myXmlTextField, -2, -1, -2)).addGroup(layout.createParallelGroup().addComponent(this.myKeyLabel).addComponent(this.myKeyTextField, -2, -1, -2)).addGroup(layout.createParallelGroup().addComponent(this.myDefaultValueLabel).addComponent((Component)this.myDefaultValueTextField, -2, -1, -2)).addGroup(layout.createParallelGroup().addComponent(this.myTranslationLabel).addComponent((Component)this.myTranslationTextField, -2, -1, -2));
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.myPanel.setLayout(layout);
    }

    public void reloadData() {
        this.myLoadingPanel.setLoadingText("Updating string resource data");
        this.myLoadingPanel.startLoading();
        new ResourceLoadingTask(this).queue();
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    JBLoadingPanel getLoadingPanel() {
        return this.myLoadingPanel;
    }

    @NotNull
    public StringResourceTable getTable() {
        return this.myTable;
    }

    @NotNull
    JComponent getPreferredFocusedComponent() {
        return this.myTable.getScrollableTable();
    }

    private static boolean isValueEditableInline(@NotNull String value2) {
        return !StringUtil.containsChar((String)value2, (char)'\n');
    }

    private static void setTextAndEditable(@NotNull JTextComponent component2, @NotNull String text2, boolean editable) {
        component2.setText(text2);
        component2.setCaretPosition(0);
        component2.setEditable(editable);
        component2.getCaret().setVisible(editable && component2.hasFocus());
        component2.setFont(StringResourceEditor.getFont(component2.getFont()));
    }

    private class ShowMultilineActionListener
    implements ActionListener {
        private ShowMultilineActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!StringResourceViewPanel.this.myTable.hasSelectedCell()) {
                return;
            }
            int row2 = StringResourceViewPanel.this.myTable.getSelectedModelRowIndex();
            int column2 = StringResourceViewPanel.this.myTable.getSelectedModelColumnIndex();
            StringResourceTableModel model2 = (StringResourceTableModel)StringResourceViewPanel.this.myTable.getModel();
            String value2 = (String)model2.getValueAt(row2, 3);
            Locale locale = model2.getLocale(column2);
            String translation = locale == null ? null : (String)model2.getValueAt(row2, column2);
            MultilineStringEditorDialog d = new MultilineStringEditorDialog(StringResourceViewPanel.this.myFacet, model2.getKey(row2).getName(), value2, locale, translation);
            if (d.showAndGet()) {
                if (!StringUtil.equals((CharSequence)value2, (CharSequence)d.getDefaultValue())) {
                    model2.setValueAt(d.getDefaultValue(), row2, 3);
                    StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), d.getDefaultValue(), StringResourceViewPanel.isValueEditableInline(d.getDefaultValue()));
                }
                if (locale != null && !StringUtil.equals((CharSequence)translation, (CharSequence)d.getTranslation())) {
                    model2.setValueAt(d.getTranslation(), row2, column2);
                    StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), d.getTranslation(), StringResourceViewPanel.isValueEditableInline(d.getTranslation()));
                }
            }
        }
    }

    private final class CellSelectionListener
    implements FrozenColumnTableListener {
        private CellSelectionListener() {
        }

        @Override
        public void selectedCellChanged() {
            if (!StringResourceViewPanel.this.myTable.hasSelectedCell()) {
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myXmlTextField, "", false);
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myKeyTextField, "", false);
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), "", false);
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), "", false);
                StringResourceViewPanel.this.myDefaultValueTextField.getButton().setEnabled(false);
                StringResourceViewPanel.this.myTranslationTextField.getButton().setEnabled(false);
                return;
            }
            StringResourceViewPanel.this.myXmlTextField.setEnabled(true);
            StringResourceViewPanel.this.myKeyTextField.setEnabled(true);
            StringResourceViewPanel.this.myDefaultValueTextField.setEnabled(true);
            StringResourceViewPanel.this.myTranslationTextField.setEnabled(true);
            StringResourceTableModel model2 = (StringResourceTableModel)StringResourceViewPanel.this.myTable.getModel();
            int row2 = StringResourceViewPanel.this.myTable.getSelectedModelRowIndex();
            int column2 = StringResourceViewPanel.this.myTable.getSelectedModelColumnIndex();
            Locale locale = model2.getLocale(column2);
            StringResourceKey key = model2.getKey(row2);
            StringResourceData data2 = model2.getData();
            if (data2 == null) {
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myXmlTextField, "", false);
            } else {
                StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myXmlTextField, data2.getStringResource(key).getTagText(locale), false);
            }
            StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myKeyTextField, key.getName(), false);
            String defaultValue = (String)model2.getValueAt(row2, 3);
            boolean defaultValueEditable = StringResourceViewPanel.isValueEditableInline(defaultValue);
            StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), defaultValue, defaultValueEditable);
            StringResourceViewPanel.this.myDefaultValueTextField.getButton().setEnabled(true);
            boolean translationEditable = false;
            String translation = "";
            if (locale != null) {
                translation = (String)model2.getValueAt(row2, column2);
                translationEditable = StringResourceViewPanel.isValueEditableInline(translation);
            }
            StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), translation, translationEditable);
            StringResourceViewPanel.this.myTranslationTextField.getButton().setEnabled(locale != null);
        }
    }
}

