/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceEditorProvider;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceEditorNotificationProvider
extends EditorNotifications.Provider<InfoPanel> {
    private static final Key<InfoPanel> KEY = Key.create((String)"android.editors.strings");
    private boolean myHide;

    @NotNull
    public Key<InfoPanel> getKey() {
        return KEY;
    }

    @Nullable
    public InfoPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (this.myHide || !StringResourceEditorProvider.canViewTranslations(project, file2)) {
            return null;
        }
        InfoPanel panel2 = new InfoPanel(fileEditor);
        panel2.setText("Edit translations for all locales in the translations editor.");
        panel2.createActionLabel("Open editor", () -> StringResourceEditorProvider.openEditor(project, file2));
        panel2.createActionLabel("Hide notification", () -> {
            panel2.setVisible(false);
            this.myHide = true;
        });
        return panel2;
    }

    public static class InfoPanel
    extends EditorNotificationPanel {
        public InfoPanel(@NotNull FileEditor fileEditor) {
            super(fileEditor, null, EditorColors.READONLY_BACKGROUND_COLOR);
        }

        @NotNull
        public Color getFallbackBackgroundColor() {
            return UIUtil.getPanelBackground();
        }
    }
}

