/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoToDeclarationAction
extends AbstractAction {
    private final Project myProject;
    @Nullable
    private ResourceItem myItemAtMouseClickLocation;

    public GoToDeclarationAction(@NotNull Project project) {
        super("Go to Declaration");
        this.myProject = project;
    }

    public void update(@NotNull JMenuItem goTo, @NotNull FrozenColumnTableEvent event) {
        int row2 = event.getModelRowIndex();
        int column2 = event.getModelColumnIndex();
        StringResourceTableModel model2 = (StringResourceTableModel)event.getSource().getModel();
        Locale locale = model2.getLocale(column2);
        StringResource resource = model2.getStringResourceAt(row2);
        this.myItemAtMouseClickLocation = locale == null ? resource.getDefaultValueAsResourceItem() : resource.getTranslationAsResourceItem(locale);
        goTo.setVisible(this.myItemAtMouseClickLocation != null);
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        assert (this.myItemAtMouseClickLocation != null);
        XmlTag tag = IdeResourcesUtil.getItemTag(this.myProject, this.myItemAtMouseClickLocation);
        if (tag == null) {
            return;
        }
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.myProject, tag.getContainingFile().getVirtualFile(), tag.getTextOffset());
        FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor2, true);
    }
}

