/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.manifmerger.Actions;
import com.android.manifmerger.IntentFilterNodeKeyResolver;
import com.android.manifmerger.XmlNode;
import com.android.tools.idea.editors.manifest.ManifestPanel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProviderManager;
import com.android.tools.idea.projectsystem.SourceProvidersKt;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.PositionXmlParser;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ManifestUtils {
    private ManifestUtils() {
    }

    @NotNull
    public static List<? extends Actions.Record> getRecords(@NotNull MergedManifestSnapshot manifest, @NotNull Node node) {
        Actions actions2 = manifest.getActions();
        if (actions2 != null) {
            Attr attribute;
            XmlNode.NodeName nodeName;
            ImmutableList attributeRecords;
            XmlNode.NodeKey parentKey;
            Element parentElement;
            Element element2;
            if (node instanceof Element) {
                element2 = (Element)node;
            } else if (node instanceof Attr) {
                Attr attribute2 = (Attr)node;
                element2 = attribute2.getOwnerElement();
            } else {
                return Collections.emptyList();
            }
            Node parentNode = element2.getParentNode();
            if (parentNode instanceof Element && "intent-filter".equals((parentElement = (Element)parentNode).getTagName()) && (parentKey = ManifestUtils.getNodeKey(manifest, parentElement)) != null) {
                return actions2.getNodeRecords(parentKey);
            }
            XmlNode.NodeKey key = ManifestUtils.getNodeKey(manifest, element2);
            if (key == null) {
                return Collections.emptyList();
            }
            if (node instanceof Attr && !(attributeRecords = actions2.getAttributeRecords(key, nodeName = XmlNode.fromXmlName((String)(attribute = (Attr)node).getName()))).isEmpty()) {
                return attributeRecords;
            }
            return actions2.getNodeRecords(key);
        }
        return Collections.emptyList();
    }

    @Nullable
    static XmlNode.NodeKey getNodeKey(@NotNull MergedManifestSnapshot manifest, @NotNull Element element2) {
        Object key = manifest.getNodeKey(element2.getNodeName());
        if (key == null) {
            Attr glEsVersionAttribute;
            Attr nameAttribute = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            key = nameAttribute != null ? manifest.getNodeKey(element2.getTagName() + "#" + nameAttribute.getValue()) : ((glEsVersionAttribute = element2.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "glEsVersion")) != null ? manifest.getNodeKey(element2.getTagName() + "#" + glEsVersionAttribute.getValue()) : ("intent-filter".equals(element2.getTagName()) ? manifest.getNodeKey(element2.getTagName() + "#" + IntentFilterNodeKeyResolver.INSTANCE.getKey(element2)) : null));
        }
        return key;
    }

    @Nullable
    public static Node getSourceNode(@NotNull Module module2, @NotNull Actions.Record record) {
        SourceFilePosition sourceFilePosition = record.getActionLocation();
        SourceFile sourceFile = sourceFilePosition.getFile();
        File file2 = sourceFile.getSourceFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        if (file2 != null && !SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
            VirtualFile vFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
            assert (vFile != null);
            Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)module2.getProject());
            if (fileModule != null && !fileModule.equals(module2)) {
                MergedManifestSnapshot manifest = MergedManifestManager.getSnapshot(fileModule);
                Document document2 = manifest.getDocument();
                assert (document2 != null);
                Element root = document2.getDocumentElement();
                assert (root != null);
                int startLine = sourcePosition.getStartLine();
                int startColumn = sourcePosition.getStartColumn();
                return PositionXmlParser.findNodeAtLineAndCol((Document)document2, (int)startLine, (int)startColumn);
            }
            int startLine = sourcePosition.getStartLine();
            int startColumn = sourcePosition.getStartColumn();
            try {
                byte[] bytes2 = Files.toByteArray((File)file2);
                Document document3 = PositionXmlParser.parse((byte[])bytes2);
                return PositionXmlParser.findNodeAtLineAndCol((Document)document3, (int)startLine, (int)startColumn);
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    static SourceFilePosition getActionLocation(@NotNull Module module2, @NotNull Actions.Record record) {
        int startColumn;
        AndroidFacet facet2;
        Module fileModule;
        SourceFilePosition sourceFilePosition = record.getActionLocation();
        SourceFile sourceFile = sourceFilePosition.getFile();
        File file2 = sourceFile.getSourceFile();
        SourcePosition sourcePosition = sourceFilePosition.getPosition();
        if (file2 == null || SourcePosition.UNKNOWN.equals((Object)sourcePosition)) {
            return sourceFilePosition;
        }
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
        Module module3 = fileModule = vFile == null ? null : ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)module2.getProject());
        if (module2.equals(fileModule)) {
            return sourceFilePosition;
        }
        AndroidFacet androidFacet = facet2 = fileModule == null ? null : AndroidFacet.getInstance((Module)fileModule);
        if (facet2 == null || !SourceProvidersKt.isManifestFile(facet2, vFile)) {
            return sourceFilePosition;
        }
        MergedManifestSnapshot manifest = MergedManifestManager.getSnapshot(fileModule);
        Document document2 = manifest.getDocument();
        assert (document2 != null);
        Element root = document2.getDocumentElement();
        assert (root != null);
        int startLine = sourcePosition.getStartLine();
        Node node = PositionXmlParser.findNodeAtLineAndCol((Document)document2, (int)startLine, (int)(startColumn = sourcePosition.getStartColumn()));
        if (node == null) {
            Logger.getInstance(ManifestPanel.class).warn("Can not find node in " + fileModule + " for " + sourceFilePosition);
            return sourceFilePosition;
        }
        List<? extends Actions.Record> records = ManifestUtils.getRecords(manifest, node);
        if (!records.isEmpty()) {
            return ManifestUtils.getActionLocation(fileModule, records.get(0));
        }
        return sourceFilePosition;
    }

    @Nullable
    public static NamedIdeaSourceProvider findManifestSourceProvider(@NotNull AndroidFacet facet2, @NotNull VirtualFile manifestFile) {
        return SourceProvidersKt.findByFile(SourceProviderManager.getInstance(facet2).getCurrentSourceProviders(), manifestFile);
    }

    @NotNull
    static XmlFile getMainManifest(@NotNull AndroidFacet facet2) {
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet2);
        assert (manifestFile != null);
        PsiFile psiFile = PsiManager.getInstance((Project)facet2.getModule().getProject()).findFile(manifestFile);
        assert (psiFile != null);
        return (XmlFile)psiFile;
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Node item2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (item2 instanceof Element) {
            ManifestUtils.toolsRemove(manifest, (Element)item2);
        } else if (item2 instanceof Attr) {
            Attr attribute = (Attr)item2;
            Element element2 = attribute.getOwnerElement();
            if ("name".equals(attribute.getLocalName()) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI()) || Lint.getChildCount((Node)element2) == 0 && element2.getAttributes().getLength() == 1) {
                ManifestUtils.toolsRemove(manifest, element2);
            } else {
                ManifestUtils.toolsRemove(manifest, attribute);
            }
        }
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Element item2) {
        ManifestUtils.addToolsAttribute(manifest, item2, "node", "remove");
    }

    static void toolsRemove(@NotNull XmlFile manifest, @NotNull Attr item2) {
        ManifestUtils.addToolsAttribute(manifest, item2.getOwnerElement(), "remove", item2.getName());
    }

    static void addToolsAttribute(@NotNull XmlFile manifest, @NotNull Element item2, @NotNull String attributeName, @NotNull String attributeValue) {
        if (attributeName.contains(":")) {
            throw new IllegalArgumentException("should not have namespace as it's always tools");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        IdeResourcesUtil.ensureNamespaceImported(manifest, "http://schemas.android.com/tools", null);
        XmlTag parent2 = null;
        XmlTag[] manifestTags = new XmlTag[]{manifest.getRootTag()};
        for (Element tag : ManifestUtils.getPath(item2)) {
            XmlTag found = ManifestUtils.findTag(manifestTags, tag);
            if (found == null) {
                if (parent2 == null) {
                    Logger.getInstance(ManifestUtils.class).warn("can not root tag " + tag + " in xml file " + manifest);
                    return;
                }
                found = parent2.createChildTag(tag.getLocalName(), null, null, false);
                found = parent2.addSubTag(found, true);
                Attr nameAttribute = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (nameAttribute != null) {
                    found.setAttribute(nameAttribute.getLocalName(), nameAttribute.getNamespaceURI(), nameAttribute.getValue());
                }
                if (tag == item2) {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attributeValue);
                }
            } else if (tag == item2) {
                XmlAttribute attribute = found.getAttribute(attributeName, "http://schemas.android.com/tools");
                if (attribute == null) {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attributeValue);
                } else {
                    found.setAttribute(attributeName, "http://schemas.android.com/tools", attribute.getValue() + "," + attributeValue);
                }
            }
            parent2 = found;
            manifestTags = found.getSubTags();
        }
    }

    @Nullable
    private static XmlTag findTag(@NotNull XmlTag[] manifestTags, @NotNull Element tag) {
        Attr nameAttribute = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        String name = nameAttribute == null ? null : nameAttribute.getValue();
        for (XmlTag xmlTag : manifestTags) {
            if (!tag.getTagName().equals(xmlTag.getName())) continue;
            if (name != null) {
                XmlAttribute xmlAttribute = xmlTag.getAttribute("name", "http://schemas.android.com/apk/res/android");
                if (xmlAttribute == null || !name.equals(xmlAttribute.getValue())) continue;
                return xmlTag;
            }
            return xmlTag;
        }
        return null;
    }

    @NotNull
    private static List<Element> getPath(@NotNull Element element2) {
        Element tag = element2;
        ArrayList<Element> path2 = new ArrayList<Element>();
        while (true) {
            path2.add(tag);
            Node parentNode = tag.getParentNode();
            if (!(parentNode instanceof Element)) break;
            tag = (Element)parentNode;
        }
        Collections.reverse(path2);
        return path2;
    }
}

