/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.literals.internal;

import com.android.tools.idea.editors.literals.LiveLiteralsMonitorHandler;
import com.android.tools.idea.editors.literals.internal.LiveLiteralsDiagnosticsKt;
import com.android.tools.idea.editors.literals.internal.LiveLiteralsDiagnosticsWrite;
import com.android.tools.idea.editors.literals.internal.RemoteStatsCollector;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.wireless.android.sdk.stats.LiveLiteralsEvent;
import com.intellij.openapi.Disposable;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B?\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001c\u001a\u00020\tH\u0016J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J&\u0010 \u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\u0018\u0010$\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0013H\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J\u0006\u0010'\u001a\u00020\tR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000RN\u0010\u0017\u001aB\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00050\u0005 \u0019* \u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDiagnosticsRemoteReporterImpl;", "Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDiagnosticsWrite;", "Lcom/intellij/openapi/Disposable;", "msProvider", "Lkotlin/Function0;", "", "onReport", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/LiveLiteralsEvent;", "", "reportScheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "reportInterval", "reportIntervalUnit", "Ljava/util/concurrent/TimeUnit;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/ScheduledExecutorService;JLjava/util/concurrent/TimeUnit;)V", "activeDevices", "", "", "Lcom/android/tools/idea/editors/literals/LiveLiteralsMonitorHandler$DeviceType;", "currentStatsCollector", "Ljava/util/EnumMap;", "Lcom/android/tools/idea/editors/literals/internal/RemoteStatsCollector;", "deploymentStartTimes", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "scheduledReport", "Ljava/util/concurrent/Future;", "dispose", "liveLiteralPushStarted", "deviceId", "pushId", "liveLiteralPushed", "problems", "", "Lcom/android/tools/idea/editors/literals/LiveLiteralsMonitorHandler$Problem;", "liveLiteralsMonitorStarted", "deviceType", "liveLiteralsMonitorStopped", "reportToServer", "intellij.android.core"})
final class LiveLiteralsDiagnosticsRemoteReporterImpl
implements LiveLiteralsDiagnosticsWrite,
Disposable {
    @NotNull
    private final Function0<Long> msProvider;
    @NotNull
    private final Function1<LiveLiteralsEvent, Unit> onReport;
    private final Cache<String, Long> deploymentStartTimes;
    @NotNull
    private final Map<String, LiveLiteralsMonitorHandler.DeviceType> activeDevices;
    @NotNull
    private EnumMap<LiveLiteralsMonitorHandler.DeviceType, RemoteStatsCollector> currentStatsCollector;
    @NotNull
    private Future<?> scheduledReport;

    public LiveLiteralsDiagnosticsRemoteReporterImpl(@NotNull Function0<Long> msProvider, @NotNull Function1<? super LiveLiteralsEvent, Unit> onReport, @NotNull ScheduledExecutorService reportScheduler, long reportInterval, @NotNull TimeUnit reportIntervalUnit) {
        Intrinsics.checkNotNullParameter(msProvider, (String)"msProvider");
        Intrinsics.checkNotNullParameter(onReport, (String)"onReport");
        Intrinsics.checkNotNullParameter((Object)reportScheduler, (String)"reportScheduler");
        Intrinsics.checkNotNullParameter((Object)((Object)reportIntervalUnit), (String)"reportIntervalUnit");
        this.msProvider = msProvider;
        this.onReport = onReport;
        this.deploymentStartTimes = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
        this.activeDevices = new LinkedHashMap();
        this.currentStatsCollector = new EnumMap(LiveLiteralsMonitorHandler.DeviceType.class);
        ScheduledFuture<?> scheduledFuture2 = reportScheduler.scheduleWithFixedDelay(new Runnable(this){
            final /* synthetic */ LiveLiteralsDiagnosticsRemoteReporterImpl $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void run() {
                this.$tmp0.reportToServer();
            }
        }, reportInterval, reportInterval, reportIntervalUnit);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture2, (String)"reportScheduler.schedule\u2026      reportIntervalUnit)");
        this.scheduledReport = scheduledFuture2;
    }

    @Override
    public synchronized void liveLiteralsMonitorStarted(@NotNull String deviceId, @NotNull LiveLiteralsMonitorHandler.DeviceType deviceType) {
        RemoteStatsCollector stats;
        int n;
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)((Object)deviceType), (String)"deviceType");
        this.activeDevices.put(deviceId, deviceType);
        Map<String, LiveLiteralsMonitorHandler.DeviceType> $this$count$iv = this.activeDevices;
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator<Map.Entry<String, LiveLiteralsMonitorHandler.DeviceType>> iterator2 = $this$count$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, LiveLiteralsMonitorHandler.DeviceType> element$iv;
                Map.Entry<String, LiveLiteralsMonitorHandler.DeviceType> it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(it.getValue() == deviceType)) continue;
                ++count$iv;
            }
            n = count$iv;
        }
        int numberOfDevices = n;
        Map $this$getOrCreate$iv = this.currentStatsCollector;
        boolean $i$f$getOrCreate = false;
        Object object = $this$getOrCreate$iv.get((Object)deviceType);
        if (object == null) {
            RemoteStatsCollector remoteStatsCollector;
            LiveLiteralsMonitorHandler.DeviceType it = deviceType;
            boolean bl = false;
            RemoteStatsCollector it$iv = remoteStatsCollector = new RemoteStatsCollector((Function0<Long>)this.msProvider);
            boolean bl2 = false;
            $this$getOrCreate$iv.put(deviceType, it$iv);
            object = it$iv;
        }
        RemoteStatsCollector remoteStatsCollector = stats = (RemoteStatsCollector)object;
        if (remoteStatsCollector != null) {
            remoteStatsCollector.setActiveDevices(RangesKt.coerceAtLeast((int)numberOfDevices, (int)stats.getActiveDevices()));
        }
        LiveLiteralsEvent liveLiteralsEvent = LiveLiteralsEvent.newBuilder().setEventType(LiveLiteralsEvent.LiveLiteralsEventType.START).setDeviceType(LiveLiteralsDiagnosticsKt.protoType(deviceType)).build();
        Intrinsics.checkNotNullExpressionValue((Object)liveLiteralsEvent, (String)"newBuilder()\n           \u2026)\n               .build()");
        this.onReport.invoke((Object)liveLiteralsEvent);
    }

    @Override
    public synchronized void liveLiteralsMonitorStopped(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        LiveLiteralsMonitorHandler.DeviceType deviceType = this.activeDevices.remove(deviceId);
        if (deviceType == null) {
            return;
        }
        LiveLiteralsMonitorHandler.DeviceType deviceType2 = deviceType;
        LiveLiteralsEvent liveLiteralsEvent = LiveLiteralsEvent.newBuilder().setEventType(LiveLiteralsEvent.LiveLiteralsEventType.STOP).setDeviceType(LiveLiteralsDiagnosticsKt.protoType(deviceType2)).build();
        Intrinsics.checkNotNullExpressionValue((Object)liveLiteralsEvent, (String)"newBuilder()\n           \u2026)\n               .build()");
        this.onReport.invoke((Object)liveLiteralsEvent);
    }

    @Override
    public synchronized void liveLiteralPushStarted(@NotNull String deviceId, @NotNull String pushId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)pushId, (String)"pushId");
        this.deploymentStartTimes.put((Object)LiveLiteralsDiagnosticsKt.access$pushKey(deviceId, pushId), this.msProvider.invoke());
    }

    public final synchronized void reportToServer() {
        Map $this$forEach$iv = this.currentStatsCollector;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            LiveLiteralsMonitorHandler.DeviceType typeToReport = (LiveLiteralsMonitorHandler.DeviceType)((Object)entry.getKey());
            RemoteStatsCollector statsToReport = (RemoteStatsCollector)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)typeToReport), (String)"typeToReport");
            LiveLiteralsEvent.LiveLiteralsDeployStats statsProto = statsToReport.buildProto(typeToReport);
            LiveLiteralsEvent liveLiteralsEvent = LiveLiteralsEvent.newBuilder().setEventType(LiveLiteralsEvent.LiveLiteralsEventType.DEPLOY_STATS).setDeviceType(LiveLiteralsDiagnosticsKt.protoType(typeToReport)).addAllDeployStats((Iterable)CollectionsKt.listOf((Object)statsProto)).build();
            Intrinsics.checkNotNullExpressionValue((Object)liveLiteralsEvent, (String)"newBuilder()\n           \u2026                 .build()");
            this.onReport.invoke((Object)liveLiteralsEvent);
        }
        this.currentStatsCollector.clear();
    }

    @Override
    public synchronized void liveLiteralPushed(@NotNull String deviceId, @NotNull String pushId, @NotNull Collection<LiveLiteralsMonitorHandler.Problem> problems) {
        LiveLiteralsMonitorHandler.DeviceType deviceType;
        Long timeMs;
        Long l;
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)pushId, (String)"pushId");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        String key = LiveLiteralsDiagnosticsKt.access$pushKey(deviceId, pushId);
        Long l2 = (Long)this.deploymentStartTimes.getIfPresent((Object)key);
        if (l2 != null) {
            Long it = l2;
            boolean bl = false;
            l = ((Number)this.msProvider.invoke()).longValue() - it;
        } else {
            l = timeMs = null;
        }
        if ((deviceType = this.activeDevices.get(deviceId)) == null) {
            deviceType = LiveLiteralsMonitorHandler.DeviceType.UNKNOWN;
        }
        LiveLiteralsMonitorHandler.DeviceType deviceType2 = deviceType;
        Map $this$getOrCreate$iv = this.currentStatsCollector;
        boolean $i$f$getOrCreate = false;
        Object object = $this$getOrCreate$iv.get((Object)deviceType2);
        if (object == null) {
            RemoteStatsCollector remoteStatsCollector;
            LiveLiteralsMonitorHandler.DeviceType it = deviceType2;
            boolean bl = false;
            RemoteStatsCollector it$iv = remoteStatsCollector = new RemoteStatsCollector((Function0<Long>)this.msProvider);
            boolean bl2 = false;
            $this$getOrCreate$iv.put(deviceType2, it$iv);
            object = it$iv;
        }
        RemoteStatsCollector stats = (RemoteStatsCollector)object;
        if (problems.isEmpty()) {
            int n = stats.getSuccessfulDeployments();
            stats.setSuccessfulDeployments(n + 1);
        } else {
            int n = stats.getFailedDeployments();
            stats.setFailedDeployments(n + 1);
        }
        Long l3 = timeMs;
        if (l3 != null) {
            long it = ((Number)l3).longValue();
            boolean bl = false;
            stats.getDeployTimeMsPercentiles().addSample((double)it);
        }
        stats.getProblemsPercentiles().addSample((double)problems.size());
    }

    public synchronized void dispose() {
        this.scheduledReport.cancel(true);
    }
}

