/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.literals.internal;

import com.android.tools.idea.editors.literals.LiveLiteralsMonitorHandler;
import com.android.tools.idea.editors.literals.internal.DeployRecord;
import com.android.tools.idea.editors.literals.internal.LiveLiteralsDiagnosticsKt;
import com.android.tools.idea.editors.literals.internal.LiveLiteralsDiagnosticsRead;
import com.android.tools.idea.editors.literals.internal.LiveLiteralsDiagnosticsWrite;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.EvictingQueue;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0016J&\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016RN\u0010\u0007\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005 \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDiagnosticsLocalImpl;", "Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDiagnosticsRead;", "Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDiagnosticsWrite;", "msProvider", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "deploymentStartTimes", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "failedDeployments", "lastDeployments", "Lcom/google/common/collect/EvictingQueue;", "Lcom/android/tools/idea/editors/literals/internal/DeployRecord;", "successfulDeployments", "failedDeploymentCount", "", "liveLiteralPushStarted", "", "deviceId", "pushId", "liveLiteralPushed", "problems", "", "Lcom/android/tools/idea/editors/literals/LiveLiteralsMonitorHandler$Problem;", "liveLiteralsMonitorStarted", "deviceType", "Lcom/android/tools/idea/editors/literals/LiveLiteralsMonitorHandler$DeviceType;", "liveLiteralsMonitorStopped", "successfulDeploymentCount", "intellij.android.core"})
final class LiveLiteralsDiagnosticsLocalImpl
implements LiveLiteralsDiagnosticsRead,
LiveLiteralsDiagnosticsWrite {
    @NotNull
    private final Function0<Long> msProvider;
    private final Cache<String, Long> deploymentStartTimes;
    private final EvictingQueue<DeployRecord> lastDeployments;
    private long successfulDeployments;
    private long failedDeployments;

    public LiveLiteralsDiagnosticsLocalImpl(@NotNull Function0<Long> msProvider) {
        Intrinsics.checkNotNullParameter(msProvider, (String)"msProvider");
        this.msProvider = msProvider;
        this.deploymentStartTimes = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
        this.lastDeployments = EvictingQueue.create((int)100);
    }

    @Override
    public synchronized long successfulDeploymentCount() {
        return this.successfulDeployments;
    }

    @Override
    public synchronized long failedDeploymentCount() {
        return this.failedDeployments;
    }

    @Override
    @NotNull
    public synchronized List<DeployRecord> lastDeployments() {
        EvictingQueue<DeployRecord> evictingQueue = this.lastDeployments;
        Intrinsics.checkNotNullExpressionValue(evictingQueue, (String)"lastDeployments");
        return CollectionsKt.toList((Iterable)((Iterable)evictingQueue));
    }

    @Override
    public void liveLiteralsMonitorStarted(@NotNull String deviceId, @NotNull LiveLiteralsMonitorHandler.DeviceType deviceType) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)((Object)deviceType), (String)"deviceType");
    }

    @Override
    public void liveLiteralsMonitorStopped(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
    }

    @Override
    public synchronized void liveLiteralPushStarted(@NotNull String deviceId, @NotNull String pushId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)pushId, (String)"pushId");
        this.deploymentStartTimes.put((Object)LiveLiteralsDiagnosticsKt.access$pushKey(deviceId, pushId), this.msProvider.invoke());
    }

    @Override
    public synchronized void liveLiteralPushed(@NotNull String deviceId, @NotNull String pushId, @NotNull Collection<LiveLiteralsMonitorHandler.Problem> problems) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)pushId, (String)"pushId");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        String key = LiveLiteralsDiagnosticsKt.access$pushKey(deviceId, pushId);
        Long l = (Long)this.deploymentStartTimes.getIfPresent((Object)key);
        if (l == null) {
            return;
        }
        Long it = l;
        boolean bl = false;
        long timeMs = ((Number)this.msProvider.invoke()).longValue() - it;
        this.deploymentStartTimes.invalidate((Object)key);
        if (problems.isEmpty()) {
            long l2 = this.successfulDeployments;
            this.successfulDeployments = l2 + 1L;
        } else {
            long l3 = this.failedDeployments;
            this.failedDeployments = l3 + 1L;
        }
        this.lastDeployments.add((Object)new DeployRecord(deviceId, pushId, timeMs, problems.size()));
    }
}

