/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.literals.internal;

import com.android.tools.idea.editors.literals.LiveLiteralsMonitorHandler;
import com.android.tools.idea.editors.literals.internal.LiveLiteralsDeploymentReportServiceKt;
import com.android.tools.idea.editors.literals.internal.LiveLiteralsDiagnosticsManager;
import com.android.tools.idea.editors.liveedit.LiveEditApplicationConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 62\u00020\u00012\u00020\u00022\u00020\u0003:\u000267B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020!H\u0016J\u001f\u0010'\u001a\u00020\u000f2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0)\"\u00020\r\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0016J&\u0010.\u001a\u00020%2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0016J\u0018\u0010/\u001a\u00020%2\u0006\u0010,\u001a\u00020\f2\u0006\u0010(\u001a\u00020\rH\u0016J\u0010\u00100\u001a\u00020%2\u0006\u0010,\u001a\u00020\fH\u0016J\u0006\u00101\u001a\u00020%J\u0016\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u000205R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001a0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020!0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDeploymentReportService;", "Lcom/android/tools/idea/editors/literals/LiveLiteralsMonitorHandler;", "Lcom/intellij/openapi/util/ModificationTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "listenerExecutor", "Ljava/util/concurrent/Executor;", "(Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/Executor;)V", "activeDevices", "", "", "Lcom/android/tools/idea/editors/literals/LiveLiteralsMonitorHandler$DeviceType;", "hasActiveDevices", "", "getHasActiveDevices", "()Z", "hasProblems", "getHasProblems", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "modificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "problems", "", "Lkotlin/Pair;", "Lcom/android/tools/idea/editors/literals/LiveLiteralsMonitorHandler$Problem;", "getProblems", "()Ljava/util/Collection;", "problemsMap", "pushedStarted", "", "serviceLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "dispose", "", "getModificationCount", "hasActiveDeviceOfType", "deviceType", "", "([Lcom/android/tools/idea/editors/literals/LiveLiteralsMonitorHandler$DeviceType;)Z", "liveLiteralPushStarted", "deviceId", "pushId", "liveLiteralPushed", "liveLiteralsMonitorStarted", "liveLiteralsMonitorStopped", "stopAllMonitors", "subscribe", "parentDisposable", "listener", "Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDeploymentReportService$Listener;", "Companion", "Listener", "intellij.android.core"})
@VisibleForTesting
public final class LiveLiteralsDeploymentReportService
implements LiveLiteralsMonitorHandler,
ModificationTracker,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Executor listenerExecutor;
    @NotNull
    private final Logger log;
    @NotNull
    private final SimpleModificationTracker modificationTracker;
    @NotNull
    private final ReentrantReadWriteLock serviceLock;
    @NotNull
    private final Map<String, LiveLiteralsMonitorHandler.DeviceType> activeDevices;
    @NotNull
    private final Map<String, Collection<LiveLiteralsMonitorHandler.Problem>> problemsMap;
    @NotNull
    private final Map<String, Long> pushedStarted;
    @NotNull
    private static final Topic<Listener> LITERALS_DEPLOYED_TOPIC = new Topic("Live Literals Deployed", Listener.class);

    private LiveLiteralsDeploymentReportService(Project project, Executor listenerExecutor) {
        this.project = project;
        Executor executor2 = listenerExecutor;
        if (executor2 == null) {
            ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Listener executor", (Executor)AppExecutorUtil.getAppExecutorService(), (int)1, (Disposable)this);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026                 1, this)");
            executor2 = executorService;
        }
        this.listenerExecutor = executor2;
        Logger logger2 = Logger.getInstance(LiveLiteralsDeploymentReportService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(LiveLiterals\u2026eportService::class.java)");
        this.log = logger2;
        this.modificationTracker = new SimpleModificationTracker();
        this.serviceLock = new ReentrantReadWriteLock();
        this.activeDevices = new LinkedHashMap();
        this.problemsMap = new LinkedHashMap();
        this.pushedStarted = new LinkedHashMap();
    }

    public LiveLiteralsDeploymentReportService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, null);
    }

    public long getModificationCount() {
        return this.modificationTracker.getModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getHasProblems() {
        ReentrantReadWriteLock.ReadLock readLock = this.serviceLock.readLock();
        readLock.lock();
        try {
            boolean bl;
            block6: {
                boolean bl2 = false;
                Map<String, Collection<LiveLiteralsMonitorHandler.Problem>> $this$any$iv = this.problemsMap;
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator<Map.Entry<String, Collection<LiveLiteralsMonitorHandler.Problem>>> iterator2 = $this$any$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, Collection<LiveLiteralsMonitorHandler.Problem>> element$iv;
                        Map.Entry<String, Collection<LiveLiteralsMonitorHandler.Problem>> it = element$iv = iterator2.next();
                        boolean bl3 = false;
                        boolean bl4 = !it.getValue().isEmpty();
                        if (!bl4) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean bl5 = bl;
            return bl5;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getHasActiveDevices() {
        ReentrantReadWriteLock.ReadLock readLock = this.serviceLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = !this.activeDevices.isEmpty();
            return bl2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasActiveDeviceOfType(LiveLiteralsMonitorHandler.DeviceType ... deviceType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        ReentrantReadWriteLock.ReadLock readLock = this.serviceLock.readLock();
        readLock.lock();
        try {
            boolean bl2;
            block4: {
                boolean bl3 = false;
                LiveLiteralsMonitorHandler.DeviceType[] $this$any$iv = deviceType;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    LiveLiteralsMonitorHandler.DeviceType element$iv;
                    LiveLiteralsMonitorHandler.DeviceType it = element$iv = $this$any$iv[i];
                    boolean bl4 = false;
                    if (!this.activeDevices.containsValue((Object)it)) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
            bl = bl2;
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Pair<String, LiveLiteralsMonitorHandler.Problem>> getProblems() {
        ReentrantReadWriteLock.ReadLock readLock = this.serviceLock.readLock();
        readLock.lock();
        try {
            void $this$flatMapTo$iv$iv;
            boolean bl = false;
            Iterable $this$flatMap$iv = this.problemsMap.entrySet();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$map$iv = (Iterable)entry.getValue();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LiveLiteralsMonitorHandler.Problem problem = (LiveLiteralsMonitorHandler.Problem)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection2.add(TuplesKt.to(entry.getKey(), (Object)it));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Collection collection3 = (List)destination$iv$iv;
            return collection3;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void liveLiteralsMonitorStarted(@NotNull String deviceId, @NotNull LiveLiteralsMonitorHandler.DeviceType deviceType) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)((Object)deviceType), (String)"deviceType");
        if (!LiveEditApplicationConfiguration.Companion.getInstance().isLiveLiterals()) {
            return;
        }
        boolean started = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.serviceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = started = this.activeDevices.putIfAbsent(deviceId, deviceType) == null;
            if (started) {
                Logger $this$debug$iv = this.log;
                Exception e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger2 = $this$debug$iv;
                    boolean bl3 = false;
                    logger2.debug("Monitor started for '" + deviceId + "' deviceCount=" + this.activeDevices.size(), (Throwable)e$iv);
                }
                this.problemsMap.remove(deviceId);
                this.pushedStarted.put(deviceId, System.currentTimeMillis());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (started) {
            this.modificationTracker.incModificationCount();
            this.listenerExecutor.execute(new Runnable(this, deviceId){
                final /* synthetic */ LiveLiteralsDeploymentReportService this$0;
                final /* synthetic */ String $deviceId;
                {
                    this.this$0 = $receiver;
                    this.$deviceId = $deviceId;
                }

                public final void run() {
                    ((Listener)LiveLiteralsDeploymentReportService.access$getProject$p(this.this$0).getMessageBus().syncPublisher(LiveLiteralsDeploymentReportService.access$getLITERALS_DEPLOYED_TOPIC$cp())).onMonitorStarted(this.$deviceId);
                }
            });
        }
        LiveLiteralsDiagnosticsManager.getWriteInstance(this.project).liveLiteralsMonitorStarted(deviceId, deviceType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void liveLiteralsMonitorStopped(@NotNull String deviceId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        if (!LiveEditApplicationConfiguration.Companion.getInstance().isLiveLiterals()) {
            return;
        }
        boolean stopped = false;
        this.modificationTracker.incModificationCount();
        ReentrantReadWriteLock reentrantReadWriteLock = this.serviceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            stopped = this.activeDevices.remove(deviceId) != null;
            this.problemsMap.remove(deviceId);
            if (stopped) {
                Logger $this$debug$iv = this.log;
                Exception e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger2 = $this$debug$iv;
                    boolean bl2 = false;
                    logger2.debug("Monitor stopped for '" + deviceId + "' deviceCount=" + this.activeDevices.size(), (Throwable)e$iv);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (stopped) {
            this.listenerExecutor.execute(new Runnable(this, deviceId){
                final /* synthetic */ LiveLiteralsDeploymentReportService this$0;
                final /* synthetic */ String $deviceId;
                {
                    this.this$0 = $receiver;
                    this.$deviceId = $deviceId;
                }

                public final void run() {
                    ((Listener)LiveLiteralsDeploymentReportService.access$getProject$p(this.this$0).getMessageBus().syncPublisher(LiveLiteralsDeploymentReportService.access$getLITERALS_DEPLOYED_TOPIC$cp())).onMonitorStopped(this.$deviceId);
                }
            });
        }
        LiveLiteralsDiagnosticsManager.getWriteInstance(this.project).liveLiteralsMonitorStopped(deviceId);
    }

    @Override
    public void liveLiteralPushStarted(@NotNull String deviceId, @NotNull String pushId) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)pushId, (String)"pushId");
        if (!LiveEditApplicationConfiguration.Companion.getInstance().isLiveLiterals()) {
            return;
        }
        this.log.debug("Device '" + deviceId + "' pushed started.");
        LiveLiteralsDiagnosticsManager.getWriteInstance(this.project).liveLiteralPushStarted(deviceId, pushId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void liveLiteralPushed(@NotNull String deviceId, @NotNull String pushId, @NotNull Collection<LiveLiteralsMonitorHandler.Problem> problems) {
        Intrinsics.checkNotNullParameter((Object)deviceId, (String)"deviceId");
        Intrinsics.checkNotNullParameter((Object)pushId, (String)"pushId");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        if (!LiveEditApplicationConfiguration.Companion.getInstance().isLiveLiterals()) {
            return;
        }
        boolean isActive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.serviceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean $i$a$-write-LiveLiteralsDeploymentReportService$liveLiteralPushed$22 = false;
            isActive = this.activeDevices.containsKey(deviceId);
            if (isActive) {
                this.problemsMap.put(deviceId, CollectionsKt.toList((Iterable)problems));
            } else {
                this.log.warn("Device " + deviceId + " is not active, liveLiteralPushed ignored.");
            }
            Unit $i$a$-write-LiveLiteralsDeploymentReportService$liveLiteralPushed$22 = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (isActive) {
            LiveLiteralsDiagnosticsManager.getWriteInstance(this.project).liveLiteralPushed(deviceId, pushId, problems);
            Iterable $this$forEach$iv = problems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LiveLiteralsMonitorHandler.Problem it = (LiveLiteralsMonitorHandler.Problem)element$iv;
                boolean bl = false;
                LiveLiteralsDeploymentReportServiceKt.access$getPROBLEM_NOTIFICATION_GROUP$p().createNotification("[" + it.getSeverity() + "] " + it.getContent(), LiveLiteralsDeploymentReportServiceKt.access$toNotificationSeverity(it.getSeverity())).notify(this.project);
            }
            this.listenerExecutor.execute(new Runnable(this, deviceId){
                final /* synthetic */ LiveLiteralsDeploymentReportService this$0;
                final /* synthetic */ String $deviceId;
                {
                    this.this$0 = $receiver;
                    this.$deviceId = $deviceId;
                }

                public final void run() {
                    ((Listener)LiveLiteralsDeploymentReportService.access$getProject$p(this.this$0).getMessageBus().syncPublisher(LiveLiteralsDeploymentReportService.access$getLITERALS_DEPLOYED_TOPIC$cp())).onLiveLiteralsPushed(this.$deviceId);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopAllMonitors() {
        List list2;
        ReentrantReadWriteLock.ReadLock readLock = this.serviceLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            list2 = CollectionsKt.toMutableList((Collection)this.activeDevices.keySet());
        }
        finally {
            readLock.unlock();
        }
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.liveLiteralsMonitorStopped(it);
        }
    }

    public final void subscribe(@NotNull Disposable parentDisposable, @NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.project.getMessageBus().connect(parentDisposable).subscribe(LITERALS_DEPLOYED_TOPIC, (Object)listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.serviceLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            this.problemsMap.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public static final /* synthetic */ Project access$getProject$p(LiveLiteralsDeploymentReportService $this) {
        return $this.project;
    }

    public static final /* synthetic */ Topic access$getLITERALS_DEPLOYED_TOPIC$cp() {
        return LITERALS_DEPLOYED_TOPIC;
    }

    public /* synthetic */ LiveLiteralsDeploymentReportService(Project project, Executor listenerExecutor, DefaultConstructorMarker $constructor_marker) {
        this(project, listenerExecutor);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDeploymentReportService$Listener;", "", "onLiveLiteralsPushed", "", "deviceId", "", "onMonitorStarted", "onMonitorStopped", "intellij.android.core"})
    public static interface Listener {
        public void onMonitorStarted(@NotNull String var1);

        public void onMonitorStopped(@NotNull String var1);

        public void onLiveLiteralsPushed(@NotNull String var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDeploymentReportService$Companion;", "", "()V", "LITERALS_DEPLOYED_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDeploymentReportService$Listener;", "kotlin.jvm.PlatformType", "getInstance", "Lcom/android/tools/idea/editors/literals/internal/LiveLiteralsDeploymentReportService;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceForTesting", "listenerExecutor", "Ljava/util/concurrent/Executor;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LiveLiteralsDeploymentReportService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LiveLiteralsDeploymentReportService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(LiveL\u2026eportService::class.java)");
            return (LiveLiteralsDeploymentReportService)object;
        }

        @TestOnly
        @NotNull
        public final LiveLiteralsDeploymentReportService getInstanceForTesting(@NotNull Project project, @NotNull Executor listenerExecutor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)listenerExecutor, (String)"listenerExecutor");
            return new LiveLiteralsDeploymentReportService(project, listenerExecutor, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

