/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.fonts;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.template.emmet.generators.LoremGenerator;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FontEditor
implements FileEditor {
    private static final Logger LOG = Logger.getInstance(FontEditor.class);
    private static final String NAME = "Font";
    private static final String LOREM_TEXT = new LoremGenerator().generate(50, true);
    private static final float MAX_FONT_SIZE = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL) + JBUI.scale((float)30.0f);
    private static final float MIN_FONT_SIZE = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI);
    private static final Border BORDER = JBUI.Borders.empty((int)50);
    private static final Font DEFAULT_FONT = StartupUiUtil.getLabelFont();
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private final JTextArea myTextArea;
    private final VirtualFile myFile;
    private final JPanel myRootPanel;
    private float myCurrentFontSize;
    private final JLabel myFontNameLabel;

    @NotNull
    private static JTextArea createTextArea() {
        JTextArea area = new JTextArea();
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        return area;
    }

    @NotNull
    private static String findDisplayableText(@NotNull Font font) {
        if (font.canDisplayUpTo(LOREM_TEXT) == -1) {
            return LOREM_TEXT;
        }
        StringBuilder displayableString = new StringBuilder(50);
        int numGlyphs = Math.min(font.getNumGlyphs(), 250);
        int displayedGlyphs = 0;
        for (int i = 0; i < 0x10FFFF; ++i) {
            if (!Character.isValidCodePoint(i)) continue;
            if (displayedGlyphs >= numGlyphs) {
                return displayableString.toString();
            }
            if (!font.canDisplay(i)) continue;
            ++displayedGlyphs;
            displayableString.appendCodePoint(i);
        }
        return "";
    }

    public FontEditor(@NotNull VirtualFile file2) {
        this.myFile = file2;
        this.myRootPanel = new JPanel(new BorderLayout());
        this.myRootPanel.setBackground(UIUtil.getTextFieldBackground());
        this.myRootPanel.setBorder(BORDER);
        this.myFontNameLabel = new JLabel();
        this.myTextArea = FontEditor.createTextArea();
        this.myCurrentFontSize = UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.NORMAL) + JBUI.scale((float)15.0f);
        try {
            Font font = Font.createFont(0, file2.getInputStream()).deriveFont(this.myCurrentFontSize);
            this.myFontNameLabel.setText(font.getFontName());
            if (font.canDisplayUpTo(font.getFontName()) == -1) {
                this.myFontNameLabel.setFont(font);
            } else {
                this.myFontNameLabel.setFont(DEFAULT_FONT.deriveFont(this.myCurrentFontSize));
            }
            String displayableText = FontEditor.findDisplayableText(font);
            if (!displayableText.isEmpty()) {
                this.myTextArea.setFont(font);
                this.myTextArea.setText(displayableText);
            } else {
                this.myTextArea.setFont(DEFAULT_FONT);
                this.myTextArea.setEditable(false);
                this.myTextArea.setText("This font does not contain any glyphs that can be previewed");
            }
            this.myRootPanel.addMouseWheelListener(this::onMouseWheelEvent);
        }
        catch (FontFormatException | IOException e) {
            String message2 = "Unable to open font " + file2.getName();
            this.myTextArea.setFont(StartupUiUtil.getLabelFont());
            this.myTextArea.setEditable(false);
            this.myTextArea.setText(message2);
            LOG.warn(message2, (Throwable)e);
        }
        this.myRootPanel.add((Component)this.myFontNameLabel, "North");
        JBScrollPane scrollPane = new JBScrollPane();
        scrollPane.getViewport().add(this.myTextArea);
        this.myRootPanel.add((Component)scrollPane, "Center");
    }

    private void onMouseWheelEvent(MouseWheelEvent e) {
        float increment = e.getWheelRotation() < 0 ? -1.0f : 1.0f;
        float newFontSize = Math.min(Math.max(MIN_FONT_SIZE, this.myCurrentFontSize + increment), MAX_FONT_SIZE);
        if (newFontSize != this.myCurrentFontSize) {
            this.myCurrentFontSize = newFontSize;
            this.myTextArea.setFont(this.myTextArea.getFont().deriveFont(this.myCurrentFontSize));
            this.myFontNameLabel.setFont(this.myFontNameLabel.getFont().deriveFont(this.myCurrentFontSize));
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTextArea;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(@NotNull FileEditorState state2) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        this.myUserDataHolder.putUserData(key, value2);
    }
}

