/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.draw9patch.graphics.GraphicsUtilities;
import com.android.draw9patch.ui.ImageEditorPanel;
import com.android.draw9patch.ui.ImageViewer;
import com.intellij.AppTopics;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.ModalityUiUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NinePatchEditor
implements FileEditor,
ImageViewer.PatchUpdateListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.editors.NinePatchEditor");
    private static final String NAME = "9-Patch";
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private final Project myProject;
    private VirtualFile myFile;
    private BufferedImage myBufferedImage;
    private ImageEditorPanel myImageEditorPanel;
    private boolean myDirtyFlag;

    public NinePatchEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        this.myProject = project;
        FileDocumentManagerListener saveListener = new FileDocumentManagerListener(){

            public void beforeAllDocumentsSaving() {
                NinePatchEditor.this.saveFile();
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)saveListener);
        this.myFile = file2;
        try {
            this.myBufferedImage = this.loadImage(file2);
            Supplier<Color> helpBackgroundColor = () -> {
                EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
                return globalScheme.getColor(EditorColors.NOTIFICATION_BACKGROUND);
            };
            this.myImageEditorPanel = new ImageEditorPanel(null, this.myBufferedImage, this.myFile.getName(), helpBackgroundColor, JBColor::border);
            this.myImageEditorPanel.getViewer().addPatchUpdateListener((ImageViewer.PatchUpdateListener)this);
        }
        catch (IOException e) {
            LOG.error("Unexpected exception while reading 9-patch file", (Throwable)e);
        }
    }

    private BufferedImage loadImage(VirtualFile file2) throws IOException {
        this.myBufferedImage = ImageIO.read(file2.getInputStream());
        if (this.myBufferedImage == null) {
            throw new IOException("Unable to parse file: " + file2.getCanonicalPath());
        }
        return GraphicsUtilities.toCompatibleImage((BufferedImage)this.myBufferedImage);
    }

    private void saveFile() {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            try {
                this.saveFileFromEDT();
            }
            catch (IOException e) {
                LOG.error("Unexpected exception while saving 9-patch file", (Throwable)e);
            }
        });
    }

    private void saveFileFromEDT() throws IOException {
        if (!this.myDirtyFlag) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)this.myProject).withName("Update N-patch").run(() -> {
            ByteArrayOutputStream stream = new ByteArrayOutputStream((int)this.myFile.getLength());
            ImageIO.write((RenderedImage)this.myBufferedImage, "PNG", stream);
            this.myFile.setBinaryContent(stream.toByteArray());
        });
        this.myDirtyFlag = false;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myImageEditorPanel != null ? this.myImageEditorPanel : new JLabel("Unexpected error while loading 9-patch file. See Event Log for details.");
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myImageEditorPanel;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(@NotNull FileEditorState state2) {
    }

    public boolean isModified() {
        return this.myDirtyFlag;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        this.saveFile();
        if (this.myImageEditorPanel != null) {
            this.myImageEditorPanel.getViewer().removePatchUpdateListener((ImageViewer.PatchUpdateListener)this);
            this.myImageEditorPanel.dispose();
            this.myImageEditorPanel = null;
        }
    }

    public void patchesUpdated() {
        this.myDirtyFlag = true;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        this.myUserDataHolder.putUserData(key, value2);
    }
}

