/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.annotations.concurrency.UiThread;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeEditor.JavaEditorFileSwapper;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000  2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0003\u001f !B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0017J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001aH\u0015J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createLegacyPanel", "Lcom/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider$MyEditorNotificationPanel;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "title", "", "requestedSourceVersion", "Lcom/android/sdklib/AndroidVersion;", "refresh", "Ljava/lang/Runnable;", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createNotificationPanelForClassFiles", "createNotificationPanelForDebugSession", "createPanel", "refreshAfterDownload", "createSdkDownloadDialog", "Lcom/android/tools/idea/wizard/model/ModelWizardDialog;", "requestedPaths", "", "findAndroidSdkEntryForFile", "Lcom/intellij/openapi/roots/JdkOrderEntry;", "getKey", "Lcom/intellij/openapi/util/Key;", "AttachAndroidSdkSourcesCallback", "Companion", "MyEditorNotificationPanel", "intellij.android.core"})
public class AttachAndroidSdkSourcesNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private static final Key<EditorNotificationPanel> KEY;
    @JvmField
    @NotNull
    public static final Key<AttachAndroidSdkSourcesCallback> REQUIRED_SOURCES_KEY;

    public AttachAndroidSdkSourcesNotificationProvider(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @UiThread
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        EditorNotificationPanel editorNotificationPanel = this.createNotificationPanelForDebugSession(file2, fileEditor);
        if (editorNotificationPanel == null) {
            editorNotificationPanel = this.createNotificationPanelForClassFiles(file2, fileEditor);
        }
        return editorNotificationPanel;
    }

    private final EditorNotificationPanel createNotificationPanelForDebugSession(VirtualFile file2, FileEditor fileEditor) {
        if (!((Boolean)StudioFlags.DEBUG_DEVICE_SDK_SOURCES_ENABLE.get()).booleanValue()) {
            return null;
        }
        AttachAndroidSdkSourcesCallback attachAndroidSdkSourcesCallback = (AttachAndroidSdkSourcesCallback)file2.getUserData(REQUIRED_SOURCES_KEY);
        if (attachAndroidSdkSourcesCallback == null) {
            return null;
        }
        AttachAndroidSdkSourcesCallback missingDebugSourcesInfo = attachAndroidSdkSourcesCallback;
        return this.createPanel(fileEditor, missingDebugSourcesInfo.getMissingSourceVersion(), new Runnable(missingDebugSourcesInfo){
            final /* synthetic */ AttachAndroidSdkSourcesCallback $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void run() {
                this.$tmp0.refreshAfterDownload();
            }
        });
    }

    private final EditorNotificationPanel createNotificationPanelForClassFiles(VirtualFile file2, FileEditor fileEditor) {
        EditorNotificationPanel editorNotificationPanel;
        if (!FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)JavaClassFileType.INSTANCE)) {
            return null;
        }
        if (JavaEditorFileSwapper.findSourceFile((Project)this.myProject, (VirtualFile)file2) != null) {
            return null;
        }
        JdkOrderEntry jdkOrderEntry = this.findAndroidSdkEntryForFile(file2);
        if (jdkOrderEntry == null) {
            return null;
        }
        JdkOrderEntry jdkOrderEntry2 = jdkOrderEntry;
        Sdk sdk = jdkOrderEntry2.getJdk();
        if (sdk == null) {
            return null;
        }
        Sdk sdk2 = sdk;
        VirtualFile[] virtualFileArray = sdk2.getRootProvider().getFiles(OrderRootType.SOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"sdk.rootProvider.getFiles(OrderRootType.SOURCES)");
        if (!(((Object[])virtualFileArray).length == 0)) {
            return null;
        }
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(sdk2);
        if (androidPlatform == null || (androidPlatform = androidPlatform.getApiVersion()) == null) {
            return null;
        }
        AndroidPlatform apiVersion = androidPlatform;
        Runnable refresh2 = new Runnable(sdk2){
            final /* synthetic */ Sdk $sdk;
            {
                this.$sdk = $sdk;
            }

            public final void run() {
                AndroidSdkUtils.updateSdkSourceRoot(this.$sdk);
            }
        };
        Object t = StudioFlags.DEBUG_DEVICE_SDK_SOURCES_ENABLE.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"DEBUG_DEVICE_SDK_SOURCES_ENABLE.get()");
        if (((Boolean)t).booleanValue()) {
            editorNotificationPanel = this.createPanel(fileEditor, (AndroidVersion)apiVersion, refresh2);
        } else {
            String title = "Sources for '" + jdkOrderEntry2.getJdkName() + "' not found.";
            editorNotificationPanel = this.createLegacyPanel(fileEditor, title, (AndroidVersion)apiVersion, refresh2);
        }
        return editorNotificationPanel;
    }

    private final MyEditorNotificationPanel createPanel(FileEditor fileEditor, AndroidVersion requestedSourceVersion, Runnable refreshAfterDownload2) {
        MyEditorNotificationPanel panel2 = new MyEditorNotificationPanel(fileEditor);
        panel2.setText("Android SDK sources for API level " + requestedSourceVersion.getApiLevel() + " not found.");
        panel2.createAndAddLink("Download", new Runnable(requestedSourceVersion, this, refreshAfterDownload2){
            final /* synthetic */ AndroidVersion $requestedSourceVersion;
            final /* synthetic */ AttachAndroidSdkSourcesNotificationProvider this$0;
            final /* synthetic */ Runnable $refreshAfterDownload;
            {
                this.$requestedSourceVersion = $requestedSourceVersion;
                this.this$0 = $receiver;
                this.$refreshAfterDownload = $refreshAfterDownload;
            }

            public final void run() {
                String sourcesPath = DetailsTypes.getSourcesPath((AndroidVersion)this.$requestedSourceVersion);
                ModelWizardDialog modelWizardDialog2 = this.this$0.createSdkDownloadDialog(CollectionsKt.listOf((Object)sourcesPath));
                boolean bl = modelWizardDialog2 != null ? modelWizardDialog2.showAndGet() : false;
                if (bl) {
                    this.$refreshAfterDownload.run();
                }
            }
        });
        return panel2;
    }

    private final MyEditorNotificationPanel createLegacyPanel(FileEditor fileEditor, String title, AndroidVersion requestedSourceVersion, Runnable refresh2) {
        MyEditorNotificationPanel panel2 = new MyEditorNotificationPanel(fileEditor);
        panel2.setText(title);
        panel2.createAndAddLink("Download", new Runnable(requestedSourceVersion, this, refresh2){
            final /* synthetic */ AndroidVersion $requestedSourceVersion;
            final /* synthetic */ AttachAndroidSdkSourcesNotificationProvider this$0;
            final /* synthetic */ Runnable $refresh;
            {
                this.$requestedSourceVersion = $requestedSourceVersion;
                this.this$0 = $receiver;
                this.$refresh = $refresh;
            }

            public final void run() {
                List sourcesPaths = CollectionsKt.listOf((Object)DetailsTypes.getSourcesPath((AndroidVersion)this.$requestedSourceVersion));
                ModelWizardDialog modelWizardDialog2 = this.this$0.createSdkDownloadDialog(sourcesPaths);
                boolean bl = modelWizardDialog2 != null ? modelWizardDialog2.showAndGet() : false;
                if (bl) {
                    this.$refresh.run();
                }
            }
        });
        panel2.createAndAddLink("Refresh (if already downloaded)", refresh2);
        return panel2;
    }

    @VisibleForTesting
    @Nullable
    protected ModelWizardDialog createSdkDownloadDialog(@Nullable List<String> requestedPaths2) {
        List<String> list2 = requestedPaths2;
        Intrinsics.checkNotNull(list2);
        return SdkQuickfixUtils.createDialogForPaths(this.myProject, (Collection<String>)list2);
    }

    /*
     * WARNING - void declaration
     */
    private final JdkOrderEntry findAndroidSdkEntryForFile(VirtualFile file2) {
        Object v2;
        block4: {
            void $this$filterIsInstanceTo$iv$iv;
            List list2 = ProjectFileIndex.getInstance((Project)this.myProject).getOrderEntriesForFile(file2);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInstance(myProject)\n \u2026OrderEntriesForFile(file)");
            Iterable $this$filterIsInstance$iv = list2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JdkOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                JdkOrderEntry entry = (JdkOrderEntry)element$iv;
                boolean bl2 = false;
                if (entry.getJdk() != null) {
                    Sdk it;
                    boolean bl3 = false;
                    bl = AndroidSdks.getInstance().isAndroidSdk(it);
                } else {
                    bl = false;
                }
                if (!bl) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        return v2;
    }

    static {
        Key key = Key.create((String)"add sdk sources to class");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<EditorNotificatio\u2026dd sdk sources to class\")");
        KEY = key;
        Key key2 = Key.create((String)"sources to download");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create<AttachAndroidSdkS\u2026k>(\"sources to download\")");
        REQUIRED_SOURCES_KEY = key2;
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\r\u001a\u00020\u000e2\u000b\u0010\u000f\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider$MyEditorNotificationPanel;", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "(Lcom/intellij/openapi/fileEditor/FileEditor;)V", "links", "", "", "Ljava/lang/Runnable;", "getLinks", "()Ljava/util/Map;", "myLinks", "", "createAndAddLink", "", "text", "Lcom/intellij/openapi/util/NlsContexts$LinkLabel;", "action", "intellij.android.core"})
    public static final class MyEditorNotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final Map<String, Runnable> myLinks = new HashMap();

        public MyEditorNotificationPanel(@Nullable FileEditor fileEditor) {
            super(fileEditor);
        }

        public final void createAndAddLink(@NotNull String text2, @NotNull Runnable action2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            HyperlinkLabel hyperlinkLabel2 = this.createActionLabel(text2, action2);
            Intrinsics.checkNotNullExpressionValue((Object)hyperlinkLabel2, (String)"createActionLabel(text, action)");
            HyperlinkLabel label = hyperlinkLabel2;
            Map<String, Runnable> map2 = this.myLinks;
            String string = label.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"label.text");
            map2.put(string, action2);
        }

        @VisibleForTesting
        @NotNull
        public final Map<String, Runnable> getLinks() {
            return this.myLinks;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\t0\t0\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "REQUIRED_SOURCES_KEY", "Lcom/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider$AttachAndroidSdkSourcesCallback;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H'R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider$AttachAndroidSdkSourcesCallback;", "", "missingSourceVersion", "Lcom/android/sdklib/AndroidVersion;", "getMissingSourceVersion", "()Lcom/android/sdklib/AndroidVersion;", "refreshAfterDownload", "", "intellij.android.core"})
    public static interface AttachAndroidSdkSourcesCallback {
        @NotNull
        public AndroidVersion getMissingSourceVersion();

        @UiThread
        public void refreshAfterDownload();
    }
}

