/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.resources.ResourceFolderType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidEditorTitleProvider
implements EditorTabTitleProvider {
    @Nullable
    public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)XmlFileType.INSTANCE)) {
            return null;
        }
        if (file2.getName().equals("AndroidManifest.xml")) {
            return null;
        }
        VirtualFile parent2 = file2.getParent();
        if (parent2 == null) {
            return null;
        }
        String parentName = parent2.getName();
        int index2 = parentName.indexOf(45);
        if (index2 == -1 || index2 == parentName.length() - 1) {
            return null;
        }
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentName);
        if (folderType == null) {
            return null;
        }
        return parentName.substring(index2 + 1) + File.separator + file2.getPresentableName();
    }
}

