/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.report;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.diagnostics.report.BuilderInfo;
import com.android.tools.idea.diagnostics.report.DiagnosticsSummaryFileProvider;
import com.android.tools.idea.diagnostics.report.FileInfo;
import com.android.tools.idea.diagnostics.report.MetricsLogFileProvider;
import com.android.tools.idea.diagnostics.report.PathProvider;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/report/MetricsLogFileProvider;", "Lcom/android/tools/idea/diagnostics/report/DiagnosticsSummaryFileProvider;", "pathProvider", "Lcom/android/tools/idea/diagnostics/report/PathProvider;", "size", "", "(Lcom/android/tools/idea/diagnostics/report/PathProvider;I)V", "builders", "", "Lcom/android/tools/idea/diagnostics/report/BuilderInfo;", "[Lcom/android/tools/idea/diagnostics/report/BuilderInfo;", "index", "getFiles", "", "Lcom/android/tools/idea/diagnostics/report/FileInfo;", "project", "Lcom/intellij/openapi/project/Project;", "processEvent", "", "builder", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "intellij.android.core"})
public final class MetricsLogFileProvider
implements DiagnosticsSummaryFileProvider {
    @NotNull
    private final PathProvider pathProvider;
    private final int size;
    @NotNull
    private final BuilderInfo[] builders;
    private int index;

    public MetricsLogFileProvider(@NotNull PathProvider pathProvider, int size) {
        Intrinsics.checkNotNullParameter((Object)pathProvider, (String)"pathProvider");
        this.pathProvider = pathProvider;
        this.size = size;
        this.builders = new BuilderInfo[this.size];
    }

    public /* synthetic */ MetricsLogFileProvider(PathProvider pathProvider, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        this(pathProvider, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processEvent(@NotNull AndroidStudioEvent.Builder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        BuilderInfo[] builderInfoArray = this.builders;
        synchronized (builderInfoArray) {
            boolean bl = false;
            Date date = AnalyticsSettings.getDateProvider().now();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"dateProvider.now()");
            this.builders[this.index] = new BuilderInfo(date, builder2);
            this.index = (this.index + 1) % this.size;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<FileInfo> getFiles(@Nullable Project project) {
        Object[] orderedArray = new BuilderInfo[this.size];
        BuilderInfo[] builderInfoArray = this.builders;
        synchronized (builderInfoArray) {
            boolean bl = false;
            ArraysKt.copyInto$default((Object[])this.builders, (Object[])orderedArray, (int)0, (int)this.index, (int)0, (int)8, null);
            BuilderInfo[] builderInfoArray2 = (BuilderInfo[])ArraysKt.copyInto((Object[])this.builders, (Object[])orderedArray, (int)(this.builders.length - this.index), (int)0, (int)this.index);
        }
        Path path2 = DiagnosticsSummaryFileProvider.Companion.getDiagnosticsDirectoryPath(this.pathProvider.getLogDir()).resolve("MetricsInfo.log");
        File file2 = path2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"path.toFile()");
        FilesKt.writeText$default((File)file2, (String)CollectionsKt.joinToString$default((Iterable)ArraysKt.filterNotNull((Object[])orderedArray), (CharSequence)"\n", null, null, (int)0, null, (Function1)getFiles.2.INSTANCE, (int)30, null), null, (int)2, null);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
        Path path3 = Paths.get("MetricsInfo.log", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(FILE_NAME)");
        return CollectionsKt.listOf((Object)new FileInfo(path2, path3));
    }
}

