/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.report;

import com.android.tools.idea.diagnostics.report.DiagnosticsSummaryFileProvider;
import com.android.tools.idea.diagnostics.report.FileInfo;
import com.android.tools.idea.util.ZipData;
import com.android.tools.idea.util.ZipUtilKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/diagnostics/report/DiagnosticSummaryAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.android.core"})
public final class DiagnosticSummaryAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DiagnosticSummaryAction() {
        super("Create Diagnostics Summary File");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        try {
            String destination = Companion.createSummaryFile(e.getProject());
            string = "Diagnostics file created successfully. Path: " + destination;
        }
        catch (Exception e2) {
            string = "Error creating diagnostics report: " + e2.getMessage();
        }
        String message2 = string;
        Messages.showInfoMessage((String)message2, (String)"Diagnostics Summary File");
    }

    @JvmStatic
    @NotNull
    public static final String createSummaryFile(@Nullable Project project) {
        return Companion.createSummaryFile(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/diagnostics/report/DiagnosticSummaryAction$Companion;", "", "()V", "createSummaryFile", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final String createSummaryFile(@Nullable Project project) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            List<FileInfo> fileInfo = DiagnosticsSummaryFileProvider.Companion.buildFileList(project);
            Iterable $this$map$iv = fileInfo;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileInfo fileInfo2 = (FileInfo)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(new ZipData(((Object)it.getSource()).toString(), ((Object)it.getDestination()).toString()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ZipData[] zipDataArray = thisCollection$iv.toArray(new ZipData[0]);
            if (zipDataArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            ZipData[] zipInfo = zipDataArray;
            String datetime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
            String string = PathManager.getLogPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLogPath()");
            Path dir = DiagnosticsSummaryFileProvider.Companion.getDiagnosticsDirectoryPath(string);
            String destination = ((Object)dir.resolve("DiagnosticsReport" + datetime + ".zip")).toString();
            ZipUtilKt.zipFiles(zipInfo, destination);
            return destination;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

