/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.profiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import jdk.jfr.Configuration;
import jdk.jfr.Recording;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/diagnostics/profiler/Jfr;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "r", "Ljdk/jfr/Recording;", "getR", "()Ljdk/jfr/Recording;", "setR", "(Ljdk/jfr/Recording;)V", "dump", "Ljava/nio/file/Path;", "getJfrConfiguration", "Ljdk/jfr/Configuration;", "isProfilerActive", "", "start", "", "stop", "intellij.android.core"})
public final class Jfr {
    @NotNull
    private final Logger LOG;
    @Nullable
    private Recording r;

    public Jfr() {
        Logger logger2 = Logger.getInstance(Jfr.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(Jfr::class.java)");
        this.LOG = logger2;
    }

    @NotNull
    public final Logger getLOG() {
        return this.LOG;
    }

    @Nullable
    public final Recording getR() {
        return this.r;
    }

    public final void setR(@Nullable Recording recording) {
        this.r = recording;
    }

    public final boolean isProfilerActive() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.r != null;
    }

    public final void start() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isProfilerActive()) {
            return;
        }
        Recording recording = this.r = new Recording(this.getJfrConfiguration());
        if (recording != null) {
            recording.start();
        }
        this.LOG.info("JFR Started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Configuration getJfrConfiguration() {
        Configuration configuration;
        InputStream inputStream = this.getClass().getResourceAsStream("/diagnostics/prodprofile.jfc");
        if (inputStream == null) {
            Configuration configuration2 = Configuration.getConfiguration("profile");
            Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"getConfiguration(\"profile\")");
            return configuration2;
        }
        InputStream inputStream2 = inputStream;
        Closeable closeable = new InputStreamReader(inputStream2);
        Throwable throwable = null;
        try {
            InputStreamReader r = (InputStreamReader)closeable;
            boolean bl = false;
            Configuration configuration3 = Configuration.create(r);
            configuration = configuration3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"InputStreamReader(inputS\u2026iguration.create(r)\n    }");
        return configuration;
    }

    public final void stop() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isProfilerActive()) {
            return;
        }
        this.dump();
        Recording recording = this.r;
        if (recording != null) {
            recording.stop();
        }
        this.r = null;
        this.LOG.info("JFR Stopped");
    }

    @Nullable
    public final Path dump() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.r == null) {
            return null;
        }
        LocalDateTime dt = LocalDateTime.now(ZoneId.of("America/Los_Angeles"));
        Path path2 = Files.createTempFile("studio-" + dt.getYear() + "-" + dt.getMonthValue() + "-" + dt.getDayOfMonth() + "-" + dt.getHour() + "-" + dt.getMinute() + "-" + dt.getSecond() + "-", ".jfr", new FileAttribute[0]);
        Recording recording = this.r;
        if (recording != null) {
            recording.dump(path2);
        }
        this.LOG.info("Saved JFR Recording in " + path2);
        return path2;
    }
}

