/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr.reports;

import com.android.tools.idea.diagnostics.jfr.CallTreeAggregator;
import com.android.tools.idea.diagnostics.jfr.EventFilter;
import com.android.tools.idea.diagnostics.jfr.JfrReportGenerator;
import java.time.Instant;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0001H\u0016J\u0014\u0010\u0011\u001a\u00020\f2\n\u0010\u000f\u001a\u00060\u0010R\u00020\u0001H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/MyReportGenerator;", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator;", "()V", "callTreeAggregator", "Lcom/android/tools/idea/diagnostics/jfr/CallTreeAggregator;", "keystrokeCount", "", "getKeystrokeCount", "()I", "setKeystrokeCount", "(I)V", "accept", "", "e", "Ljdk/jfr/consumer/RecordedEvent;", "c", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator$Capture;", "captureCompleted", "generateReport", "", "", "intellij.android.core"})
final class MyReportGenerator
extends JfrReportGenerator {
    private int keystrokeCount = -1;
    @NotNull
    private final CallTreeAggregator callTreeAggregator = new CallTreeAggregator(CallTreeAggregator.Companion.getTHREAD_FILTER_ALL());

    public MyReportGenerator() {
        super("JFR-TypingLatency", EventFilter.Companion.getCPU_SAMPLES(), 0, 0);
    }

    public final int getKeystrokeCount() {
        return this.keystrokeCount;
    }

    public final void setKeystrokeCount(int n) {
        this.keystrokeCount = n;
    }

    @Override
    public void accept(@NotNull RecordedEvent e, @NotNull JfrReportGenerator.Capture c) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        this.callTreeAggregator.accept(e);
    }

    @Override
    public void captureCompleted(@NotNull JfrReportGenerator.Capture c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Instant instant = c.getEnd();
        Intrinsics.checkNotNull((Object)instant);
        this.callTreeAggregator.processBatch(instant);
    }

    @Override
    @NotNull
    public Map<String, String> generateReport() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"callTrees", (Object)this.callTreeAggregator.generateReport(200000)), TuplesKt.to((Object)"keystrokes", (Object)String.valueOf(this.keystrokeCount))};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

