/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr.reports;

import com.android.annotations.concurrency.UiThread;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0002 !B@\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012!\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00040\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0014\u001a\u00020\u0004H\u0007J\b\u0010\u0015\u001a\u00020\u0004H\u0003J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0012H\u0003J\"\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0012H\u0003R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R)\u0010\u0005\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/MyLatencyListener;", "Lcom/intellij/openapi/editor/actionSystem/LatencyListener;", "startCapture", "Lkotlin/Function0;", "", "stopCapture", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "keystrokeCount", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/ScheduledExecutorService;)V", "state", "Lcom/android/tools/idea/diagnostics/jfr/reports/MyLatencyListener$State;", "timeouts", "", "Lcom/android/tools/idea/diagnostics/jfr/reports/MyLatencyListener$TimeoutType;", "Ljava/util/concurrent/Future;", "cancelAllTimeouts", "doStopRecording", "handleTimeout", "timeoutType", "recordTypingLatency", "editor", "Lcom/intellij/openapi/editor/Editor;", "action", "", "latencyMs", "", "startTimeout", "State", "TimeoutType", "intellij.android.core"})
public final class MyLatencyListener
implements LatencyListener {
    @NotNull
    private final Function0<Unit> startCapture;
    @NotNull
    private final Function1<Integer, Unit> stopCapture;
    @NotNull
    private final ScheduledExecutorService scheduler;
    @NotNull
    private State state;
    private int keystrokeCount;
    @NotNull
    private final Map<TimeoutType, Future<?>> timeouts;

    public MyLatencyListener(@NotNull Function0<Unit> startCapture, @NotNull Function1<? super Integer, Unit> stopCapture2, @NotNull ScheduledExecutorService scheduler) {
        Intrinsics.checkNotNullParameter(startCapture, (String)"startCapture");
        Intrinsics.checkNotNullParameter(stopCapture2, (String)"stopCapture");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        this.startCapture = startCapture;
        this.stopCapture = stopCapture2;
        this.scheduler = scheduler;
        this.state = State.WAITING_TO_RECORD;
        this.timeouts = new LinkedHashMap();
    }

    public /* synthetic */ MyLatencyListener(Function0 function0, Function1 function1, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = JobScheduler.getScheduler();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"getScheduler()");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this((Function0<Unit>)function0, (Function1<? super Integer, Unit>)function1, scheduledExecutorService);
    }

    @UiThread
    public void recordTypingLatency(@NotNull Editor editor, @Nullable String action2, long latencyMs) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                if (latencyMs <= 1000L) break;
                this.keystrokeCount = 1;
                this.cancelAllTimeouts();
                this.startTimeout(TimeoutType.TYPING);
                this.startTimeout(TimeoutType.SESSION);
                this.startCapture.invoke();
                this.state = State.RECORDING;
                break;
            }
            case 2: {
                if (latencyMs > 1000L) {
                    int n = this.keystrokeCount;
                    this.keystrokeCount = n + 1;
                    this.startTimeout(TimeoutType.TYPING);
                    break;
                }
                this.doStopRecording();
            }
        }
    }

    @UiThread
    private final void startTimeout(TimeoutType timeoutType) {
        Future<?> future2 = this.timeouts.remove((Object)timeoutType);
        if (future2 != null) {
            future2.cancel(false);
        }
        Map<TimeoutType, Future<?>> map2 = this.timeouts;
        ScheduledFuture<?> scheduledFuture2 = this.scheduler.schedule(new Runnable(this, timeoutType){
            final /* synthetic */ MyLatencyListener this$0;
            final /* synthetic */ TimeoutType $timeoutType;
            {
                this.this$0 = $receiver;
                this.$timeoutType = $timeoutType;
            }

            public final void run() {
                MyLatencyListener myLatencyListener = this.this$0;
                TimeoutType timeoutType = this.$timeoutType;
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(myLatencyListener, timeoutType){
                    final /* synthetic */ MyLatencyListener this$0;
                    final /* synthetic */ TimeoutType $timeoutType$inlined;
                    {
                        this.this$0 = myLatencyListener;
                        this.$timeoutType$inlined = timeoutType;
                    }

                    public final void run() {
                        boolean bl = false;
                        MyLatencyListener.access$handleTimeout(this.this$0, this.$timeoutType$inlined);
                    }
                }, ModalityState.defaultModalityState());
            }
        }, timeoutType.getTimeoutMs(), TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture2, (String)"@UiThread\n  private fun \u2026imeUnit.MILLISECONDS)\n  }");
        ScheduledFuture<?> scheduledFuture3 = scheduledFuture2;
        map2.put(timeoutType, scheduledFuture3);
    }

    @UiThread
    private final void handleTimeout(TimeoutType timeoutType) {
        switch (WhenMappings.$EnumSwitchMapping$1[timeoutType.ordinal()]) {
            case 1: 
            case 2: {
                if (this.state != State.RECORDING) break;
                this.doStopRecording();
                break;
            }
            case 3: {
                if (this.state != State.COOLDOWN) break;
                this.cancelAllTimeouts();
                this.state = State.WAITING_TO_RECORD;
            }
        }
    }

    @UiThread
    public final void cancelAllTimeouts() {
        for (Future<?> future2 : this.timeouts.values()) {
            future2.cancel(false);
        }
        this.timeouts.clear();
    }

    @UiThread
    private final void doStopRecording() {
        this.stopCapture.invoke((Object)this.keystrokeCount);
        this.keystrokeCount = 0;
        this.cancelAllTimeouts();
        this.startTimeout(TimeoutType.COOLDOWN);
        this.state = State.COOLDOWN;
    }

    public static final /* synthetic */ void access$handleTimeout(MyLatencyListener $this, TimeoutType timeoutType) {
        $this.handleTimeout(timeoutType);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/MyLatencyListener$State;", "", "(Ljava/lang/String;I)V", "WAITING_TO_RECORD", "RECORDING", "COOLDOWN", "intellij.android.core"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State WAITING_TO_RECORD = new State();
        public static final /* enum */ State RECORDING = new State();
        public static final /* enum */ State COOLDOWN = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        static {
            $VALUES = stateArray = new State[]{State.WAITING_TO_RECORD, State.RECORDING, State.COOLDOWN};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/reports/MyLatencyListener$TimeoutType;", "", "timeoutMs", "", "(Ljava/lang/String;IJ)V", "getTimeoutMs", "()J", "TYPING", "SESSION", "COOLDOWN", "intellij.android.core"})
    private static final class TimeoutType
    extends Enum<TimeoutType> {
        private final long timeoutMs;
        public static final /* enum */ TimeoutType TYPING = new TimeoutType(2000L);
        public static final /* enum */ TimeoutType SESSION = new TimeoutType(10000L);
        public static final /* enum */ TimeoutType COOLDOWN = new TimeoutType(600000L);
        private static final /* synthetic */ TimeoutType[] $VALUES;

        private TimeoutType(long timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public final long getTimeoutMs() {
            return this.timeoutMs;
        }

        public static TimeoutType[] values() {
            return (TimeoutType[])$VALUES.clone();
        }

        public static TimeoutType valueOf(String value2) {
            return Enum.valueOf(TimeoutType.class, value2);
        }

        static {
            $VALUES = timeoutTypeArray = new TimeoutType[]{TimeoutType.TYPING, TimeoutType.SESSION, TimeoutType.COOLDOWN};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[State.values().length];
            nArray[State.WAITING_TO_RECORD.ordinal()] = 1;
            nArray[State.RECORDING.ordinal()] = 2;
            nArray[State.COOLDOWN.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TimeoutType.values().length];
            nArray[TimeoutType.TYPING.ordinal()] = 1;
            nArray[TimeoutType.SESSION.ordinal()] = 2;
            nArray[TimeoutType.COOLDOWN.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

