/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001d\u001a\u00020\u0019J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/analysis/CallTree;", "", "name", "", "(Ljava/lang/String;)V", "children", "", "getName", "()Ljava/lang/String;", "sampleCount", "", "getSampleCount", "()I", "setSampleCount", "(I)V", "time", "", "getTime", "()J", "setTime", "(J)V", "truncatedSampleCount", "getTruncatedSampleCount", "setTruncatedSampleCount", "addStacktrace", "", "stacktrace", "", "numNodesAboveCutoff", "sort", "toString", "depth", "branch", "", "Companion", "intellij.android.core"})
public final class CallTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private int sampleCount;
    private int truncatedSampleCount;
    private long time;
    @NotNull
    private final List<CallTree> children;
    private static final int MIN_TIME_CUTOFF_MS = 200;

    public CallTree(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.children = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getSampleCount() {
        return this.sampleCount;
    }

    public final void setSampleCount(int n) {
        this.sampleCount = n;
    }

    public final int getTruncatedSampleCount() {
        return this.truncatedSampleCount;
    }

    public final void setTruncatedSampleCount(int n) {
        this.truncatedSampleCount = n;
    }

    public final long getTime() {
        return this.time;
    }

    public final void setTime(long l) {
        this.time = l;
    }

    public final void addStacktrace(@NotNull List<String> stacktrace, long time2) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter(stacktrace, (String)"stacktrace");
            int n = this.sampleCount;
            this.sampleCount = n + 1;
            this.time += time2;
            Iterable iterable = this.children;
            for (Object t : iterable) {
                CallTree it = (CallTree)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)CollectionsKt.last(stacktrace))) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        CallTree matchingChild = v0;
        if (matchingChild == null) {
            matchingChild = new CallTree((String)CollectionsKt.last(stacktrace));
            this.children.add(matchingChild);
        }
        if (stacktrace.size() > 1) {
            matchingChild.addStacktrace(stacktrace.subList(0, stacktrace.size() - 1), time2);
        } else {
            CallTree callTree = matchingChild;
            int n = callTree.sampleCount;
            callTree.sampleCount = n + 1;
            callTree = matchingChild;
            callTree.time += time2;
        }
    }

    public final void sort() {
        List<CallTree> $this$sortByDescending$iv = this.children;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CallTree ch = (CallTree)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(ch.getTime());
                    ch = (CallTree)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(ch.getTime()));
                }
            });
        }
        Iterable $this$forEach$iv = this.children;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CallTree it = (CallTree)element$iv;
            boolean bl = false;
            it.sort();
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d4 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.children.size() > 1 && this.children.get((int)1).time > 200L) {
            Iterable $this$forEach$iv = this.children;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CallTree c = (CallTree)element$iv;
                boolean bl2 = false;
                if (c.time <= 200L) continue;
                $this$toString_u24lambda_u2d4.append(c.toString(1, true));
            }
        } else if (!((Collection)this.children).isEmpty() && this.children.get((int)0).time > 200L) {
            $this$toString_u24lambda_u2d4.append(this.children.get(0).toString(0, false));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String toString(int depth, boolean branch) {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d6 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int indent = depth - (branch ? 1 : 0);
        for (int i = 0; i < indent; ++i) {
            $this$toString_u24lambda_u2d6.append("  ");
        }
        if (branch) {
            $this$toString_u24lambda_u2d6.append("+ ");
        }
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u2d6.append(this.name + " [" + this.time + "ms] (" + this.sampleCount + ")");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        if (this.children.size() > 1 && this.children.get((int)1).time > 200L) {
            Iterable $this$forEach$iv = this.children;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CallTree c = (CallTree)element$iv;
                boolean bl2 = false;
                if (c.time <= 200L) continue;
                $this$toString_u24lambda_u2d6.append(c.toString(depth + 1, true));
            }
        } else if (!((Collection)this.children).isEmpty() && this.children.get((int)0).time > 200L) {
            $this$toString_u24lambda_u2d6.append(this.children.get(0).toString(depth, false));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final int numNodesAboveCutoff() {
        int n;
        if (this.time < 200L) {
            n = 0;
        } else {
            int n2;
            Iterable iterable = this.children;
            int n3 = 1;
            int n4 = 0;
            for (Object t : iterable) {
                void it;
                CallTree callTree = (CallTree)t;
                n2 = n4;
                boolean bl = false;
                int n5 = it.numNodesAboveCutoff();
                n4 = n2 + n5;
            }
            n2 = n4;
            n = n3 + n2;
        }
        return n;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/analysis/CallTree$Companion;", "", "()V", "MIN_TIME_CUTOFF_MS", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

