/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr;

import com.android.tools.idea.diagnostics.jfr.Action;
import com.android.tools.idea.diagnostics.jfr.JfrReportGenerator;
import com.android.tools.idea.diagnostics.jfr.LowMemory;
import com.android.tools.idea.diagnostics.jfr.RecordingBuffer;
import com.android.tools.idea.diagnostics.jfr.reports.JfrFreezeReports;
import com.android.tools.idea.diagnostics.report.DiagnosticReport;
import com.android.tools.idea.diagnostics.report.DiagnosticReportProperties;
import com.android.tools.idea.diagnostics.report.JfrBasedReport;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import jdk.jfr.Recording;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import org.jetbrains.annotations.NotNull;

public class RecordingManager {
    private static final Logger LOG = Logger.getInstance(RecordingManager.class);
    public static final int JFR_RECORDING_DURATION_SECONDS = 30;
    private static final int MAX_CAPTURE_DURATION_SECONDS = 300;
    private static final String JFR_SERVER_FLAG_NAME = "diagnostics/jfr";
    private static final List<JfrReportGenerator.Capture> pendingCaptures = new ArrayList<JfrReportGenerator.Capture>();
    private static Instant previousRecordingEnd = Instant.MIN;
    private static final RecordingBuffer recordings = new RecordingBuffer();
    private static final Object jfrLock = new Object();
    private static LowMemoryWatcher lowMemoryWatcher;
    private static Consumer<DiagnosticReport> reportCallback;

    public static void init(Consumer<DiagnosticReport> callback) {
        if (ServerFlagService.Companion.getInstance().getBoolean(JFR_SERVER_FLAG_NAME, false)) {
            reportCallback = callback;
            RecordingManager.setupActionEvents();
            RecordingManager.setupLowMemoryEvents();
            JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Instant recordingEnd = Instant.now();
                    Object object = jfrLock;
                    synchronized (object) {
                        try {
                            Recording rec = recordings.swapBuffers();
                            if (rec != null) {
                                boolean hasActiveCaptures = false;
                                for (JfrReportGenerator.Capture c : pendingCaptures) {
                                    if (!c.getStart().isBefore(previousRecordingEnd)) continue;
                                    hasActiveCaptures = true;
                                    break;
                                }
                                if (hasActiveCaptures) {
                                    Path recPath = new File(FileUtil.getTempDirectory(), "recording.jfr").toPath();
                                    rec.dump(recPath);
                                    rec.close();
                                    RecordingManager.readAndDispatchRecordingEvents(recPath);
                                    Files.deleteIfExists(recPath);
                                }
                            }
                        }
                        catch (IOException e) {
                            LOG.warn((Throwable)e);
                        }
                        RecordingManager.purgeCompletedCaptures();
                        previousRecordingEnd = recordingEnd;
                    }
                }
            }, 0L, 30L, TimeUnit.SECONDS);
            RecordingManager.createReportManagers();
        }
    }

    private static void createReportManagers() {
        JfrFreezeReports.Companion.createFreezeReportManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startCapture(JfrReportGenerator.Capture capture) {
        Object object = jfrLock;
        synchronized (object) {
            pendingCaptures.add(capture);
        }
    }

    private static void readAndDispatchRecordingEvents(Path recPath) throws IOException {
        try (RecordingFile recordingFile = new RecordingFile(recPath);){
            while (recordingFile.hasMoreEvents()) {
                RecordedEvent e = recordingFile.readEvent();
                for (JfrReportGenerator.Capture capture : pendingCaptures) {
                    if (!capture.containsInstant(e.getStartTime()) || !capture.getGenerator().getEventFilter().accept(e)) continue;
                    capture.getGenerator().accept(e, capture);
                }
            }
        }
    }

    private static void purgeCompletedCaptures() {
        for (int i = pendingCaptures.size() - 1; i >= 0; --i) {
            JfrReportGenerator.Capture capture = pendingCaptures.get(i);
            if (capture.getEnd() == null || !capture.getEnd().isBefore(previousRecordingEnd)) continue;
            JfrReportGenerator generator2 = capture.getGenerator();
            generator2.captureCompleted(capture);
            if (generator2.isFinished()) {
                RecordingManager.generateReport(generator2);
            }
            pendingCaptures.remove(i);
        }
    }

    private static void generateReport(JfrReportGenerator gen) {
        try {
            Map<String, String> report2 = gen.generateReport();
            if (!report2.isEmpty()) {
                reportCallback.accept(new JfrBasedReport(gen.getReportType(), gen.generateReport(), new DiagnosticReportProperties()));
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void setupActionEvents() {
        MessageBusConnection connection2 = ApplicationManager.getApplication().getMessageBus().connect();
        final IdentityHashMap jfrEventMap = new IdentityHashMap();
        connection2.subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                Action a = new Action();
                a.actionId = ActionManager.getInstance().getId(action2);
                a.begin();
                jfrEventMap.put(event, a);
            }

            public void afterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                Action a = (Action)jfrEventMap.get(event);
                if (a != null) {
                    jfrEventMap.remove(event);
                    a.commit();
                }
            }
        });
    }

    private static void setupLowMemoryEvents() {
        lowMemoryWatcher = LowMemoryWatcher.register(() -> new LowMemory().commit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path dumpJfrTo(Path directory) {
        Object object = jfrLock;
        synchronized (object) {
            return recordings.dumpJfrTo(directory);
        }
    }

    public static class DumpJfrAction
    extends AnAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            RecordingManager.dumpJfrTo(new File(PathManager.getLogPath()).toPath());
        }
    }
}

