/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.jfr;

import com.android.tools.idea.diagnostics.jfr.EventFilter;
import com.android.tools.idea.diagnostics.jfr.RecordingManager;
import java.time.Instant;
import java.util.Map;
import jdk.jfr.consumer.RecordedEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001\u001fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u000bR\u00020\u0000H&J\u0014\u0010\u0019\u001a\u00020\u00152\n\u0010\u0018\u001a\u00060\u000bR\u00020\u0000H&J\u0006\u0010\u001a\u001a\u00020\u0015J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cH&J\u0006\u0010\u001d\u001a\u00020\u0015J\u0006\u0010\u001e\u001a\u00020\u0015R\u0014\u0010\n\u001a\b\u0018\u00010\u000bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator;", "", "reportType", "", "eventFilter", "Lcom/android/tools/idea/diagnostics/jfr/EventFilter;", "startOffsetMs", "", "endOffsetMs", "(Ljava/lang/String;Lcom/android/tools/idea/diagnostics/jfr/EventFilter;II)V", "currentCapture", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator$Capture;", "getEventFilter", "()Lcom/android/tools/idea/diagnostics/jfr/EventFilter;", "<set-?>", "", "isFinished", "()Z", "getReportType", "()Ljava/lang/String;", "accept", "", "e", "Ljdk/jfr/consumer/RecordedEvent;", "c", "captureCompleted", "finish", "generateReport", "", "startCapture", "stopCapture", "Capture", "intellij.android.core"})
public abstract class JfrReportGenerator {
    @NotNull
    private final String reportType;
    @NotNull
    private final EventFilter eventFilter;
    private final int startOffsetMs;
    private final int endOffsetMs;
    @Nullable
    private Capture currentCapture;
    private boolean isFinished;

    public JfrReportGenerator(@NotNull String reportType, @NotNull EventFilter eventFilter, int startOffsetMs, int endOffsetMs) {
        Intrinsics.checkNotNullParameter((Object)reportType, (String)"reportType");
        Intrinsics.checkNotNullParameter((Object)eventFilter, (String)"eventFilter");
        this.reportType = reportType;
        this.eventFilter = eventFilter;
        this.startOffsetMs = startOffsetMs;
        this.endOffsetMs = endOffsetMs;
        if (this.startOffsetMs < -30000) {
            throw new IllegalArgumentException("Start offset cannot be less than -30 seconds");
        }
    }

    public /* synthetic */ JfrReportGenerator(String string, EventFilter eventFilter, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = 0;
        }
        this(string, eventFilter, n, n2);
    }

    @NotNull
    public final String getReportType() {
        return this.reportType;
    }

    @NotNull
    public final EventFilter getEventFilter() {
        return this.eventFilter;
    }

    public final boolean isFinished() {
        return this.isFinished;
    }

    public abstract void accept(@NotNull RecordedEvent var1, @NotNull Capture var2);

    public abstract void captureCompleted(@NotNull Capture var1);

    @NotNull
    public abstract Map<String, String> generateReport();

    public final void finish() {
        this.isFinished = true;
    }

    public final void startCapture() {
        if (this.currentCapture != null) {
            throw new IllegalStateException("Cannot start capture: capture already in progress");
        }
        this.currentCapture = new Capture();
        RecordingManager.startCapture(this.currentCapture);
    }

    public final void stopCapture() {
        if (this.currentCapture == null) {
            throw new IllegalStateException("Cannot stop capture: there is no active capture");
        }
        Capture capture = this.currentCapture;
        if (capture != null) {
            capture.setEnd(Instant.now().plusMillis(this.endOffsetMs));
        }
        this.currentCapture = null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator$Capture;", "", "(Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator;)V", "end", "Ljava/time/Instant;", "getEnd", "()Ljava/time/Instant;", "setEnd", "(Ljava/time/Instant;)V", "generator", "Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator;", "getGenerator", "()Lcom/android/tools/idea/diagnostics/jfr/JfrReportGenerator;", "start", "kotlin.jvm.PlatformType", "getStart", "containsInstant", "", "instant", "intellij.android.core"})
    public final class Capture {
        private final Instant start;
        @Nullable
        private Instant end;
        @NotNull
        private final JfrReportGenerator generator;

        public Capture() {
            this.start = Instant.now().plusMillis(JfrReportGenerator.this.startOffsetMs);
            this.generator = JfrReportGenerator.this;
        }

        public final Instant getStart() {
            return this.start;
        }

        @Nullable
        public final Instant getEnd() {
            return this.end;
        }

        public final void setEnd(@Nullable Instant instant) {
            this.end = instant;
        }

        @NotNull
        public final JfrReportGenerator getGenerator() {
            return this.generator;
        }

        public final boolean containsInstant(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            if (instant.isBefore(this.start)) {
                return false;
            }
            if (this.end == null) {
                return true;
            }
            return instant.isBefore(this.end);
        }
    }
}

