/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.visitors;

import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.histogram.Histogram;
import com.android.tools.idea.diagnostics.hprof.histogram.HistogramEntry;
import com.android.tools.idea.diagnostics.hprof.parser.ConstantPoolEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfVisitor;
import com.android.tools.idea.diagnostics.hprof.parser.HeapDumpRecordType;
import com.android.tools.idea.diagnostics.hprof.parser.InstanceFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.StaticFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J_\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001aH\u0016\u00a2\u0006\u0002\u0010 J(\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0016J(\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*H\u0016J(\u0010+\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/HistogramVisitor;", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfVisitor;", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;)V", "classToHistogramEntryInternal", "Ljava/util/HashMap;", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "Lcom/android/tools/idea/diagnostics/hprof/visitors/HistogramVisitor$InternalHistogramEntry;", "Lkotlin/collections/HashMap;", "completed", "", "instanceCount", "", "createHistogram", "Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "postVisit", "", "preVisit", "visitClassDump", "classId", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "objects", "", "visitPrimitiveArrayDump", "numberOfElements", "elementType", "Lcom/android/tools/idea/diagnostics/hprof/parser/Type;", "InternalHistogramEntry", "intellij.android.core"})
public final class HistogramVisitor
extends HProfVisitor {
    @NotNull
    private final ClassStore classStore;
    private boolean completed;
    private long instanceCount;
    @NotNull
    private HashMap<ClassDefinition, InternalHistogramEntry> classToHistogramEntryInternal;

    public HistogramVisitor(@NotNull ClassStore classStore) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        this.classStore = classStore;
        this.classToHistogramEntryInternal = new HashMap();
    }

    @Override
    public void preVisit() {
        boolean bl;
        boolean bl2 = bl = !this.completed;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.disableAll();
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.enable(HeapDumpRecordType.ClassDump);
    }

    @Override
    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)elementType), (String)"elementType");
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.getClassForPrimitiveArray(elementType);
        Intrinsics.checkNotNull((Object)classDefinition);
        ClassDefinition classDefinition2 = classDefinition;
        Map $this$getOrPut$iv = this.classToHistogramEntryInternal;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classDefinition2);
        if (value$iv == null) {
            boolean bl = false;
            InternalHistogramEntry answer$iv = new InternalHistogramEntry(classDefinition2);
            $this$getOrPut$iv.put(classDefinition2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((InternalHistogramEntry)object).addInstance(numberOfElements * (long)elementType.getSize() + (long)ClassDefinition.Companion.getARRAY_PREAMBLE_SIZE());
    }

    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.getClassClass();
        Map $this$getOrPut$iv = this.classToHistogramEntryInternal;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classDefinition);
        if (value$iv == null) {
            boolean bl = false;
            InternalHistogramEntry answer$iv = new InternalHistogramEntry(classDefinition);
            $this$getOrPut$iv.put(classDefinition, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((InternalHistogramEntry)object).addInstance((long)classDefinition.getInstanceSize() + (long)ClassDefinition.Companion.getOBJECT_PREAMBLE_SIZE());
    }

    @Override
    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.get(arrayClassObjectId);
        Map $this$getOrPut$iv = this.classToHistogramEntryInternal;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classDefinition);
        if (value$iv == null) {
            boolean bl = false;
            InternalHistogramEntry answer$iv = new InternalHistogramEntry(classDefinition);
            $this$getOrPut$iv.put(classDefinition, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((InternalHistogramEntry)object).addInstance((long)objects.length * (long)this.getVisitorContext().getIdSize() + (long)ClassDefinition.Companion.getARRAY_PREAMBLE_SIZE());
    }

    @Override
    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
        long l = this.instanceCount;
        this.instanceCount = l + 1L;
        ClassDefinition classDefinition = this.classStore.get(classObjectId);
        Map $this$getOrPut$iv = this.classToHistogramEntryInternal;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(classDefinition);
        if (value$iv == null) {
            boolean bl = false;
            InternalHistogramEntry answer$iv = new InternalHistogramEntry(classDefinition);
            $this$getOrPut$iv.put(classDefinition, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((InternalHistogramEntry)object).addInstance((long)classDefinition.getInstanceSize() + (long)ClassDefinition.Companion.getOBJECT_PREAMBLE_SIZE());
    }

    @Override
    public void postVisit() {
        this.completed = true;
    }

    @NotNull
    public final Histogram createHistogram() {
        boolean bl = this.completed;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ArrayList<HistogramEntry> result2 = new ArrayList<HistogramEntry>(this.classToHistogramEntryInternal.size());
        Map $this$forEach$iv = this.classToHistogramEntryInternal;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl2 = false;
            InternalHistogramEntry internalEntry = (InternalHistogramEntry)entry.getValue();
            result2.add(internalEntry.asHistogramEntry());
        }
        List $this$sortByDescending$iv = result2;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    HistogramEntry e = (HistogramEntry)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(e.getTotalInstances());
                    e = (HistogramEntry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(e.getTotalInstances()));
                }
            });
        }
        return new Histogram((List<HistogramEntry>)result2, this.instanceCount);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/HistogramVisitor$InternalHistogramEntry;", "", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;)V", "totalBytes", "", "totalInstances", "addInstance", "", "sizeInBytes", "asHistogramEntry", "Lcom/android/tools/idea/diagnostics/hprof/histogram/HistogramEntry;", "intellij.android.core"})
    public static final class InternalHistogramEntry {
        @NotNull
        private final ClassDefinition classDefinition;
        private long totalInstances;
        private long totalBytes;

        public InternalHistogramEntry(@NotNull ClassDefinition classDefinition) {
            Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
            this.classDefinition = classDefinition;
        }

        public final void addInstance(long sizeInBytes) {
            long l = this.totalInstances;
            this.totalInstances = l + 1L;
            this.totalBytes += sizeInBytes;
        }

        @NotNull
        public final HistogramEntry asHistogramEntry() {
            return new HistogramEntry(this.classDefinition, this.totalInstances, this.totalBytes);
        }
    }
}

