/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.visitors;

import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.classstore.InstanceField;
import com.android.tools.idea.diagnostics.hprof.classstore.StaticField;
import com.android.tools.idea.diagnostics.hprof.parser.ConstantPoolEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfVisitor;
import com.android.tools.idea.diagnostics.hprof.parser.HeapDumpRecordType;
import com.android.tools.idea.diagnostics.hprof.parser.InstanceFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.RecordType;
import com.android.tools.idea.diagnostics.hprof.parser.StaticFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J_\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019H\u0016\u00a2\u0006\u0002\u0010\u001fJ(\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/CreateClassStoreVisitor;", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfVisitor;", "stringIdMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V", "classIDToNameStringID", "Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "completed", "", "result", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "getClassStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "postVisit", "", "preVisit", "visitClassDump", "classId", "", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;)V", "visitLoadClass", "classSerialNumber", "classObjectId", "stackSerialNumber", "classNameStringId", "intellij.android.core"})
public final class CreateClassStoreVisitor
extends HProfVisitor {
    @NotNull
    private final Long2ObjectOpenHashMap<String> stringIdMap;
    @NotNull
    private final Long2LongOpenHashMap classIDToNameStringID;
    @NotNull
    private final Long2ObjectOpenHashMap<ClassDefinition> result;
    private boolean completed;

    public CreateClassStoreVisitor(@NotNull Long2ObjectOpenHashMap<String> stringIdMap) {
        Intrinsics.checkNotNullParameter(stringIdMap, (String)"stringIdMap");
        this.stringIdMap = stringIdMap;
        this.classIDToNameStringID = new Long2LongOpenHashMap();
        this.result = new Long2ObjectOpenHashMap();
    }

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(RecordType.LoadClass);
        this.enable(HeapDumpRecordType.ClassDump);
        this.classIDToNameStringID.clear();
    }

    @Override
    public void postVisit() {
        this.completed = true;
    }

    @Override
    public void visitLoadClass(long classSerialNumber, long classObjectId, long stackSerialNumber, long classNameStringId) {
        this.classIDToNameStringID.put(classObjectId, classNameStringId);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv2;
        int n;
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        List refInstanceFields = new ArrayList();
        List primitiveInstanceFields = new ArrayList();
        List staticFieldList = new ArrayList();
        int currentOffset = 0;
        InstanceFieldEntry[] $this$forEach$iv2 = instanceFields;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv2.length;
        for (int i = 0; i < n2; ++i) {
            InstanceFieldEntry instanceFieldEntry;
            InstanceFieldEntry it = instanceFieldEntry = $this$forEach$iv2[i];
            n = 0;
            String fieldName = (String)this.stringIdMap.get(it.getFieldNameStringId());
            Intrinsics.checkNotNullExpressionValue((Object)fieldName, (String)"fieldName");
            InstanceField field2 = new InstanceField(fieldName, currentOffset, it.getType());
            if (it.getType() != Type.OBJECT) {
                primitiveInstanceFields.add(field2);
                currentOffset += it.getType().getSize();
                continue;
            }
            refInstanceFields.add(field2);
            currentOffset += this.getVisitorContext().getIdSize();
        }
        LongArrayList constantsArray = new LongArrayList(constants.length);
        Object $this$filter$iv = constants;
        boolean $i$f$filter = false;
        ConstantPoolEntry[] constantPoolEntryArray = $this$filter$iv;
        Collection collection2 = new ArrayList();
        boolean $i$f$filterTo = false;
        int fieldName = ((void)$this$filterTo$iv$iv2).length;
        for (n = 0; n < fieldName; ++n) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv2[n];
            boolean bl = false;
            if (!(it.getType() == Type.OBJECT)) continue;
            collection2.add(element$iv$iv);
        }
        $this$filter$iv = (List)collection2;
        boolean $i$f$forEach2 = false;
        for (Object t : $this$forEach$iv) {
            ConstantPoolEntry it = (ConstantPoolEntry)t;
            boolean bl = false;
            constantsArray.add(it.getValue());
        }
        StaticFieldEntry[] $this$filter$iv2 = staticFields;
        boolean $i$f$filter2 = false;
        StaticFieldEntry[] staticFieldEntryArray = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        int element$iv$iv = staticFieldEntryArray.length;
        for (fieldName = 0; fieldName < element$iv$iv; ++fieldName) {
            StaticFieldEntry element$iv$iv2;
            StaticFieldEntry it = element$iv$iv2 = staticFieldEntryArray[fieldName];
            boolean bl = false;
            if (!(it.getType() == Type.OBJECT)) continue;
            destination$iv$iv2.add(element$iv$iv2);
        }
        List objectStaticFields = (List)destination$iv$iv2;
        Iterable $this$forEach$iv3 = objectStaticFields;
        boolean $i$f$forEach3 = false;
        for (Object element$iv3 : $this$forEach$iv3) {
            StaticFieldEntry it = (StaticFieldEntry)element$iv3;
            boolean bl = false;
            Object object = this.stringIdMap.get(it.getFieldNameStringId());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stringIdMap[it.fieldNameStringId]");
            StaticField field3 = new StaticField((String)object, it.getValue());
            staticFieldList.add(field3);
        }
        Object object = this.stringIdMap.get(this.classIDToNameStringID.get(classId));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stringIdMap[classIDToNameStringID[classId]]");
        String string = StringsKt.replace$default((String)((String)object), (char)'/', (char)'.', (boolean)false, (int)4, null);
        int n3 = (int)instanceSize;
        Collection $this$toTypedArray$iv = refInstanceFields;
        boolean $i$f$toTypedArray = false;
        Collection collection3 = $this$toTypedArray$iv;
        InstanceField[] instanceFieldArray = collection3.toArray(new InstanceField[0]);
        if (instanceFieldArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        $this$toTypedArray$iv = primitiveInstanceFields;
        $i$f$toTypedArray = false;
        Collection collection4 = $this$toTypedArray$iv;
        InstanceField[] instanceFieldArray2 = collection4.toArray(new InstanceField[0]);
        if (instanceFieldArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        long[] lArray = constantsArray.toLongArray();
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"constantsArray.toLongArray()");
        $this$toTypedArray$iv = staticFieldList;
        $i$f$toTypedArray = false;
        Collection collection5 = $this$toTypedArray$iv;
        StaticField[] staticFieldArray = collection5.toArray(new StaticField[0]);
        if (staticFieldArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        this.result.put(classId, (Object)new ClassDefinition(string, classId, superClassId, n3, currentOffset, instanceFieldArray, instanceFieldArray2, lArray, staticFieldArray));
    }

    @NotNull
    public final ClassStore getClassStore() {
        boolean bl = this.completed;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new ClassStore(this.result);
    }
}

