/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.visitors;

import com.android.tools.idea.diagnostics.hprof.classstore.ThreadInfo;
import com.android.tools.idea.diagnostics.hprof.parser.HProfVisitor;
import com.android.tools.idea.diagnostics.hprof.parser.RecordType;
import gnu.trove.TLongObjectHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0016\n\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J(\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0016J8\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/CollectThreadInfoVisitor;", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfVisitor;", "threadsMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ThreadInfo;", "stringIdMap", "", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V", "classSerialNumberToNameMap", "Lgnu/trove/TLongObjectHashMap;", "stackFrameIdToStringMap", "getStackFrameString", "methodNameStringId", "", "sourceFilenameStringId", "classSerialNumber", "lineNumber", "", "preVisit", "", "visitLoadClass", "classObjectId", "stackSerialNumber", "classNameStringId", "visitStackFrame", "stackFrameId", "methodSignatureStringId", "visitStackTrace", "stackTraceSerialNumber", "threadSerialNumber", "numberOfFrames", "stackFrameIds", "", "intellij.android.core"})
public final class CollectThreadInfoVisitor
extends HProfVisitor {
    @NotNull
    private final Long2ObjectOpenHashMap<ThreadInfo> threadsMap;
    @NotNull
    private final Long2ObjectOpenHashMap<String> stringIdMap;
    @NotNull
    private final TLongObjectHashMap<String> stackFrameIdToStringMap;
    @NotNull
    private final TLongObjectHashMap<String> classSerialNumberToNameMap;

    public CollectThreadInfoVisitor(@NotNull Long2ObjectOpenHashMap<ThreadInfo> threadsMap, @NotNull Long2ObjectOpenHashMap<String> stringIdMap) {
        Intrinsics.checkNotNullParameter(threadsMap, (String)"threadsMap");
        Intrinsics.checkNotNullParameter(stringIdMap, (String)"stringIdMap");
        this.threadsMap = threadsMap;
        this.stringIdMap = stringIdMap;
        this.stackFrameIdToStringMap = new TLongObjectHashMap();
        this.classSerialNumberToNameMap = new TLongObjectHashMap();
    }

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(RecordType.StackFrame);
        this.enable(RecordType.StackTrace);
        this.enable(RecordType.LoadClass);
    }

    @Override
    public void visitLoadClass(long classSerialNumber, long classObjectId, long stackSerialNumber, long classNameStringId) {
        Object object = this.stringIdMap.get(classNameStringId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stringIdMap[classNameStringId]");
        this.classSerialNumberToNameMap.put(classSerialNumber, (Object)StringsKt.replace$default((String)((String)object), (String)"/", (String)".", (boolean)false, (int)4, null));
    }

    @Override
    public void visitStackFrame(long stackFrameId, long methodNameStringId, long methodSignatureStringId, long sourceFilenameStringId, long classSerialNumber, int lineNumber) {
        this.stackFrameIdToStringMap.put(stackFrameId, (Object)this.getStackFrameString(methodNameStringId, sourceFilenameStringId, classSerialNumber, lineNumber));
    }

    private final String getStackFrameString(long methodNameStringId, long sourceFilenameStringId, long classSerialNumber, int lineNumber) {
        StringBuilder stringBuilder;
        StringBuilder $this$getStackFrameString_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (classSerialNumber != 0L) {
            $this$getStackFrameString_u24lambda_u2d0.append((String)this.classSerialNumberToNameMap.get(classSerialNumber));
            $this$getStackFrameString_u24lambda_u2d0.append(".");
            if (methodNameStringId != 0L) {
                $this$getStackFrameString_u24lambda_u2d0.append((String)this.stringIdMap.get(methodNameStringId));
            } else {
                $this$getStackFrameString_u24lambda_u2d0.append("<unknown method>");
            }
        } else {
            $this$getStackFrameString_u24lambda_u2d0.append("<unknown location>");
        }
        if (lineNumber == -1) {
            $this$getStackFrameString_u24lambda_u2d0.append("(Native method)");
        } else if (sourceFilenameStringId != 0L) {
            $this$getStackFrameString_u24lambda_u2d0.append("(" + this.stringIdMap.get(sourceFilenameStringId));
            if (lineNumber > 0) {
                $this$getStackFrameString_u24lambda_u2d0.append(":" + lineNumber);
            }
            $this$getStackFrameString_u24lambda_u2d0.append(")");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    public void visitStackTrace(long stackTraceSerialNumber, long threadSerialNumber, int numberOfFrames, @NotNull long[] stackFrameIds) {
        Intrinsics.checkNotNullParameter((Object)stackFrameIds, (String)"stackFrameIds");
        ArrayList<Object> frames = new ArrayList<Object>(stackFrameIds.length);
        int n = stackFrameIds.length;
        for (int i = 0; i < n; ++i) {
            frames.add(this.stackFrameIdToStringMap.get(stackFrameIds[i]));
        }
        this.threadsMap.put(threadSerialNumber, (Object)new ThreadInfo((List<String>)frames));
    }
}

