/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.util;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.util.TreeNode;
import com.android.tools.idea.diagnostics.hprof.util.TreeVisualizer;
import com.android.tools.idea.diagnostics.hprof.util.TruncatingPrintBuffer;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/TreeVisualizer;", "", "()V", "visualizeTree", "", "root", "Lcom/android/tools/idea/diagnostics/hprof/util/TreeNode;", "buffer", "Lcom/android/tools/idea/diagnostics/hprof/util/TruncatingPrintBuffer;", "options", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$DisposerTreeSummaryOptions;", "IndentStore", "intellij.android.core"})
public final class TreeVisualizer {
    public final void visualizeTree(@NotNull TreeNode root, @NotNull TruncatingPrintBuffer buffer, @NotNull AnalysisConfig.DisposerTreeSummaryOptions options2) {
        Stack<StackItem> stack;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Stack<StackItem> $this$visualizeTree_u24lambda_u2d0 = stack = new Stack<StackItem>();
        boolean bl = false;
        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000'\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"com/android/tools/idea/diagnostics/hprof/util/TreeVisualizer$visualizeTree$StackItem", "", "node", "Lcom/android/tools/idea/diagnostics/hprof/util/TreeNode;", "depth", "", "(Lcom/android/tools/idea/diagnostics/hprof/util/TreeNode;I)V", "getDepth", "()I", "getNode", "()Lcom/android/tools/idea/diagnostics/hprof/util/TreeNode;", "component1", "component2", "copy", "(Lcom/android/tools/idea/diagnostics/hprof/util/TreeNode;I)Lcom/android/tools/idea/diagnostics/hprof/util/TreeVisualizer$visualizeTree$StackItem;", "equals", "", "other", "hashCode", "toString", "", "intellij.android.core"})
        public final class StackItem {
            @NotNull
            private final TreeNode node;
            private final int depth;

            public StackItem(@NotNull TreeNode node, int depth) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.node = node;
                this.depth = depth;
            }

            @NotNull
            public final TreeNode getNode() {
                return this.node;
            }

            public final int getDepth() {
                return this.depth;
            }

            @NotNull
            public final TreeNode component1() {
                return this.node;
            }

            public final int component2() {
                return this.depth;
            }

            @NotNull
            public final StackItem copy(@NotNull TreeNode node, int depth) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return new StackItem(node, depth);
            }

            public static /* synthetic */ StackItem copy$default(StackItem stackItem, TreeNode treeNode, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    treeNode = stackItem.node;
                }
                if ((n2 & 2) != 0) {
                    n = stackItem.depth;
                }
                return stackItem.copy(treeNode, n);
            }

            @NotNull
            public String toString() {
                return "StackItem(node=" + this.node + ", depth=" + this.depth + ")";
            }

            public int hashCode() {
                int result2 = this.node.hashCode();
                result2 = result2 * 31 + Integer.hashCode(this.depth);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StackItem)) {
                    return false;
                }
                StackItem stackItem = (StackItem)other;
                if (!Intrinsics.areEqual((Object)this.node, (Object)stackItem.node)) {
                    return false;
                }
                return this.depth == stackItem.depth;
            }
        }
        $this$visualizeTree_u24lambda_u2d0.push(new StackItem(root, 0));
        Stack<StackItem> nodeStack = stack;
        IndentStore indentStore = new IndentStore();
        while (!nodeStack.empty()) {
            StackItem stackItem = (StackItem)nodeStack.pop();
            TreeNode node = stackItem.component1();
            int depth = stackItem.component2();
            String indent = indentStore.getIndentForDepth(depth);
            buffer.println(indent + node.description());
            List children = CollectionsKt.reversed((Iterable)node.children());
            if (depth >= options2.getMaxDepth() && !((Collection)children).isEmpty()) {
                buffer.println(indentStore.getIndentForDepth(depth + 1) + "[...]");
                continue;
            }
            Iterable $this$forEach$iv = children;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TreeNode child = (TreeNode)element$iv;
                boolean bl2 = false;
                nodeStack.push(new StackItem(child, depth + 1));
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/TreeVisualizer$IndentStore;", "", "()V", "map", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "", "getIndentForDepth", "size", "", "intellij.android.core"})
    private static final class IndentStore {
        @NotNull
        private final Int2ObjectOpenHashMap<String> map = new Int2ObjectOpenHashMap();

        @NotNull
        public final String getIndentForDepth(int size) {
            if (this.map.containsKey(size)) {
                Object object = this.map.get(size);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"map[size]");
                return (String)object;
            }
            String indent = StringsKt.repeat((CharSequence)"  ", (int)size);
            Integer n = size;
            ((Map)this.map).put(n, indent);
            return indent;
        }
    }
}

