/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.util;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/util/FileChannelBackedWriteBuffer;", "Ljava/io/Closeable;", "channel", "Ljava/nio/channels/FileChannel;", "closeOutput", "", "(Ljava/nio/channels/FileChannel;Z)V", "closed", "position", "", "tempBuf", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "close", "", "flushBuffer", "writeByte", "value", "", "writeInt", "writeLong", "", "writeNonNegativeLEB128Int", "writeShort", "", "writeString", "s", "", "intellij.android.core"})
public final class FileChannelBackedWriteBuffer
implements Closeable {
    @NotNull
    private final FileChannel channel;
    private final boolean closeOutput;
    private final ByteBuffer tempBuf;
    private int position;
    private boolean closed;

    public FileChannelBackedWriteBuffer(@NotNull FileChannel channel, boolean closeOutput) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
        this.closeOutput = closeOutput;
        this.tempBuf = ByteBuffer.allocateDirect(71680);
    }

    public /* synthetic */ FileChannelBackedWriteBuffer(FileChannel fileChannel, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(fileChannel, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.flushBuffer();
            }
            finally {
                if (this.closeOutput) {
                    this.channel.close();
                }
            }
        }
    }

    private final void flushBuffer() {
        this.tempBuf.flip();
        this.channel.write(this.tempBuf);
        this.tempBuf.clear();
    }

    public final void writeLong(long value2) {
        if (this.tempBuf.remaining() < 8) {
            this.flushBuffer();
        }
        this.tempBuf.putLong(value2);
        this.position += 8;
    }

    public final void writeInt(int value2) {
        if (this.tempBuf.remaining() < 4) {
            this.flushBuffer();
        }
        this.tempBuf.putInt(value2);
        this.position += 4;
    }

    public final void writeShort(short value2) {
        if (this.tempBuf.remaining() < 2) {
            this.flushBuffer();
        }
        this.tempBuf.putShort(value2);
        this.position += 2;
    }

    public final void writeByte(byte value2) {
        if (this.tempBuf.remaining() < 1) {
            this.flushBuffer();
        }
        this.tempBuf.put(value2);
        ++this.position;
    }

    public final void writeNonNegativeLEB128Int(int value2) {
        boolean bl;
        boolean bl2 = bl = value2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int v = value2;
        do {
            int b = v & 0x7F;
            if ((v >>= 7) != 0) {
                b |= 0x80;
            }
            this.writeByte((byte)b);
        } while (v != 0);
    }

    public final void writeString(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] byArray = s.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes2 = byArray;
        if (bytes2.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("String too long.");
        }
        this.writeShort((short)s.length());
        if (this.tempBuf.remaining() < bytes2.length) {
            this.flushBuffer();
        }
        this.tempBuf.put(bytes2);
        this.position += 2 + bytes2.length;
    }

    public final int position() {
        return this.position;
    }
}

