/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.histogram;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.histogram.HistogramEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.TruncatingPrintBuffer;
import com.android.tools.idea.diagnostics.hprof.visitors.HistogramVisitor;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "", "entries", "", "Lcom/android/tools/idea/diagnostics/hprof/histogram/HistogramEntry;", "instanceCount", "", "(Ljava/util/List;J)V", "bytesCount", "getBytesCount", "()J", "getEntries", "()Ljava/util/List;", "getInstanceCount", "getTotals", "Lkotlin/Pair;", "prepareReport", "", "name", "topClassCount", "", "Companion", "intellij.android.core"})
public final class Histogram {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<HistogramEntry> entries;
    private final long instanceCount;
    private final long bytesCount;

    public Histogram(@NotNull List<HistogramEntry> entries2, long instanceCount) {
        Intrinsics.checkNotNullParameter(entries2, (String)"entries");
        this.entries = entries2;
        this.instanceCount = instanceCount;
        this.bytesCount = ((Number)this.getTotals().getSecond()).longValue();
    }

    @NotNull
    public final List<HistogramEntry> getEntries() {
        return this.entries;
    }

    public final long getInstanceCount() {
        return this.instanceCount;
    }

    private final Pair<Long, Long> getTotals() {
        long totalInstances = 0L;
        long totalBytes = 0L;
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HistogramEntry it = (HistogramEntry)element$iv;
            boolean bl = false;
            totalBytes += it.getTotalBytes();
            totalInstances += it.getTotalInstances();
        }
        return new Pair((Object)totalInstances, (Object)totalBytes);
    }

    public final long getBytesCount() {
        return this.bytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String prepareReport(@NotNull String name, int topClassCount) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        StringBuilder $this$prepareReport_u24lambda_u2d4 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$prepareReport_u24lambda_u2d4.append("Histogram. Top " + topClassCount + " by instance count:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        Function1 appendToResult2 = (Function1)new Function1<String, Unit>($this$prepareReport_u24lambda_u2d4){
            final /* synthetic */ StringBuilder $this_buildString;
            {
                this.$this_buildString = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                StringBuilder stringBuilder = this.$this_buildString.append(s);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
            }
        };
        int counter = 0;
        counter = 1;
        Closeable closeable = new TruncatingPrintBuffer(topClassCount, 0, (Function1<? super String, ? extends Object>)appendToResult2);
        Throwable throwable = null;
        try {
            TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)closeable;
            boolean bl2 = false;
            Iterable $this$forEach$iv = this.entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HistogramEntry entry = (HistogramEntry)element$iv;
                boolean bl3 = false;
                buffer.println(Histogram.Companion.formatEntryLine(counter, entry));
                ++counter;
            }
            buffer = Unit.INSTANCE;
        }
        catch (Throwable buffer) {
            throwable = buffer;
            throw buffer;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        StringBuilder stringBuilder3 = $this$prepareReport_u24lambda_u2d4.append(Histogram.Companion.getSummaryLine(this, name));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        StringsKt.appendln((StringBuilder)$this$prepareReport_u24lambda_u2d4);
        StringBuilder stringBuilder4 = $this$prepareReport_u24lambda_u2d4.append("Top 10 by bytes count:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        Iterable $this$sortedByDescending$iv = this.entries;
        boolean $i$f$sortedByDescending = false;
        List entriesByBytes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalBytes());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalBytes()));
            }
        });
        int n = Math.min(10, this.entries.size());
        for (int i = 0; i < n; ++i) {
            HistogramEntry entry = (HistogramEntry)entriesByBytes.get(i);
            StringBuilder stringBuilder5 = $this$prepareReport_u24lambda_u2d4.append(Histogram.Companion.formatEntryLine(i + 1, entry));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\nH\u0002J.\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram$Companion;", "", "()V", "create", "Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "parser", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "formatEntryLine", "", "counter", "", "entry", "Lcom/android/tools/idea/diagnostics/hprof/histogram/HistogramEntry;", "formatEntryLineMerged", "entry2", "getSummaryLine", "histogram", "histogramName", "prepareMergedHistogramReport", "mainHistogram", "mainHistogramName", "secondaryHistogram", "secondaryHistogramName", "options", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$HistogramOptions;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Histogram create(@NotNull HProfEventBasedParser parser2, @NotNull ClassStore classStore) {
            Intrinsics.checkNotNullParameter((Object)parser2, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
            HistogramVisitor histogramVisitor = new HistogramVisitor(classStore);
            parser2.accept(histogramVisitor, "histogram");
            return histogramVisitor.createHistogram();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String prepareMergedHistogramReport(@NotNull Histogram mainHistogram, @NotNull String mainHistogramName, @NotNull Histogram secondaryHistogram, @NotNull String secondaryHistogramName, @NotNull AnalysisConfig.HistogramOptions options2) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)mainHistogram, (String)"mainHistogram");
            Intrinsics.checkNotNullParameter((Object)mainHistogramName, (String)"mainHistogramName");
            Intrinsics.checkNotNullParameter((Object)secondaryHistogram, (String)"secondaryHistogram");
            Intrinsics.checkNotNullParameter((Object)secondaryHistogramName, (String)"secondaryHistogramName");
            Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
            StringBuilder $this$prepareMergedHistogramReport_u24lambda_u2d4 = stringBuilder = new StringBuilder();
            boolean bl = false;
            HashMap mapClassNameToEntrySecondary = new HashMap();
            Iterable $this$forEach$iv = secondaryHistogram.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HistogramEntry it = (HistogramEntry)element$iv;
                boolean bl2 = false;
                ((Map)mapClassNameToEntrySecondary).put(it.getClassDefinition().getName(), it);
            }
            String summary = Companion.getSummaryLine(mainHistogram, mainHistogramName) + System.lineSeparator() + Companion.getSummaryLine(secondaryHistogram, secondaryHistogramName);
            if (options2.getIncludeByCount()) {
                Object element$iv;
                StringBuilder stringBuilder2 = $this$prepareMergedHistogramReport_u24lambda_u2d4.append("Histogram. Top " + options2.getClassByCountLimit() + " by instance count [All-objects] [Only-strong-ref]:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                int counter = 0;
                counter = 1;
                Closeable closeable = new TruncatingPrintBuffer(options2.getClassByCountLimit(), 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$prepareMergedHistogramReport_u24lambda_u2d4){

                    @NotNull
                    public final StringBuilder invoke(@Nullable String p0) {
                        StringBuilder stringBuilder = ((StringBuilder)this.receiver).append(p0);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                        return StringsKt.appendln((StringBuilder)stringBuilder);
                    }
                }));
                element$iv = null;
                try {
                    TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)closeable;
                    boolean bl3 = false;
                    Iterable $this$forEach$iv2 = mainHistogram.getEntries();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        HistogramEntry entry = (HistogramEntry)element$iv2;
                        boolean bl4 = false;
                        HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                        buffer.println(Companion.formatEntryLineMerged(counter, entry, entry2));
                        ++counter;
                    }
                    buffer = Unit.INSTANCE;
                }
                catch (Throwable buffer) {
                    element$iv = buffer;
                    throw buffer;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, element$iv);
                }
                StringBuilder stringBuilder3 = $this$prepareMergedHistogramReport_u24lambda_u2d4.append(summary);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
            }
            if (options2.getIncludeBySize() && options2.getIncludeByCount()) {
                StringsKt.appendln((StringBuilder)$this$prepareMergedHistogramReport_u24lambda_u2d4);
            }
            if (options2.getIncludeBySize()) {
                int classCountInByBytesSection = Math.min(mainHistogram.getEntries().size(), options2.getClassBySizeLimit());
                StringBuilder stringBuilder4 = $this$prepareMergedHistogramReport_u24lambda_u2d4.append("Top " + classCountInByBytesSection + " by size:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder4);
                Iterable $this$sortedByDescending$iv = mainHistogram.getEntries();
                boolean $i$f$sortedByDescending = false;
                List entriesByBytes = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        HistogramEntry it = (HistogramEntry)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTotalBytes());
                        it = (HistogramEntry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalBytes()));
                    }
                });
                for (int i = 0; i < classCountInByBytesSection; ++i) {
                    HistogramEntry entry = (HistogramEntry)entriesByBytes.get(i);
                    HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                    StringBuilder stringBuilder5 = $this$prepareMergedHistogramReport_u24lambda_u2d4.append(Companion.formatEntryLineMerged(i + 1, entry, entry2));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder5);
                }
                if (!options2.getIncludeByCount()) {
                    StringBuilder stringBuilder6 = $this$prepareMergedHistogramReport_u24lambda_u2d4.append(summary);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder6);
                }
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private final String getSummaryLine(Histogram histogram2, String histogramName) {
            Pair pair = histogram2.getTotals();
            long totalInstances = ((Number)pair.component1()).longValue();
            long totalBytes = ((Number)pair.component2()).longValue();
            String string = "Total - %10s: %s %s %d classes (Total instances: %d)";
            Object[] objectArray = new Object[]{histogramName, HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(totalInstances), HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(totalBytes), histogram2.getEntries().size(), histogram2.getInstanceCount()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        private final String formatEntryLineMerged(int counter, HistogramEntry entry, HistogramEntry entry2) {
            String string = "%5d: [%s/%s] [%s/%s] %s";
            Object[] objectArray = new Object[6];
            objectArray[0] = counter;
            objectArray[1] = HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(entry.getTotalInstances());
            objectArray[2] = HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getTotalBytes());
            HistogramEntry histogramEntry = entry2;
            objectArray[3] = HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(histogramEntry != null ? histogramEntry.getTotalInstances() : 0L);
            HistogramEntry histogramEntry2 = entry2;
            objectArray[4] = HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(histogramEntry2 != null ? histogramEntry2.getTotalBytes() : 0L);
            objectArray[5] = entry.getClassDefinition().getPrettyName();
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        private final String formatEntryLine(int counter, HistogramEntry entry) {
            String string = "%5d: [%s/%s] %s";
            Object[] objectArray = new Object[]{counter, HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(entry.getTotalInstances()), HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getTotalBytes()), entry.getClassDefinition().getPrettyName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

