/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.classstore;

import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u001fJ\u0011\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020#H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0013H\u0086\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u000eJ\u0010\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0004J\u0006\u0010*\u001a\u00020\"R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00040\nj\b\u0012\u0004\u0012\u00020\u0004`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\rj\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\b\u00a8\u0006+"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "", "classes", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V", "classClass", "getClassClass", "()Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "classDefinitionToShortPrettyName", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "primitiveArrayToClassDefinition", "Ljava/util/HashMap;", "Lcom/android/tools/idea/diagnostics/hprof/parser/Type;", "Lkotlin/collections/HashMap;", "softReferenceClass", "getSoftReferenceClass", "stringToClassDefinition", "", "weakReferenceClass", "getWeakReferenceClass", "containsClass", "", "name", "createStoreWithRemappedIDs", "remappingFunction", "Ljava/util/function/LongUnaryOperator;", "forEachClass", "", "func", "Lkotlin/Function1;", "get", "id", "", "", "getClassForPrimitiveArray", "t", "getClassIfExists", "getShortPrettyNameForClass", "classDefinition", "isSoftOrWeakReferenceClass", "size", "intellij.android.core"})
public final class ClassStore {
    @NotNull
    private final Long2ObjectOpenHashMap<ClassDefinition> classes;
    @NotNull
    private final HashMap<String, ClassDefinition> stringToClassDefinition;
    @NotNull
    private final HashSet<ClassDefinition> classDefinitionToShortPrettyName;
    @NotNull
    private final ClassDefinition softReferenceClass;
    @NotNull
    private final ClassDefinition weakReferenceClass;
    @NotNull
    private final ClassDefinition classClass;
    @NotNull
    private final HashMap<Type, ClassDefinition> primitiveArrayToClassDefinition;

    public ClassStore(@NotNull Long2ObjectOpenHashMap<ClassDefinition> classes2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(classes2, (String)"classes");
        this.classes = classes2;
        this.stringToClassDefinition = new HashMap();
        this.classDefinitionToShortPrettyName = new HashSet();
        this.primitiveArrayToClassDefinition = new HashMap();
        Set clashedClassNames = new LinkedHashSet();
        Collection collection2 = this.classes.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"classes.values");
        Type[] $this$forEach$iv = (Type[])collection2;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            ClassDefinition classDefinition = (ClassDefinition)t;
            bl = false;
            String className = classDefinition.getName();
            boolean clashed = false;
            if (clashedClassNames.contains(className)) {
                clashed = true;
            } else {
                ClassDefinition clashedClass = this.stringToClassDefinition.remove(className);
                if (clashedClass != null) {
                    clashed = true;
                    ClassDefinition newDefinition = clashedClass.copyWithName(ClassStore._init_$getClashedNameWithIndex(clashedClass, 1));
                    ((Map)this.stringToClassDefinition).put(newDefinition.getName(), newDefinition);
                    this.classes.put(clashedClass.getId(), (Object)newDefinition);
                    clashedClassNames.add(className);
                }
            }
            if (clashed) {
                int i = 2;
                String newName2 = null;
                do {
                    Intrinsics.checkNotNullExpressionValue((Object)classDefinition, (String)"classDefinition");
                    newName2 = ClassStore._init_$getClashedNameWithIndex(classDefinition, i);
                    ++i;
                } while (this.stringToClassDefinition.containsKey(newName2));
                ClassDefinition newClassDefinition = classDefinition.copyWithName(newName2);
                ((Map)this.stringToClassDefinition).put(newName2, newClassDefinition);
                this.classes.put(classDefinition.getId(), (Object)newClassDefinition);
                continue;
            }
            Map map2 = this.stringToClassDefinition;
            String string = classDefinition.getName();
            Intrinsics.checkNotNullExpressionValue((Object)classDefinition, (String)"classDefinition");
            map2.put(string, classDefinition);
        }
        $this$forEach$iv = clashedClassNames;
        $i$f$forEach = false;
        for (Object iterator2 : $this$forEach$iv) {
            boolean className;
            String string = (String)iterator2;
            bl = false;
            boolean bl2 = className = !((Map)this.stringToClassDefinition).containsKey(string);
            if (!_Assertions.ENABLED || className) continue;
            String clashed = "Assertion failed";
            throw new AssertionError((Object)clashed);
        }
        ClassDefinition classDefinition = this.stringToClassDefinition.get("java.lang.ref.SoftReference");
        Intrinsics.checkNotNull((Object)classDefinition);
        this.softReferenceClass = classDefinition;
        ClassDefinition classDefinition2 = this.stringToClassDefinition.get("java.lang.ref.WeakReference");
        Intrinsics.checkNotNull((Object)classDefinition2);
        this.weakReferenceClass = classDefinition2;
        ClassDefinition classDefinition3 = this.stringToClassDefinition.get("java.lang.Class");
        Intrinsics.checkNotNull((Object)classDefinition3);
        this.classClass = classDefinition3;
        $this$forEach$iv = Type.values();
        $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ClassDefinition classDefinition4;
            Type type;
            Type type2 = type = $this$forEach$iv[i];
            boolean bl3 = false;
            if (type2 == Type.OBJECT) continue;
            if (this.stringToClassDefinition.get(type2.getClassNameOfPrimitiveArray()) == null) continue;
            boolean bl32 = false;
            this.primitiveArrayToClassDefinition.put(type2, classDefinition4);
        }
        HashMap shortNameToClassDefinition = new HashMap();
        Collection collection3 = this.classes.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"classes.values");
        Iterable $this$forEach$iv2 = collection3;
        boolean $i$f$forEach2 = false;
        for (Object t : $this$forEach$iv2) {
            ClassDefinition it = (ClassDefinition)t;
            boolean bl4 = false;
            if (StringsKt.contains$default((CharSequence)it.getName(), (char)'$', (boolean)false, (int)2, null)) continue;
            String prettyName = it.getPrettyName();
            String shortPrettyName = StringsKt.substringAfterLast$default((String)prettyName, (char)'.', null, (int)2, null);
            if (shortNameToClassDefinition.containsKey(shortPrettyName)) {
                ClassDefinition prevClassDefinition = (ClassDefinition)shortNameToClassDefinition.get(shortPrettyName);
                if (prevClassDefinition == null) continue;
                ((Map)shortNameToClassDefinition).put(shortPrettyName, null);
                continue;
            }
            ((Map)shortNameToClassDefinition).put(shortPrettyName, it);
        }
        Map $this$forEach$iv3 = shortNameToClassDefinition;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl5 = false;
            ClassDefinition classDef = (ClassDefinition)entry2.getValue();
            if (classDef == null) continue;
            this.classDefinitionToShortPrettyName.add(classDef);
        }
    }

    @NotNull
    public final ClassDefinition getSoftReferenceClass() {
        return this.softReferenceClass;
    }

    @NotNull
    public final ClassDefinition getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    @NotNull
    public final ClassDefinition getClassClass() {
        return this.classClass;
    }

    @NotNull
    public final ClassDefinition get(int id2) {
        Object object = this.classes.get((long)id2);
        Intrinsics.checkNotNull((Object)object);
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(long id2) {
        Object object = this.classes.get(id2);
        Intrinsics.checkNotNull((Object)object);
        return (ClassDefinition)object;
    }

    @NotNull
    public final ClassDefinition get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ClassDefinition classDefinition = this.stringToClassDefinition.get(name);
        Intrinsics.checkNotNull((Object)classDefinition);
        return classDefinition;
    }

    @Nullable
    public final ClassDefinition getClassIfExists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.stringToClassDefinition.get(name);
    }

    public final boolean containsClass(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.stringToClassDefinition.containsKey(name);
    }

    @Nullable
    public final ClassDefinition getClassForPrimitiveArray(@NotNull Type t) {
        Intrinsics.checkNotNullParameter((Object)((Object)t), (String)"t");
        return this.primitiveArrayToClassDefinition.get((Object)t);
    }

    public final int size() {
        return ((Map)this.classes).size();
    }

    public final boolean isSoftOrWeakReferenceClass(@NotNull ClassDefinition classDefinition) {
        Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
        return Intrinsics.areEqual((Object)classDefinition, (Object)this.softReferenceClass) || Intrinsics.areEqual((Object)classDefinition, (Object)this.weakReferenceClass);
    }

    public final void forEachClass(@NotNull Function1<? super ClassDefinition, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        Collection collection2 = this.classes.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"classes.values");
        Iterable $this$forEach$iv = collection2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassDefinition it = (ClassDefinition)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            func.invoke((Object)it);
        }
    }

    @NotNull
    public final ClassStore createStoreWithRemappedIDs(@NotNull LongUnaryOperator remappingFunction) {
        Intrinsics.checkNotNullParameter((Object)remappingFunction, (String)"remappingFunction");
        Long2ObjectOpenHashMap newClasses = new Long2ObjectOpenHashMap();
        Collection collection2 = this.classes.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"classes.values");
        Iterable $this$forEach$iv = collection2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassDefinition it = (ClassDefinition)element$iv;
            boolean bl = false;
            newClasses.put(ClassStore.createStoreWithRemappedIDs$map(remappingFunction, it.getId()), (Object)it.copyWithRemappedIDs(remappingFunction));
        }
        return new ClassStore((Long2ObjectOpenHashMap<ClassDefinition>)newClasses);
    }

    @NotNull
    public final String getShortPrettyNameForClass(@NotNull ClassDefinition classDefinition) {
        ClassDefinition outerClass;
        Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
        if (StringsKt.contains$default((CharSequence)classDefinition.getName(), (char)'$', (boolean)false, (int)2, null) ? (outerClass = this.stringToClassDefinition.get(StringsKt.substringBefore$default((String)classDefinition.getName(), (char)'$', null, (int)2, null))) != null && this.classDefinitionToShortPrettyName.contains(outerClass) : this.classDefinitionToShortPrettyName.contains(classDefinition)) {
            return StringsKt.substringAfterLast$default((String)classDefinition.getPrettyName(), (char)'.', null, (int)2, null);
        }
        return classDefinition.getPrettyName();
    }

    private static final String _init_$getClashedNameWithIndex(ClassDefinition classDefinition, int index2) {
        if (StringsKt.endsWith$default((CharSequence)classDefinition.getName(), (char)';', (boolean)false, (int)2, null)) {
            return StringsKt.removeSuffix((String)classDefinition.getName(), (CharSequence)";") + "!" + index2 + ";";
        }
        return classDefinition.getName() + "!" + index2;
    }

    private static final long createStoreWithRemappedIDs$map(LongUnaryOperator $remappingFunction, long id2) {
        return $remappingFunction.applyAsLong(id2);
    }
}

