/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.analysis;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisContext;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisReport;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalyzeGraph;
import com.android.tools.idea.diagnostics.hprof.analysis.ClassNomination;
import com.android.tools.idea.diagnostics.hprof.classstore.HProfMetadata;
import com.android.tools.idea.diagnostics.hprof.histogram.Histogram;
import com.android.tools.idea.diagnostics.hprof.histogram.HistogramEntry;
import com.android.tools.idea.diagnostics.hprof.navigator.ObjectNavigator;
import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.util.FileBackedIntList;
import com.android.tools.idea.diagnostics.hprof.util.FileBackedUByteList;
import com.android.tools.idea.diagnostics.hprof.util.FileBackedUShortList;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.IntList;
import com.android.tools.idea.diagnostics.hprof.util.ListProvider;
import com.android.tools.idea.diagnostics.hprof.util.PartialProgressIndicator;
import com.android.tools.idea.diagnostics.hprof.util.UByteList;
import com.android.tools.idea.diagnostics.hprof.util.UShortList;
import com.android.tools.idea.diagnostics.hprof.visitors.RemapIDsVisitor;
import com.google.common.base.Stopwatch;
import com.intellij.openapi.progress.ProgressIndicator;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\fH\u0007R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis;", "", "hprofFileChannel", "Ljava/nio/channels/FileChannel;", "tempFilenameSupplier", "Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFilenameSupplier;", "(Ljava/nio/channels/FileChannel;Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFilenameSupplier;)V", "fileBackedListProvider", "Lcom/android/tools/idea/diagnostics/hprof/util/ListProvider;", "getFileBackedListProvider", "()Lcom/android/tools/idea/diagnostics/hprof/util/ListProvider;", "includeMetaInfo", "", "tempFiles", "", "Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFile;", "analyze", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "closeAndDeleteTemporaryFiles", "", "isSupported", "instanceCount", "", "openTempEmptyFileChannel", "type", "setIncludeMetaInfo", "value", "TempFile", "TempFilenameSupplier", "intellij.android.core"})
public final class HProfAnalysis {
    @NotNull
    private final FileChannel hprofFileChannel;
    @NotNull
    private final TempFilenameSupplier tempFilenameSupplier;
    @NotNull
    private final List<TempFile> tempFiles;
    private boolean includeMetaInfo;
    @NotNull
    private final ListProvider fileBackedListProvider;

    public HProfAnalysis(@NotNull FileChannel hprofFileChannel, @NotNull TempFilenameSupplier tempFilenameSupplier) {
        Intrinsics.checkNotNullParameter((Object)hprofFileChannel, (String)"hprofFileChannel");
        Intrinsics.checkNotNullParameter((Object)tempFilenameSupplier, (String)"tempFilenameSupplier");
        this.hprofFileChannel = hprofFileChannel;
        this.tempFilenameSupplier = tempFilenameSupplier;
        this.tempFiles = new ArrayList();
        this.includeMetaInfo = true;
        this.fileBackedListProvider = new ListProvider(this){
            final /* synthetic */ HProfAnalysis this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public UByteList createUByteList(@NotNull String name, long size) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return FileBackedUByteList.Companion.createEmpty(HProfAnalysis.access$openTempEmptyFileChannel(this.this$0, name), size);
            }

            @NotNull
            public UShortList createUShortList(@NotNull String name, long size) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return FileBackedUShortList.Companion.createEmpty(HProfAnalysis.access$openTempEmptyFileChannel(this.this$0, name), size);
            }

            @NotNull
            public IntList createIntList(@NotNull String name, long size) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return FileBackedIntList.Companion.createEmpty(HProfAnalysis.access$openTempEmptyFileChannel(this.this$0, name), size);
            }
        };
    }

    @TestOnly
    public final void setIncludeMetaInfo(boolean value2) {
        this.includeMetaInfo = value2;
    }

    private final FileChannel openTempEmptyFileChannel(String type) {
        Path tempPath = this.tempFilenameSupplier.getTempFilePath(type);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE};
        FileChannel tempChannel = FileChannel.open(tempPath, openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)tempChannel, (String)"tempChannel");
        this.tempFiles.add(new TempFile(type, tempPath, tempChannel));
        return tempChannel;
    }

    @NotNull
    public final ListProvider getFileBackedListProvider() {
        return this.fileBackedListProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String analyze(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        StringBuilder result2 = new StringBuilder();
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        Stopwatch prepareFilesStopwatch = Stopwatch.createStarted();
        Stopwatch analysisStopwatch = Stopwatch.createUnstarted();
        progress2.setText("Analyze Heap");
        progress2.setText2("Open heap file");
        progress2.setFraction(0.0);
        HProfEventBasedParser parser2 = new HProfEventBasedParser(this.hprofFileChannel);
        try {
            void $this$mapTo$iv$iv;
            progress2.setText2("Collect heap metadata");
            progress2.setFraction(0.0);
            HProfMetadata hprofMetadata = HProfMetadata.Companion.create(parser2);
            progress2.setText2("Create histogram");
            progress2.setFraction(0.1);
            Histogram histogram2 = Histogram.Companion.create(parser2, hprofMetadata.getClassStore());
            List<HistogramEntry> nominatedClasses = new ClassNomination(histogram2, 5).nominateClasses();
            progress2.setText2("Remap object IDs");
            progress2.setFraction(0.2);
            if (!this.isSupported(histogram2.getInstanceCount())) {
                StringBuilder stringBuilder = result2.append(histogram2.prepareReport("All", 50));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
                String string = result2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
                String string2 = string;
                return string2;
            }
            FileChannel idMappingChannel = this.openTempEmptyFileChannel("id-mapping");
            RemapIDsVisitor remapIDsVisitor = RemapIDsVisitor.Companion.createFileBased(idMappingChannel, histogram2.getInstanceCount());
            parser2.accept(remapIDsVisitor, "id mapping");
            parser2.setIdRemappingFunction(remapIDsVisitor.getRemappingFunction());
            hprofMetadata.remapIds(remapIDsVisitor.getRemappingFunction());
            progress2.setText2("Create reference graph");
            progress2.setFraction(0.3);
            ObjectNavigator navigator = ObjectNavigator.Companion.createOnAuxiliaryFiles(parser2, this.openTempEmptyFileChannel("auxOffset"), this.openTempEmptyFileChannel("aux"), hprofMetadata, histogram2.getInstanceCount());
            prepareFilesStopwatch.stop();
            IntList parentList = this.fileBackedListProvider.createIntList("parents", navigator.getInstanceCount() + 1L);
            IntList sizesList = this.fileBackedListProvider.createIntList("sizes", navigator.getInstanceCount() + 1L);
            IntList visitedList = this.fileBackedListProvider.createIntList("visited", navigator.getInstanceCount() + 1L);
            UByteList refIndexList = this.fileBackedListProvider.createUByteList("refIndex", navigator.getInstanceCount() + 1L);
            analysisStopwatch.start();
            Iterable $this$map$iv = nominatedClasses;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HistogramEntry histogramEntry = (HistogramEntry)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getClassDefinition().getName());
            }
            List nominatedClassNames = (List)destination$iv$iv;
            AnalysisConfig analysisConfig = new AnalysisConfig(new AnalysisConfig.PerClassOptions(nominatedClassNames, false, null, 6, null), null, null, null, new AnalysisConfig.MetaInfoOptions(this.includeMetaInfo), null, null, 110, null);
            AnalysisContext analysisContext = new AnalysisContext(navigator, analysisConfig, parentList, sizesList, visitedList, refIndexList, histogram2);
            AnalysisReport analysisReport = new AnalyzeGraph(analysisContext, this.fileBackedListProvider).analyze((ProgressIndicator)new PartialProgressIndicator(progress2, 0.4, 0.4));
            StringBuilder stringBuilder = result2.append((CharSequence)analysisReport.getMainReport());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            analysisStopwatch.stop();
            if (this.includeMetaInfo) {
                StringBuilder stringBuilder2 = result2.append(HeapReportUtils.INSTANCE.sectionHeader("Analysis information"));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                StringBuilder stringBuilder3 = result2.append("Prepare files duration: " + prepareFilesStopwatch);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
                StringBuilder stringBuilder4 = result2.append("Analysis duration: " + analysisStopwatch);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder4);
                StringBuilder stringBuilder5 = result2.append("TOTAL DURATION: " + totalStopwatch);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder5);
                StringBuilder stringBuilder6 = result2.append("Temp files:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder6);
                StringBuilder stringBuilder7 = result2.append("  heapdump = " + HeapReportUtils.INSTANCE.toShortStringAsCount(this.hprofFileChannel.size()));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder7);
                Iterable $this$forEach$iv = this.tempFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TempFile temp = (TempFile)element$iv;
                    boolean bl = false;
                    FileChannel channel = temp.getChannel();
                    if (!channel.isOpen()) continue;
                    StringBuilder stringBuilder8 = result2.append("  " + temp.getType() + " = " + HeapReportUtils.INSTANCE.toShortStringAsCount(channel.size()));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder8);
                }
                StringBuilder stringBuilder9 = result2.append((CharSequence)analysisReport.getMetaInfo());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder9);
            }
        }
        finally {
            parser2.close();
            this.closeAndDeleteTemporaryFiles();
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final boolean isSupported(long instanceCount) {
        return RemapIDsVisitor.Companion.isSupported(instanceCount) && instanceCount <= Integer.MAX_VALUE;
    }

    private final void closeAndDeleteTemporaryFiles() {
        Iterable $this$forEach$iv = this.tempFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TempFile tempFile = (TempFile)element$iv;
            boolean bl = false;
            try {
                tempFile.getChannel().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Path path2;
                Path it = path2 = tempFile.getPath();
                boolean bl2 = false;
                Files.deleteIfExists(it);
            }
            catch (Throwable throwable) {
            }
        }
        this.tempFiles.clear();
    }

    public static final /* synthetic */ FileChannel access$openTempEmptyFileChannel(HProfAnalysis $this, String type) {
        return $this.openTempEmptyFileChannel(type);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFilenameSupplier;", "", "getTempFilePath", "Ljava/nio/file/Path;", "type", "", "intellij.android.core"})
    public static interface TempFilenameSupplier {
        @NotNull
        public Path getTempFilePath(@NotNull String var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFile;", "", "type", "", "path", "Ljava/nio/file/Path;", "channel", "Ljava/nio/channels/FileChannel;", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/channels/FileChannel;)V", "getChannel", "()Ljava/nio/channels/FileChannel;", "getPath", "()Ljava/nio/file/Path;", "getType", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
    private static final class TempFile {
        @NotNull
        private final String type;
        @NotNull
        private final Path path;
        @NotNull
        private final FileChannel channel;

        public TempFile(@NotNull String type, @NotNull Path path2, @NotNull FileChannel channel) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.type = type;
            this.path = path2;
            this.channel = channel;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final FileChannel getChannel() {
            return this.channel;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final Path component2() {
            return this.path;
        }

        @NotNull
        public final FileChannel component3() {
            return this.channel;
        }

        @NotNull
        public final TempFile copy(@NotNull String type, @NotNull Path path2, @NotNull FileChannel channel) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            return new TempFile(type, path2, channel);
        }

        public static /* synthetic */ TempFile copy$default(TempFile tempFile, String string, Path path2, FileChannel fileChannel, int n, Object object) {
            if ((n & 1) != 0) {
                string = tempFile.type;
            }
            if ((n & 2) != 0) {
                path2 = tempFile.path;
            }
            if ((n & 4) != 0) {
                fileChannel = tempFile.channel;
            }
            return tempFile.copy(string, path2, fileChannel);
        }

        @NotNull
        public String toString() {
            return "TempFile(type=" + this.type + ", path=" + this.path + ", channel=" + this.channel + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + ((Object)this.path).hashCode();
            result2 = result2 * 31 + this.channel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TempFile)) {
                return false;
            }
            TempFile tempFile = (TempFile)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)tempFile.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)tempFile.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.channel, (Object)tempFile.channel);
        }
    }
}

