/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.analysis;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisContext;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisReport;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalyzeDisposer;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalyzeGraph;
import com.android.tools.idea.diagnostics.hprof.analysis.GCRootPathsTree;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.classstore.StaticField;
import com.android.tools.idea.diagnostics.hprof.histogram.Histogram;
import com.android.tools.idea.diagnostics.hprof.histogram.HistogramEntry;
import com.android.tools.idea.diagnostics.hprof.navigator.ObjectNavigator;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.ListProvider;
import com.android.tools.idea.diagnostics.hprof.util.PartialProgressIndicator;
import com.android.tools.idea.diagnostics.hprof.util.TruncatingPrintBuffer;
import com.android.tools.idea.diagnostics.hprof.util.UByteList;
import com.android.tools.idea.diagnostics.hprof.util.UShortList;
import com.android.tools.idea.diagnostics.hprof.visitors.HistogramVisitor;
import com.google.common.base.Stopwatch;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 ?2\u00020\u0001:\u0002?@B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001dH\u0002J\"\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001dH\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J0\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\"H\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u001dH\u0002J\b\u0010/\u001a\u00020\u0014H\u0002J\b\u00100\u001a\u00020\u0014H\u0002J\u0010\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020-H\u0002J\u0016\u00103\u001a\u00020\n2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\n05H\u0002J\b\u00106\u001a\u00020\nH\u0002J(\u00107\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020-H\u0002J\u0010\u00108\u001a\u00020\n2\u0006\u0010#\u001a\u000209H\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u00102\u001a\u00020-2\u0006\u0010\u001e\u001a\u00020-H\u0002J\u0018\u0010<\u001a\u00020;2\u0006\u0010#\u001a\u00020$2\u0006\u0010+\u001a\u00020\"H\u0002J\u0014\u0010=\u001a\u00020;*\u00020\u00122\u0006\u0010>\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalyzeGraph;", "", "analysisContext", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;", "listProvider", "Lcom/android/tools/idea/diagnostics/hprof/util/ListProvider;", "(Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;Lcom/android/tools/idea/diagnostics/hprof/util/ListProvider;)V", "config", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig;", "dominatorFlameGraph", "", "innerClassReport", "nominatedInstances", "Ljava/util/HashMap;", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "Lkotlin/collections/HashMap;", "parentList", "Lcom/android/tools/idea/diagnostics/hprof/util/IntList;", "softWeakRefHistogram", "Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "strongRefHistogram", "traverseReport", "unreachableDisposableObjects", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "addIdToListAndSetParentIfOrphan", "", "list", "id", "", "parentId", "addIdToSetIfOrphan", "set", "analyze", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisReport;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "computeDominatorFlameGraph", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "rootsSet", "sizesList", "edgeCount", "report", "estimateDominatorTempFilesSize", "", "objectCount", "getAndClearSoftWeakHistogram", "getAndClearStrongRefHistogram", "getParentIdForObjectId", "objectId", "getReportOrExceptionString", "generateReport", "Lkotlin/Function0;", "prepareHistogramSection", "prepareInnerClassSection", "preparePerClassSection", "Lcom/android/tools/idea/diagnostics/hprof/util/PartialProgressIndicator;", "setParentForObjectId", "", "traverseInstanceGraph", "clear", "size", "Companion", "WalkGraphPhase", "intellij.android.core"})
public final class AnalyzeGraph {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalysisContext analysisContext;
    @NotNull
    private final ListProvider listProvider;
    @NotNull
    private final IntArrayList unreachableDisposableObjects;
    @Nullable
    private Histogram strongRefHistogram;
    @Nullable
    private Histogram softWeakRefHistogram;
    @Nullable
    private String traverseReport;
    @Nullable
    private String dominatorFlameGraph;
    @Nullable
    private String innerClassReport;
    @NotNull
    private final com.android.tools.idea.diagnostics.hprof.util.IntList parentList;
    @NotNull
    private final HashMap<ClassDefinition, IntOpenHashSet> nominatedInstances;
    @NotNull
    private final AnalysisConfig config;
    @NotNull
    private static final Logger LOG;

    public AnalyzeGraph(@NotNull AnalysisContext analysisContext, @NotNull ListProvider listProvider) {
        Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
        Intrinsics.checkNotNullParameter((Object)listProvider, (String)"listProvider");
        this.analysisContext = analysisContext;
        this.listProvider = listProvider;
        this.unreachableDisposableObjects = new IntArrayList();
        this.parentList = this.analysisContext.getParentList();
        this.nominatedInstances = new HashMap();
        this.config = this.analysisContext.getConfig();
    }

    private final void setParentForObjectId(long objectId, long parentId2) {
        this.parentList.set((int)objectId, (int)parentId2);
    }

    private final long getParentIdForObjectId(long objectId) {
        return this.parentList.get((int)objectId);
    }

    @NotNull
    public final AnalysisReport analyze(@NotNull ProgressIndicator progress2) {
        AnalysisReport analysisReport;
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        AnalysisReport $this$analyze_u24lambda_u2d0 = analysisReport = new AnalysisReport(null, null, 3, null);
        boolean bl = false;
        boolean includePerClassSection = !((Collection)this.analysisContext.getConfig().getPerClassOptions().getClassNames()).isEmpty();
        ProgressIndicator traverseProgress = includePerClassSection ? (ProgressIndicator)new PartialProgressIndicator(progress2, 0.0, 0.5) : progress2;
        AnalyzeDisposer analyzeDisposer = new AnalyzeDisposer(this.analysisContext);
        analyzeDisposer.prepareDisposerChildren();
        analyzeDisposer.computeDisposedObjectsIDs();
        this.traverseInstanceGraph(traverseProgress, $this$analyze_u24lambda_u2d0);
        analyzeDisposer.computeStrongReferencedDisposedObjectsIDs();
        AnalysisConfig.HistogramOptions histogramOptions = this.analysisContext.getConfig().getHistogramOptions();
        if (histogramOptions.getIncludeByCount() || histogramOptions.getIncludeBySize()) {
            StringBuilder stringBuilder = $this$analyze_u24lambda_u2d0.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Histogram"));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            $this$analyze_u24lambda_u2d0.getMainReport().append(this.prepareHistogramSection());
        }
        if (histogramOptions.getIncludeSummary()) {
            StringBuilder stringBuilder = $this$analyze_u24lambda_u2d0.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Heap summary"));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            $this$analyze_u24lambda_u2d0.getMainReport().append(this.traverseReport);
        }
        if (includePerClassSection) {
            PartialProgressIndicator perClassProgress = new PartialProgressIndicator(progress2, 0.5, 0.5);
            StringBuilder stringBuilder = $this$analyze_u24lambda_u2d0.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Instances of each nominated class"));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            $this$analyze_u24lambda_u2d0.getMainReport().append(this.preparePerClassSection(perClassProgress));
        }
        if (this.config.getInnerClassOptions().getIncludeInnerClassSection()) {
            StringBuilder stringBuilder = $this$analyze_u24lambda_u2d0.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Inner classes that retain objects via this$0"));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            $this$analyze_u24lambda_u2d0.getMainReport().append(this.innerClassReport);
        }
        if (this.config.getDisposerOptions().getIncludeDisposerTreeSummary()) {
            StringBuilder stringBuilder = $this$analyze_u24lambda_u2d0.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Disposer tree summary"));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            $this$analyze_u24lambda_u2d0.getMainReport().append(analyzeDisposer.prepareDisposerTreeSummarySection(this.config.getDisposerOptions().getDisposerTreeSummaryOptions()));
        }
        if (this.config.getDisposerOptions().getIncludeDisposedObjectsSummary() || this.config.getDisposerOptions().getIncludeDisposedObjectsDetails()) {
            StringBuilder stringBuilder = $this$analyze_u24lambda_u2d0.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Disposed objects"));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            $this$analyze_u24lambda_u2d0.getMainReport().append(analyzeDisposer.prepareDisposedObjectsSection());
        }
        if (this.config.getDominatorTreeOptions().getIncludeDominatorTree()) {
            StringBuilder stringBuilder = $this$analyze_u24lambda_u2d0.getMainReport().append(HeapReportUtils.INSTANCE.sectionHeader("Dominator tree flame graph"));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            $this$analyze_u24lambda_u2d0.getMainReport().append(this.dominatorFlameGraph);
        }
        return analysisReport;
    }

    private final String preparePerClassSection(PartialProgressIndicator progress2) {
        StringBuilder stringBuilder;
        StringBuilder $this$preparePerClassSection_u24lambda_u2d5 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Histogram histogram2 = this.analysisContext.getHistogram();
        AnalysisConfig.PerClassOptions perClassOptions = this.analysisContext.getConfig().getPerClassOptions();
        if (perClassOptions.getIncludeClassList()) {
            StringBuilder stringBuilder2 = $this$preparePerClassSection_u24lambda_u2d5.append("Nominated classes:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            Iterable $this$forEach$iv = perClassOptions.getClassNames();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HistogramEntry histogramEntry;
                Object v1;
                block6: {
                    String name = (String)element$iv;
                    boolean bl2 = false;
                    Iterable iterable = histogram2.getEntries();
                    Iterator iterator2 = iterable.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        HistogramEntry entry = (HistogramEntry)t;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)entry.getClassDefinition().getName(), (Object)name)) continue;
                        v1 = t;
                        break block6;
                    }
                    v1 = null;
                }
                if ((HistogramEntry)v1 == null) continue;
                ClassDefinition classDefinition = histogramEntry.component1();
                long totalInstances = histogramEntry.component2();
                long totalBytes = histogramEntry.component3();
                String prettyName = classDefinition.getPrettyName();
                StringBuilder stringBuilder3 = $this$preparePerClassSection_u24lambda_u2d5.append(" --> [" + HeapReportUtils.INSTANCE.toShortStringAsCount(totalInstances) + "/" + HeapReportUtils.INSTANCE.toShortStringAsSize(totalBytes) + "] " + prettyName);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
            }
            StringsKt.appendln((StringBuilder)$this$preparePerClassSection_u24lambda_u2d5);
        }
        ObjectNavigator nav = this.analysisContext.getNavigator();
        int counter = 0;
        List<String> nominatedClassNames = this.config.getPerClassOptions().getClassNames();
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Iterable $this$forEach$iv = nominatedClassNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntOpenHashSet set;
            String className = (String)element$iv;
            boolean bl4 = false;
            ClassDefinition classDefinition = nav.getClassStore().get(className);
            Intrinsics.checkNotNull((Object)this.nominatedInstances.get(classDefinition));
            progress2.setFraction((double)counter / (double)this.nominatedInstances.size());
            progress2.setText2("Processing: " + ((Collection)set).size() + " " + classDefinition.getPrettyName());
            stopwatch.reset().start();
            StringBuilder stringBuilder4 = $this$preparePerClassSection_u24lambda_u2d5.append("CLASS: " + classDefinition.getPrettyName() + " (" + ((Collection)set).size() + " objects)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            GCRootPathsTree referenceRegistry = new GCRootPathsTree(this.analysisContext, perClassOptions.getTreeDisplayOptions(), classDefinition);
            Iterable $this$forEach$iv2 = (Iterable)set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Integer objectId = (Integer)element$iv2;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"objectId");
                referenceRegistry.registerObject(objectId);
            }
            set.clear();
            $this$preparePerClassSection_u24lambda_u2d5.append(referenceRegistry.printTree());
            if (this.config.getMetaInfoOptions().getInclude()) {
                StringBuilder stringBuilder5 = $this$preparePerClassSection_u24lambda_u2d5.append("Report for " + classDefinition.getPrettyName() + " created in " + stopwatch);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder5);
            }
            StringsKt.appendln((StringBuilder)$this$preparePerClassSection_u24lambda_u2d5);
            ++counter;
        }
        progress2.setFraction(1.0);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String prepareHistogramSection() {
        StringBuilder stringBuilder;
        StringBuilder $this$prepareHistogramSection_u24lambda_u2d6 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Histogram strongRefHistogram = this.getAndClearStrongRefHistogram();
        Histogram softWeakRefHistogram = this.getAndClearSoftWeakHistogram();
        Histogram histogram2 = this.analysisContext.getHistogram();
        AnalysisConfig.HistogramOptions histogramOptions = this.analysisContext.getConfig().getHistogramOptions();
        $this$prepareHistogramSection_u24lambda_u2d6.append(Histogram.Companion.prepareMergedHistogramReport(histogram2, "All", strongRefHistogram, "Strong-ref", histogramOptions));
        long unreachableObjectsCount = histogram2.getInstanceCount() - strongRefHistogram.getInstanceCount() - softWeakRefHistogram.getInstanceCount();
        long unreachableObjectsSize = histogram2.getBytesCount() - strongRefHistogram.getBytesCount() - softWeakRefHistogram.getBytesCount();
        StringBuilder stringBuilder2 = $this$prepareHistogramSection_u24lambda_u2d6.append("Unreachable objects: " + HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(unreachableObjectsCount) + "  " + HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(unreachableObjectsSize));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String getReportOrExceptionString(Function0<String> generateReport) {
        String string;
        try {
            string = (String)generateReport.invoke();
        }
        catch (Exception e) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            e.printStackTrace(pw);
            pw.flush();
            String string2 = baos.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n      val baos = ByteA\u2026    baos.toString()\n    }");
            string = string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void traverseInstanceGraph(ProgressIndicator progress2, AnalysisReport report2) {
        void $this$traverseInstanceGraph_u24lambda_u2d21;
        StringBuilder stringBuilder;
        Iterable $this$sortedByDescending$iv;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        AnalysisConfig.TraverseOptions traverseOptions = this.config.getTraverseOptions();
        boolean onlyStrongReferences = traverseOptions.getOnlyStrongReferences();
        boolean includeDisposerRelationships = traverseOptions.getIncludeDisposerRelationships();
        boolean includeFieldInformation = traverseOptions.getIncludeFieldInformation();
        ObjectNavigator nav = this.analysisContext.getNavigator();
        ClassStore classStore = this.analysisContext.getClassStore();
        com.android.tools.idea.diagnostics.hprof.util.IntList sizesList = this.analysisContext.getSizesList();
        com.android.tools.idea.diagnostics.hprof.util.IntList visitedList = this.analysisContext.getVisitedList();
        UByteList refIndexList = this.analysisContext.getRefIndexList();
        Iterator<ObjectNavigator.RootObject> roots = nav.createRootsIterator();
        this.nominatedInstances.clear();
        List<String> nominatedClassNames = this.config.getPerClassOptions().getClassNames();
        Iterable $this$forEach$iv = nominatedClassNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ((Map)this.nominatedInstances).put(classStore.get(it), new IntOpenHashSet());
        }
        progress2.setText2("Collect all object roots");
        IntArrayList toVisit = null;
        toVisit = new IntArrayList();
        IntArrayList toVisit2 = new IntArrayList();
        IntOpenHashSet rootsSet = new IntOpenHashSet();
        IntOpenHashSet frameRootsSet = new IntOpenHashSet();
        IntOpenHashSet disposedObjectsIDs = this.analysisContext.getDisposedObjectsIDs();
        IntOpenHashSet disposedRootsSet = new IntOpenHashSet();
        while (roots.hasNext()) {
            ObjectNavigator.RootObject rootObject = roots.next();
            int rootObjectId = (int)rootObject.getId();
            if (rootObject.getReason().getJavaFrame()) {
                frameRootsSet.add(rootObjectId);
                continue;
            }
            AnalyzeGraph.addIdToSetIfOrphan$default(this, disposedObjectsIDs.contains(rootObjectId) ? disposedRootsSet : rootsSet, rootObjectId, 0, 4, null);
        }
        classStore.forEachClass((Function1<? super ClassDefinition, Unit>)((Function1)new Function1<ClassDefinition, Unit>(this, rootsSet, disposedObjectsIDs, disposedRootsSet){
            final /* synthetic */ AnalyzeGraph this$0;
            final /* synthetic */ IntOpenHashSet $rootsSet;
            final /* synthetic */ IntOpenHashSet $disposedObjectsIDs;
            final /* synthetic */ IntOpenHashSet $disposedRootsSet;
            {
                this.this$0 = $receiver;
                this.$rootsSet = $rootsSet;
                this.$disposedObjectsIDs = $disposedObjectsIDs;
                this.$disposedRootsSet = $disposedRootsSet;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ClassDefinition classDefinition) {
                int n;
                long[] $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)classDefinition, (String)"classDefinition");
                AnalyzeGraph.addIdToSetIfOrphan$default(this.this$0, this.$rootsSet, (int)classDefinition.getId(), 0, 4, null);
                StaticField[] staticFieldArray = classDefinition.getStaticFields();
                AnalyzeGraph analyzeGraph = this.this$0;
                IntOpenHashSet intOpenHashSet = this.$disposedObjectsIDs;
                IntOpenHashSet intOpenHashSet2 = this.$disposedRootsSet;
                IntOpenHashSet intOpenHashSet3 = this.$rootsSet;
                boolean $i$f$forEach = false;
                int n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    void element$iv;
                    void staticField = element$iv = $this$forEach$iv[n];
                    boolean bl = false;
                    int staticFieldObjectId = (int)staticField.getObjectId();
                    AnalyzeGraph.addIdToSetIfOrphan$default(analyzeGraph, intOpenHashSet.contains(staticFieldObjectId) ? intOpenHashSet2 : intOpenHashSet3, staticFieldObjectId, 0, 4, null);
                }
                $this$forEach$iv = classDefinition.getConstantFields();
                analyzeGraph = this.this$0;
                intOpenHashSet = this.$disposedObjectsIDs;
                intOpenHashSet2 = this.$disposedRootsSet;
                intOpenHashSet3 = this.$rootsSet;
                $i$f$forEach = false;
                n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    long element$iv;
                    long objectId = element$iv = $this$forEach$iv[n];
                    boolean bl = false;
                    int constantObjectId = (int)objectId;
                    AnalyzeGraph.addIdToSetIfOrphan$default(analyzeGraph, intOpenHashSet.contains(constantObjectId) ? intOpenHashSet2 : intOpenHashSet3, constantObjectId, 0, 4, null);
                }
            }
        }));
        toVisit.addAll((IntCollection)rootsSet);
        int leafCounter = 0;
        progress2.setText2("Traversing instance graph");
        HashMap strongRefHistogramEntries = new HashMap();
        HashMap reachableNonStrongHistogramEntries = new HashMap();
        Int2IntOpenHashMap softReferenceIdToParentMap = new Int2IntOpenHashMap();
        Int2IntOpenHashMap weakReferenceIdToParentMap = new Int2IntOpenHashMap();
        int visitedInstancesCount = 0;
        Stopwatch stopwatch = Stopwatch.createStarted();
        LongArrayList references = new LongArrayList();
        int visitedCount = 0;
        int strongRefVisitedCount = 0;
        int softWeakVisitedCount = 0;
        Ref.IntRef edgeCount = new Ref.IntRef();
        long finalizableBytes = 0L;
        long softBytes = 0L;
        long weakBytes = 0L;
        WalkGraphPhase phase = WalkGraphPhase.StrongReferencesNonLocalVariables;
        IntArrayList cleanerObjects = new IntArrayList();
        ClassDefinition sunMiscCleanerClass = classStore.getClassIfExists("sun.misc.Cleaner");
        ClassDefinition finalizerClass = classStore.getClassIfExists("java.lang.ref.Finalizer");
        IntOpenHashSet disposedReferencedNonRootSet = new IntOpenHashSet();
        while (!((Collection)toVisit).isEmpty() || phase != WalkGraphPhase.Finished) {
            int n = ((Collection)toVisit).size();
            for (int i = 0; i < n; ++i) {
                Object object;
                int id2 = toVisit.getInt(i);
                if (includeDisposerRelationships && phase.compareTo((Enum)WalkGraphPhase.DisposedRoots) < 0 && disposedObjectsIDs.contains(id2)) {
                    disposedReferencedNonRootSet.add(id2);
                    continue;
                }
                if (includeDisposerRelationships && id2 == this.analysisContext.getDisposerTreeObjectId() && phase.compareTo((Enum)WalkGraphPhase.DisposerTree) < 0) continue;
                nav.goTo(id2, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
                ClassDefinition currentObjectClass = nav.getClass();
                if ((Intrinsics.areEqual((Object)currentObjectClass, (Object)sunMiscCleanerClass) || Intrinsics.areEqual((Object)currentObjectClass, (Object)finalizerClass)) && phase.compareTo((Enum)WalkGraphPhase.CleanerFinalizerReferences) < 0) {
                    if (onlyStrongReferences) continue;
                    cleanerObjects.add(id2);
                    continue;
                }
                int n2 = visitedInstancesCount;
                visitedInstancesCount = n2 + 1;
                IntOpenHashSet intOpenHashSet = this.nominatedInstances.get(currentObjectClass);
                Boolean bl = intOpenHashSet != null ? Boolean.valueOf(intOpenHashSet.add(id2)) : null;
                boolean isLeaf = true;
                nav.copyReferencesTo(references);
                boolean currentObjectIsArray = currentObjectClass.isArray();
                if (phase.compareTo((Enum)WalkGraphPhase.SoftReferences) < 0 && nav.getSoftReferenceId() != 0L) {
                    if (!onlyStrongReferences) {
                        softReferenceIdToParentMap.put((int)nav.getSoftReferenceId(), id2);
                    }
                    references.set(nav.getSoftWeakReferenceIndex(), 0L);
                }
                if (phase.compareTo((Enum)WalkGraphPhase.WeakReferences) < 0 && nav.getWeakReferenceId() != 0L) {
                    if (!onlyStrongReferences) {
                        weakReferenceIdToParentMap.put((int)nav.getWeakReferenceId(), id2);
                    }
                    references.set(nav.getSoftWeakReferenceIndex(), 0L);
                }
                int size = nav.getObjectSize();
                int nonDisposerReferences = ((Collection)references).size();
                if (includeDisposerRelationships) {
                    Integer n3 = id2;
                    if (((Map)this.analysisContext.getDisposerParentToChildren()).containsKey(n3)) {
                        if (phase.compareTo((Enum)WalkGraphPhase.DisposerTree) >= 0) {
                            this.unreachableDisposableObjects.add(id2);
                        }
                        Object object2 = this.analysisContext.getDisposerParentToChildren().get(id2);
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"analysisContext.disposerParentToChildren[id]");
                        Iterable $this$forEach$iv2 = (Iterable)object2;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv : $this$forEach$iv2) {
                            Integer it = (Integer)element$iv;
                            boolean bl2 = false;
                            references.add((long)it.intValue());
                        }
                    }
                }
                int $i$f$forEach2 = ((Collection)references).size();
                for (int j = 0; j < $i$f$forEach2; ++j) {
                    int referenceId = (int)references.getLong(j);
                    if (referenceId != 0) {
                        int element$iv = edgeCount.element;
                        edgeCount.element = element$iv + 1;
                    }
                    if (!this.addIdToListAndSetParentIfOrphan(toVisit2, referenceId, id2)) continue;
                    if (includeFieldInformation) {
                        refIndexList.set(referenceId, currentObjectIsArray ? 254 : (j >= nonDisposerReferences ? 255 : (j < 250 ? j + 1 : 0)));
                    }
                    isLeaf = false;
                }
                visitedList.set(visitedCount++, id2);
                int sizeDivBy4 = (size + 3) / 4;
                if (sizeDivBy4 == 0) {
                    sizeDivBy4 = 1;
                }
                sizesList.set(id2, sizeDivBy4);
                HashMap histogramEntries = null;
                if (phase.compareTo((Enum)WalkGraphPhase.StrongReferencesMarker) <= 0) {
                    histogramEntries = strongRefHistogramEntries;
                    if (isLeaf) {
                        int referenceId = leafCounter;
                        leafCounter = referenceId + 1;
                    }
                    ++strongRefVisitedCount;
                } else {
                    histogramEntries = reachableNonStrongHistogramEntries;
                    switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
                        case 1: {
                            finalizableBytes += (long)size;
                            Unit unit = Unit.INSTANCE;
                            break;
                        }
                        case 2: {
                            softBytes += (long)size;
                            Unit unit = Unit.INSTANCE;
                            break;
                        }
                        default: {
                            boolean it;
                            boolean bl3 = it = phase == WalkGraphPhase.WeakReferences;
                            if (_Assertions.ENABLED && !it) {
                                String bl2 = "Assertion failed";
                                throw new AssertionError((Object)bl2);
                            }
                            weakBytes += (long)size;
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    ++softWeakVisitedCount;
                }
                Map $this$getOrPut$iv = histogramEntries;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(currentObjectClass);
                if (value$iv == null) {
                    boolean bl4 = false;
                    HistogramVisitor.InternalHistogramEntry answer$iv = new HistogramVisitor.InternalHistogramEntry(currentObjectClass);
                    $this$getOrPut$iv.put(currentObjectClass, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((HistogramVisitor.InternalHistogramEntry)object).addInstance(size);
            }
            progress2.setFraction(1.0 * (double)visitedInstancesCount / (double)nav.getInstanceCount());
            toVisit.clear();
            IntArrayList tmp = toVisit;
            toVisit = toVisit2;
            toVisit2 = tmp;
            while (toVisit.isEmpty() && phase != WalkGraphPhase.Finished) {
                phase = WalkGraphPhase.values()[phase.ordinal() + 1];
                switch (WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
                    case 3: {
                        Object id3;
                        Object element$iv;
                        Object $this$forEach$iv3 = (Iterable)frameRootsSet;
                        boolean $i$f$forEach3 = false;
                        Iterator<Object> currentObjectIsArray = $this$forEach$iv3.iterator();
                        while (currentObjectIsArray.hasNext()) {
                            element$iv = currentObjectIsArray.next();
                            id3 = (Integer)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)id3, (String)"id");
                            this.addIdToListAndSetParentIfOrphan(toVisit, (Integer)id3, (Integer)id3);
                        }
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case 1: {
                        toVisit.addAll((IntList)cleanerObjects);
                        cleanerObjects.clear();
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case 2: {
                        Integer parentId2;
                        Object id3;
                        Object element$iv;
                        Object $this$forEach$iv3 = (Map)softReferenceIdToParentMap;
                        boolean $i$f$forEach3 = false;
                        Iterator<Object> currentObjectIsArray = $this$forEach$iv3.entrySet().iterator();
                        while (currentObjectIsArray.hasNext()) {
                            id3 = element$iv = (Map.Entry)currentObjectIsArray.next();
                            boolean bl = false;
                            Integer softId = (Integer)id3.getKey();
                            parentId2 = (Integer)id3.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)softId, (String)"softId");
                            int n4 = softId;
                            Intrinsics.checkNotNullExpressionValue((Object)parentId2, (String)"parentId");
                            if (!this.addIdToListAndSetParentIfOrphan(toVisit, n4, parentId2)) continue;
                            refIndexList.set(softId, 252);
                        }
                        softReferenceIdToParentMap.clear();
                        softReferenceIdToParentMap.trim();
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case 4: {
                        Integer parentId2;
                        Object id3;
                        Object element$iv;
                        Object $this$forEach$iv3 = (Map)weakReferenceIdToParentMap;
                        boolean $i$f$forEach3 = false;
                        Iterator<Object> currentObjectIsArray = $this$forEach$iv3.entrySet().iterator();
                        while (currentObjectIsArray.hasNext()) {
                            id3 = element$iv = (Map.Entry)currentObjectIsArray.next();
                            boolean bl = false;
                            Integer weakId = (Integer)id3.getKey();
                            parentId2 = (Integer)id3.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)weakId, (String)"weakId");
                            int n5 = weakId;
                            Intrinsics.checkNotNullExpressionValue((Object)parentId2, (String)"parentId");
                            if (!this.addIdToListAndSetParentIfOrphan(toVisit, n5, parentId2)) continue;
                            refIndexList.set(weakId, 253);
                        }
                        weakReferenceIdToParentMap.clear();
                        weakReferenceIdToParentMap.trim();
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case 5: {
                        if (this.analysisContext.getDisposerTreeObjectId() != 0) {
                            toVisit.add(this.analysisContext.getDisposerTreeObjectId());
                        }
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case 6: {
                        toVisit.addAll((IntCollection)disposedRootsSet);
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case 7: {
                        toVisit.addAll((IntCollection)disposedReferencedNonRootSet);
                        disposedReferencedNonRootSet.clear();
                        disposedReferencedNonRootSet.trim();
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    default: {
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        }
        if (this.config.getDominatorTreeOptions().getIncludeDominatorTree()) {
            long usableDiskSpace22 = new File(FileUtil.getTempDirectory()).getUsableSpace();
            if (usableDiskSpace22 - this.estimateDominatorTempFilesSize(visitedCount, edgeCount.element) > this.config.getDominatorTreeOptions().getDiskSpaceThreshold()) {
                rootsSet.addAll((IntCollection)frameRootsSet);
                rootsSet.addAll((IntCollection)disposedRootsSet);
                this.dominatorFlameGraph = this.getReportOrExceptionString((Function0<String>)((Function0)new Function0<String>(this, nav, rootsSet, sizesList, edgeCount, report2){
                    final /* synthetic */ AnalyzeGraph this$0;
                    final /* synthetic */ ObjectNavigator $nav;
                    final /* synthetic */ IntOpenHashSet $rootsSet;
                    final /* synthetic */ com.android.tools.idea.diagnostics.hprof.util.IntList $sizesList;
                    final /* synthetic */ Ref.IntRef $edgeCount;
                    final /* synthetic */ AnalysisReport $report;
                    {
                        this.this$0 = $receiver;
                        this.$nav = $nav;
                        this.$rootsSet = $rootsSet;
                        this.$sizesList = $sizesList;
                        this.$edgeCount = $edgeCount;
                        this.$report = $report;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return AnalyzeGraph.access$computeDominatorFlameGraph(this.this$0, this.$nav, this.$rootsSet, this.$sizesList, this.$edgeCount.element, this.$report);
                    }
                }));
            } else {
                this.dominatorFlameGraph = "Omitted due to low disk space";
            }
        }
        boolean usableDiskSpace22 = cleanerObjects.isEmpty();
        if (_Assertions.ENABLED && !usableDiskSpace22) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        usableDiskSpace22 = softReferenceIdToParentMap.isEmpty();
        if (_Assertions.ENABLED && !usableDiskSpace22) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        usableDiskSpace22 = weakReferenceIdToParentMap.isEmpty();
        if (_Assertions.ENABLED && !usableDiskSpace22) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Collection collection3 = strongRefHistogramEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"strongRefHistogramEntries\n        .values");
        Iterable usableDiskSpace22 = collection3;
        AnalyzeGraph analyzeGraph = this;
        boolean $i$f$map = false;
        void id2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HistogramVisitor.InternalHistogramEntry id3 = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.asHistogramEntry());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        long l = strongRefVisitedCount;
        List list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalInstances()));
            }
        });
        analyzeGraph.strongRefHistogram = new Histogram(list2, l);
        Collection collection4 = reachableNonStrongHistogramEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection4, (String)"reachableNonStrongHistogramEntries\n        .values");
        $this$sortedByDescending$iv = collection4;
        analyzeGraph = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            HistogramVisitor.InternalHistogramEntry it = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.asHistogramEntry());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$sortedByDescending = false;
        long l2 = softWeakVisitedCount;
        List list3 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalInstances()));
            }
        });
        analyzeGraph.softWeakRefHistogram = new Histogram(list3, l2);
        Stopwatch stopwatchUpdateSizes = Stopwatch.createStarted();
        for (int index2 = visitedCount - 1; index2 >= 0; --index2) {
            int parentId3;
            int id4 = visitedList.get(index2);
            if (id4 == (parentId3 = this.parentList.get(id4))) continue;
            sizesList.set(parentId3, sizesList.get(parentId3) + sizesList.get(id4));
        }
        stopwatchUpdateSizes.stop();
        Stopwatch stopwatchInnerClasses = Stopwatch.createStarted();
        if (this.config.getInnerClassOptions().getIncludeInnerClassSection()) {
            this.innerClassReport = this.getReportOrExceptionString((Function0<String>)((Function0)new Function0<String>(this, nav, rootsSet){
                final /* synthetic */ AnalyzeGraph this$0;
                final /* synthetic */ ObjectNavigator $nav;
                final /* synthetic */ IntOpenHashSet $rootsSet;
                {
                    this.this$0 = $receiver;
                    this.$nav = $nav;
                    this.$rootsSet = $rootsSet;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return AnalyzeGraph.access$prepareInnerClassSection(this.this$0, AnalyzeGraph.access$getAnalysisContext$p(this.this$0), this.$nav, this.$rootsSet, this.$nav.getInstanceCount());
                }
            }));
        }
        rootsSet.clear();
        rootsSet.trim();
        disposedRootsSet.clear();
        disposedRootsSet.trim();
        frameRootsSet.clear();
        frameRootsSet.trim();
        stopwatchInnerClasses.stop();
        StringBuilder $i$f$mapTo2 = stringBuilder = new StringBuilder();
        analyzeGraph = this;
        boolean bl = false;
        if (this.config.getMetaInfoOptions().getInclude()) {
            StringBuilder stringBuilder2 = $this$traverseInstanceGraph_u24lambda_u2d21.append("Analysis completed! Visited instances: " + visitedInstancesCount + ", time: " + stopwatch);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            StringBuilder stringBuilder3 = $this$traverseInstanceGraph_u24lambda_u2d21.append("Update sizes time: " + stopwatchUpdateSizes);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            StringBuilder stringBuilder4 = $this$traverseInstanceGraph_u24lambda_u2d21.append("Inner class report time: " + stopwatchInnerClasses);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            StringBuilder stringBuilder5 = $this$traverseInstanceGraph_u24lambda_u2d21.append("Leaves found: " + leafCounter);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
        }
        StringBuilder stringBuilder6 = $this$traverseInstanceGraph_u24lambda_u2d21.append("Class count: " + classStore.size());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder6);
        StringBuilder stringBuilder7 = $this$traverseInstanceGraph_u24lambda_u2d21.append("Finalizable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(finalizableBytes));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder7);
        StringBuilder stringBuilder8 = $this$traverseInstanceGraph_u24lambda_u2d21.append("Soft-reachable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(softBytes));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder8);
        StringBuilder stringBuilder9 = $this$traverseInstanceGraph_u24lambda_u2d21.append("Weak-reachable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(weakBytes));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder9);
        StringBuilder stringBuilder10 = $this$traverseInstanceGraph_u24lambda_u2d21.append("Reachable only from disposer tree: " + ((Collection)this.unreachableDisposableObjects).size());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder10);
        Closeable closeable = new TruncatingPrintBuffer(10, 0, (Function1<? super String, ? extends Object>)((Function1)new Function1<String, StringBuilder>((Object)$this$traverseInstanceGraph_u24lambda_u2d21){

            @NotNull
            public final StringBuilder invoke(@Nullable String p0) {
                StringBuilder stringBuilder = ((StringBuilder)this.receiver).append(p0);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                return StringsKt.appendln((StringBuilder)stringBuilder);
            }
        }));
        Throwable throwable = null;
        try {
            Integer id5;
            TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)closeable;
            boolean bl5 = false;
            IntOpenHashSet unreachableChildren = new IntOpenHashSet();
            Iterable $this$forEach$iv4 = (Iterable)this.unreachableDisposableObjects;
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv4) {
                Unit unit;
                IntArrayList intArrayList;
                id5 = (Integer)element$iv;
                boolean bl6 = false;
                Int2ObjectOpenHashMap<IntArrayList> int2ObjectOpenHashMap = this.analysisContext.getDisposerParentToChildren();
                Intrinsics.checkNotNullExpressionValue((Object)id5, (String)"id");
                IntArrayList intArrayList2 = intArrayList = (IntArrayList)int2ObjectOpenHashMap.get(id5.intValue());
                if (intArrayList2 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)intArrayList2, (String)"analysisContext.disposerParentToChildren[id]");
                    IntArrayList it = intArrayList;
                    boolean bl7 = false;
                    unreachableChildren.addAll((IntCollection)it);
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            $this$forEach$iv4 = (Iterable)this.unreachableDisposableObjects;
            $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv4) {
                id5 = (Integer)element$iv;
                boolean bl8 = false;
                Intrinsics.checkNotNullExpressionValue((Object)id5, (String)"id");
                if (unreachableChildren.contains(id5.intValue())) continue;
                buffer.println(" * " + nav.getClassForObjectId(id5.intValue()).getName() + " (" + HeapReportUtils.INSTANCE.toShortStringAsSize((long)sizesList.get(id5) * (long)4) + ")");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        analyzeGraph.traverseReport = string;
    }

    private final long estimateDominatorTempFilesSize(int objectCount, int edgeCount) {
        return 20L * (long)objectCount + 10L * (long)edgeCount;
    }

    /*
     * WARNING - void declaration
     */
    private final String computeDominatorFlameGraph(ObjectNavigator nav, IntOpenHashSet rootsSet, com.android.tools.idea.diagnostics.hprof.util.IntList sizesList, int edgeCount, AnalysisReport report2) {
        void $this$computeDominatorFlameGraph_u24lambda_u2d27;
        StringBuilder stringBuilder;
        int i;
        int chunk2;
        int chunkIndex;
        int i2;
        int j;
        Stopwatch totalStopwatch = Stopwatch.createUnstarted();
        Stopwatch postorderStopwatch = Stopwatch.createUnstarted();
        Stopwatch incomingEdgesStopwatch = Stopwatch.createUnstarted();
        Stopwatch sortIncomingEdgesStopwatch = Stopwatch.createUnstarted();
        Stopwatch dominatorsStopwatch = Stopwatch.createUnstarted();
        Stopwatch retainedSizesStopwatch = Stopwatch.createUnstarted();
        Stopwatch flameGraphStopwatch = Stopwatch.createUnstarted();
        totalStopwatch.start();
        postorderStopwatch.start();
        int objectCount = (int)nav.getInstanceCount();
        com.android.tools.idea.diagnostics.hprof.util.IntList postorderList = this.listProvider.createIntList("postorderList", objectCount + 2);
        com.android.tools.idea.diagnostics.hprof.util.IntList postorderNumbers = this.listProvider.createIntList("postorderNumbers", objectCount + 2);
        com.android.tools.idea.diagnostics.hprof.util.IntList nodeStack = this.listProvider.createIntList("dominatorBuf1", objectCount + 2);
        com.android.tools.idea.diagnostics.hprof.util.IntList childrenStack = this.listProvider.createIntList("childStack", edgeCount + ((Collection)rootsSet).size());
        com.android.tools.idea.diagnostics.hprof.util.IntList childrenStackOffsets = this.listProvider.createIntList("dominatorBuf2", objectCount + 2);
        com.android.tools.idea.diagnostics.hprof.util.IntList childrenStackSizes = this.listProvider.createIntList("dominatorBuf3", objectCount + 2);
        int csEntries = 0;
        int poEdgeCount = 0;
        poEdgeCount = ((Collection)rootsSet).size();
        IntIterator intIterator = rootsSet.intIterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"rootsSet.intIterator()");
        IntIterator intIterator2 = intIterator;
        while (intIterator2.hasNext()) {
            Integer id2 = intIterator2.next();
            int n = csEntries++;
            Intrinsics.checkNotNullExpressionValue((Object)id2, (String)"id");
            childrenStack.set(n, id2);
        }
        childrenStackSizes.set(0, csEntries);
        childrenStackOffsets.set(0, 0);
        childrenStackOffsets.set(1, csEntries);
        int nsSize = 0;
        int csSize = 1;
        int maxPonum = 0;
        maxPonum = 1;
        int maxStackDepth = 0;
        LongArrayList refList = new LongArrayList();
        while (csSize != 0) {
            int refsAdded;
            if (childrenStackSizes.get(csSize - 1) > 0) {
                int child = childrenStack.get(childrenStackOffsets.get(csSize - 1) + childrenStackSizes.get(csSize - 1) - 1);
                int n = csSize - 1;
                int n2 = childrenStackSizes.get(n);
                childrenStackSizes.set(n, n2 + -1);
                if (postorderNumbers.get(child) != 0) continue;
                postorderNumbers.set(child, -1);
                nodeStack.set(nsSize++, child);
                ObjectNavigator.goTo$default(nav, child, null, 2, null);
                nav.copyReferencesTo(refList);
                refsAdded = 0;
                int n3 = ((Collection)refList).size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    Long l = refList.get(i3);
                    long l2 = 0L;
                    if (l != null && l == l2) continue;
                    childrenStack.set(csEntries++, (int)refList.get(i3).longValue());
                    ++refsAdded;
                    int n4 = poEdgeCount;
                    poEdgeCount = n4 + 1;
                }
                childrenStackSizes.set(csSize, refsAdded);
                childrenStackOffsets.set(csSize + 1, childrenStackOffsets.get(csSize) + refsAdded);
                maxStackDepth = Math.max(++csSize, maxStackDepth);
                continue;
            }
            if (--csSize == 0) break;
            csEntries = childrenStackOffsets.get(csSize);
            if (nsSize == 0) continue;
            int n = nodeStack.get(nsSize - 1);
            postorderList.set(maxPonum, n);
            refsAdded = maxPonum;
            maxPonum = refsAdded + 1;
            postorderNumbers.set(n, refsAdded);
            --nsSize;
        }
        int rootPonum = maxPonum;
        postorderNumbers.set(objectCount + 1, rootPonum);
        postorderStopwatch.stop();
        incomingEdgesStopwatch.start();
        int cardBits = maxPonum < 65536 ? 0 : (int)(Math.log((double)maxPonum / 65536.0) / Math.log(2.0) + 1.0);
        int cardSize = 1 << cardBits;
        int ncards = (maxPonum + cardSize - 1) / cardSize;
        int ncardChunks = (ncards + 63) / 64;
        long[] dirtyCards = new long[ncardChunks];
        ArraysKt.fill$default((long[])dirtyCards, (long)-1L, (int)0, (int)0, (int)6, null);
        UShortList outgoingCardRefs = this.listProvider.createUShortList("cardRefs", poEdgeCount);
        com.android.tools.idea.diagnostics.hprof.util.IntList outgoingCardListOffsets = nodeStack;
        this.clear(outgoingCardListOffsets, maxPonum + 1);
        com.android.tools.idea.diagnostics.hprof.util.IntList edgeListOffsets = childrenStackOffsets;
        this.clear(edgeListOffsets, maxPonum + 1);
        LongArrayList references = new LongArrayList();
        int ncardrefs = 0;
        int n = maxPonum;
        for (int i4 = 1; i4 < n; ++i4) {
            int n5;
            int id3 = postorderList.get(i4);
            ObjectNavigator.goTo$default(nav, id3, null, 2, null);
            nav.copyReferencesTo(references);
            if (rootsSet.contains(id3)) {
                int n6 = i4;
                n5 = edgeListOffsets.get(n6);
                edgeListOffsets.set(n6, n5 + 1);
            }
            outgoingCardListOffsets.set(i4, ncardrefs);
            n5 = ((Collection)references).size();
            for (j = 0; j < n5; ++j) {
                Long l = references.get(j);
                long l3 = 0L;
                if (l != null && l == l3) continue;
                int target2 = postorderNumbers.get((int)references.get(j).longValue());
                int n7 = edgeListOffsets.get(target2);
                edgeListOffsets.set(target2, n7 + 1);
                outgoingCardRefs.set(ncardrefs++, target2 >> cardBits);
            }
        }
        outgoingCardListOffsets.set(maxPonum, ncardrefs);
        int next = 0;
        int psum = edgeListOffsets.get(0);
        j = maxPonum;
        for (int i5 = 0; i5 < j; ++i5) {
            next = edgeListOffsets.get(i5 + 1);
            edgeListOffsets.set(i5 + 1, psum);
            psum += next;
        }
        edgeListOffsets.set(0, 0);
        com.android.tools.idea.diagnostics.hprof.util.IntList incomingEdges = null;
        if (poEdgeCount < edgeCount + ((Collection)rootsSet).size()) {
            incomingEdges = childrenStack;
            this.clear(incomingEdges, poEdgeCount);
        } else {
            incomingEdges = this.listProvider.createIntList("incoming", poEdgeCount);
        }
        com.android.tools.idea.diagnostics.hprof.util.IntList edgeListIndices = childrenStackSizes;
        this.clear(edgeListIndices, maxPonum + 1);
        int target2 = maxPonum;
        for (i2 = 1; i2 < target2; ++i2) {
            int id4 = postorderList.get(i2);
            ObjectNavigator.goTo$default(nav, id4, null, 2, null);
            nav.copyReferencesTo(references);
            if (rootsSet.contains(id4)) {
                AnalyzeGraph.computeDominatorFlameGraph$addEdge(edgeListOffsets, edgeListIndices, incomingEdges, i2, rootPonum);
            }
            int n8 = ((Collection)references).size();
            for (int j2 = 0; j2 < n8; ++j2) {
                Long l = references.get(j2);
                long l4 = 0L;
                if (l != null && l == l4) continue;
                int target3 = postorderNumbers.get((int)references.get(j2).longValue());
                AnalyzeGraph.computeDominatorFlameGraph$addEdge(edgeListOffsets, edgeListIndices, incomingEdges, target3, i2);
            }
        }
        incomingEdgesStopwatch.stop();
        sortIncomingEdgesStopwatch.start();
        target2 = maxPonum - 1;
        for (i2 = 0; i2 < target2; ++i2) {
            int j3;
            int size = edgeListOffsets.get(i2 + 1) - edgeListOffsets.get(i2);
            if (size <= 1) continue;
            int[] arr = new int[size];
            for (j3 = 0; j3 < size; ++j3) {
                arr[j3] = incomingEdges.get(edgeListOffsets.get(i2) + j3);
            }
            Arrays.sort(arr);
            for (j3 = 0; j3 < size; ++j3) {
                incomingEdges.set(edgeListOffsets.get(i2) + j3, arr[j3]);
            }
        }
        sortIncomingEdgesStopwatch.stop();
        dominatorsStopwatch.start();
        com.android.tools.idea.diagnostics.hprof.util.IntList idomList = edgeListIndices;
        this.clear(idomList, maxPonum + 1);
        idomList.set(rootPonum, rootPonum);
        Ref.IntRef intersectCalls = new Ref.IntRef();
        Ref.IntRef rootSkipIntersectCalls = new Ref.IntRef();
        int nchanged = 1;
        int iter = 0;
        int idomUpdates = 0;
        int prevIntersectCalls = 0;
        long updateCallsSavedByCardTable = 0L;
        while (nchanged != 0 && iter < this.config.getDominatorTreeOptions().getMaxDominatorIterations()) {
            Stopwatch iterationStopwatch = Stopwatch.createStarted();
            int nupdates = 0;
            nchanged = 0;
            chunkIndex = ncardChunks - 1;
            while (chunkIndex >= 0) {
                long chunk2 = dirtyCards[chunkIndex];
                if (chunk2 == 0L) {
                    updateCallsSavedByCardTable += (long)(cardSize * 64);
                    --chunkIndex;
                    continue;
                }
                for (int card = 63; card >= 0; --card) {
                    if ((chunk2 & 1L << card) != 0L) {
                        int ponum;
                        int basePonum = cardSize * (chunkIndex * 64 + card);
                        int i6 = cardSize - 1;
                        AnalyzeGraph.computeDominatorFlameGraph$markCard(dirtyCards, chunkIndex * 64 + card, false);
                        while (i6 >= 0 && (ponum = basePonum + i6) != 0) {
                            if (ponum >= rootPonum) {
                                --i6;
                                continue;
                            }
                            if (idomList.get(ponum) == rootPonum) {
                                --i6;
                                continue;
                            }
                            int n9 = idomUpdates;
                            idomUpdates = n9 + 1;
                            ++nupdates;
                            if (AnalyzeGraph.computeDominatorFlameGraph$updateIdom(rootPonum, rootSkipIntersectCalls, idomList, edgeListOffsets, incomingEdges, intersectCalls, ponum)) {
                                for (int chidx = outgoingCardListOffsets.get(ponum); chidx < outgoingCardListOffsets.get(ponum + 1); ++chidx) {
                                    int targetCard = outgoingCardRefs.get(chidx);
                                    AnalyzeGraph.computeDominatorFlameGraph$markCard(dirtyCards, targetCard, true);
                                }
                                ++nchanged;
                            }
                            --i6;
                        }
                        continue;
                    }
                    updateCallsSavedByCardTable += (long)cardSize;
                }
                --chunkIndex;
            }
            LOG.debug("iteration " + iter + " recomputed " + nupdates + " and changed " + nchanged + " idoms in " + iterationStopwatch + "; called intersect() " + (intersectCalls.element - prevIntersectCalls) + " times");
            prevIntersectCalls = intersectCalls.element;
            chunk2 = iter;
            iter = chunk2 + 1;
        }
        dominatorsStopwatch.stop();
        retainedSizesStopwatch.start();
        com.android.tools.idea.diagnostics.hprof.util.IntList retainedSizes = outgoingCardListOffsets;
        chunkIndex = maxPonum;
        for (i = 1; i < chunkIndex; ++i) {
            retainedSizes.set(i, sizesList.get(postorderList.get(i)));
        }
        chunkIndex = maxPonum;
        for (i = 1; i < chunkIndex; ++i) {
            chunk2 = idomList.get(i);
            retainedSizes.set(chunk2, retainedSizes.get(chunk2) + retainedSizes.get(i));
        }
        retainedSizesStopwatch.stop();
        flameGraphStopwatch.start();
        Map idomTreeChildren = new LinkedHashMap();
        chunk2 = maxPonum;
        for (int i7 = 1; i7 < chunk2; ++i7) {
            if ((long)retainedSizes.get(i7) * 4L < (long)this.config.getDominatorTreeOptions().getMinNodeSize()) continue;
            ((List)idomTreeChildren.computeIfAbsent(idomList.get(i7), computeDominatorFlameGraph.1.INSTANCE)).add(i7);
        }
        Map stringToIndex = new LinkedHashMap();
        List indexToString = new ArrayList();
        Ref.IntRef renderedNodes = new Ref.IntRef();
        StringBuilder sb = new StringBuilder();
        AnalyzeGraph.computeDominatorFlameGraph$dumpCompressedFlameGraph$default(sb, idomTreeChildren, this, retainedSizes, renderedNodes, rootPonum, nav, postorderList, stringToIndex, indexToString, rootPonum, 0, 1024, null);
        StringBuilder i6 = stringBuilder = new StringBuilder();
        int n10 = 0;
        StringBuilder stringBuilder2 = sb;
        boolean bl = false;
        StringBuilder stringBuilder3 = $this$computeDominatorFlameGraph_u24lambda_u2d27.append(indexToString.size());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        Iterable $this$forEach$iv = indexToString;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder4 = $this$computeDominatorFlameGraph_u24lambda_u2d27.append(it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
        }
        Unit unit = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        stringBuilder2.insert(n10, string);
        flameGraphStopwatch.stop();
        totalStopwatch.stop();
        StringBuilder $this$computeDominatorFlameGraph_u24lambda_u2d28 = stringBuilder = report2.getMetaInfo();
        boolean bl3 = false;
        StringBuilder stringBuilder5 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("Dominator phase total time: " + totalStopwatch);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        StringBuilder stringBuilder6 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("  Compute postorder numbers: " + postorderStopwatch);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder6);
        StringBuilder stringBuilder7 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("    edgeCount = " + edgeCount + ", poEdgeCount = " + poEdgeCount + ", rootsSet size = " + ((Collection)rootsSet).size() + ", maxPonum = " + maxPonum + "; max stack depth = " + maxStackDepth);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder7);
        StringBuilder stringBuilder8 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("  Compute incoming edges + card refs: " + incomingEdgesStopwatch);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder8);
        StringBuilder stringBuilder9 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("  Sort incoming edges: " + sortIncomingEdgesStopwatch);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder9);
        StringBuilder stringBuilder10 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("  Dominator computation: " + dominatorsStopwatch);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder10);
        StringBuilder stringBuilder11 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("    " + iter + " iterations");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder11);
        StringBuilder stringBuilder12 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("    " + idomUpdates + " idom updates (" + AnalyzeGraph.computeDominatorFlameGraph$round((double)idomUpdates / (double)maxPonum) + "x per node); " + intersectCalls.element + " calls to intersect (" + AnalyzeGraph.computeDominatorFlameGraph$round((double)intersectCalls.element / (double)idomUpdates) + " per idomUpdate)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder12);
        StringBuilder stringBuilder13 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("    card table is " + ncards + " bits x " + cardSize + " obj/bit, saved " + updateCallsSavedByCardTable + " idom updates");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder13, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder13);
        StringBuilder stringBuilder14 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("    aborting updateIdom when root is hit saved " + rootSkipIntersectCalls.element + " intersect calls");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder14, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder14);
        StringBuilder stringBuilder15 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("  Compute retained sizes: " + retainedSizesStopwatch);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder15, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder15);
        StringBuilder stringBuilder16 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("  Emit flame graph: " + flameGraphStopwatch);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder16, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder16);
        StringBuilder stringBuilder17 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("    retained size cutoff: " + this.config.getDominatorTreeOptions().getMinNodeSize());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder17, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder17);
        StringBuilder stringBuilder18 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("    depth cutoff: " + this.config.getDominatorTreeOptions().getMaxDepth());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder18, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder18);
        StringBuilder stringBuilder19 = $this$computeDominatorFlameGraph_u24lambda_u2d28.append("    pruned tree contains " + renderedNodes.element + " nodes " + (String)(renderedNodes.element > this.config.getDominatorTreeOptions().getHeadLimit() ? "(truncated to " + this.config.getDominatorTreeOptions().getHeadLimit() + ")" : ""));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder19, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder19);
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sb.toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final String prepareInnerClassSection(AnalysisContext analysisContext, ObjectNavigator nav, IntOpenHashSet rootsSet, long objectCount) {
        StringBuilder stringBuilder;
        void $this$sortedByDescending$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$sortedByDescending$iv2;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        HistogramVisitor.InternalHistogramEntry value$iv;
        ClassDefinition klass;
        int i;
        int r;
        int element$iv;
        int n;
        BitSet marks = new BitSet((int)objectCount);
        com.android.tools.idea.diagnostics.hprof.util.IntList toVisit = analysisContext.getVisitedList();
        Ref.IntRef toVisitSize = new Ref.IntRef();
        IntOpenHashSet visited = new IntOpenHashSet();
        int[] roots = rootsSet.toIntArray();
        LongArrayList refList = new LongArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)roots, (String)"roots");
        int[] $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            r = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            AnalyzeGraph.prepareInnerClassSection$pushToVisit(toVisit, toVisitSize, r);
        }
        while (toVisitSize.element != 0) {
            int cur = AnalyzeGraph.prepareInnerClassSection$popToVisit(toVisitSize, toVisit);
            visited.add(cur);
            marks.set(cur);
            nav.goTo(cur, ObjectNavigator.ReferenceResolution.ONLY_STRONG_REFERENCES);
            nav.copyReferencesTo(refList);
            n = ((Collection)refList).size();
            for (i = 0; i < n; ++i) {
                Long l = refList.get(i);
                long l2 = 0L;
                if (l != null && l == l2 || visited.contains((int)refList.get(i).longValue())) continue;
                AnalyzeGraph.prepareInnerClassSection$pushToVisit(toVisit, toVisitSize, (int)refList.get(i).longValue());
            }
        }
        visited.clear();
        $this$forEach$iv = roots;
        $i$f$forEach = false;
        n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            r = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            AnalyzeGraph.prepareInnerClassSection$pushToVisit(toVisit, toVisitSize, r);
        }
        while (toVisitSize.element != 0) {
            int cur = AnalyzeGraph.prepareInnerClassSection$popToVisit(toVisitSize, toVisit);
            visited.add(cur);
            marks.clear(cur);
            nav.goTo(cur, ObjectNavigator.ReferenceResolution.STRONG_EXCLUDING_INNER_CLASS);
            nav.copyReferencesTo(refList);
            n = ((Collection)refList).size();
            for (i = 0; i < n; ++i) {
                Long l = refList.get(i);
                long l3 = 0L;
                if (l != null && l == l3 || visited.contains((int)refList.get(i).longValue())) continue;
                AnalyzeGraph.prepareInnerClassSection$pushToVisit(toVisit, toVisitSize, (int)refList.get(i).longValue());
            }
        }
        IntArrayList retainedObjects = new IntArrayList();
        int index2 = marks.nextSetBit(0);
        while (index2 != -1) {
            retainedObjects.add(index2);
            index2 = marks.nextSetBit(index2 + 1);
        }
        if (retainedObjects.isEmpty()) {
            return "";
        }
        HashMap culpritsHistogramEntries = new HashMap();
        HashMap objectsHistogramEntries = new HashMap();
        r = ((Collection)retainedObjects).size();
        for (int i2 = 0; i2 < r; ++i2) {
            HistogramVisitor.InternalHistogramEntry internalHistogramEntry;
            Object object;
            nav.goTo(retainedObjects.get(i2).intValue(), ObjectNavigator.ReferenceResolution.NO_REFERENCES);
            int size = nav.getObjectSize();
            klass = nav.getClass();
            Map $this$getOrPut$iv = objectsHistogramEntries;
            boolean $i$f$getOrPut = false;
            Object value$iv2 = $this$getOrPut$iv.get(klass);
            if (value$iv2 == null) {
                boolean bl = false;
                HistogramVisitor.InternalHistogramEntry answer$iv = new HistogramVisitor.InternalHistogramEntry(klass);
                $this$getOrPut$iv.put(klass, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv2;
            }
            ((HistogramVisitor.InternalHistogramEntry)object).addInstance(size);
            Integer n3 = retainedObjects.get(i2);
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"retainedObjects[i]");
            int culprit = AnalyzeGraph.prepareInnerClassSection$findCulprit(analysisContext, nav, marks, ((Number)n3).intValue());
            if (culprit == 0) continue;
            nav.goTo(culprit, ObjectNavigator.ReferenceResolution.NO_REFERENCES);
            ClassDefinition culpritClass = nav.getClass();
            Map $this$getOrPut$iv2 = culpritsHistogramEntries;
            boolean $i$f$getOrPut2 = false;
            value$iv = $this$getOrPut$iv2.get(culpritClass);
            if (value$iv == null) {
                boolean bl = false;
                HistogramVisitor.InternalHistogramEntry answer$iv = new HistogramVisitor.InternalHistogramEntry(culpritClass);
                $this$getOrPut$iv2.put(culpritClass, answer$iv);
                internalHistogramEntry = answer$iv;
            } else {
                internalHistogramEntry = value$iv;
            }
            internalHistogramEntry.addInstance(size);
        }
        Collection collection3 = culpritsHistogramEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"culpritsHistogramEntries\n        .values");
        Iterable r2 = collection3;
        boolean $i$f$map = false;
        klass = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            value$iv = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.asHistogramEntry());
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending22 = false;
        long l = ((Collection)retainedObjects).size();
        List list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalInstances()));
            }
        });
        Histogram culpritsHistogram = new Histogram(list2, l);
        Collection collection4 = objectsHistogramEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection4, (String)"objectsHistogramEntries\n        .values");
        Iterable $i$f$sortedByDescending22 = collection4;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HistogramVisitor.InternalHistogramEntry bl = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(it.asHistogramEntry());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedByDescending = false;
        long l4 = ((Collection)retainedObjects).size();
        List list3 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTotalInstances()));
            }
        });
        Histogram objectsHistogram = new Histogram(list3, l4);
        StringBuilder $this$prepareInnerClassSection_u24lambda_u2d37 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$prepareInnerClassSection_u24lambda_u2d37.append(culpritsHistogram.prepareReport("Inner class culprits", analysisContext.getConfig().getInnerClassOptions().getHistogramEntries()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        StringBuilder stringBuilder3 = $this$prepareInnerClassSection_u24lambda_u2d37.append(objectsHistogram.prepareReport("Objects retained by enclosing instance references", analysisContext.getConfig().getInnerClassOptions().getHistogramEntries()));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void clear(com.android.tools.idea.diagnostics.hprof.util.IntList $this$clear, int size) {
        for (int i = 0; i < size; ++i) {
            $this$clear.set(i, 0);
        }
    }

    private final boolean addIdToListAndSetParentIfOrphan(IntArrayList list2, int id2, int parentId2) {
        if (id2 != 0 && this.getParentIdForObjectId(id2) == 0L) {
            this.setParentForObjectId(id2, parentId2);
            list2.add(id2);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean addIdToListAndSetParentIfOrphan$default(AnalyzeGraph analyzeGraph, IntArrayList intArrayList, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return analyzeGraph.addIdToListAndSetParentIfOrphan(intArrayList, n, n2);
    }

    private final boolean addIdToSetIfOrphan(IntOpenHashSet set, int id2, int parentId2) {
        if (id2 != 0 && this.getParentIdForObjectId(id2) == 0L && set.add(id2)) {
            this.setParentForObjectId(id2, parentId2);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean addIdToSetIfOrphan$default(AnalyzeGraph analyzeGraph, IntOpenHashSet intOpenHashSet, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return analyzeGraph.addIdToSetIfOrphan(intOpenHashSet, n, n2);
    }

    private final Histogram getAndClearStrongRefHistogram() {
        Histogram result2 = this.strongRefHistogram;
        this.strongRefHistogram = null;
        Histogram histogram2 = result2;
        if (histogram2 == null) {
            throw new IllegalStateException("Graph not analyzed.");
        }
        return histogram2;
    }

    private final Histogram getAndClearSoftWeakHistogram() {
        Histogram result2 = this.softWeakRefHistogram;
        this.softWeakRefHistogram = null;
        Histogram histogram2 = result2;
        if (histogram2 == null) {
            throw new IllegalStateException("Graph not analyzed.");
        }
        return histogram2;
    }

    private static final int computeDominatorFlameGraph$getEdge(com.android.tools.idea.diagnostics.hprof.util.IntList incomingEdges, com.android.tools.idea.diagnostics.hprof.util.IntList edgeListOffsets, int ponum, int index2) {
        return incomingEdges.get(edgeListOffsets.get(ponum) + index2);
    }

    private static final void computeDominatorFlameGraph$addEdge(com.android.tools.idea.diagnostics.hprof.util.IntList edgeListOffsets, com.android.tools.idea.diagnostics.hprof.util.IntList edgeListIndices, com.android.tools.idea.diagnostics.hprof.util.IntList incomingEdges, int ponum, int parent2) {
        int nextFreeSlot = edgeListOffsets.get(ponum) + edgeListIndices.get(ponum);
        incomingEdges.set(nextFreeSlot, parent2);
        int n = edgeListIndices.get(ponum);
        edgeListIndices.set(ponum, n + 1);
    }

    private static final int computeDominatorFlameGraph$numIncomingEdges(com.android.tools.idea.diagnostics.hprof.util.IntList edgeListOffsets, int ponum) {
        return edgeListOffsets.get(ponum + 1) - edgeListOffsets.get(ponum);
    }

    private static final int computeDominatorFlameGraph$intersect(Ref.IntRef intersectCalls, com.android.tools.idea.diagnostics.hprof.util.IntList idomList, int a, int b) {
        int n = intersectCalls.element;
        intersectCalls.element = n + 1;
        int i = a;
        int j = b;
        while (i != j) {
            while (i < j) {
                if (i == 0) {
                    return j;
                }
                i = idomList.get(i);
            }
            while (j < i) {
                if (j == 0) {
                    return i;
                }
                j = idomList.get(j);
            }
        }
        return i;
    }

    private static final boolean computeDominatorFlameGraph$updateIdom(int rootPonum, Ref.IntRef rootSkipIntersectCalls, com.android.tools.idea.diagnostics.hprof.util.IntList idomList, com.android.tools.idea.diagnostics.hprof.util.IntList edgeListOffsets, com.android.tools.idea.diagnostics.hprof.util.IntList incomingEdges, Ref.IntRef intersectCalls, int i) {
        int parent2;
        int numIncoming = AnalyzeGraph.computeDominatorFlameGraph$numIncomingEdges(edgeListOffsets, i);
        int newIdom = AnalyzeGraph.computeDominatorFlameGraph$getEdge(incomingEdges, edgeListOffsets, i, numIncoming - 1);
        for (int j = numIncoming - 2; j >= 0 && (parent2 = AnalyzeGraph.computeDominatorFlameGraph$getEdge(incomingEdges, edgeListOffsets, i, j)) != 0; --j) {
            int intersection = AnalyzeGraph.computeDominatorFlameGraph$intersect(intersectCalls, idomList, newIdom, parent2);
            if (intersection != 0) {
                newIdom = intersection;
            }
            if (newIdom != rootPonum) continue;
            rootSkipIntersectCalls.element += j;
            break;
        }
        if (newIdom != idomList.get(i)) {
            idomList.set(i, newIdom);
            return true;
        }
        return false;
    }

    private static final void computeDominatorFlameGraph$markCard(long[] dirtyCards, int cardNumber, boolean value2) {
        int chunk = cardNumber >> 6;
        int card = cardNumber & 0x3F;
        dirtyCards[chunk] = value2 ? dirtyCards[chunk] | 1L << card : dirtyCards[chunk] & (1L << card ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static final String computeDominatorFlameGraph$signatureFor(int rootPonum, ObjectNavigator $nav, com.android.tools.idea.diagnostics.hprof.util.IntList postorderList, int ponum) {
        String string;
        block3: {
            if (ponum == rootPonum) {
                string = "root";
            } else {
                String $this$dropLastWhile$iv = $nav.getClassForObjectId(postorderList.get(ponum)).getName();
                boolean $i$f$dropLastWhile = false;
                for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                    char it = $this$dropLastWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it == ';') continue;
                    String string2 = $this$dropLastWhile$iv;
                    int n = 0;
                    int n2 = index$iv + 1;
                    String string3 = string2.substring(n, n2);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    break block3;
                }
                string = "";
            }
        }
        return string;
    }

    private static final int computeDominatorFlameGraph$addStringToPool(Map<String, Integer> stringToIndex, List<String> indexToString, String s) {
        if (!stringToIndex.containsKey(s)) {
            stringToIndex.put(s, stringToIndex.size());
            indexToString.add(s);
        }
        Integer n = stringToIndex.get(s);
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final void computeDominatorFlameGraph$dumpCompressedFlameGraph(StringBuilder $this$computeDominatorFlameGraph_u24dumpCompressedFlameGraph, Map<Integer, List<Integer>> idomTreeChildren, AnalyzeGraph this$0, com.android.tools.idea.diagnostics.hprof.util.IntList retainedSizes, Ref.IntRef renderedNodes, int rootPonum, ObjectNavigator $nav, com.android.tools.idea.diagnostics.hprof.util.IntList postorderList, Map<String, Integer> stringToIndex, List<String> indexToString, int poNumber, int depth) {
        int signatureIndex = AnalyzeGraph.computeDominatorFlameGraph$addStringToPool(stringToIndex, indexToString, AnalyzeGraph.computeDominatorFlameGraph$signatureFor(rootPonum, $nav, postorderList, poNumber));
        List<Integer> children = idomTreeChildren.get(poNumber);
        if (depth < this$0.config.getDominatorTreeOptions().getMaxDepth() && children != null) {
            void $this$forEach$iv;
            int p;
            Iterable iterable = children;
            int n = 0;
            for (Object t : iterable) {
                int n2 = ((Number)t).intValue();
                int n3 = n;
                boolean bl = false;
                int n4 = retainedSizes.get(p);
                n = n3 + n4;
            }
            int childrenSize = n;
            StringBuilder stringBuilder = $this$computeDominatorFlameGraph_u24dumpCompressedFlameGraph.append(signatureIndex + " " + (retainedSizes.get(poNumber) - childrenSize) + " " + children.size());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            int n5 = renderedNodes.element;
            renderedNodes.element = n5 + 1;
            Iterable $this$sortedByDescending$iv = children;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(retainedSizes){
                final /* synthetic */ com.android.tools.idea.diagnostics.hprof.util.IntList $retainedSizes$inlined;
                {
                    this.$retainedSizes$inlined = intList;
                }

                public final int compare(T a, T b) {
                    int p = ((Number)b).intValue();
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$retainedSizes$inlined.get(p));
                    p = ((Number)a).intValue();
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$retainedSizes$inlined.get(p)));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p = ((Number)element$iv).intValue();
                boolean bl = false;
                if (renderedNodes.element >= this$0.config.getDominatorTreeOptions().getHeadLimit()) continue;
                AnalyzeGraph.computeDominatorFlameGraph$dumpCompressedFlameGraph($this$computeDominatorFlameGraph_u24dumpCompressedFlameGraph, idomTreeChildren, this$0, retainedSizes, renderedNodes, rootPonum, $nav, postorderList, stringToIndex, indexToString, p, depth + 1);
            }
        } else {
            StringBuilder stringBuilder = $this$computeDominatorFlameGraph_u24dumpCompressedFlameGraph.append(signatureIndex + " " + retainedSizes.get(poNumber) + " 0");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            int n = renderedNodes.element;
            renderedNodes.element = n + 1;
        }
    }

    static /* synthetic */ void computeDominatorFlameGraph$dumpCompressedFlameGraph$default(StringBuilder stringBuilder, Map map2, AnalyzeGraph analyzeGraph, com.android.tools.idea.diagnostics.hprof.util.IntList intList, Ref.IntRef intRef, int n, ObjectNavigator objectNavigator, com.android.tools.idea.diagnostics.hprof.util.IntList intList2, Map map3, List list2, int n2, int n3, int n4, Object object) {
        if ((n4 & 0x400) != 0) {
            n3 = 0;
        }
        AnalyzeGraph.computeDominatorFlameGraph$dumpCompressedFlameGraph(stringBuilder, map2, analyzeGraph, intList, intRef, n, objectNavigator, intList2, map3, list2, n2, n3);
    }

    private static final String computeDominatorFlameGraph$round(double $this$computeDominatorFlameGraph_u24round) {
        String s = String.valueOf($this$computeDominatorFlameGraph_u24round);
        if (!StringsKt.contains$default((CharSequence)s, (char)'.', (boolean)false, (int)2, null)) {
            return s;
        }
        String string = s.substring(0, Math.min(StringsKt.indexOf$default((CharSequence)s, (String)".", (int)0, (boolean)false, (int)6, null) + 3, s.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    private static final int prepareInnerClassSection$popToVisit(Ref.IntRef toVisitSize, com.android.tools.idea.diagnostics.hprof.util.IntList toVisit) {
        int n = toVisitSize.element;
        toVisitSize.element = n + -1;
        return toVisit.get(toVisitSize.element);
    }

    private static final void prepareInnerClassSection$pushToVisit(com.android.tools.idea.diagnostics.hprof.util.IntList toVisit, Ref.IntRef toVisitSize, int i) {
        int n = toVisitSize.element;
        toVisitSize.element = n + 1;
        toVisit.set(n, i);
    }

    private static final int prepareInnerClassSection$findCulprit(AnalysisContext $analysisContext, ObjectNavigator $nav, BitSet marks, int id2) {
        int parentId2 = $analysisContext.getParentList().get(id2);
        int curId = id2;
        while (parentId2 != 0) {
            $nav.goTo(parentId2, ObjectNavigator.ReferenceResolution.NO_REFERENCES);
            String parentClass = $nav.getClass().getName();
            if (StringsKt.contains$default((CharSequence)parentClass, (CharSequence)"$", (boolean)false, (int)2, null) && marks.get(curId) && !marks.get(parentId2)) {
                return parentId2;
            }
            curId = parentId2;
            if (curId != (parentId2 = $analysisContext.getParentList().get(parentId2))) continue;
            break;
        }
        return 0;
    }

    public static final /* synthetic */ String access$computeDominatorFlameGraph(AnalyzeGraph $this, ObjectNavigator nav, IntOpenHashSet rootsSet, com.android.tools.idea.diagnostics.hprof.util.IntList sizesList, int edgeCount, AnalysisReport report2) {
        return $this.computeDominatorFlameGraph(nav, rootsSet, sizesList, edgeCount, report2);
    }

    public static final /* synthetic */ String access$prepareInnerClassSection(AnalyzeGraph $this, AnalysisContext analysisContext, ObjectNavigator nav, IntOpenHashSet rootsSet, long objectCount) {
        return $this.prepareInnerClassSection(analysisContext, nav, rootsSet, objectCount);
    }

    public static final /* synthetic */ AnalysisContext access$getAnalysisContext$p(AnalyzeGraph $this) {
        return $this.analysisContext;
    }

    static {
        Logger logger2 = Logger.getInstance(AnalyzeGraph.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(AnalyzeGraph::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalyzeGraph$WalkGraphPhase;", "", "(Ljava/lang/String;I)V", "StrongReferencesNonLocalVariables", "StrongReferencesLocalVariables", "DisposedRoots", "DisposedNonRootObjects", "DisposerTree", "StrongReferencesMarker", "SoftReferences", "WeakReferences", "CleanerFinalizerReferences", "Finished", "intellij.android.core"})
    public static final class WalkGraphPhase
    extends Enum<WalkGraphPhase> {
        public static final /* enum */ WalkGraphPhase StrongReferencesNonLocalVariables = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase StrongReferencesLocalVariables = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase DisposedRoots = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase DisposedNonRootObjects = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase DisposerTree = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase StrongReferencesMarker = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase SoftReferences = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase WeakReferences = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase CleanerFinalizerReferences = new WalkGraphPhase();
        public static final /* enum */ WalkGraphPhase Finished = new WalkGraphPhase();
        private static final /* synthetic */ WalkGraphPhase[] $VALUES;

        public static WalkGraphPhase[] values() {
            return (WalkGraphPhase[])$VALUES.clone();
        }

        public static WalkGraphPhase valueOf(String value2) {
            return Enum.valueOf(WalkGraphPhase.class, value2);
        }

        static {
            $VALUES = walkGraphPhaseArray = new WalkGraphPhase[]{WalkGraphPhase.StrongReferencesNonLocalVariables, WalkGraphPhase.StrongReferencesLocalVariables, WalkGraphPhase.DisposedRoots, WalkGraphPhase.DisposedNonRootObjects, WalkGraphPhase.DisposerTree, WalkGraphPhase.StrongReferencesMarker, WalkGraphPhase.SoftReferences, WalkGraphPhase.WeakReferences, WalkGraphPhase.CleanerFinalizerReferences, WalkGraphPhase.Finished};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalyzeGraph$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WalkGraphPhase.values().length];
            nArray[WalkGraphPhase.CleanerFinalizerReferences.ordinal()] = 1;
            nArray[WalkGraphPhase.SoftReferences.ordinal()] = 2;
            nArray[WalkGraphPhase.StrongReferencesLocalVariables.ordinal()] = 3;
            nArray[WalkGraphPhase.WeakReferences.ordinal()] = 4;
            nArray[WalkGraphPhase.DisposerTree.ordinal()] = 5;
            nArray[WalkGraphPhase.DisposedRoots.ordinal()] = 6;
            nArray[WalkGraphPhase.DisposedNonRootObjects.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

