/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.action;

import com.android.tools.idea.diagnostics.AndroidStudioSystemHealthMonitor;
import com.android.tools.idea.diagnostics.hprof.action.AnalysisRunnable;
import com.android.tools.idea.diagnostics.hprof.analysis.LiveInstanceStats;
import com.android.tools.idea.diagnostics.hprof.util.HeapDumpAnalysisNotificationGroup;
import com.android.tools.idea.diagnostics.report.HeapReportProperties;
import com.android.tools.idea.diagnostics.report.MemoryReportReason;
import com.android.tools.idea.diagnostics.report.UnanalyzedHeapReport;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.utils.TraceUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0003\u000e\u000f\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable;", "Ljava/lang/Runnable;", "reason", "Lcom/android/tools/idea/diagnostics/report/MemoryReportReason;", "analysisOption", "Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;", "(Lcom/android/tools/idea/diagnostics/report/MemoryReportReason;Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;)V", "estimateRequiredFreeSpaceInMB", "", "run", "", "shouldRunAnalysis", "", "userInvoked", "AnalysisOption", "CaptureHeapDumpTask", "Companion", "intellij.android.core"})
public final class HeapDumpSnapshotRunnable
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MemoryReportReason reason;
    @NotNull
    private final AnalysisOption analysisOption;
    public static final int MINIMUM_USED_MEMORY_TO_CAPTURE_HEAP_DUMP_IN_MB = 800;
    @NotNull
    public static final String NEXT_CHECK_TIMESTAMP_KEY = "heap.dump.snapshot.next.check.timestamp";
    @NotNull
    private static final Logger LOG;

    public HeapDumpSnapshotRunnable(@NotNull MemoryReportReason reason, @NotNull AnalysisOption analysisOption) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        Intrinsics.checkNotNullParameter((Object)((Object)analysisOption), (String)"analysisOption");
        this.reason = reason;
        this.analysisOption = analysisOption;
    }

    @Override
    public void run() {
        long estimatedRequiredMB;
        Path hprofPath;
        long spaceInMB;
        LOG.info("HeapDumpSnapshotRunnable started: reason=" + this.reason + ", analysisOption=" + this.analysisOption);
        boolean userInvoked = this.reason.isUserInvoked();
        if (!this.shouldRunAnalysis(userInvoked)) {
            return;
        }
        if (this.analysisOption == AnalysisOption.SCHEDULE_ON_NEXT_START) {
            try {
                AndroidStudioSystemHealthMonitor androidStudioSystemHealthMonitor = AndroidStudioSystemHealthMonitor.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)androidStudioSystemHealthMonitor, (String)"getInstance()");
                AndroidStudioSystemHealthMonitor instance2 = androidStudioSystemHealthMonitor;
                boolean isHeapReportPending = instance2.hasPendingHeapReport();
                if (isHeapReportPending) {
                    if (userInvoked) {
                        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                        Object[] objectArray = new Object[]{productName};
                        String message2 = AndroidBundle.message("heap.dump.snapshot.already.pending", objectArray);
                        Messages.showErrorDialog((String)message2, (String)AndroidBundle.message("heap.dump.snapshot.title", new Object[0]));
                    }
                    LOG.info("Heap report already pending.");
                    return;
                }
            }
            catch (IOException ex) {
                if (userInvoked) {
                    String message3 = AndroidBundle.message("heap.dump.snapshot.error.check.log", new Object[0]);
                    Messages.showErrorDialog((String)message3, (String)AndroidBundle.message("heap.dump.snapshot.title", new Object[0]));
                    LOG.warn("Exception while querying for pending heap report", (Throwable)ex);
                } else {
                    LOG.info("Exception while querying for pending heap report", (Throwable)ex);
                }
                return;
            }
        }
        if ((spaceInMB = Files.getFileStore((hprofPath = AndroidStudioSystemHealthMonitor.ourHProfDatabase.createHprofTemporaryFilePath()).getParent()).getUsableSpace() / (long)1000000) < (estimatedRequiredMB = this.estimateRequiredFreeSpaceInMB())) {
            LOG.info("Not enough space for heap dump: " + spaceInMB + " MB < " + estimatedRequiredMB + " MB");
            if (userInvoked) {
                Object[] objectArray = new Object[]{((Object)hprofPath.getParent()).toString(), estimatedRequiredMB, spaceInMB};
                String message4 = AndroidBundle.message("heap.dump.snapshot.no.space", objectArray);
                Messages.showErrorDialog((String)message4, (String)AndroidBundle.message("heap.dump.snapshot.title", new Object[0]));
            }
            return;
        }
        LOG.info("Capturing heap dump.");
        new CaptureHeapDumpTask(hprofPath, this.reason, this.analysisOption, userInvoked).queue();
    }

    private final boolean shouldRunAnalysis(boolean userInvoked) {
        if (!userInvoked) {
            long currentTimestampMs;
            if (Boolean.getBoolean("diagnostics.disable.heap.analysis")) {
                LOG.info("Disabled with system property.");
                return false;
            }
            if (ApplicationManager.getApplication().isUnitTestMode() || GuiTestingService.getInstance().isGuiTestingMode()) {
                LOG.info("Disabled for tests.");
                return false;
            }
            if (!ApplicationManager.getApplication().isEAP()) {
                LOG.info("Heap dump analysis is enabled only on EAP builds.");
                return false;
            }
            if (!Intrinsics.areEqual((Object)System.getProperty("sun.arch.data.model"), (Object)"64")) {
                LOG.info("Heap dump analysis supported only on 64-bit platforms.");
                return false;
            }
            boolean withGC$iv = false;
            boolean $i$f$usedMemory = false;
            Runtime rt$iv = Runtime.getRuntime();
            long usedMemoryMB = (rt$iv.totalMemory() - rt$iv.freeMemory()) / (long)1000000;
            if (usedMemoryMB < 800L) {
                LOG.info("Heap dump too small: " + usedMemoryMB + " MB < 800 MB");
                return false;
            }
            long nextCheckPropertyMs = PropertiesComponent.getInstance().getLong(NEXT_CHECK_TIMESTAMP_KEY, 0L);
            if (nextCheckPropertyMs > (currentTimestampMs = System.currentTimeMillis())) {
                String nextCheckDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US).format(new Date(nextCheckPropertyMs));
                LOG.info("Don't ask for snapshot until " + nextCheckDateString + ".");
                return false;
            }
        }
        return true;
    }

    private final long estimateRequiredFreeSpaceInMB() {
        long l = 100L;
        boolean withGC$iv = false;
        boolean $i$f$usedMemory = false;
        Runtime rt$iv = Runtime.getRuntime();
        long l2 = (long)((double)(rt$iv.totalMemory() - rt$iv.freeMemory()) * 2.0) / (long)1000000;
        return Math.max(l, l2);
    }

    static {
        Logger logger2 = Logger.getInstance(HeapDumpSnapshotRunnable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(HeapDumpSnapshotRunnable::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MINIMUM_USED_MEMORY_TO_CAPTURE_HEAP_DUMP_IN_MB", "", "NEXT_CHECK_TIMESTAMP_KEY", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;", "", "(Ljava/lang/String;I)V", "NO_ANALYSIS", "SCHEDULE_ON_NEXT_START", "IMMEDIATE", "intellij.android.core"})
    public static final class AnalysisOption
    extends Enum<AnalysisOption> {
        public static final /* enum */ AnalysisOption NO_ANALYSIS = new AnalysisOption();
        public static final /* enum */ AnalysisOption SCHEDULE_ON_NEXT_START = new AnalysisOption();
        public static final /* enum */ AnalysisOption IMMEDIATE = new AnalysisOption();
        private static final /* synthetic */ AnalysisOption[] $VALUES;

        public static AnalysisOption[] values() {
            return (AnalysisOption[])$VALUES.clone();
        }

        public static AnalysisOption valueOf(String value2) {
            return Enum.valueOf(AnalysisOption.class, value2);
        }

        static {
            $VALUES = analysisOptionArray = new AnalysisOption[]{AnalysisOption.NO_ANALYSIS, AnalysisOption.SCHEDULE_ON_NEXT_START, AnalysisOption.IMMEDIATE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$CaptureHeapDumpTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "hprofPath", "Ljava/nio/file/Path;", "reason", "Lcom/android/tools/idea/diagnostics/report/MemoryReportReason;", "analysisOption", "Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;", "restart", "", "(Ljava/nio/file/Path;Lcom/android/tools/idea/diagnostics/report/MemoryReportReason;Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;Z)V", "captureSnapshot", "", "confirmRestart", "onSuccess", "onThrowable", "error", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.android.core"})
    public static final class CaptureHeapDumpTask
    extends Task.Modal {
        @NotNull
        private final Path hprofPath;
        @NotNull
        private final MemoryReportReason reason;
        @NotNull
        private final AnalysisOption analysisOption;
        private final boolean restart;

        public CaptureHeapDumpTask(@NotNull Path hprofPath, @NotNull MemoryReportReason reason, @NotNull AnalysisOption analysisOption, boolean restart) {
            Intrinsics.checkNotNullParameter((Object)hprofPath, (String)"hprofPath");
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            Intrinsics.checkNotNullParameter((Object)((Object)analysisOption), (String)"analysisOption");
            super(null, AndroidBundle.message("heap.dump.snapshot.task.title", new Object[0]), false);
            this.hprofPath = hprofPath;
            this.reason = reason;
            this.analysisOption = analysisOption;
            this.restart = restart;
        }

        public void onSuccess() {
            if (this.analysisOption == AnalysisOption.SCHEDULE_ON_NEXT_START && this.restart) {
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ CaptureHeapDumpTask $tmp0;
                    {
                        this.$tmp0 = $tmp0;
                    }

                    public final void run() {
                        CaptureHeapDumpTask.access$confirmRestart(this.$tmp0);
                    }
                }, ModalityState.NON_MODAL);
            }
        }

        public void onThrowable(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            LOG.error(error);
            String string = AndroidBundle.message("heap.dump.snapshot.exception", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"heap.dump.snapshot.exception\")");
            Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, NotificationType.ERROR);
            notification.notify(null);
        }

        private final void confirmRestart() {
            String title = AndroidBundle.message("heap.dump.snapshot.restart.dialog.title", new Object[0]);
            String message2 = AndroidBundle.message("heap.dump.snapshot.restart.dialog.message", new Object[0]);
            String yesString = AndroidBundle.message("heap.dump.snapshot.restart.dialog.restart.now", new Object[0]);
            String noString = AndroidBundle.message("heap.dump.snapshot.restart.dialog.restart.later", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)title, (String)"title");
            Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"message");
            MessageDialogBuilder.YesNo result2 = MessageDialogBuilder.Companion.yesNo(title, message2);
            MessageDialogBuilder.YesNo yesNo = MessageDialogBuilder.Companion.yesNo(title, message2);
            Intrinsics.checkNotNullExpressionValue((Object)yesString, (String)"yesString");
            MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(yesString);
            Intrinsics.checkNotNullExpressionValue((Object)noString, (String)"noString");
            if (((MessageDialogBuilder.YesNo)yesNo2.noText(noString)).guessWindowAndAsk()) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
                ApplicationEx application2 = (ApplicationEx)application;
                application2.restart(true);
            }
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.setIndeterminate(true);
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            if (this.reason.isUserInvoked()) {
                objectArray = new Object[]{productName};
                indicator.setText(AndroidBundle.message("heap.dump.snapshot.indicator.text", objectArray));
            } else {
                objectArray = new Object[]{productName};
                indicator.setText(AndroidBundle.message("heap.dump.snapshot.indicator.low.memory.text", objectArray));
            }
            Thread.sleep(500L);
            this.captureSnapshot();
            Ref.ObjectRef liveStats = new Ref.ObjectRef();
            liveStats.element = "";
            ApplicationManager.getApplication().invokeAndWait(new Runnable((Ref.ObjectRef<String>)liveStats){
                final /* synthetic */ Ref.ObjectRef<String> $liveStats;
                {
                    this.$liveStats = $liveStats;
                }

                public final void run() {
                    Object object;
                    Ref.ObjectRef<String> objectRef;
                    Ref.ObjectRef<String> objectRef2 = this.$liveStats;
                    try {
                        objectRef = objectRef2;
                        object = new LiveInstanceStats().createReport();
                    }
                    catch (Error e) {
                        objectRef = objectRef2;
                        object = "Error while gathering live statistics: " + TraceUtils.getStackTrace((Throwable)e) + "\n";
                    }
                    objectRef.element = object;
                }
            });
            UnanalyzedHeapReport report2 = new UnanalyzedHeapReport(this.hprofPath, new HeapReportProperties(this.reason, (String)liveStats.element), null, 4, null);
            switch (WhenMappings.$EnumSwitchMapping$0[this.analysisOption.ordinal()]) {
                case 1: {
                    AndroidStudioSystemHealthMonitor.getInstance().addHeapReportToDatabase(report2);
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, productName){
                        final /* synthetic */ CaptureHeapDumpTask this$0;
                        final /* synthetic */ String $productName;
                        {
                            this.this$0 = $receiver;
                            this.$productName = $productName;
                        }

                        public final void run() {
                            String string = AndroidBundle.message("heap.dump.analysis.notification.title", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"heap.dump.analysis.notification.title\")");
                            Object[] objectArray = new Object[]{((Object)CaptureHeapDumpTask.access$getHprofPath$p(this.this$0)).toString(), this.$productName};
                            String string2 = AndroidBundle.message("heap.dump.snapshot.created", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"heap.dump.snaps\u2026.toString(), productName)");
                            Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, string2, NotificationType.INFORMATION);
                            notification.notify(null);
                        }
                    });
                    break;
                }
                case 2: {
                    ApplicationManager.getApplication().invokeLater((Runnable)new AnalysisRunnable(report2, true));
                    break;
                }
                case 3: {
                    String string = AndroidBundle.message("heap.dump.analysis.notification.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"heap.dump.analysis.notification.title\")");
                    Object[] objectArray2 = new Object[]{((Object)this.hprofPath).toString()};
                    String string2 = AndroidBundle.message("heap.dump.snapshot.created.no.analysis", objectArray2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"heap.dump.snaps\u2026s\", hprofPath.toString())");
                    Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, string2, NotificationType.INFORMATION);
                    notification.notify(null);
                }
            }
        }

        private final void captureSnapshot() {
            if (PathKt.exists((Path)this.hprofPath)) {
                File file2 = this.hprofPath.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"hprofPath.toFile()");
                throw new FileAlreadyExistsException(file2, null, null, 6, null);
            }
            try {
                MemoryDumpHelper.captureMemoryDump((String)((Object)this.hprofPath).toString());
            }
            catch (Throwable t) {
                Files.deleteIfExists(this.hprofPath);
                throw t;
            }
        }

        public static final /* synthetic */ void access$confirmRestart(CaptureHeapDumpTask $this) {
            $this.confirmRestart();
        }

        public static final /* synthetic */ Path access$getHprofPath$p(CaptureHeapDumpTask $this) {
            return $this.hprofPath;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AnalysisOption.values().length];
                nArray[AnalysisOption.SCHEDULE_ON_NEXT_START.ordinal()] = 1;
                nArray[AnalysisOption.IMMEDIATE.ordinal()] = 2;
                nArray[AnalysisOption.NO_ANALYSIS.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

