/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.action;

import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.hprof.action.AnalysisRunnable;
import com.android.tools.idea.diagnostics.hprof.action.ShowReportDialog;
import com.android.tools.idea.diagnostics.hprof.action.SystemTempFilenameSupplier;
import com.android.tools.idea.diagnostics.hprof.analysis.HProfAnalysis;
import com.android.tools.idea.diagnostics.hprof.util.HeapDumpAnalysisNotificationGroup;
import com.android.tools.idea.diagnostics.report.AnalyzedHeapReport;
import com.android.tools.idea.diagnostics.report.HeapReport;
import com.android.tools.idea.diagnostics.report.UnanalyzedHeapReport;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.util.ui.UIUtil;
import java.io.Closeable;
import java.io.File;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0003\u000b\f\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/AnalysisRunnable;", "Ljava/lang/Runnable;", "report", "Lcom/android/tools/idea/diagnostics/report/UnanalyzedHeapReport;", "deleteAfterAnalysis", "", "(Lcom/android/tools/idea/diagnostics/report/UnanalyzedHeapReport;Z)V", "getReport", "()Lcom/android/tools/idea/diagnostics/report/UnanalyzedHeapReport;", "run", "", "AnalysisTask", "Companion", "ReviewReportAction", "intellij.android.core"})
public final class AnalysisRunnable
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UnanalyzedHeapReport report;
    private final boolean deleteAfterAnalysis;
    @NotNull
    private static final Logger LOG;

    public AnalysisRunnable(@NotNull UnanalyzedHeapReport report2, boolean deleteAfterAnalysis) {
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        this.report = report2;
        this.deleteAfterAnalysis = deleteAfterAnalysis;
    }

    @NotNull
    public final UnanalyzedHeapReport getReport() {
        return this.report;
    }

    @Override
    public void run() {
        new AnalysisTask().queue();
    }

    static {
        Logger logger2 = Logger.getInstance(AnalysisRunnable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(AnalysisRunnable::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/AnalysisRunnable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "updateNextCheckTimeIfNeeded", "", "report", "Lcom/android/tools/idea/diagnostics/report/HeapReport;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final void updateNextCheckTimeIfNeeded(HeapReport report2) {
            if (!report2.getHeapProperties().getReason().isUserInvoked()) {
                long nextCheckMs = System.currentTimeMillis() + TimeUnit.DAYS.toMillis(7L);
                PropertiesComponent.getInstance().setValue("heap.dump.snapshot.next.check.timestamp", String.valueOf(nextCheckMs));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/AnalysisRunnable$AnalysisTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "(Lcom/android/tools/idea/diagnostics/hprof/action/AnalysisRunnable;)V", "deleteHprofFileAsync", "", "onThrowable", "error", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.android.core"})
    public final class AnalysisTask
    extends Task.Backgroundable {
        public AnalysisTask() {
            super(null, AndroidBundle.message("heap.dump.analysis.task.title", new Object[0]), false);
        }

        public void onThrowable(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            LOG.error(error);
            Companion.updateNextCheckTimeIfNeeded(AnalysisRunnable.this.getReport());
            String string = AndroidBundle.message("heap.dump.analysis.exception", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"heap.dump.analysis.exception\")");
            Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, NotificationType.INFORMATION);
            notification.notify(null);
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                this.deleteHprofFileAsync();
            }
        }

        private final void deleteHprofFileAsync() {
            CompletableFuture.runAsync(new Runnable(AnalysisRunnable.this){
                final /* synthetic */ AnalysisRunnable this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void run() {
                    Files.deleteIfExists(this.this$0.getReport().getHprofPath());
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.setIndeterminate(false);
            indicator.setText("Analyze Heap");
            indicator.setFraction(0.0);
            Set openOptions = null;
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                Object[] objectArray = new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE};
                openOptions = SetsKt.setOf((Object[])objectArray);
            } else {
                openOptions = SetsKt.setOf((Object)StandardOpenOption.READ);
            }
            Closeable closeable = FileChannel.open(AnalysisRunnable.this.getReport().getHprofPath(), openOptions, new FileAttribute[0]);
            Throwable throwable = null;
            try {
                Object channel = (FileChannel)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
                channel = new HProfAnalysis((FileChannel)channel, new SystemTempFilenameSupplier()).analyze(indicator);
            }
            catch (Throwable channel) {
                throwable = channel;
                throw channel;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object reportString = channel;
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                this.deleteHprofFileAsync();
            }
            AnalyzedHeapReport analyzedReport = new AnalyzedHeapReport((String)reportString, AnalysisRunnable.this.getReport().getHeapProperties(), AnalysisRunnable.this.getReport().getProperties());
            Path heapReportDir = Paths.get(PathManager.getLogPath(), new String[0]).resolve("heapReports");
            heapReportDir.toFile().mkdirs();
            String datetime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
            Path heapReportFile = heapReportDir.resolve(Paths.get("heapReport" + datetime + ".txt", new String[0]));
            File file2 = heapReportFile.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"heapReportFile.toFile()");
            FilesKt.writeText$default((File)file2, (String)reportString, null, (int)2, null);
            String string = AndroidBundle.message("heap.dump.analysis.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"heap.dump.analysis.notification.title\")");
            String string2 = AndroidBundle.message("heap.dump.analysis.notification.ready.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"heap.dump.analy\u2026ification.ready.content\")");
            Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, string2, NotificationType.INFORMATION);
            notification.setImportant(true);
            notification.addAction((AnAction)new ReviewReportAction(analyzedReport));
            notification.notify(null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/AnalysisRunnable$ReviewReportAction;", "Lcom/intellij/notification/NotificationAction;", "report", "Lcom/android/tools/idea/diagnostics/report/AnalyzedHeapReport;", "(Lcom/android/tools/idea/diagnostics/report/AnalyzedHeapReport;)V", "reportShown", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notification", "Lcom/intellij/notification/Notification;", "uploadReport", "intellij.android.core"})
    public static final class ReviewReportAction
    extends NotificationAction {
        @NotNull
        private final AnalyzedHeapReport report;
        private boolean reportShown;

        public ReviewReportAction(@NotNull AnalyzedHeapReport report2) {
            Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
            super(AndroidBundle.message("heap.dump.analysis.notification.action.title", new Object[0]));
            this.report = report2;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            if (this.reportShown) {
                return;
            }
            this.reportShown = true;
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(notification, this){
                final /* synthetic */ Notification $notification;
                final /* synthetic */ ReviewReportAction this$0;
                {
                    this.$notification = $notification;
                    this.this$0 = $receiver;
                }

                public final void run() {
                    this.$notification.expire();
                    ShowReportDialog reportDialog = new ShowReportDialog(ReviewReportAction.access$getReport$p(this.this$0));
                    boolean userAgreedToSendReport = reportDialog.showAndGet();
                    com.android.tools.idea.diagnostics.hprof.action.AnalysisRunnable$Companion.access$updateNextCheckTimeIfNeeded(AnalysisRunnable.Companion, ReviewReportAction.access$getReport$p(this.this$0));
                    if (userAgreedToSendReport) {
                        ReviewReportAction.access$uploadReport(this.this$0);
                    }
                }
            });
        }

        private final void uploadReport() {
            StudioCrashReporter.getInstance().submit(this.report.asCrashReport(), true).whenCompleteAsync((BiConsumer)uploadReport.1.INSTANCE, (Executor)PooledThreadExecutor.INSTANCE);
        }

        public static final /* synthetic */ AnalyzedHeapReport access$getReport$p(ReviewReportAction $this) {
            return $this.report;
        }

        public static final /* synthetic */ void access$uploadReport(ReviewReportAction $this) {
            $this.uploadReport();
        }
    }
}

