/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof;

import com.android.tools.idea.diagnostics.hprof.AnalyzerProgressIndicator;
import com.android.tools.idea.diagnostics.hprof.action.SystemTempFilenameSupplier;
import com.android.tools.idea.diagnostics.hprof.analysis.HProfAnalysis;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class Analyzer {
    public static void main(String[] args) throws IOException {
        String report2;
        Path hprofPath;
        AnalyzerProgressIndicator progress2;
        if (args.length == 0 || args.length == 1 && args[0].equals("-v")) {
            System.out.println();
            System.out.println("Usage: " + Analyzer.class.getName() + " [-v] <hprof file>");
            System.exit(1);
        }
        if (args[0].equals("-v")) {
            progress2 = new AnalyzerProgressIndicator();
            hprofPath = Paths.get(args[1], new String[0]);
        } else {
            progress2 = new EmptyProgressIndicator(ModalityState.NON_MODAL);
            hprofPath = Paths.get(args[0], new String[0]);
        }
        try (FileChannel channel = FileChannel.open(hprofPath, StandardOpenOption.READ);){
            report2 = new HProfAnalysis(channel, new SystemTempFilenameSupplier()).analyze((ProgressIndicator)progress2);
            progress2.setText("DONE");
        }
        System.out.println(report2);
    }
}

