/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverse;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import java.util.Locale;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class HeapTraverseUtil {
    static boolean isArrayOfPrimitives(@NotNull Class<?> type) {
        return type.isArray() && HeapTraverseUtil.isPrimitive(type.getComponentType());
    }

    public static void processMask(long mask, @NotNull Consumer<Integer> p) {
        int trailingZeros = Long.numberOfTrailingZeros(mask);
        mask >>= Long.numberOfTrailingZeros(mask);
        int i = trailingZeros;
        while (mask != 0L) {
            if ((mask & 1L) != 0L) {
                p.accept(i);
            }
            ++i;
            mask >>= 1;
        }
    }

    public static boolean isPrimitive(@NotNull Class<?> type) {
        return type.isPrimitive();
    }

    @NotNull
    public static String getObjectsSizePresentation(long bytes2, HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle style) {
        if (style == HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle.BYTES) {
            return String.format(Locale.US, "%d bytes", bytes2);
        }
        return HeapReportUtils.INSTANCE.toShortStringAsCount(bytes2);
    }

    @NotNull
    public static String getObjectsStatsPresentation(ObjectsStatistics statistics, HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle style) {
        return String.format(Locale.US, "%s/%d objects", HeapTraverseUtil.getObjectsSizePresentation(statistics.getTotalSizeInBytes(), style), statistics.getObjectsCount());
    }
}

