/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.heap.ComponentsSet;
import com.android.tools.idea.diagnostics.heap.FieldCache;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverseException;
import com.android.tools.idea.diagnostics.heap.HeapTraverseChildProcessor;
import com.android.tools.idea.diagnostics.heap.HeapTraverseNode;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.google.common.math.LongMath;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.MemoryUsageReportEvent;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.WeakList;
import com.intellij.util.messages.MessageBusConnection;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HeapSnapshotTraverse
implements Disposable {
    private static final int MAX_ALLOWED_OBJECT_MAP_SIZE = 1000000;
    private static final int INVALID_OBJECT_ID = -1;
    private static final int MAX_DEPTH = 100000;
    private static final long OBJECT_CREATION_ITERATION_ID_MASK = 255L;
    private static final long CURRENT_ITERATION_ID_MASK = 65280L;
    private static final long CURRENT_ITERATION_VISITED_MASK = 65536L;
    private static final long CURRENT_ITERATION_OBJECT_ID_MASK = 562949953290240L;
    private static final int CURRENT_ITERATION_OBJECT_ID_OFFSET = 17;
    private static final int CURRENT_ITERATION_ID_OFFSET = 8;
    private static short ourIterationId = 0;
    @NotNull
    private final LowMemoryWatcher watcher = LowMemoryWatcher.register(this::onLowMemorySignalReceived);
    @NotNull
    private final MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
    @NotNull
    private final HeapTraverseChildProcessor heapTraverseChildProcessor;
    private final short iterationId;
    @NotNull
    private final HeapSnapshotStatistics statistics;
    private volatile boolean shouldAbortTraversal = false;
    private int lastObjectId = 0;

    public HeapSnapshotTraverse(@NotNull HeapSnapshotStatistics statistics) {
        this(new HeapTraverseChildProcessor(statistics), statistics);
    }

    public HeapSnapshotTraverse(@NotNull HeapTraverseChildProcessor childProcessor, @NotNull HeapSnapshotStatistics statistics) {
        this.messageBusConnection.subscribe(PowerSaveMode.TOPIC, () -> {
            if (PowerSaveMode.isEnabled()) {
                this.shouldAbortTraversal = true;
                this.messageBusConnection.disconnect();
            }
        });
        this.heapTraverseChildProcessor = childProcessor;
        this.iterationId = HeapSnapshotTraverse.getNextIterationId();
        this.statistics = statistics;
    }

    public MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode walkObjects(int maxDepth) {
        if (!HeapSnapshotTraverse.canTagObjects()) {
            return MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.CANT_TAG_OBJECTS;
        }
        WeakList classes2 = new WeakList();
        classes2.addAll(Arrays.asList(HeapSnapshotTraverse.getClasses()));
        return this.walkObjects(maxDepth, (Collection<?>)classes2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode walkObjects(int maxDepth, @NotNull Collection<?> startRoots) {
        try {
            if (!HeapSnapshotTraverse.canTagObjects()) {
                MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.CANT_TAG_OBJECTS;
                return statusCode;
            }
            FieldCache fieldCache = new FieldCache(this.statistics);
            ArrayDeque<Node> stack = new ArrayDeque<Node>();
            for (Object root : startRoots) {
                if (root == null) continue;
                stack.clear();
                this.depthFirstTraverseHeapObjects(root, maxDepth, stack, fieldCache);
            }
            Int2ObjectOpenHashMap objectIdToTraverseNode = new Int2ObjectOpenHashMap();
            for (Object root : startRoots) {
                int objectId = this.getObjectId(root);
                if (objectId <= 0 || objectId > this.lastObjectId) {
                    MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.WRONG_ROOT_OBJECT_ID;
                    return statusCode;
                }
                objectIdToTraverseNode.put(objectId, new HeapTraverseNode(root));
            }
            this.statistics.setHeapObjectCount(this.lastObjectId);
            this.statistics.setTraverseSessionId(this.iterationId);
            for (int i = this.lastObjectId; i > 0; --i) {
                this.abortTraversalIfRequested();
                this.statistics.updateMaxObjectsQueueSize(objectIdToTraverseNode.size());
                if (objectIdToTraverseNode.size() > 1000000) {
                    Object root;
                    root = MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.OBJECTS_MAP_IS_TOO_BIG;
                    return root;
                }
                HeapTraverseNode node = (HeapTraverseNode)objectIdToTraverseNode.get(i);
                if (node == null) {
                    this.statistics.incrementGarbageCollectedObjectsCounter();
                    continue;
                }
                objectIdToTraverseNode.remove(i);
                Object currentObject = node.getObject();
                if (currentObject == null) {
                    this.statistics.incrementGarbageCollectedObjectsCounter();
                    continue;
                }
                ComponentsSet.Component currentObjectComponent = this.statistics.getConfig().getComponentsSet().getComponentOfObject(currentObject);
                long currentObjectSize = HeapSnapshotTraverse.getObjectSize(currentObject);
                short currentObjectCreationIterationId = this.getObjectCreationIterationId(currentObject);
                short currentObjectAge = (short)(this.iterationId - currentObjectCreationIterationId);
                String currentObjectClassName = currentObject.getClass().getName();
                this.statistics.addObjectToTotal(currentObjectSize, currentObjectAge);
                if (currentObjectComponent != null) {
                    this.updateComponentRootMasks(node, currentObjectComponent, HeapTraverseNode.RefWeight.DEFAULT);
                }
                HeapTraverseUtil.processMask(node.retainedMask, index2 -> this.statistics.addRetainedObjectSizeToComponent((int)index2, currentObjectSize, currentObjectAge));
                HeapTraverseUtil.processMask(node.retainedMaskForCategories, index2 -> this.statistics.addRetainedObjectSizeToCategoryComponent((int)index2, currentObjectSize, currentObjectAge));
                AtomicInteger categoricalOwnedMask = new AtomicInteger();
                HeapTraverseUtil.processMask(node.ownedByComponentMask, index2 -> categoricalOwnedMask.set(categoricalOwnedMask.get() | 1 << this.statistics.getConfig().getComponentsSet().getComponents().get((int)index2).getComponentCategory().getId()));
                if (categoricalOwnedMask.get() != 0 && LongMath.isPowerOfTwo((long)categoricalOwnedMask.get())) {
                    HeapTraverseUtil.processMask(categoricalOwnedMask.get(), index2 -> this.statistics.addOwnedObjectSizeToCategoryComponent((int)index2, currentObjectSize, currentObjectAge, currentObjectClassName));
                }
                if (node.ownedByComponentMask == 0L) {
                    int uncategorizedComponentId = this.statistics.getConfig().getComponentsSet().getUncategorizedComponent().getId();
                    int uncategorizedCategoryId = this.statistics.getConfig().getComponentsSet().getUncategorizedComponent().getComponentCategory().getId();
                    this.statistics.addOwnedObjectSizeToComponent(uncategorizedComponentId, currentObjectSize, currentObjectAge, currentObjectClassName);
                    this.statistics.addOwnedObjectSizeToCategoryComponent(uncategorizedCategoryId, currentObjectSize, currentObjectAge, currentObjectClassName);
                } else if (LongMath.isPowerOfTwo((long)node.ownedByComponentMask)) {
                    HeapTraverseUtil.processMask(node.ownedByComponentMask, index2 -> this.statistics.addOwnedObjectSizeToComponent((int)index2, currentObjectSize, currentObjectAge, currentObjectClassName));
                } else {
                    this.statistics.addObjectSizeToSharedComponent(node.ownedByComponentMask, currentObjectSize, currentObjectAge, currentObjectClassName);
                }
                this.propagateComponentMask(currentObject, node, (Map<Integer, HeapTraverseNode>)objectIdToTraverseNode, fieldCache);
            }
        }
        catch (HeapSnapshotTraverseException exception) {
            MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = exception.getStatusCode();
            return statusCode;
        }
        finally {
            this.watcher.stop();
            this.messageBusConnection.disconnect();
        }
        return MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.NO_ERROR;
    }

    private void updateComponentRootMasks(HeapTraverseNode node, ComponentsSet.Component currentObjectComponent, HeapTraverseNode.RefWeight weight) {
        node.retainedMask |= 1L << currentObjectComponent.getId();
        node.retainedMaskForCategories |= 1 << currentObjectComponent.getComponentCategory().getId();
        node.ownedByComponentMask = 1L << currentObjectComponent.getId();
        node.ownershipWeight = weight;
    }

    private void abortTraversalIfRequested() throws HeapSnapshotTraverseException {
        if (this.shouldAbortTraversal) {
            throw new HeapSnapshotTraverseException(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.LOW_MEMORY);
        }
    }

    private void onLowMemorySignalReceived() {
        this.shouldAbortTraversal = true;
    }

    private boolean isTagFromTheCurrentIteration(long tag) {
        return (tag & 0xFF00L) >> 8 == (long)this.iterationId;
    }

    private short getObjectCreationIterationId(@NotNull Object obj) {
        long tag = HeapSnapshotTraverse.getObjectTag(obj);
        return (short)(tag & 0xFFL);
    }

    private void checkObjectCreationIterationIdAndSetIfNot(@NotNull Object obj) {
        long tag = HeapSnapshotTraverse.getObjectTag(obj);
        int creationIterationId = (int)(tag & 0xFFL);
        if (creationIterationId == 0) {
            tag &= (long)(~this.iterationId);
            HeapSnapshotTraverse.setObjectTag(obj, (tag |= (long)this.iterationId) | (long)this.iterationId);
        }
    }

    private int getObjectId(@NotNull Object obj) {
        long tag = HeapSnapshotTraverse.getObjectTag(obj);
        if (!this.isTagFromTheCurrentIteration(tag)) {
            return -1;
        }
        return (int)(tag >> 17);
    }

    private boolean wasVisited(@NotNull Object obj) {
        long tag = HeapSnapshotTraverse.getObjectTag(obj);
        if (!this.isTagFromTheCurrentIteration(tag)) {
            return false;
        }
        return (tag & 0x10000L) != 0L;
    }

    private void setObjectId(@NotNull Object obj, int newObjectId) {
        long tag = HeapSnapshotTraverse.getObjectTag(obj);
        tag &= 0xFFFE00000001FFFFL;
        tag |= (long)newObjectId << 17;
        tag &= 0xFFFFFFFFFFFF00FFL;
        HeapSnapshotTraverse.setObjectTag(obj, tag |= (long)this.iterationId << 8);
    }

    private void markVisited(@NotNull Object obj) {
        long tag = HeapSnapshotTraverse.getObjectTag(obj);
        tag &= 0xFFFFFFFFFFFEFFFFL;
        tag |= 0x10000L;
        tag &= 0xFFFFFFFFFFFF00FFL;
        HeapSnapshotTraverse.setObjectTag(obj, tag |= (long)this.iterationId << 8);
    }

    private void addToStack(@NotNull Node node, int maxDepth, @Nullable Object value2, @NotNull Deque<Node> stack) {
        if (value2 == null) {
            return;
        }
        if (node.getDepth() + 1 > maxDepth) {
            return;
        }
        if (HeapTraverseUtil.isPrimitive(value2.getClass())) {
            return;
        }
        if (this.wasVisited(value2)) {
            return;
        }
        this.markVisited(value2);
        stack.push(new Node(value2, node.getDepth() + 1));
    }

    private void addStronglyReferencedChildrenToStack(@NotNull Node node, int maxDepth, @NotNull Deque<Node> stack, @NotNull FieldCache fieldCache) throws HeapSnapshotTraverseException {
        if (node.depth >= maxDepth) {
            return;
        }
        this.heapTraverseChildProcessor.processChildObjects(node.getObject(), (value2, weight) -> this.addToStack(node, maxDepth, value2, stack), fieldCache);
    }

    private int getNextObjectId() {
        return ++this.lastObjectId;
    }

    private void depthFirstTraverseHeapObjects(@NotNull Object root, int maxDepth, @NotNull Deque<Node> stack, @NotNull FieldCache fieldCache) throws HeapSnapshotTraverseException {
        if (this.wasVisited(root)) {
            return;
        }
        Node rootNode = new Node(root, 0);
        this.markVisited(root);
        stack.push(rootNode);
        while (!stack.isEmpty()) {
            if (stack.size() > 1000000) {
                stack.clear();
                throw new HeapSnapshotTraverseException(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.OBJECTS_MAP_IS_TOO_BIG);
            }
            Node node = stack.peek();
            Object obj = node.getObject();
            if (obj == null) {
                stack.pop();
                continue;
            }
            if (node.referencesProcessed) {
                if (node.getObject() != null) {
                    this.checkObjectCreationIterationIdAndSetIfNot(obj);
                    this.setObjectId(node.getObject(), this.getNextObjectId());
                }
                stack.pop();
                continue;
            }
            this.addStronglyReferencedChildrenToStack(node, maxDepth, stack, fieldCache);
            this.abortTraversalIfRequested();
            node.referencesProcessed = true;
        }
    }

    private void propagateComponentMask(@NotNull Object parentObj, @NotNull HeapTraverseNode parentNode, Map<Integer, HeapTraverseNode> objectIdToTraverseNode, @NotNull FieldCache fieldCache) throws HeapSnapshotTraverseException {
        this.heapTraverseChildProcessor.processChildObjects(parentObj, (value2, ownershipWeight) -> {
            HeapTraverseNode currentNode;
            if (value2 == null) {
                return;
            }
            int objectId = this.getObjectId(value2);
            if (objectId == -1) {
                return;
            }
            if (parentObj.getClass().isSynthetic()) {
                ownershipWeight = HeapTraverseNode.RefWeight.SYNTHETIC;
            }
            if (parentNode.ownedByComponentMask == 0L) {
                ownershipWeight = HeapTraverseNode.RefWeight.NON_COMPONENT;
            }
            if ((currentNode = (HeapTraverseNode)objectIdToTraverseNode.get(objectId)) == null) {
                currentNode = new HeapTraverseNode(value2);
                currentNode.ownershipWeight = ownershipWeight;
                currentNode.ownedByComponentMask = parentNode.ownedByComponentMask;
                currentNode.retainedMask = parentNode.retainedMask;
                currentNode.retainedMaskForCategories = parentNode.retainedMaskForCategories;
                objectIdToTraverseNode.put(objectId, currentNode);
            }
            currentNode.retainedMask &= parentNode.retainedMask;
            currentNode.retainedMaskForCategories &= parentNode.retainedMaskForCategories;
            if (ownershipWeight.compareTo(currentNode.ownershipWeight) > 0) {
                currentNode.ownershipWeight = ownershipWeight;
                currentNode.ownedByComponentMask = parentNode.ownedByComponentMask;
            } else if (ownershipWeight.compareTo(currentNode.ownershipWeight) == 0) {
                currentNode.ownedByComponentMask |= parentNode.ownedByComponentMask;
            }
        }, fieldCache);
    }

    public void dispose() {
        this.watcher.stop();
        this.messageBusConnection.disconnect();
    }

    public static void collectAndWriteStats(@NotNull Consumer<String> writer2, @NotNull HeapSnapshotStatistics stats, @NotNull HeapSnapshotPresentationConfig presentationConfig) {
        long collectionStartTimestamp = System.nanoTime();
        new HeapSnapshotTraverse(stats).walkObjects(100000);
        stats.print(writer2, bytes2 -> HeapTraverseUtil.getObjectsStatsPresentation(bytes2, presentationConfig.sizePresentation), presentationConfig, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - collectionStartTimestamp));
    }

    public static MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode collectMemoryReport() {
        HeapSnapshotStatistics stats = new HeapSnapshotStatistics(ComponentsSet.buildComponentSet());
        long startTime = System.nanoTime();
        MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode = new HeapSnapshotTraverse(stats).walkObjects(100000);
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.MEMORY_USAGE_REPORT_EVENT).setMemoryUsageReportEvent(stats.buildMemoryUsageReportEvent(statusCode, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime), TimeUnit.NANOSECONDS.toMillis(startTime), ComponentsSet.getServerFlagConfiguration().getSharedComponentsLimit())));
        return statusCode;
    }

    private static short getNextIterationId() {
        ourIterationId = (short)(ourIterationId + 1);
        return ourIterationId;
    }

    private static native long getObjectTag(@NotNull Object var0);

    private static native void setObjectTag(@NotNull Object var0, long var1);

    private static native boolean canTagObjects();

    public static native Class<?>[] getClasses();

    private static native long getObjectSize(@NotNull Object var0);

    static native boolean isClassInitialized(@NotNull Class<?> var0);

    static native Object[] getClassStaticFieldsValues(@NotNull Class<?> var0);

    static class HeapSnapshotPresentationConfig {
        final SizePresentationStyle sizePresentation;
        final boolean shouldLogSharedClusters;
        final boolean shouldLogRetainedSizes;

        HeapSnapshotPresentationConfig(SizePresentationStyle sizePresentation, boolean shouldLogSharedClusters, boolean shouldLogRetainedSizes) {
            this.sizePresentation = sizePresentation;
            this.shouldLogSharedClusters = shouldLogSharedClusters;
            this.shouldLogRetainedSizes = shouldLogRetainedSizes;
        }

        static enum SizePresentationStyle {
            BYTES,
            OPTIMAL_UNITS;

        }
    }

    private static final class Node {
        private final int depth;
        @NotNull
        private final WeakReference<Object> objReference;
        private boolean referencesProcessed = false;

        private Node(@NotNull Object obj, int depth) {
            this.objReference = new WeakReference<Object>(obj);
            this.depth = depth;
        }

        @Nullable
        private Object getObject() {
            return this.objReference.get();
        }

        private int getDepth() {
            return this.depth;
        }
    }
}

