/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.ComponentsSet;
import com.android.tools.idea.diagnostics.heap.ExtendedReportStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverse;
import com.android.tools.idea.diagnostics.heap.HeapTraverseConfig;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.android.tools.idea.flags.StudioFlags;
import com.google.wireless.android.sdk.stats.MemoryUsageReportEvent;
import com.intellij.ide.PowerSaveMode;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HeapSnapshotStatistics {
    @NotNull
    private final ClusterObjectsStatistics.MemoryTrafficStatistics totalStats = new ClusterObjectsStatistics.MemoryTrafficStatistics();
    @NotNull
    private final List<ComponentClusterObjectsStatistics> componentStats = new ArrayList<ComponentClusterObjectsStatistics>();
    @NotNull
    private final List<CategoryClusterObjectsStatistics> categoryComponentStats = new ArrayList<CategoryClusterObjectsStatistics>();
    @NotNull
    private final Long2ObjectMap<SharedClusterStatistics> maskToSharedComponentStats = new Long2ObjectOpenHashMap();
    int maxFieldsCacheSize = 0;
    int maxObjectsQueueSize = 0;
    int enumeratedGarbageCollectedObjects = 0;
    int unsuccessfulFieldAccessCounter = 0;
    int heapObjectCount = 0;
    private short traverseSessionId;
    @NotNull
    private final HeapTraverseConfig config;
    @Nullable
    private final ExtendedReportStatistics extendedReportStatistics;

    public HeapSnapshotStatistics(@NotNull ComponentsSet componentsSet) {
        this(new HeapTraverseConfig(componentsSet, false));
    }

    public HeapSnapshotStatistics(@NotNull HeapTraverseConfig config2) {
        this.config = config2;
        for (ComponentsSet.Component component2 : config2.getComponentsSet().getComponents()) {
            this.componentStats.add(new ComponentClusterObjectsStatistics(component2));
        }
        for (ComponentsSet.ComponentCategory category : config2.getComponentsSet().getComponentsCategories()) {
            this.categoryComponentStats.add(new CategoryClusterObjectsStatistics(category));
        }
        this.extendedReportStatistics = config2.collectHistograms ? new ExtendedReportStatistics(config2) : null;
    }

    @NotNull
    public List<ComponentClusterObjectsStatistics> getComponentStats() {
        return this.componentStats;
    }

    @NotNull
    public List<CategoryClusterObjectsStatistics> getCategoryComponentStats() {
        return this.categoryComponentStats;
    }

    public void addObjectSizeToSharedComponent(long sharedMask, long size, short objectAge, String objectClassName) {
        if (!this.maskToSharedComponentStats.containsKey(sharedMask)) {
            this.maskToSharedComponentStats.put(sharedMask, (Object)new SharedClusterStatistics(sharedMask));
        }
        SharedClusterStatistics stats = (SharedClusterStatistics)this.maskToSharedComponentStats.get(sharedMask);
        stats.getStatistics().addObject(size, objectAge);
        if (this.config.collectHistograms && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addClassNameToSharedClusterHistogram(stats, objectClassName, size);
        }
    }

    public void addOwnedObjectSizeToComponent(int componentId, long size, short objectAge, String objectClassName) {
        ComponentClusterObjectsStatistics stats = this.componentStats.get(componentId);
        stats.addOwnedObject(size, objectAge);
        if (this.config.collectHistograms && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addClassNameToComponentOwnedHistogram(stats.getComponent(), objectClassName, size);
        }
    }

    public void addObjectToTotal(long size, short objectAge) {
        this.totalStats.addObject(size, objectAge);
    }

    public void addRetainedObjectSizeToCategoryComponent(int categoryId, long size, short objectAge) {
        this.categoryComponentStats.get(categoryId).addRetainedObject(size, objectAge);
    }

    public void addOwnedObjectSizeToCategoryComponent(int categoryId, long size, short objectAge, String objectClassName) {
        CategoryClusterObjectsStatistics stats = this.categoryComponentStats.get(categoryId);
        stats.addOwnedObject(size, objectAge);
        if (this.config.collectHistograms && this.extendedReportStatistics != null) {
            this.extendedReportStatistics.addClassNameToCategoryOwnedHistogram(stats.getComponentCategory(), objectClassName, size);
        }
    }

    public void addRetainedObjectSizeToComponent(int componentID, long size, short objectAge) {
        this.componentStats.get(componentID).addRetainedObject(size, objectAge);
    }

    void print(@NotNull Consumer<String> writer2, @NotNull Function<ObjectsStatistics, String> objectsStatsPresentation, @NotNull HeapSnapshotTraverse.HeapSnapshotPresentationConfig presentationConfig, long collectionTimeMs) {
        writer2.accept(String.format(Locale.US, "Total used memory: %s", objectsStatsPresentation.apply(this.totalStats.objectsStat)));
        ObjectsStatistics sharedObjectsStatistics = new ObjectsStatistics();
        this.maskToSharedComponentStats.values().forEach(e -> sharedObjectsStatistics.addStats(e.getStatistics().getObjectsStatistics()));
        writer2.accept(String.format(Locale.US, "Total shared memory: %s", objectsStatsPresentation.apply(sharedObjectsStatistics)));
        writer2.accept(String.format(Locale.US, "Report collection time: %d ms", collectionTimeMs));
        writer2.accept(String.format(Locale.US, "%d Categories:", this.categoryComponentStats.size()));
        for (CategoryClusterObjectsStatistics categoryClusterObjectsStatistics : this.categoryComponentStats) {
            writer2.accept(String.format(Locale.US, "  Category %s:", categoryClusterObjectsStatistics.getComponentCategory().getComponentCategoryLabel()));
            writer2.accept(String.format(Locale.US, "    Owned: %s", objectsStatsPresentation.apply(categoryClusterObjectsStatistics.getOwnedClusterStat().getObjectsStatistics())));
            if (this.config.collectHistograms && this.extendedReportStatistics != null) {
                this.extendedReportStatistics.logCategoryHistogram(writer2, categoryClusterObjectsStatistics.getComponentCategory());
            }
            if (!presentationConfig.shouldLogRetainedSizes) continue;
            writer2.accept(String.format(Locale.US, "    Retained: %s", objectsStatsPresentation.apply(categoryClusterObjectsStatistics.getRetainedClusterStat().getObjectsStatistics())));
        }
        writer2.accept(String.format(Locale.US, "%d Components:", this.componentStats.size()));
        for (ComponentClusterObjectsStatistics componentClusterObjectsStatistics : this.componentStats) {
            writer2.accept(String.format(Locale.US, "  Component %s:", componentClusterObjectsStatistics.getComponent().getComponentLabel()));
            writer2.accept(String.format(Locale.US, "    Owned: %s", objectsStatsPresentation.apply(componentClusterObjectsStatistics.getOwnedClusterStat().getObjectsStatistics())));
            if (this.config.collectHistograms && this.extendedReportStatistics != null) {
                this.extendedReportStatistics.logComponentHistogram(writer2, componentClusterObjectsStatistics.getComponent());
            }
            if (!presentationConfig.shouldLogRetainedSizes) continue;
            writer2.accept(String.format(Locale.US, "    Retained: %s", objectsStatsPresentation.apply(componentClusterObjectsStatistics.getRetainedClusterStat().getObjectsStatistics())));
        }
        if (presentationConfig.shouldLogSharedClusters) {
            writer2.accept("Shared clusters:");
            this.maskToSharedComponentStats.values().stream().sorted(Comparator.comparingLong(a -> -a.getStatistics().getObjectsStatistics().getTotalSizeInBytes())).limit(10L).forEach(s -> {
                writer2.accept(String.format(Locale.US, "  %s: %s", s.getComponentIds(this.config).stream().map(id2 -> this.componentStats.get((int)id2).getComponent().getComponentLabel()).collect(Collectors.toList()), objectsStatsPresentation.apply(s.getStatistics().getObjectsStatistics())));
                if (this.config.collectHistograms && this.extendedReportStatistics != null) {
                    this.extendedReportStatistics.logSharedClusterHistogram(writer2, (SharedClusterStatistics)s);
                }
            });
        }
    }

    public void updateMaxFieldsCacheSize(int currentFieldSize) {
        this.maxFieldsCacheSize = Math.max(this.maxFieldsCacheSize, currentFieldSize);
    }

    public void updateMaxObjectsQueueSize(int currentObjectsQueueSize) {
        this.maxObjectsQueueSize = Math.max(this.maxObjectsQueueSize, currentObjectsQueueSize);
    }

    public void incrementGarbageCollectedObjectsCounter() {
        ++this.enumeratedGarbageCollectedObjects;
    }

    public void incrementUnsuccessfulFieldAccessCounter() {
        ++this.unsuccessfulFieldAccessCounter;
    }

    public void setHeapObjectCount(int heapObjectCount) {
        this.heapObjectCount = heapObjectCount;
    }

    @NotNull
    private MemoryUsageReportEvent.ObjectsStatistics buildObjectStatistics(@NotNull ObjectsStatistics objectsStatistics) {
        return MemoryUsageReportEvent.ObjectsStatistics.newBuilder().setObjectsCount(objectsStatistics.getObjectsCount()).setTotalSizeBytes(objectsStatistics.getTotalSizeInBytes()).build();
    }

    @NotNull
    private MemoryUsageReportEvent.MemoryTrafficStatistics buildMemoryTrafficStatistics(@NotNull ClusterObjectsStatistics.MemoryTrafficStatistics memoryTrafficStatistics) {
        return MemoryUsageReportEvent.MemoryTrafficStatistics.newBuilder().setTotalStats(this.buildObjectStatistics(memoryTrafficStatistics.getObjectsStatistics())).setNewGenerationStats(this.buildObjectStatistics(memoryTrafficStatistics.getNewObjectsStatistics())).build();
    }

    @NotNull
    private MemoryUsageReportEvent.ClusterObjectsStatistics buildClusterObjectsStatistics(@NotNull ClusterObjectsStatistics componentStatistics) {
        return MemoryUsageReportEvent.ClusterObjectsStatistics.newBuilder().setOwnedClusterStats(this.buildMemoryTrafficStatistics(componentStatistics.getOwnedClusterStat())).setRetainedClusterStats(this.buildMemoryTrafficStatistics(componentStatistics.getRetainedClusterStat())).build();
    }

    @NotNull
    public MemoryUsageReportEvent buildMemoryUsageReportEvent(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode statusCode, long executionTimeMs, long executionStartMs, int sharedComponentsLimit) {
        MemoryUsageReportEvent.Builder builder2 = MemoryUsageReportEvent.newBuilder();
        for (ComponentClusterObjectsStatistics componentStat : this.componentStats) {
            builder2.addComponentStats(MemoryUsageReportEvent.ClusterMemoryUsage.newBuilder().setLabel(componentStat.getComponent().getComponentLabel()).setStats(this.buildClusterObjectsStatistics(componentStat)));
        }
        this.maskToSharedComponentStats.values().stream().sorted(Comparator.comparingLong(s -> -s.getStatistics().getObjectsStatistics().getTotalSizeInBytes())).limit(sharedComponentsLimit).forEach(s -> builder2.addSharedComponentStats(MemoryUsageReportEvent.SharedClusterMemoryUsage.newBuilder().addAllIds(s.getComponentIds(this.config)).setStats(this.buildMemoryTrafficStatistics(s.getStatistics()))));
        for (CategoryClusterObjectsStatistics categoryStat : this.categoryComponentStats) {
            builder2.addComponentCategoryStats(MemoryUsageReportEvent.ClusterMemoryUsage.newBuilder().setLabel(categoryStat.getComponentCategory().getComponentCategoryLabel()).setStats(this.buildClusterObjectsStatistics(categoryStat)));
        }
        builder2.setMetadata(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.newBuilder().setStatusCode(statusCode).setTotalHeapObjectsStats(this.buildMemoryTrafficStatistics(this.totalStats)).setFieldCacheCountPeak(this.maxFieldsCacheSize).setObjectQueueLengthPeak(this.maxObjectsQueueSize).setGarbageCollectedBefore2PassCount(this.enumeratedGarbageCollectedObjects).setCollectionTimeSeconds((double)executionTimeMs / 1000.0).setIsInPowerSaveMode(PowerSaveMode.isEnabled()).setUnsuccessfulFieldAccessesCount(this.unsuccessfulFieldAccessCounter).setCollectionStartTimestampSeconds((double)executionStartMs / 1000.0).setCollectionIteration((int)this.traverseSessionId));
        return builder2.build();
    }

    public void setTraverseSessionId(short traverseSessionId) {
        this.traverseSessionId = traverseSessionId;
    }

    @NotNull
    public HeapTraverseConfig getConfig() {
        return this.config;
    }

    @Nullable
    public ExtendedReportStatistics getExtendedReportStatistics() {
        return this.extendedReportStatistics;
    }

    static class ClusterObjectsStatistics {
        public static final int MAX_TRACKED_OBJECT_AGE = 4;
        @NotNull
        private final MemoryTrafficStatistics retainedClusterStat = new MemoryTrafficStatistics();
        @NotNull
        private final MemoryTrafficStatistics ownedClusterStat = new MemoryTrafficStatistics();

        ClusterObjectsStatistics() {
        }

        public void addOwnedObject(long size, short objectAge) {
            this.ownedClusterStat.addObject(size, objectAge);
        }

        public void addRetainedObject(long size, short objectAge) {
            this.retainedClusterStat.addObject(size, objectAge);
        }

        @NotNull
        public MemoryTrafficStatistics getOwnedClusterStat() {
            return this.ownedClusterStat;
        }

        @NotNull
        public MemoryTrafficStatistics getRetainedClusterStat() {
            return this.retainedClusterStat;
        }

        static class MemoryTrafficStatistics {
            @NotNull
            private final ObjectsStatistics objectsStat = new ObjectsStatistics();
            @NotNull
            private final ObjectsStatistics newObjectsStat = new ObjectsStatistics();
            @NotNull
            private final List<ObjectsStatistics> previousSnapshotsRemainedObjectsStats = IntStream.range(0, 4).mapToObj(x -> new ObjectsStatistics()).collect(Collectors.toList());

            MemoryTrafficStatistics() {
            }

            public void addObject(long size, short objectAge) {
                this.objectsStat.addObject(size);
                if (objectAge == 0) {
                    this.newObjectsStat.addObject(size);
                    return;
                }
                if (((Boolean)StudioFlags.MEMORY_TRAFFIC_TRACK_OLDER_GENERATIONS.get()).booleanValue()) {
                    if (objectAge >= 4) {
                        objectAge = (short)4;
                    }
                    this.previousSnapshotsRemainedObjectsStats.get(objectAge - 1).addObject(size);
                }
            }

            public ObjectsStatistics getObjectsStatistics() {
                return this.objectsStat;
            }

            public ObjectsStatistics getNewObjectsStatistics() {
                return this.newObjectsStat;
            }

            public List<ObjectsStatistics> getPreviousSnapshotsRemainedObjectsStatistics() {
                return this.previousSnapshotsRemainedObjectsStats;
            }
        }
    }

    static class CategoryClusterObjectsStatistics
    extends ClusterObjectsStatistics {
        @NotNull
        private final ComponentsSet.ComponentCategory componentCategory;

        private CategoryClusterObjectsStatistics(@NotNull ComponentsSet.ComponentCategory category) {
            this.componentCategory = category;
        }

        @NotNull
        ComponentsSet.ComponentCategory getComponentCategory() {
            return this.componentCategory;
        }
    }

    static class ComponentClusterObjectsStatistics
    extends ClusterObjectsStatistics {
        @NotNull
        private final ComponentsSet.Component component;

        private ComponentClusterObjectsStatistics(@NotNull ComponentsSet.Component component2) {
            this.component = component2;
        }

        @NotNull
        ComponentsSet.Component getComponent() {
            return this.component;
        }
    }

    static class SharedClusterStatistics {
        @NotNull
        private final ClusterObjectsStatistics.MemoryTrafficStatistics statistics;
        final long componentsMask;

        private SharedClusterStatistics(long componentsMask) {
            this.componentsMask = componentsMask;
            this.statistics = new ClusterObjectsStatistics.MemoryTrafficStatistics();
        }

        @NotNull
        private ClusterObjectsStatistics.MemoryTrafficStatistics getStatistics() {
            return this.statistics;
        }

        @NotNull
        Collection<Integer> getComponentIds(@NotNull HeapTraverseConfig config2) {
            ArrayList<Integer> components = new ArrayList<Integer>();
            HeapTraverseUtil.processMask(this.componentsMask, index2 -> components.add(config2.getComponentsSet().getComponents().get((int)index2).getId()));
            return components;
        }
    }
}

