/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverse;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverseException;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.google.common.collect.Sets;
import com.google.wireless.android.sdk.stats.MemoryUsageReportEvent;
import com.intellij.util.Function;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldCache {
    private static final int MAX_ALLOWED_CACHE_SIZE = 1000000;
    @NotNull
    private final Map<Class<?>, Field[]> instanceFieldsCache = new Object2ObjectOpenCustomHashMap(CanonicalObjectStrategy.INSTANCE);
    @NotNull
    private final HeapSnapshotStatistics statistics;
    private int cacheSize = 0;

    public FieldCache(@NotNull HeapSnapshotStatistics statistics) {
        this.statistics = statistics;
    }

    private Field[] getFieldsFromCacheOrUpdateCaches(@NotNull Class<?> aClass, @NotNull Map<Class<?>, Field[]> cache2, Function<Class<?>, List<Field>> getFields2) throws HeapSnapshotTraverseException {
        Field[] cached2 = cache2.get(aClass);
        if (cached2 != null) {
            return cached2;
        }
        try {
            List declaredFields = (List)getFields2.fun(aClass);
            HashSet fields = Sets.newHashSet();
            for (Field declaredField : declaredFields) {
                declaredField.setAccessible(true);
                Class<?> type = declaredField.getType();
                if (HeapTraverseUtil.isPrimitive(type)) continue;
                fields.add(declaredField);
            }
            Class<?> superclass = aClass.getSuperclass();
            if (superclass != null) {
                fields.addAll(Arrays.asList(this.getFieldsFromCacheOrUpdateCaches(superclass, cache2, getFields2)));
            }
            cache2.put(aClass, fields.isEmpty() ? ArrayUtils.EMPTY_FIELD_ARRAY : fields.toArray(new Field[0]));
            this.cacheSize += fields.size();
            this.statistics.updateMaxFieldsCacheSize(this.cacheSize);
            if (this.cacheSize > 1000000) {
                throw new HeapSnapshotTraverseException(MemoryUsageReportEvent.MemoryUsageCollectionMetadata.StatusCode.CLASS_FIELDS_CACHE_IS_TOO_BIG);
            }
        }
        catch (IncompatibleClassChangeError | NoClassDefFoundError | SecurityException | InaccessibleObjectException e) {
            cache2.put(aClass, ArrayUtils.EMPTY_FIELD_ARRAY);
        }
        return cache2.get(aClass);
    }

    public Field[] getInstanceFields(@NotNull Class<?> aClass) throws HeapSnapshotTraverseException {
        return this.getFieldsFromCacheOrUpdateCaches(aClass, this.instanceFieldsCache, c -> Arrays.stream(c.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).collect(Collectors.toList()));
    }

    public Object[] getStaticFields(@NotNull Class<?> aClass) {
        return HeapSnapshotTraverse.getClassStaticFieldsValues(aClass);
    }

    static final class CanonicalObjectStrategy<T>
    implements Hash.Strategy<T> {
        static final Hash.Strategy<Object> INSTANCE = new CanonicalObjectStrategy<Object>();

        CanonicalObjectStrategy() {
        }

        public int hashCode(@Nullable T o) {
            return Objects.hashCode(o);
        }

        public boolean equals(@Nullable T a, @Nullable T b) {
            return Objects.equals(a, b);
        }
    }
}

