/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.ComponentsSet;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverse;
import com.android.tools.idea.diagnostics.heap.HeapTraverseConfig;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ExtendedReportStatistics {
    @NotNull
    final List<ClassNameHistogram> componentHistograms = Lists.newArrayList();
    @NotNull
    final List<ClassNameHistogram> categoryHistograms = Lists.newArrayList();
    @NotNull
    final Long2ObjectMap<ClassNameHistogram> sharedClustersHistograms = new Long2ObjectOpenHashMap();

    public ExtendedReportStatistics(@NotNull HeapTraverseConfig config2) {
        int componentIndex = 0;
        for (ComponentsSet.Component component2 : config2.getComponentsSet().getComponents()) {
            this.componentHistograms.add(new ClassNameHistogram());
            assert (component2.getId() == componentIndex);
            ++componentIndex;
        }
        int componentCategoryIndex = 0;
        for (ComponentsSet.ComponentCategory componentCategory : config2.getComponentsSet().getComponentsCategories()) {
            this.categoryHistograms.add(new ClassNameHistogram());
            assert (componentCategory.getId() == componentCategoryIndex);
            ++componentCategoryIndex;
        }
    }

    void addClassNameToComponentOwnedHistogram(@NotNull ComponentsSet.Component component2, @NotNull String className, long size) {
        this.componentHistograms.get(component2.getId()).addObjectClassName(className, size);
    }

    void addClassNameToCategoryOwnedHistogram(@NotNull ComponentsSet.ComponentCategory componentCategory, @NotNull String className, long size) {
        this.categoryHistograms.get(componentCategory.getId()).addObjectClassName(className, size);
    }

    public void addClassNameToSharedClusterHistogram(@NotNull HeapSnapshotStatistics.SharedClusterStatistics sharedClusterStatistics, @NotNull String className, long size) {
        this.sharedClustersHistograms.putIfAbsent(sharedClusterStatistics.componentsMask, (Object)new ClassNameHistogram());
        ((ClassNameHistogram)this.sharedClustersHistograms.get(sharedClusterStatistics.componentsMask)).addObjectClassName(className, size);
    }

    public void logCategoryHistogram(@NotNull Consumer<String> writer2, @NotNull ComponentsSet.ComponentCategory componentCategory) {
        this.categoryHistograms.get(componentCategory.getId()).print(writer2);
    }

    public void logComponentHistogram(@NotNull Consumer<String> writer2, @NotNull ComponentsSet.Component component2) {
        this.componentHistograms.get(component2.getId()).print(writer2);
    }

    public void logSharedClusterHistogram(@NotNull Consumer<String> writer2, @NotNull HeapSnapshotStatistics.SharedClusterStatistics sharedClusterStatistics) {
        ((ClassNameHistogram)this.sharedClustersHistograms.get(sharedClusterStatistics.componentsMask)).print(writer2);
    }

    static class ClassNameHistogram {
        private static final int HISTOGRAM_PRINT_LIMIT = 20;
        @NotNull
        final Map<String, ObjectsStatistics> histogram = Maps.newHashMap();

        ClassNameHistogram() {
        }

        public void addObjectClassName(@NotNull String className, long size) {
            this.histogram.putIfAbsent(className, new ObjectsStatistics());
            this.histogram.get(className).addObject(size);
        }

        private boolean classNameIsStudioSource(@NotNull String className) {
            return className.startsWith("com.android.") || !className.startsWith("org.jetbrains") || !className.startsWith("com.intellij") || !className.startsWith("com.jetbrains");
        }

        public void print(Consumer<String> writer2) {
            writer2.accept("      Histogram:");
            this.histogram.entrySet().stream().sorted(Comparator.comparingLong(a -> ((ObjectsStatistics)a.getValue()).getTotalSizeInBytes()).reversed()).limit(20L).forEach(e -> writer2.accept(String.format(Locale.US, "        %s: %s", HeapTraverseUtil.getObjectsStatsPresentation((ObjectsStatistics)e.getValue(), HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle.OPTIMAL_UNITS), e.getKey())));
            writer2.accept("      Studio objects histogram:");
            this.histogram.entrySet().stream().filter(e -> this.classNameIsStudioSource((String)e.getKey())).sorted(Comparator.comparingLong(a -> ((ObjectsStatistics)a.getValue()).getTotalSizeInBytes()).reversed()).limit(20L).forEach(e -> writer2.accept(String.format(Locale.US, "        %s: %s", HeapTraverseUtil.getObjectsStatsPresentation((ObjectsStatistics)e.getValue(), HeapSnapshotTraverse.HeapSnapshotPresentationConfig.SizePresentationStyle.OPTIMAL_UNITS), e.getKey())));
        }
    }
}

