/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.MemoryUsageComponent;
import com.android.tools.idea.serverflags.protos.MemoryUsageComponentCategory;
import com.android.tools.idea.serverflags.protos.MemoryUsageReportConfiguration;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentsSet {
    private static final Logger LOG = Logger.getInstance(ComponentsSet.class);
    public static final String MEMORY_USAGE_REPORTING_SERVER_FLAG_NAME = "diagnostics/memory_usage_reporting";
    private static final String INTEGRATION_TEST_CONFIG_RESOURCE_NAME = "/diagnostics/integration_test_memory_usage_config.textproto";
    static final String UNCATEGORIZED_CATEGORY_LABEL = "android:uncategorized";
    static final String UNCATEGORIZED_COMPONENT_LABEL = "uncategorized_main";
    @NotNull
    private final Component uncategorizedComponent;
    @NotNull
    private final List<Component> components;
    @NotNull
    private final List<ComponentCategory> componentCategories;
    @NotNull
    private final Map<String, Component> classNameToComponent;
    @NotNull
    private final Map<String, Component> packageNameToComponentCache = Maps.newHashMap();

    ComponentsSet() {
        this.classNameToComponent = Maps.newHashMap();
        this.components = new ArrayList<Component>();
        this.componentCategories = new ArrayList<ComponentCategory>();
        this.uncategorizedComponent = this.registerComponent(UNCATEGORIZED_COMPONENT_LABEL, this.registerCategory(UNCATEGORIZED_CATEGORY_LABEL));
    }

    @NotNull
    public static MemoryUsageReportConfiguration getServerFlagConfiguration() {
        return ServerFlagService.Companion.getInstance().getProto(MEMORY_USAGE_REPORTING_SERVER_FLAG_NAME, MemoryUsageReportConfiguration.getDefaultInstance());
    }

    @NotNull
    public static MemoryUsageReportConfiguration getIntegrationTestConfiguration() {
        MemoryUsageReportConfiguration.Builder builder2 = MemoryUsageReportConfiguration.newBuilder();
        try {
            TextFormat.merge((CharSequence)Resources.toString((URL)Resources.getResource(ComponentsSet.class, (String)INTEGRATION_TEST_CONFIG_RESOURCE_NAME), (Charset)StandardCharsets.UTF_8), (Message.Builder)builder2);
        }
        catch (IOException e) {
            LOG.error("Failed to read memory usage components configuration", (Throwable)e);
        }
        return builder2.build();
    }

    @NotNull
    public List<ComponentCategory> getComponentsCategories() {
        return this.componentCategories;
    }

    @NotNull
    public Component getUncategorizedComponent() {
        return this.uncategorizedComponent;
    }

    @NotNull
    public List<Component> getComponents() {
        return this.components;
    }

    @NotNull
    Component registerComponent(@NotNull String componentLabel, @NotNull ComponentCategory category) {
        Component component2 = new Component(componentLabel, this.components.size(), category);
        this.components.add(component2);
        return component2;
    }

    ComponentCategory registerCategory(@NotNull String componentCategoryLabel) {
        ComponentCategory category = new ComponentCategory(componentCategoryLabel, this.componentCategories.size());
        this.componentCategories.add(category);
        return category;
    }

    void addComponentWithPackagesAndClassNames(@NotNull String componentLabel, @NotNull ComponentCategory componentCategory, @NotNull List<String> packageNames, @NotNull List<String> classNames) {
        Component newComponent = this.registerComponent(componentLabel, componentCategory);
        for (String name : classNames) {
            this.classNameToComponent.put(name, newComponent);
        }
        for (String name : packageNames) {
            this.packageNameToComponentCache.put(name, newComponent);
        }
    }

    @Nullable
    public Component getComponentOfObject(@NotNull Object obj) {
        return obj instanceof Class ? this.getClassComponent((Class)obj) : this.getObjectComponent(obj);
    }

    @Nullable
    private Component getObjectComponent(@NotNull Object obj) {
        return this.getClassComponent(obj.getClass());
    }

    @Nullable
    private Component getClassComponent(@NotNull Class<?> aClass) {
        String objClassName = aClass.getName();
        if (this.classNameToComponent.containsKey(objClassName)) {
            return this.classNameToComponent.get(objClassName);
        }
        String packageName2 = aClass.getPackageName();
        int lastDot = packageName2.length();
        String packageNamePrefix = packageName2;
        do {
            if (!this.packageNameToComponentCache.containsKey(packageNamePrefix = packageNamePrefix.substring(0, lastDot))) continue;
            Component ans = this.packageNameToComponentCache.get(packageNamePrefix);
            this.packageNameToComponentCache.put(packageName2, ans);
            return ans;
        } while ((lastDot = packageNamePrefix.lastIndexOf(46)) > 0);
        this.packageNameToComponentCache.put(packageName2, null);
        return null;
    }

    private static ComponentsSet buildComponentSetFromConfiguration(MemoryUsageReportConfiguration configuration) {
        int i;
        ComponentsSet components = new ComponentsSet();
        for (MemoryUsageComponentCategory protoCategory : configuration.getCategoriesList()) {
            ComponentCategory category = components.registerCategory(protoCategory.getLabel());
            for (MemoryUsageComponent component2 : protoCategory.getComponentsList()) {
                components.addComponentWithPackagesAndClassNames(component2.getLabel(), category, (List<String>)component2.getPackageNamesList(), (List<String>)component2.getClassNamesList());
            }
        }
        for (i = 0; i < components.getComponents().size(); ++i) {
            assert (components.getComponents().get(i).getId() == i);
        }
        for (i = 0; i < components.getComponentsCategories().size(); ++i) {
            assert (components.getComponentsCategories().get(i).getId() == i);
        }
        return components;
    }

    @NotNull
    public static ComponentsSet buildComponentSet() {
        return ComponentsSet.buildComponentSetFromConfiguration(ComponentsSet.getServerFlagConfiguration());
    }

    @NotNull
    public static ComponentsSet buildComponentSetForIntegrationTesting() {
        return ComponentsSet.buildComponentSetFromConfiguration(ComponentsSet.getIntegrationTestConfiguration());
    }

    public static final class ComponentCategory {
        private final int id;
        @NotNull
        private final String label;

        private ComponentCategory(@NotNull String label, int id2) {
            this.label = label;
            this.id = id2;
        }

        @NotNull
        public String getComponentCategoryLabel() {
            return this.label;
        }

        public int getId() {
            return this.id;
        }
    }

    public static final class Component {
        private final int id;
        @NotNull
        private final String componentLabel;
        @NotNull
        private final ComponentCategory componentCategory;

        private Component(@NotNull String componentLabel, int id2, @NotNull ComponentCategory category) {
            this.componentLabel = componentLabel;
            this.id = id2;
            this.componentCategory = category;
        }

        @NotNull
        public ComponentCategory getComponentCategory() {
            return this.componentCategory;
        }

        @NotNull
        public String getComponentLabel() {
            return this.componentLabel;
        }

        public int getId() {
            return this.id;
        }
    }
}

