/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.crash.StudioCrashReport;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.android.tools.idea.diagnostics.error.ErrorReportCustomizer;
import com.android.tools.idea.diagnostics.error.SubmitCrashReportTask;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.ReportMessages;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.idea.IdeaLogger;
import com.intellij.internal.statistic.analytics.StudioCrashDetails;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.android.diagnostics.error.ErrorBean;
import org.jetbrains.android.diagnostics.error.IdeaITNProxy;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ErrorReporter
extends ErrorReportSubmitter {
    private static final String FEEDBACK_TASK_TITLE = "Submitting error report";

    @NotNull
    public String getReportActionText() {
        return AndroidBundle.message("error.report.to.google.action", new Object[0]);
    }

    public boolean submit(@NotNull IdeaLoggingEvent[] events, String description2, Component parentComponent, @NotNull Consumer<? super SubmittedReportInfo> callback) {
        IdeaLoggingEvent event = events[0];
        ErrorBean bean = new ErrorBean(event.getThrowable(), IdeaLogger.ourLastActionId);
        bean.setDescription(description2);
        bean.setMessage(event.getMessage());
        IdeaPluginDescriptor plugin = IdeErrorsDialog.getPlugin((IdeaLoggingEvent)event);
        if (plugin != null && (!plugin.isBundled() || plugin.allowBundledUpdate())) {
            bean.setPluginName(plugin.getName());
            bean.setPluginVersion(plugin.getVersion());
        }
        Object data2 = event.getData();
        if (ErrorReporter.handleAnalyticsReports(event.getThrowable(), data2)) {
            return true;
        }
        if (data2 instanceof AbstractMessage) {
            bean.setAttachments(((AbstractMessage)data2).getIncludedAttachments());
        }
        java.util.function.Consumer<DataContext> submitter = dataContext -> {
            Task.Backgroundable feedbackTask;
            if (dataContext == null) {
                return;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            Consumer successCallback = token -> {
                SubmittedReportInfo reportInfo = new SubmittedReportInfo(null, "Issue " + token, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
                callback.consume((Object)reportInfo);
                ReportMessages.GROUP.createNotification("Report Submitted", NotificationType.INFORMATION).setImportant(false).notify(project);
            };
            Consumer errorCallback = e -> {
                String message2 = AndroidBundle.message("error.report.at.b.android", e.getMessage());
                ReportMessages.GROUP.createNotification(message2, NotificationType.ERROR).setListener(NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(project);
            };
            if (data2 instanceof ErrorReportCustomizer) {
                feedbackTask = ((ErrorReportCustomizer)data2).makeReportingTask(project, FEEDBACK_TASK_TITLE, true, bean, (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback);
            } else {
                List<Pair<String, String>> kv = IdeaITNProxy.getKeyValuePairs(null, null, bean, ApplicationManager.getApplication(), (ApplicationInfoEx)ApplicationInfo.getInstance(), ApplicationNamesInfo.getInstance(), UpdateSettings.getInstance());
                feedbackTask = new SubmitCrashReportTask(project, FEEDBACK_TASK_TITLE, true, event.getThrowable(), ErrorReporter.pair2map(kv), (Consumer<String>)successCallback, (Consumer<Exception>)errorCallback);
            }
            if (project == null) {
                feedbackTask.run((ProgressIndicator)new EmptyProgressIndicator());
            } else {
                ProgressManager.getInstance().run((Task)feedbackTask);
            }
        };
        if (parentComponent != null) {
            submitter.accept(DataManager.getInstance().getDataContext(parentComponent));
        } else {
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(submitter);
        }
        return true;
    }

    private static boolean handleAnalyticsReports(Throwable t, Object data2) {
        if (!(data2 instanceof Map)) {
            return false;
        }
        Map map2 = (Map)data2;
        String type = (String)map2.get("Type");
        if ("Exception".equals(type)) {
            ImmutableMap productData = ImmutableMap.of((Object)"md5", (Object)((String)map2.get("md5")), (Object)"summary", (Object)((String)map2.get("summary")));
            StudioExceptionReport exceptionReport = ((StudioExceptionReport.Builder)new StudioExceptionReport.Builder().setThrowable(t, false, true).addProductData((Map)productData)).build();
            StudioCrashReporter.getInstance().submit(exceptionReport);
        } else if ("Crashes".equals(type)) {
            Optional<StudioCrashDetails> jvmCrashOptional;
            List crashDetails = (List)map2.get("crashDetails");
            List descriptions = ContainerUtil.map((Collection)crashDetails, details -> details.getDescription());
            boolean isJvmCrash = crashDetails.stream().anyMatch(details -> details.isJvmCrash());
            long uptimeInMs = crashDetails.stream().mapToLong(details -> details.getUptimeInMs()).min().orElse(-1L);
            StudioCrashReport.Builder reportBuilder = new StudioCrashReport.Builder().setDescriptions(descriptions).setIsJvmCrash(isJvmCrash).setUptimeInMs(uptimeInMs);
            if (isJvmCrash && (jvmCrashOptional = crashDetails.stream().filter(details -> details.isJvmCrash()).findAny()).isPresent()) {
                StudioCrashDetails jvmCrash = jvmCrashOptional.get();
                reportBuilder.setErrorSignal(jvmCrash.getErrorSignal());
                reportBuilder.setErrorFrame(jvmCrash.getErrorFrame());
                reportBuilder.setErrorThread(jvmCrash.getErrorThread());
                reportBuilder.setNativeStack(jvmCrash.getNativeStack());
            }
            StudioCrashReport report2 = reportBuilder.build();
            StudioCrashReporter.getInstance().submit(report2, true);
        }
        return true;
    }

    @NotNull
    private static Map<String, String> pair2map(@NotNull List<Pair<String, String>> kv) {
        HashMap m = Maps.newHashMapWithExpectedSize((int)kv.size());
        for (Pair<String, String> i : kv) {
            m.put((String)i.getFirst(), (String)i.getSecond());
        }
        return m;
    }
}

