/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.util.ListenerCollection;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@Service
public final class LastActionTracker {
    private final ListenerCollection<Listener> myListeners = ListenerCollection.createWithDirectExecutor();
    private String myCurrentActionId = "(no action)";
    private long myCurrentActionStartNano;

    public static LastActionTracker getInstance() {
        return (LastActionTracker)ApplicationManager.getApplication().getService(LastActionTracker.class);
    }

    private LastActionTracker() {
    }

    public void registerActionDurationListener(Listener listener2) {
        this.myListeners.add((Object)listener2);
    }

    public String getCurrentActionId() {
        return this.myCurrentActionId;
    }

    public long getCurrentDurationMs() {
        if (this.myCurrentActionStartNano != 0L) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.myCurrentActionStartNano);
        }
        return 0L;
    }

    public void unregisterActionDurationListener(Listener listener2) {
        this.myListeners.remove((Object)listener2);
    }

    private static String getActionId(AnAction action2) {
        if (action2 == null) {
            return "<null>";
        }
        return action2.getClass().getName() + " (" + ActionManager.getInstance().getId(action2) + ")";
    }

    public static interface Listener {
        public void actionStarted(String var1);

        public void actionFinished(String var1, long var2);
    }

    public static class MyActionListener
    implements AnActionListener {
        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            String actionId;
            LastActionTracker tracker = LastActionTracker.getInstance();
            tracker.myCurrentActionId = actionId = LastActionTracker.getActionId(action2);
            tracker.myCurrentActionStartNano = System.nanoTime();
            tracker.myListeners.forEach(l -> l.actionStarted(actionId));
        }

        public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
            LastActionTracker tracker = LastActionTracker.getInstance();
            String actionId = LastActionTracker.getActionId(action2);
            tracker.myListeners.forEach(l -> l.actionFinished(actionId, tracker.getCurrentDurationMs()));
            tracker.myCurrentActionId = "(no action)";
            tracker.myCurrentActionStartNano = 0L;
        }
    }
}

