/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.HistogramUtil;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.ExceptionRegistry;
import com.android.tools.idea.diagnostics.HProfDatabase;
import com.android.tools.idea.diagnostics.StackTrace;
import com.android.tools.idea.diagnostics.StudioReportDatabase;
import com.android.tools.idea.diagnostics.ThreadSamplingReport;
import com.android.tools.idea.diagnostics.crash.ExceptionDataCollection;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.crash.UploadFields;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverseService;
import com.android.tools.idea.diagnostics.hprof.action.AnalysisRunnable;
import com.android.tools.idea.diagnostics.hprof.action.HeapDumpSnapshotRunnable;
import com.android.tools.idea.diagnostics.jfr.RecordingManager;
import com.android.tools.idea.diagnostics.jfr.reports.ReportTypesKt;
import com.android.tools.idea.diagnostics.kotlin.KotlinPerfCounters;
import com.android.tools.idea.diagnostics.report.DiagnosticReport;
import com.android.tools.idea.diagnostics.report.HistogramReport;
import com.android.tools.idea.diagnostics.report.MemoryReportReason;
import com.android.tools.idea.diagnostics.report.PerformanceThreadDumpReport;
import com.android.tools.idea.diagnostics.report.UnanalyzedHeapReport;
import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.MemoryUsageReportConfiguration;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GcPauseInfo;
import com.google.wireless.android.sdk.stats.StudioCrash;
import com.google.wireless.android.sdk.stats.StudioExceptionDetails;
import com.google.wireless.android.sdk.stats.StudioPerformanceStats;
import com.google.wireless.android.sdk.stats.UIActionStats;
import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.AndroidStudioSystemHealthMonitorAdapter;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CopyAction;
import com.intellij.ide.actions.CutAction;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.ide.actions.NextOccurenceAction;
import com.intellij.ide.actions.PasteAction;
import com.intellij.ide.actions.PreviousOccurenceAction;
import com.intellij.ide.actions.SaveAllAction;
import com.intellij.ide.actions.UndoRedoAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.analytics.StudioCrashDetails;
import com.intellij.internal.statistic.analytics.StudioCrashDetection;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.NotificationFullContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.HdrHistogram.SingleWriterRecorder;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import sun.tools.attach.HotSpotVirtualMachine;

@Service
public final class AndroidStudioSystemHealthMonitor {
    private static final Logger LOG = Logger.getInstance(AndroidStudioSystemHealthMonitor.class);
    public static final String STUDIO_RUN_UNDER_INTEGRATION_TEST_KEY = "studio.run.under.integration.test";
    private final NotificationGroup myGroup = NotificationGroup.findRegisteredGroup((String)"System Health");
    public static final AtomicLong ourStudioActionCount = new AtomicLong(0L);
    private static final String STUDIO_ACTIVITY_COUNT = "studio.activity.count";
    private static final AtomicLong ourStudioExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourInitialPersistedExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourBundledPluginsExceptionCount = new AtomicLong(0L);
    private static final AtomicLong ourNonBundledPluginsExceptionCount = new AtomicLong(0L);
    private static final Object EXCEPTION_COUNT_LOCK = new Object();
    @NonNls
    private static final String STUDIO_EXCEPTION_COUNT_FILE = "studio.exc";
    @NonNls
    private static final String BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE = "studio.exb";
    @NonNls
    private static final String NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE = "studio.exp";
    private static final int MAX_PERFORMANCE_REPORTS_COUNT = Integer.getInteger("studio.diagnostic.performanceThreadDump.maxReports", 0);
    private static final int MAX_HISTOGRAM_REPORTS_COUNT = Integer.getInteger("studio.diagnostic.histogram.maxReports", 10);
    private static final int MAX_FREEZE_REPORTS_COUNT = Integer.getInteger("studio.diagnostic.freeze.maxReports", ApplicationManager.getApplication().isEAP() ? 20 : 1);
    private static final int MAX_JFR_REPORTS_COUNT = Integer.getInteger("studio.diagnostic.jfr.maxReports", ApplicationManager.getApplication().isEAP() ? 20 : 1);
    private static final ConcurrentMap<GcPauseInfo.GcType, SingleWriterRecorder> myGcPauseInfo = new ConcurrentHashMap<GcPauseInfo.GcType, SingleWriterRecorder>();
    private static final long MAX_GC_PAUSE_TIME_MS = 1800000L;
    private static final long TOO_MANY_EXCEPTIONS_THRESHOLD = 10000L;
    private final StudioReportDatabase myReportsDatabase;
    public static final HProfDatabase ourHProfDatabase = new HProfDatabase(Paths.get(PathManager.getTempPath(), new String[0]));
    private static final Object ACTION_INVOCATIONS_LOCK = new Object();
    private static final Lock REPORT_EXCEPTIONS_LOCK = new ReentrantLock();
    private static Map<String, Multiset<UIActionStats.InvocationKind>> ourActionInvocations = new HashMap<String, Multiset<UIActionStats.InvocationKind>>();
    private final PropertiesComponent myProperties;
    private AndroidStudioSystemHealthMonitorAdapter.EventsListener myListener;
    private boolean myTooManyExceptionsPromptShown = false;
    private static long ourCurrentSessionStudioExceptionCount = 0L;
    public static final long MEMORY_FREED_THRESHOLD_FOR_HEAP_REPORT = 100000000L;
    public static final long FREE_MEMORY_THRESHOLD_FOR_HEAP_REPORT = 300000000L;
    private final ExceptionDataCollection myExceptionDataCollection = ExceptionDataCollection.getInstance();
    private final Lock lowMemoryDetectedLock = new ReentrantLock();
    private boolean memoryReportCreated = false;
    private AtomicBoolean ourOomOccurred = new AtomicBoolean(false);
    private static final int INITIAL_DELAY_MINUTES = 1;
    private static final int INTERVAL_IN_MINUTES = 30;

    public AndroidStudioSystemHealthMonitor() {
        this(new StudioReportDatabase(new File(PathManager.getTempPath(), "reports.dmp")));
    }

    public AndroidStudioSystemHealthMonitor(StudioReportDatabase studioReportDatabase) {
        this.myProperties = PropertiesComponent.getInstance();
        this.myReportsDatabase = studioReportDatabase;
    }

    public void addHeapReportToDatabase(@NotNull UnanalyzedHeapReport report2) {
        try {
            this.myReportsDatabase.appendReport(report2);
        }
        catch (IOException e) {
            LOG.warn("Exception when adding heap report to database", (Throwable)e);
        }
    }

    public boolean hasPendingHeapReport() throws IOException {
        return this.myReportsDatabase.getReports().stream().anyMatch(r -> r instanceof UnanalyzedHeapReport);
    }

    @NotNull
    public static AndroidStudioSystemHealthMonitor getInstance() {
        return (AndroidStudioSystemHealthMonitor)ApplicationManager.getApplication().getService(AndroidStudioSystemHealthMonitor.class);
    }

    public static Integer getMaxHistogramReportsCount() {
        return MAX_HISTOGRAM_REPORTS_COUNT;
    }

    public static Integer getMaxPerformanceReportsCount() {
        return MAX_PERFORMANCE_REPORTS_COUNT;
    }

    public static Integer getMaxFreezeReportsCount() {
        return MAX_FREEZE_REPORTS_COUNT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long freeUpMemory() {
        long usedMemoryBefore = AndroidStudioSystemHealthMonitor.getUsedMemory();
        ArrayList<byte[]> list2 = new ArrayList<byte[]>();
        try {
            try {
                while (true) {
                    list2.add(new byte[0x7FFFFFFD]);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                list2.clear();
                list2 = null;
                System.gc();
            }
        }
        catch (Throwable throwable) {
            list2.clear();
            list2 = null;
            System.gc();
            throw throwable;
        }
        long usedMemoryAfter = AndroidStudioSystemHealthMonitor.getUsedMemory();
        return usedMemoryAfter > usedMemoryBefore ? 0L : usedMemoryBefore - usedMemoryAfter;
    }

    private static long getUsedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    private static long getFreeMemory() {
        return Runtime.getRuntime().maxMemory() - AndroidStudioSystemHealthMonitor.getUsedMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lowMemoryDetected(MemoryReportReason reason) {
        if (!this.lowMemoryDetectedLock.tryLock()) {
            return false;
        }
        try {
            if (reason != MemoryReportReason.OutOfMemory) {
                long freeMemory = AndroidStudioSystemHealthMonitor.getFreeMemory();
                if (freeMemory >= 300000000L) {
                    boolean bl = false;
                    return bl;
                }
                long memoryFreed = AndroidStudioSystemHealthMonitor.freeUpMemory();
                LOG.warn("Forced clear of soft/weak references. Reason: " + reason + ", freed memory: " + memoryFreed / 1000000L + "MB");
                if (memoryFreed >= 100000000L) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (!this.memoryReportCreated) {
                this.memoryReportCreated = true;
                this.addHistogramToDatabase(reason, "LowMemoryWatcher");
                ApplicationManager.getApplication().invokeLater((Runnable)new HeapDumpSnapshotRunnable(reason, HeapDumpSnapshotRunnable.AnalysisOption.SCHEDULE_ON_NEXT_START));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lowMemoryDetectedLock.unlock();
        }
    }

    public void addHistogramToDatabase(MemoryReportReason reason, @Nullable String description2) {
        try {
            Path histogramDirPath = AndroidStudioSystemHealthMonitor.createHistogramPath();
            if (Files.exists(histogramDirPath, new LinkOption[0])) {
                LOG.info("Histogram path already exists: " + histogramDirPath.toString());
                return;
            }
            Files.createDirectories(histogramDirPath, new FileAttribute[0]);
            Path histogramFilePath = histogramDirPath.resolve("histogram.txt");
            Files.write(histogramFilePath, AndroidStudioSystemHealthMonitor.getHistogram().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
            Path threadDumpFilePath = histogramDirPath.resolve("threadDump.txt");
            FileUtil.writeToFile((File)threadDumpFilePath.toFile(), (String)ThreadDumper.dumpThreadsToString());
            this.myReportsDatabase.appendReport(new HistogramReport(threadDumpFilePath, histogramFilePath, reason, description2));
        }
        catch (IOException e) {
            LOG.info("Exception while creating histogram", (Throwable)e);
        }
    }

    private static Path createHistogramPath() {
        String datePart = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US).format(System.currentTimeMillis());
        String dirName = "threadDumps-histogram-" + datePart;
        return Paths.get(PathManager.getLogPath(), dirName);
    }

    private static long getMyPID() {
        String pidAndMachineName = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = pidAndMachineName.split("@");
        long pid = -1L;
        if (split.length == 2) {
            try {
                pid = Long.parseLong(split[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pid;
    }

    private static String getHistogram() throws UnsupportedOperationException {
        int i;
        StringBuilder sb = new StringBuilder();
        try {
            VirtualMachine vm = VirtualMachine.attach(Long.toString(AndroidStudioSystemHealthMonitor.getMyPID()));
            if (!(vm instanceof HotSpotVirtualMachine)) {
                throw new UnsupportedOperationException();
            }
            HotSpotVirtualMachine hotSpotVM = (HotSpotVirtualMachine)vm;
            char[] chars = new char[1024];
            try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(hotSpotVM.heapHisto("-live"), Charsets.UTF_8));){
                int read2;
                while ((read2 = reader2.read(chars)) != -1) {
                    sb.append(chars, 0, read2);
                }
            }
        }
        catch (AttachNotSupportedException | IOException e) {
            throw new UnsupportedOperationException(e);
        }
        String fullHistogram = sb.toString();
        String[] lines2 = fullHistogram.split("\r?\n");
        int TOP_LINES = 103;
        boolean BOTTOM_LINES = true;
        if (lines2.length <= 104) {
            return sb.toString();
        }
        sb.setLength(0);
        for (i = 0; i < 103; ++i) {
            sb.append(lines2[i]).append("\n");
        }
        sb.append("[...]\n");
        for (i = lines2.length - 1; i < lines2.length; ++i) {
            sb.append(lines2[i]).append("\n");
        }
        return sb.toString();
    }

    public static void recordGcPauseTime(String gcName, long durationMs) {
        GcPauseInfo.GcType gcType = AndroidStudioSystemHealthMonitor.getGcType(gcName);
        myGcPauseInfo.computeIfAbsent(gcType, unused -> new SingleWriterRecorder(1)).recordValue(Math.min(durationMs, 1800000L));
    }

    private static GcPauseInfo.GcType getGcType(String name) {
        switch (name) {
            case "Copy": {
                return GcPauseInfo.GcType.SERIAL_YOUNG;
            }
            case "MarkSweepCompact": {
                return GcPauseInfo.GcType.SERIAL_OLD;
            }
            case "PS Scavenge": {
                return GcPauseInfo.GcType.PARALLEL_YOUNG;
            }
            case "PS MarkSweep": {
                return GcPauseInfo.GcType.PARALLEL_OLD;
            }
            case "ParNew": {
                return GcPauseInfo.GcType.CMS_YOUNG;
            }
            case "ConcurrentMarkSweep": {
                return GcPauseInfo.GcType.CMS_OLD;
            }
            case "G1 Young Generation": {
                return GcPauseInfo.GcType.G1_YOUNG;
            }
            case "G1 Old Generation": {
                return GcPauseInfo.GcType.G1_OLD;
            }
        }
        return GcPauseInfo.GcType.UNKNOWN;
    }

    public void start() {
        assert (this.myGroup != null);
        Application application = ApplicationManager.getApplication();
        this.registerPlatformEventsListener();
        application.executeOnPooledThread(this::checkRuntime);
        if (Boolean.getBoolean(STUDIO_RUN_UNDER_INTEGRATION_TEST_KEY)) {
            HeapSnapshotTraverseService.getInstance().registerIntegrationTestCollectMemoryUsageStatisticsAction();
        }
        if (ServerFlagService.Companion.getInstance().getProtoOrNull("diagnostics/memory_usage_reporting", MemoryUsageReportConfiguration.getDefaultInstance()) != null && !ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            HeapSnapshotTraverseService.getInstance().addMemoryReportCollectionRequest();
        }
        List<DiagnosticReport> reports = this.myReportsDatabase.reapReports();
        AndroidStudioSystemHealthMonitor.processDiagnosticReports(reports);
        if (application.isInternal() || StatisticsUploadAssistant.isSendAllowed()) {
            this.initDataCollection();
        }
        if (application.isInternal()) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName beanName = new ObjectName("com.android.tools.idea.diagnostics.kotlin:type=KotlinPerfCounters");
                mBeanServer.registerMBean(new KotlinPerfCounters(), beanName);
            }
            catch (Exception ex) {
                LOG.debug((Throwable)ex);
            }
        }
    }

    private void initDataCollection() {
        Application application = ApplicationManager.getApplication();
        ourStudioActionCount.set(this.myProperties.getLong(STUDIO_ACTIVITY_COUNT, 0L) + 1L);
        ourStudioExceptionCount.set(AndroidStudioSystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE));
        ourInitialPersistedExceptionCount.set(ourStudioExceptionCount.get());
        ourBundledPluginsExceptionCount.set(AndroidStudioSystemHealthMonitor.getPersistedExceptionCount(BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE));
        ourNonBundledPluginsExceptionCount.set(AndroidStudioSystemHealthMonitor.getPersistedExceptionCount(NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE));
        StudioCrashDetection.updateRecordedVersionNumber((String)ApplicationInfo.getInstance().getStrictVersion());
        this.startActivityMonitoring();
        AndroidStudioSystemHealthMonitor.trackCrashes(StudioCrashDetection.reapCrashDescriptions());
        RecordingManager.init(this::tryAppendReportToDatabase);
        application.getMessageBus().connect((Disposable)application).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appClosing() {
                AndroidStudioSystemHealthMonitor.this.myProperties.setValue(AndroidStudioSystemHealthMonitor.STUDIO_ACTIVITY_COUNT, Long.toString(ourStudioActionCount.get()));
                StudioCrashDetection.stop();
                AndroidStudioSystemHealthMonitor.this.reportExceptionsAndActionInvocations();
            }
        });
        application.getMessageBus().connect((Disposable)application).subscribe(IdePerformanceListener.TOPIC, (Object)new IdePerformanceListener(){

            public void uiFreezeFinished(long durationMs, @Nullable File reportDir) {
                UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PERFORMANCE_STATS).setStudioPerformanceStats(StudioPerformanceStats.newBuilder().setUiFreezeTimeMs((int)durationMs)));
            }

            public void dumpedThreads(@NotNull File toFile, @NotNull ThreadDump dump2) {
                try {
                    AndroidStudioSystemHealthMonitor.this.myReportsDatabase.appendReport(new PerformanceThreadDumpReport(toFile.toPath(), "UIFreeze"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        ThreadSamplingReport.startCollectingThreadSamplingReports(this::tryAppendReportToDatabase);
    }

    private static List<Path> startHeapReportsAnalysis(List<UnanalyzedHeapReport> reports) {
        Project[] openedProjects;
        if (reports.isEmpty()) {
            return Collections.emptyList();
        }
        final UnanalyzedHeapReport report2 = reports.get(0);
        Path path2 = report2.getHprofPath();
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        Project[] projectArray = openedProjects = projectManager != null ? projectManager.getOpenProjects() : null;
        if (openedProjects != null && openedProjects.length > 0) {
            Project project = openedProjects[0];
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> new AnalysisRunnable(report2, true).run());
        } else {
            final MessageBusConnection connection2 = ApplicationManager.getApplication().getMessageBus().connect();
            final AtomicBoolean eventHandled = new AtomicBoolean(false);
            connection2.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectOpened(@NotNull Project project) {
                    if (eventHandled.getAndSet(true)) {
                        return;
                    }
                    connection2.disconnect();
                    StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> new AnalysisRunnable(report2, true).run());
                }
            });
            connection2.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                public void welcomeScreenDisplayed() {
                    if (eventHandled.getAndSet(true)) {
                        return;
                    }
                    connection2.disconnect();
                    new AnalysisRunnable(report2, true).run();
                }
            });
        }
        return Collections.singletonList(path2);
    }

    private boolean tryAppendReportToDatabase(DiagnosticReport report2) {
        try {
            this.myReportsDatabase.appendReport(report2);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    protected void registerPlatformEventsListener() {
        this.myListener = new AndroidStudioSystemHealthMonitorAdapter.EventsListener(){

            public void countActionInvocation(Class<? extends AnAction> aClass, Presentation presentation, AnActionEvent event) {
                AndroidStudioSystemHealthMonitor.countActionInvocation(aClass, presentation, event);
            }

            public boolean handleExceptionEvent(IdeaLoggingEvent event, VMOptions.MemoryKind memoryKind) {
                return AndroidStudioSystemHealthMonitor.this.handleExceptionEvent(event, memoryKind);
            }
        };
        AndroidStudioSystemHealthMonitorAdapter.registerEventsListener((AndroidStudioSystemHealthMonitorAdapter.EventsListener)this.myListener);
    }

    private boolean handleExceptionEvent(IdeaLoggingEvent event, VMOptions.MemoryKind kind) {
        Throwable t = event.getThrowable();
        if (this.myExceptionDataCollection.requiresConfirmation(t)) {
            UploadFields fields = this.myExceptionDataCollection.getExceptionUploadFields(event.getThrowable(), false, true);
            ArrayList attachments = new ArrayList();
            fields.getLogs().forEach((name, log) -> {
                Attachment attachment = new Attachment("log_" + name + ".log", log);
                attachment.setIncluded(true);
                attachments.add(attachment);
            });
            MessagePool.getInstance().addIdeFatalMessage(LogMessage.createEvent((Throwable)event.getThrowable(), (String)event.getMessage(), (Attachment[])attachments.toArray(new Attachment[0])));
            return true;
        }
        if (AnalyticsSettings.getOptedIn() && t != null && AndroidStudioSystemHealthMonitor.isReportableCrash(t)) {
            AndroidStudioSystemHealthMonitor.incrementAndSaveExceptionCount(t);
            ErrorReportSubmitter reporter = IdeErrorsDialog.getAndroidErrorReporter();
            if (reporter != null) {
                StackTrace stackTrace = ExceptionRegistry.INSTANCE.register(t);
                AndroidStudioExceptionEvent e = new AndroidStudioExceptionEvent(t.getMessage(), t, stackTrace);
                reporter.submit(new IdeaLoggingEvent[]{e}, null, null, info2 -> {});
            }
        }
        try {
            if (kind == null || !this.ourOomOccurred.getAndSet(true)) {
                // empty if block
            }
            boolean showUI2 = AndroidStudioSystemHealthMonitor.isIdeErrorsDialogReportableCrash(t) || ApplicationManager.getApplication().isInternal();
            return !showUI2;
        }
        catch (Throwable throwable) {
            LOG.warn("Exception while handling exception event", throwable);
            return false;
        }
    }

    private static boolean isIdeErrorsDialogReportableCrash(Throwable t) {
        for (int maxCauseDepth = 100; maxCauseDepth > 0 && t.getCause() != null; --maxCauseDepth) {
            t = t.getCause();
        }
        if (t.getCause() != null) {
            return true;
        }
        if (t instanceof OutOfMemoryError) {
            return true;
        }
        String className = t.getClass().getName();
        if (className != null) {
            if (className.equals("com.intellij.psi.PsiInvalidElementAccessException")) {
                return false;
            }
            if (className.equals("com.intellij.openapi.project.IndexNotReadyException")) {
                return false;
            }
            if (className.equals("com.intellij.openapi.util.TraceableDisposable.ObjectNotDisposedException")) {
                return false;
            }
            if (className.equals("com.intellij.openapi.util.TraceableDisposable$DisposalException")) {
                return false;
            }
            if (className.equals("com.intellij.openapi.wm.impl.FocusManagerImpl$1")) {
                return false;
            }
        }
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        Object firstFrame = "";
        Object lastFrame = "";
        if (stackTraceElements != null && stackTraceElements.length >= 1) {
            firstFrame = stackTraceElements[0].getClassName() + "#" + stackTraceElements[0].getMethodName();
            int lastIndex = stackTraceElements.length - 1;
            lastFrame = stackTraceElements[lastIndex].getClassName() + "#" + stackTraceElements[lastIndex].getMethodName();
        }
        if (((String)firstFrame).equals("com.intellij.openapi.diagnostic.Logger#error") && Objects.equals(t.getClass(), Throwable.class)) {
            return false;
        }
        return ((String)lastFrame).equals("java.awt.EventDispatchThread#run");
    }

    private static boolean isReportableCrash(@NotNull Throwable t) {
        String cls;
        return !(t instanceof ClassNotFoundException) || (cls = t.getMessage()) == null || !cls.startsWith("com.sun.jdi.");
    }

    private static void incrementAndSaveExceptionCount(@NotNull Throwable t) {
        AndroidStudioSystemHealthMonitor.incrementAndSaveExceptionCount();
        PluginId pluginId = PluginUtil.getInstance().findPluginId(t);
        if (pluginId != null) {
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)pluginId);
            if (plugin != null && plugin.isBundled()) {
                AndroidStudioSystemHealthMonitor.incrementAndSaveBundledPluginsExceptionCount();
            } else {
                AndroidStudioSystemHealthMonitor.incrementAndSaveNonBundledPluginsExceptionCount();
            }
        }
    }

    private void checkRuntime() {
        this.warnIfOpenJDK();
    }

    private void warnIfOpenJDK() {
        if (StringUtil.containsIgnoreCase((String)System.getProperty("java.vm.name", ""), (String)"OpenJDK") && !SystemInfo.isJetBrainsJvm && !SystemInfo.isStudioJvm) {
            this.showNotification("unsupported.jvm.openjdk.message", null, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportExceptionsAndActionInvocations() {
        if (!REPORT_EXCEPTIONS_LOCK.tryLock()) {
            return;
        }
        try {
            long activityCount = ourStudioActionCount.getAndSet(0L);
            long exceptionCount = ourStudioExceptionCount.getAndSet(0L);
            long bundledPluginExceptionCount = ourBundledPluginsExceptionCount.getAndSet(0L);
            long nonBundledPluginExceptionCount = ourNonBundledPluginsExceptionCount.getAndSet(0L);
            AndroidStudioSystemHealthMonitor.persistExceptionCount(0L, STUDIO_EXCEPTION_COUNT_FILE);
            AndroidStudioSystemHealthMonitor.persistExceptionCount(0L, BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
            AndroidStudioSystemHealthMonitor.persistExceptionCount(0L, NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
            ourCurrentSessionStudioExceptionCount += exceptionCount;
            if (ApplicationManager.getApplication().isInternal()) assert (AndroidStudioSystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE) < 5L);
            if (activityCount > 0L || exceptionCount > 0L) {
                List<StackTrace> traces = ExceptionRegistry.INSTANCE.getStackTraces(0);
                ExceptionRegistry.INSTANCE.clear();
                AndroidStudioSystemHealthMonitor.trackExceptionsAndActivity(activityCount, exceptionCount, bundledPluginExceptionCount, nonBundledPluginExceptionCount, 0L, traces);
            }
            if (!this.myTooManyExceptionsPromptShown && ourCurrentSessionStudioExceptionCount >= 10000L) {
                this.promptUnusuallyHighExceptionCount();
            }
            AndroidStudioSystemHealthMonitor.reportActionInvocations();
        }
        finally {
            REPORT_EXCEPTIONS_LOCK.unlock();
        }
    }

    private void promptUnusuallyHighExceptionCount() {
        this.myTooManyExceptionsPromptShown = true;
        AnAction sendFeedback = ActionManager.getInstance().getAction("SendFeedback");
        NotificationAction notificationAction = NotificationAction.create((String)AndroidBundle.message("sys.health.send.feedback", new Object[0]), (event, notification) -> sendFeedback.actionPerformed(event));
        this.showNotification("sys.health.too.many.exceptions", notificationAction, new Object[0]);
    }

    private static void processDiagnosticReports(@NotNull List<DiagnosticReport> reports) {
        if (AnalyticsSettings.getOptedIn()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                AndroidStudioSystemHealthMonitor.sendDiagnosticReportsOfTypeWithLimit("PerformanceThreadDump", reports, MAX_PERFORMANCE_REPORTS_COUNT);
                AndroidStudioSystemHealthMonitor.sendDiagnosticReportsOfTypeWithLimit("Histogram", reports, MAX_HISTOGRAM_REPORTS_COUNT);
                AndroidStudioSystemHealthMonitor.sendDiagnosticReportsOfTypeWithLimit("Freeze", reports, MAX_FREEZE_REPORTS_COUNT);
                for (String type : ReportTypesKt.getTypesToFields().keySet()) {
                    AndroidStudioSystemHealthMonitor.sendDiagnosticReportsOfTypeWithLimit(type, reports, MAX_JFR_REPORTS_COUNT);
                }
            });
        }
        AndroidStudioSystemHealthMonitor.processHeapReports(reports);
    }

    private static void processHeapReports(@NotNull List<DiagnosticReport> reports) {
        List<Path> hprofsToBeAnalyzed = AndroidStudioSystemHealthMonitor.startHeapReportsAnalysis(reports.stream().filter(r -> r.getType().equals("UnanalyzedHeap")).filter(r -> r instanceof UnanalyzedHeapReport).map(r -> (UnanalyzedHeapReport)r).collect(Collectors.toList()));
        ourHProfDatabase.cleanupHProfFiles(hprofsToBeAnalyzed);
    }

    private static void sendDiagnosticReportsOfTypeWithLimit(String type, @NotNull List<DiagnosticReport> reports, int maxCount) {
        List reportsOfType = reports.stream().filter(r -> r.getType().equals(type)).collect(Collectors.toList());
        if (!type.equals("Freeze")) {
            Collections.shuffle(reportsOfType);
        }
        int numReportsToSkip = reportsOfType.size() > maxCount ? reportsOfType.size() - maxCount : 0;
        reportsOfType.stream().skip(numReportsToSkip).forEach(AndroidStudioSystemHealthMonitor::sendDiagnosticReport);
    }

    public static void trackCrashes(@NotNull List<StudioCrashDetails> descriptions) {
        if (descriptions.isEmpty()) {
            return;
        }
        AndroidStudioSystemHealthMonitor.reportCrashes(descriptions);
        AndroidStudioSystemHealthMonitor.trackExceptionsAndActivity(0L, 0L, 0L, 0L, descriptions.size(), Collections.emptyList());
    }

    public static void trackExceptionsAndActivity(long activityCount, long exceptionCount, long bundledPluginExceptionCount, long nonBundledPluginExceptionCount, long fatalExceptionCount, @NotNull List<StackTrace> stackTraces) {
        if (!StatisticsUploadAssistant.isSendAllowed()) {
            return;
        }
        AndroidStudioEvent.Builder eventBuilder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PING).setKind(AndroidStudioEvent.EventKind.STUDIO_CRASH).setStudioCrash(StudioCrash.newBuilder().setActions(activityCount).setExceptions(exceptionCount).setBundledPluginExceptions(bundledPluginExceptionCount).setNonBundledPluginExceptions(nonBundledPluginExceptionCount).setCrashes(fatalExceptionCount));
        AndroidStudioSystemHealthMonitor.logUsageOnlyIfNotInternalApplication(eventBuilder);
        for (StackTrace stackTrace : stackTraces) {
            AndroidStudioEvent.Builder crashEventBuilder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PING).setKind(AndroidStudioEvent.EventKind.STUDIO_CRASH).setStudioCrash(StudioCrash.newBuilder().addDetails(StudioExceptionDetails.newBuilder().setHash(stackTrace.md5string()).setCount(stackTrace.getCount()).setSummary(stackTrace.summarize(20)).build()));
            AndroidStudioSystemHealthMonitor.logUsageOnlyIfNotInternalApplication(stackTrace.timeOfFirstHitMs(), crashEventBuilder);
        }
    }

    private static void logUsageOnlyIfNotInternalApplication(AndroidStudioEvent.Builder eventBuilder) {
        if (!ApplicationManager.getApplication().isInternal()) {
            UsageTracker.log((AndroidStudioEvent.Builder)eventBuilder);
        } else {
            LOG.debug("SystemHealthMonitor would send following analytics event in the release build: " + eventBuilder.build());
        }
    }

    private static void logUsageOnlyIfNotInternalApplication(long eventTimeMs, AndroidStudioEvent.Builder eventBuilder) {
        if (!ApplicationManager.getApplication().isInternal()) {
            UsageTracker.log((long)eventTimeMs, (AndroidStudioEvent.Builder)eventBuilder);
        } else {
            AndroidStudioSystemHealthMonitor.logUsageOnlyIfNotInternalApplication(eventBuilder);
        }
    }

    void showNotification(final @PropertyKey(resourceBundle="messages.AndroidBundle") @PropertyKey(resourceBundle="messages.AndroidBundle") String key, @Nullable NotificationAction action2, Object ... params2) {
        boolean ignored = this.myProperties.isValueSet("ignore." + key);
        LOG.info("issue detected: " + key + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        MyFullContentNotification notification = new MyFullContentNotification(AndroidBundle.message(key, params2));
        if (action2 != null) {
            notification.addAction((AnAction)action2);
        }
        notification.addAction((AnAction)new NotificationAction(IdeBundle.message((String)"sys.health.acknowledge.action", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                notification.expire();
                AndroidStudioSystemHealthMonitor.this.myProperties.setValue("ignore." + key, "true");
            }
        });
        notification.setImportant(true);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)notification));
    }

    static NotificationAction detailsAction(String url) {
        return new BrowseNotificationAction(IdeBundle.message((String)"sys.health.details", (Object[])new Object[0]), url);
    }

    private void startActivityMonitoring() {
        JobScheduler.getScheduler().scheduleWithFixedDelay(this::reportExceptionsAndActionInvocations, 1L, 30L, TimeUnit.MINUTES);
    }

    private static void incrementAndSaveExceptionCount() {
        AndroidStudioSystemHealthMonitor.persistExceptionCount(ourStudioExceptionCount.incrementAndGet(), STUDIO_EXCEPTION_COUNT_FILE);
        if (ApplicationManager.getApplication().isInternal()) assert (Math.abs(AndroidStudioSystemHealthMonitor.getPersistedExceptionCount(STUDIO_EXCEPTION_COUNT_FILE) - ourStudioExceptionCount.get()) < 5L);
    }

    private static void incrementAndSaveBundledPluginsExceptionCount() {
        AndroidStudioSystemHealthMonitor.persistExceptionCount(ourBundledPluginsExceptionCount.incrementAndGet(), BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
    }

    private static void incrementAndSaveNonBundledPluginsExceptionCount() {
        AndroidStudioSystemHealthMonitor.persistExceptionCount(ourNonBundledPluginsExceptionCount.incrementAndGet(), NON_BUNDLED_PLUGINS_EXCEPTION_COUNT_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persistExceptionCount(long count2, @NotNull String countFileName) {
        Object object = EXCEPTION_COUNT_LOCK;
        synchronized (object) {
            try {
                File f = new File(PathManager.getTempPath(), countFileName);
                com.google.common.io.Files.write((CharSequence)Long.toString(count2), (File)f, (Charset)Charsets.UTF_8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getPersistedExceptionCount(@NotNull String countFileName) {
        Object object = EXCEPTION_COUNT_LOCK;
        synchronized (object) {
            try {
                File f = new File(PathManager.getTempPath(), countFileName);
                String contents = com.google.common.io.Files.toString((File)f, (Charset)Charsets.UTF_8);
                return Long.parseLong(contents);
            }
            catch (Throwable t) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void countActionInvocation(@NotNull Class actionClass, @NotNull Presentation templatePresentation, @NotNull AnActionEvent event) {
        ourStudioActionCount.incrementAndGet();
        Object object = ACTION_INVOCATIONS_LOCK;
        synchronized (object) {
            String actionName = AndroidStudioSystemHealthMonitor.getActionName(actionClass, templatePresentation);
            UIActionStats.InvocationKind invocationKind = AndroidStudioSystemHealthMonitor.getInvocationKindFromEvent(event);
            if (AndroidStudioSystemHealthMonitor.shouldAggregate(actionClass)) {
                LinkedHashMultiset invocations = ourActionInvocations.get(actionName);
                if (invocations == null) {
                    invocations = LinkedHashMultiset.create();
                    ourActionInvocations.put(actionName, (Multiset<UIActionStats.InvocationKind>)invocations);
                }
                invocations.add((Object)invocationKind);
            } else {
                UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.STUDIO_UI).setKind(AndroidStudioEvent.EventKind.STUDIO_UI_ACTION_STATS).setUiActionStats(UIActionStats.newBuilder().setActionClassName(actionName).setInvocationKind(invocationKind).setInvocations(1L).setDirect(true).setUiPlace(event.getPlace())));
            }
        }
    }

    private static boolean shouldAggregate(Class actionClass) {
        return EditorAction.class.isAssignableFrom(actionClass) || UndoRedoAction.class.isAssignableFrom(actionClass) || PasteAction.class.isAssignableFrom(actionClass) || CopyAction.class.isAssignableFrom(actionClass) || CutAction.class.isAssignableFrom(actionClass) || SaveAllAction.class.isAssignableFrom(actionClass) || DeleteAction.class.isAssignableFrom(actionClass) || NextOccurenceAction.class.isAssignableFrom(actionClass) || PreviousOccurenceAction.class.isAssignableFrom(actionClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportActionInvocations() {
        Map<String, Multiset<UIActionStats.InvocationKind>> currentInvocations;
        Iterator<Map.Entry<String, Multiset<UIActionStats.InvocationKind>>> iterator2 = ACTION_INVOCATIONS_LOCK;
        synchronized (iterator2) {
            currentInvocations = ourActionInvocations;
            ourActionInvocations = new HashMap<String, Multiset<UIActionStats.InvocationKind>>();
        }
        for (Map.Entry<String, Multiset<UIActionStats.InvocationKind>> actionEntry : currentInvocations.entrySet()) {
            for (Multiset.Entry invocationEntry : actionEntry.getValue().entrySet()) {
                UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.STUDIO_UI).setKind(AndroidStudioEvent.EventKind.STUDIO_UI_ACTION_STATS).setUiActionStats(UIActionStats.newBuilder().setActionClassName(actionEntry.getKey()).setInvocationKind((UIActionStats.InvocationKind)invocationEntry.getElement()).setInvocations((long)invocationEntry.getCount())));
            }
        }
        StudioPerformanceStats.Builder statsProto = StudioPerformanceStats.newBuilder();
        for (Map.Entry gcEntry : myGcPauseInfo.entrySet()) {
            statsProto.addGcPauseInfo(GcPauseInfo.newBuilder().setCollectorType((GcPauseInfo.GcType)gcEntry.getKey()).setPauseTimesMs(HistogramUtil.toProto(((SingleWriterRecorder)gcEntry.getValue()).getIntervalHistogram())));
        }
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.STUDIO_UI).setKind(AndroidStudioEvent.EventKind.STUDIO_PERFORMANCE_STATS).setStudioPerformanceStats(statsProto));
    }

    private static UIActionStats.InvocationKind getInvocationKindFromEvent(AnActionEvent event) {
        if (event.getInputEvent() instanceof KeyEvent) {
            return UIActionStats.InvocationKind.KEYBOARD_SHORTCUT;
        }
        String place = event.getPlace();
        if (place.contains("Menu")) {
            return UIActionStats.InvocationKind.MENU;
        }
        if (place.contains("Toolbar")) {
            return UIActionStats.InvocationKind.TOOLBAR;
        }
        if (event.getInputEvent() instanceof MouseEvent) {
            return UIActionStats.InvocationKind.MOUSE;
        }
        return UIActionStats.InvocationKind.UNKNOWN_INVOCATION_KIND;
    }

    static String getActionName(@NotNull Class actionClass, @NotNull Presentation templatePresentation) {
        if (actionClass.isAnonymousClass()) {
            Class<?> enclosingClass = actionClass.getEnclosingClass();
            Class superClass = actionClass.getSuperclass();
            return String.format("%s@%s", AndroidStudioSystemHealthMonitor.metricsNameForClass(superClass), AndroidStudioSystemHealthMonitor.metricsNameForClass(enclosingClass));
        }
        Object actionName = AndroidStudioSystemHealthMonitor.metricsNameForClass(actionClass);
        if (((String)actionName).equals("ExecutorAction")) {
            actionName = (String)actionName + "#" + templatePresentation.getText();
        }
        return actionName;
    }

    private static String metricsNameForClass(Class cls) {
        String packageName2;
        Package classPackage = cls.getPackage();
        String string = packageName2 = classPackage != null ? classPackage.getName() : "";
        if (packageName2.startsWith("com.android.") || packageName2.startsWith("com.intellij.") || packageName2.startsWith("org.jetbrains.") || packageName2.startsWith("org.intellij.") || packageName2.startsWith("com.jetbrains.") || packageName2.startsWith("git4idea.")) {
            String actionName = cls.getSimpleName();
            for (Class<?> parentClass = cls.getEnclosingClass(); parentClass != null; parentClass = parentClass.getEnclosingClass()) {
                actionName = String.format("%s.%s", parentClass.getSimpleName(), actionName);
            }
            return actionName;
        }
        return cls.getCanonicalName();
    }

    private static void reportCrashes(@NotNull List<StudioCrashDetails> descriptions) {
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        ErrorReportSubmitter reporter = IdeErrorsDialog.getAndroidErrorReporter();
        if (reporter != null) {
            AndroidStudioCrashEvents e = new AndroidStudioCrashEvents(descriptions);
            reporter.submit(new IdeaLoggingEvent[]{e}, null, null, info2 -> {});
        }
    }

    private static void sendDiagnosticReport(@NotNull DiagnosticReport report2) {
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        try {
            StudioCrashReporter.getInstance().submit(report2.asCrashReport(), true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class AndroidStudioCrashEvents
    extends IdeaLoggingEvent {
        private List<StudioCrashDetails> myCrashDetails;

        public AndroidStudioCrashEvents(@NotNull List<StudioCrashDetails> crashDetails) {
            super("", null);
            this.myCrashDetails = crashDetails;
        }

        @Nullable
        public Object getData() {
            return ImmutableMap.of((Object)"Type", (Object)"Crashes", (Object)"crashDetails", this.myCrashDetails);
        }
    }

    private static class AndroidStudioExceptionEvent
    extends IdeaLoggingEvent {
        private final StackTrace myStackTrace;

        public AndroidStudioExceptionEvent(String message2, Throwable throwable, @NotNull StackTrace stackTrace) {
            super(message2, throwable);
            this.myStackTrace = stackTrace;
        }

        @Nullable
        public Object getData() {
            return ImmutableMap.of((Object)"Type", (Object)"Exception", (Object)"md5", (Object)this.myStackTrace.md5string(), (Object)"summary", (Object)this.myStackTrace.summarize(50));
        }
    }

    class MyNotification
    extends Notification {
        public MyNotification(String content2) {
            super(AndroidStudioSystemHealthMonitor.this.myGroup.getDisplayId(), "", content2, NotificationType.WARNING);
        }
    }

    private final class MyFullContentNotification
    extends MyNotification
    implements NotificationFullContent {
        public MyFullContentNotification(String content2) {
            super(content2);
        }
    }
}

