/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePopUpMenuButtonTableCellEditor;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

final class WipeDataItem
extends JBMenuItem {
    @NotNull
    private final @NotNull Consumer<@NotNull Component> myShowCannotWipeARunningAvdDialog;
    @NotNull
    private final @NotNull BiPredicate<@NotNull Object, @NotNull Component> myShowConfirmDataWipeDialog;
    @NotNull
    private final @NotNull Supplier<@NotNull AvdManagerConnection> myGetDefaultAvdManagerConnection;
    @NotNull
    private final @NotNull Function<@NotNull VirtualDeviceTable, @NotNull FutureCallback<@NotNull Key>> myNewSetSelectedDeviceFutureCallback;

    WipeDataItem(@NotNull VirtualDevicePopUpMenuButtonTableCellEditor editor) {
        this(editor, WipeDataItem::showCannotWipeARunningAvdDialog, WipeDataItem::showConfirmDataWipeDialog, AvdManagerConnection::getDefaultAvdManagerConnection, WipeDataItem::newSetSelectedDeviceFutureCallback);
    }

    @VisibleForTesting
    WipeDataItem(@NotNull VirtualDevicePopUpMenuButtonTableCellEditor editor, @NotNull @NotNull Consumer<@NotNull Component> showCannotWipeARunningAvdDialog, @NotNull @NotNull BiPredicate<@NotNull Object, @NotNull Component> showConfirmDataWipeDialog, @NotNull @NotNull Supplier<@NotNull AvdManagerConnection> getDefaultAvdManagerConnection, @NotNull @NotNull Function<@NotNull VirtualDeviceTable, @NotNull FutureCallback<@NotNull Key>> newSetSelectedDeviceFutureCallback) {
        super("Wipe Data");
        this.myShowCannotWipeARunningAvdDialog = showCannotWipeARunningAvdDialog;
        this.myShowConfirmDataWipeDialog = showConfirmDataWipeDialog;
        this.myGetDefaultAvdManagerConnection = getDefaultAvdManagerConnection;
        this.myNewSetSelectedDeviceFutureCallback = newSetSelectedDeviceFutureCallback;
        this.setToolTipText("Wipe the user data of this AVD");
        this.addActionListener(actionEvent -> {
            DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(DeviceManagerEvent.EventKind.VIRTUAL_WIPE_DATA_ACTION).build();
            DeviceManagerUsageTracker.log(deviceManagerEvent);
            VirtualDevice device2 = editor.getDevice();
            VirtualDeviceTable table2 = editor.getPanel().getTable();
            if (device2.isOnline()) {
                this.myShowCannotWipeARunningAvdDialog.accept((Component)((Object)table2));
                return;
            }
            if (!this.myShowConfirmDataWipeDialog.test(device2, (Component)((Object)table2))) {
                return;
            }
            EdtExecutorService executor2 = EdtExecutorService.getInstance();
            FluentFuture.from(this.myGetDefaultAvdManagerConnection.get().wipeUserDataAsync(device2.getAvdInfo())).transformAsync(succeeded -> table2.reloadDevice(device2.getKey()), (Executor)executor2).addCallback(this.myNewSetSelectedDeviceFutureCallback.apply(table2), (Executor)executor2);
        });
    }

    private static void showCannotWipeARunningAvdDialog(@NotNull Component component2) {
        Messages.showErrorDialog((Component)component2, (String)"The selected AVD is currently running in the emulator. Please exit the emulator instance and try wiping again.", (String)"Cannot Wipe a Running AVD");
    }

    private static boolean showConfirmDataWipeDialog(@NotNull Object device2, @NotNull Component component2) {
        return MessageDialogBuilder.yesNo((String)"Confirm Data Wipe", (String)("Do you really want to wipe user files from " + device2 + "?")).ask(component2);
    }

    @VisibleForTesting
    @NotNull
    static @NotNull FutureCallback<@NotNull Key> newSetSelectedDeviceFutureCallback(@NotNull VirtualDeviceTable table2) {
        return new DeviceManagerFutureCallback<Key>(WipeDataItem.class, table2::setSelectedDevice);
    }
}

