/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.prefs.AndroidLocationsException;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.devicemanager.DeviceManagerFutures;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.virtualtab.EventListenerLists;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePath;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceWatcherEvent;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceWatcherListener;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeAvdManagers;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.swing.event.EventListenerList;
import org.jetbrains.android.AndroidPluginDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service
public final class VirtualDeviceWatcher
implements ApplicationActivationListener {
    @NotNull
    private Map<String, AvdInfo> myAvds = new HashMap<String, AvdInfo>();
    @NotNull
    private final AvdManager myAvdManager;
    @NotNull
    private final EventListenerList myListeners;
    @NotNull
    private final Alarm myAlarm;

    @UiThread
    private VirtualDeviceWatcher() throws AndroidLocationsException {
        this(VirtualDeviceWatcher.getAvdManagerInstance());
    }

    @UiThread
    @VisibleForTesting
    VirtualDeviceWatcher(@NotNull AvdManager avdManager2) {
        this.myAvdManager = avdManager2;
        this.myListeners = new EventListenerList();
        this.myAlarm = new Alarm();
        Disposer.register((Disposable)AndroidPluginDisposable.Companion.getApplicationInstance(), (Disposable)this.myAlarm);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)this);
    }

    @UiThread
    public void applicationActivated(@NotNull IdeFrame ideFrame) {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            if (!ApplicationManager.getApplication().isActive()) {
                return;
            }
            ListenableFuture<Void> future2 = DeviceManagerFutures.appExecutorServiceSubmit(this::processAvdInfoChanges);
            Futures.addCallback(future2, (FutureCallback)new FailedFutureCallback(), (Executor)AppExecutorUtil.getAppExecutorService());
        }, 1000);
    }

    @UiThread
    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        if (!this.myAlarm.isEmpty()) {
            return;
        }
        ListenableFuture<Void> future2 = DeviceManagerFutures.appExecutorServiceSubmit(this::snapshotAvds);
        Futures.addCallback(future2, (FutureCallback)new FailedFutureCallback(), (Executor)AppExecutorUtil.getAppExecutorService());
    }

    @UiThread
    @NotNull
    private static AvdManager getAvdManagerInstance() throws AndroidLocationsException {
        AvdManager manager = IdeAvdManagers.INSTANCE.getAvdManager(AndroidSdks.getInstance().tryToChooseSdkHandler());
        assert (manager != null);
        return manager;
    }

    @UiThread
    @NotNull
    static VirtualDeviceWatcher getInstance() {
        return (VirtualDeviceWatcher)ApplicationManager.getApplication().getService(VirtualDeviceWatcher.class);
    }

    @UiThread
    void addVirtualDeviceWatcherListener(@NotNull VirtualDeviceWatcherListener listener2) {
        this.myListeners.add(VirtualDeviceWatcherListener.class, listener2);
    }

    @UiThread
    void removeVirtualDeviceWatcherListener(@NotNull VirtualDeviceWatcherListener listener2) {
        this.myListeners.remove(VirtualDeviceWatcherListener.class, listener2);
    }

    @WorkerThread
    private synchronized void processAvdInfoChanges() {
        Map<String, AvdInfo> currentAvds = this.getCurrentAvds();
        Application application = ApplicationManager.getApplication();
        for (String currentId : currentAvds.keySet()) {
            AvdInfo currentAvd = currentAvds.get(currentId);
            AvdInfo pastAvd = this.myAvds.remove(currentId);
            if (pastAvd == null) {
                application.invokeLater(() -> this.fireVirtualDeviceAdded(new VirtualDevicePath(currentAvd.getId())));
                continue;
            }
            if (currentAvd.equals((Object)pastAvd)) continue;
            application.invokeLater(() -> this.fireVirtualDeviceChanged(new VirtualDevicePath(currentAvd.getId())));
        }
        this.myAvds.values().stream().map(AvdInfo::getId).map(VirtualDevicePath::new).forEach(path2 -> application.invokeLater(() -> this.fireVirtualDeviceRemoved((Key)path2)));
        this.myAvds = currentAvds;
    }

    @UiThread
    private void fireVirtualDeviceAdded(@NotNull Key key) {
        EventListenerLists.fire(this.myListeners, VirtualDeviceWatcherListener::virtualDeviceAdded, VirtualDeviceWatcherListener.class, () -> new VirtualDeviceWatcherEvent(this, key));
    }

    @UiThread
    private void fireVirtualDeviceChanged(@NotNull Key key) {
        EventListenerLists.fire(this.myListeners, VirtualDeviceWatcherListener::virtualDeviceChanged, VirtualDeviceWatcherListener.class, () -> new VirtualDeviceWatcherEvent(this, key));
    }

    @UiThread
    private void fireVirtualDeviceRemoved(@NotNull Key key) {
        EventListenerLists.fire(this.myListeners, VirtualDeviceWatcherListener::virtualDeviceRemoved, VirtualDeviceWatcherListener.class, () -> new VirtualDeviceWatcherEvent(this, key));
    }

    @WorkerThread
    private synchronized void snapshotAvds() {
        this.myAvds = this.getCurrentAvds();
    }

    @WorkerThread
    @NotNull
    private synchronized @NotNull Map<@NotNull String, @NotNull AvdInfo> getCurrentAvds() {
        try {
            this.myAvdManager.reloadAvds();
            HashMap<String, AvdInfo> idToAvdInfo = new HashMap<String, AvdInfo>();
            Arrays.stream(this.myAvdManager.getAllAvds()).forEach(avdInfo -> idToAvdInfo.put(avdInfo.getId(), (AvdInfo)avdInfo));
            return idToAvdInfo;
        }
        catch (AndroidLocationsException e) {
            throw new RuntimeException(e);
        }
    }

    private static class FailedFutureCallback
    implements FutureCallback<Void> {
        private FailedFutureCallback() {
        }

        @WorkerThread
        public void onSuccess(@Nullable Void result2) {
        }

        @WorkerThread
        public void onFailure(@NotNull Throwable t) {
            Logger.getInstance(VirtualDevice.class).warn(t);
        }
    }
}

