/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.devicemanager.ActivateDeviceFileExplorerWindowValue;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceManagerAndroidDebugBridge;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.DeviceManagerFutures;
import com.android.tools.idea.devicemanager.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Devices;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.PopUpMenuValue;
import com.android.tools.idea.devicemanager.virtualtab.ErrorDialogException;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualTabMessages;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
final class VirtualDeviceTableModel
extends AbstractTableModel {
    static final int DEVICE_ICON_MODEL_COLUMN_INDEX = 0;
    static final int DEVICE_MODEL_COLUMN_INDEX = 1;
    static final int API_MODEL_COLUMN_INDEX = 2;
    static final int SIZE_ON_DISK_MODEL_COLUMN_INDEX = 3;
    static final int LAUNCH_OR_STOP_MODEL_COLUMN_INDEX = 4;
    static final int ACTIVATE_DEVICE_FILE_EXPLORER_WINDOW_MODEL_COLUMN_INDEX = 5;
    static final int EDIT_MODEL_COLUMN_INDEX = 6;
    static final int POP_UP_MENU_MODEL_COLUMN_INDEX = 7;
    @Nullable
    private final Project myProject;
    @NotNull
    private @NotNull List<@NotNull VirtualDevice> myDevices;
    @NotNull
    private final NewSetOnline myNewSetOnline;
    @NotNull
    private final @NotNull Callable<@NotNull AvdManagerConnection> myGetDefaultAvdManagerConnection;
    @NotNull
    private final @NotNull Function<@NotNull VirtualDeviceTableModel, @NotNull FutureCallback<@Nullable Object>> myNewSetAllOnline;
    @NotNull
    private final DeviceManagerAndroidDebugBridge myBridge;
    @NotNull
    private final @NotNull Function<@NotNull IDevice, @NotNull EmulatorConsole> myGetConsole;
    @NotNull
    private final @NotNull BiConsumer<@NotNull Throwable, @Nullable Project> myShowErrorDialog;

    VirtualDeviceTableModel(@Nullable Project project) {
        this(project, List.of());
    }

    @VisibleForTesting
    VirtualDeviceTableModel(@Nullable Project project, @NotNull @NotNull Collection<@NotNull VirtualDevice> devices2) {
        this(project, devices2, VirtualDeviceTableModel::newSetOnline, AvdManagerConnection::getDefaultAvdManagerConnection, SetAllOnline::new, new DeviceManagerAndroidDebugBridge(), EmulatorConsole::getConsole, VirtualTabMessages::showErrorDialog);
    }

    @VisibleForTesting
    VirtualDeviceTableModel(@Nullable Project project, @NotNull @NotNull Collection<@NotNull VirtualDevice> devices2, @NotNull NewSetOnline newSetOnline, @NotNull @NotNull Callable<@NotNull AvdManagerConnection> getDefaultAvdManagerConnection, @NotNull @NotNull Function<@NotNull VirtualDeviceTableModel, @NotNull FutureCallback<@Nullable Object>> newSetAllOnline, @NotNull DeviceManagerAndroidDebugBridge bridge, @NotNull @NotNull Function<@NotNull IDevice, @NotNull EmulatorConsole> getConsole, @NotNull @NotNull BiConsumer<@NotNull Throwable, @Nullable Project> showErrorDialog) {
        this.myProject = project;
        this.myDevices = new ArrayList<VirtualDevice>(devices2);
        this.myNewSetOnline = newSetOnline;
        this.myGetDefaultAvdManagerConnection = getDefaultAvdManagerConnection;
        this.myNewSetAllOnline = newSetAllOnline;
        this.myBridge = bridge;
        this.myGetConsole = getConsole;
        this.myShowErrorDialog = showErrorDialog;
    }

    @VisibleForTesting
    @NotNull
    static @NotNull FutureCallback<@NotNull Boolean> newSetOnline(@NotNull VirtualDeviceTableModel model2, @NotNull Key key) {
        return new DeviceManagerFutureCallback<Boolean>(VirtualDeviceTableModel.class, online -> {
            int modelRowIndex = Devices.indexOf(model2.myDevices, key);
            if (modelRowIndex == -1) {
                return;
            }
            model2.myDevices.set(modelRowIndex, model2.myDevices.get(modelRowIndex).withState(VirtualDevice.State.valueOf(online)));
            model2.fireTableRowsUpdated(modelRowIndex, modelRowIndex);
        });
    }

    @NotNull
    @NotNull List<@NotNull VirtualDevice> getDevices() {
        return this.myDevices;
    }

    void setDevices(@NotNull @NotNull List<@NotNull VirtualDevice> devices2) {
        this.myDevices = devices2;
        this.fireTableDataChanged();
    }

    void add(@NotNull VirtualDevice device2) {
        this.myDevices.add(device2);
        int modelRowIndex = this.myDevices.size() - 1;
        this.fireTableRowsInserted(modelRowIndex, modelRowIndex);
    }

    void set(@NotNull VirtualDevice device2) {
        int modelRowIndex = Devices.indexOf(this.myDevices, device2.getKey());
        if (modelRowIndex == -1) {
            return;
        }
        this.myDevices.set(modelRowIndex, device2);
        this.fireTableRowsUpdated(modelRowIndex, modelRowIndex);
    }

    @NotNull
    ListenableFuture<Boolean> remove(@NotNull VirtualDevice device2) {
        DeviceManagerFutureCallback<Boolean> callback = new DeviceManagerFutureCallback<Boolean>(VirtualDeviceTableModel.class, deletionSuccessful -> this.remove((boolean)deletionSuccessful, device2));
        FluentFuture future2 = FluentFuture.from(this.getDefaultAvdManagerConnection()).transform(connection2 -> connection2.deleteAvd(device2.getAvdInfo()), (Executor)AppExecutorUtil.getAppExecutorService());
        Futures.addCallback((ListenableFuture)future2, callback, (Executor)EdtExecutorService.getInstance());
        return future2;
    }

    private void remove(boolean deletionSuccessful, @NotNull VirtualDevice device2) {
        if (!deletionSuccessful) {
            Logger.getInstance(VirtualDeviceTableModel.class).warn("Failed to delete " + device2);
            return;
        }
        this.remove(device2.getKey());
    }

    void remove(@NotNull Key key) {
        int modelRowIndex = Devices.indexOf(this.myDevices, key);
        if (modelRowIndex == -1) {
            return;
        }
        this.myDevices.remove(modelRowIndex);
        this.fireTableRowsDeleted(modelRowIndex, modelRowIndex);
    }

    void setAllOnline() {
        DeviceManagerFutureCallback<AvdManagerConnection> callback = new DeviceManagerFutureCallback<AvdManagerConnection>(VirtualDeviceTableModel.class, this::setAllOnline);
        Futures.addCallback(this.getDefaultAvdManagerConnection(), callback, (Executor)EdtExecutorService.getInstance());
    }

    private void setAllOnline(@NotNull AvdManagerConnection connection2) {
        this.myDevices.forEach(device2 -> this.setOnline((VirtualDevice)device2, connection2));
    }

    private void setOnline(@NotNull VirtualDevice device2, @NotNull AvdManagerConnection connection2) {
        ListenableFuture<Boolean> future2 = DeviceManagerFutures.appExecutorServiceSubmit(() -> connection2.isAvdRunning(device2.getAvdInfo()));
        Futures.addCallback(future2, this.myNewSetOnline.apply(this, device2.getKey()), (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    private @NotNull ListenableFuture<@NotNull AvdManagerConnection> getDefaultAvdManagerConnection() {
        return DeviceManagerFutures.appExecutorServiceSubmit(this.myGetDefaultAvdManagerConnection);
    }

    @Override
    public int getRowCount() {
        return this.myDevices.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    @NotNull
    public String getColumnName(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "Device";
            }
            case 2: {
                return "API";
            }
            case 3: {
                return "Size on Disk";
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return "";
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return DeviceType.class;
            }
            case 1: {
                return Device.class;
            }
            case 2: {
                return AndroidVersion.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return VirtualDevice.State.class;
            }
            case 5: {
                return ActivateDeviceFileExplorerWindowValue.class;
            }
            case 6: {
                return EditValue.class;
            }
            case 7: {
                return PopUpMenuValue.class;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    public boolean isCellEditable(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return this.myDevices.get(modelRowIndex).getIcon().equals(AllIcons.Actions.Download);
            }
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                VirtualDevice device2 = this.myDevices.get(modelRowIndex);
                return device2.getState().isEnabled(device2);
            }
            case 5: {
                return this.myProject != null && this.myDevices.get(modelRowIndex).isOnline();
            }
            case 6: 
            case 7: {
                return true;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Object getValueAt(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return this.myDevices.get(modelRowIndex).getType();
            }
            case 1: {
                return this.myDevices.get(modelRowIndex);
            }
            case 2: {
                return this.myDevices.get(modelRowIndex).getAndroidVersion();
            }
            case 3: {
                return this.myDevices.get(modelRowIndex).getSizeOnDisk();
            }
            case 4: {
                return this.myDevices.get(modelRowIndex).getState();
            }
            case 5: {
                return ActivateDeviceFileExplorerWindowValue.INSTANCE;
            }
            case 6: {
                return EditValue.INSTANCE;
            }
            case 7: {
                return PopUpMenuValue.INSTANCE;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    public void setValueAt(@NotNull Object value2, int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                assert (false) : modelColumnIndex;
                break;
            }
            case 4: {
                this.launchOrStop((VirtualDevice.State)((Object)value2), modelRowIndex);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                assert (false) : modelColumnIndex;
                break;
            }
        }
    }

    private void launchOrStop(@NotNull VirtualDevice.State state2, int modelRowIndex) {
        switch (state2) {
            case STOPPED: {
                assert (false);
                break;
            }
            case LAUNCHING: {
                this.launch(modelRowIndex);
                break;
            }
            case LAUNCHED: {
                assert (false);
                break;
            }
            case STOPPING: {
                this.stop(modelRowIndex);
                break;
            }
            default: {
                assert (false) : state2;
                break;
            }
        }
    }

    private void launch(int modelRowIndex) {
        DeviceManagerEvent event = DeviceManagerEvent.newBuilder().setKind(DeviceManagerEvent.EventKind.VIRTUAL_LAUNCH_ACTION).build();
        DeviceManagerUsageTracker.log(event);
        VirtualDevice device2 = this.myDevices.get(modelRowIndex).withState(VirtualDevice.State.LAUNCHING);
        this.myDevices.set(modelRowIndex, device2);
        this.fireTableCellUpdated(modelRowIndex, 4);
        EdtExecutorService executor2 = EdtExecutorService.getInstance();
        FluentFuture.from(this.getDefaultAvdManagerConnection()).transformAsync(connection2 -> connection2.startAvd(this.myProject, device2.getAvdInfo()), (Executor)executor2).addCallback(this.myNewSetAllOnline.apply(this), (Executor)executor2);
    }

    private void stop(int modelRowIndex) {
        DeviceManagerEvent event = DeviceManagerEvent.newBuilder().setKind(DeviceManagerEvent.EventKind.VIRTUAL_STOP_ACTION).build();
        DeviceManagerUsageTracker.log(event);
        VirtualDevice device2 = this.myDevices.get(modelRowIndex).withState(VirtualDevice.State.STOPPING);
        this.myDevices.set(modelRowIndex, device2);
        this.fireTableCellUpdated(modelRowIndex, 4);
        FluentFuture.from(this.myBridge.findDevice(this.myProject, device2.getKey())).transform(d -> this.stop((IDevice)d, device2), (Executor)AppExecutorUtil.getAppExecutorService()).addCallback(this.myNewSetAllOnline.apply(this), (Executor)EdtExecutorService.getInstance());
    }

    @WorkerThread
    @Nullable
    private Void stop(@Nullable IDevice d, @NotNull Object device2) {
        if (d == null) {
            throw new ErrorDialogException("Unable to stop " + device2, "An error occurred stopping " + device2 + ". To stop the device, try manually closing the " + device2 + " emulator window.");
        }
        EmulatorConsole console = this.myGetConsole.apply(d);
        console.kill();
        console.close();
        return null;
    }

    @UiThread
    @VisibleForTesting
    static final class SetAllOnline
    implements FutureCallback<Object> {
        @NotNull
        private final VirtualDeviceTableModel myModel;

        @VisibleForTesting
        SetAllOnline(@NotNull VirtualDeviceTableModel model2) {
            this.myModel = model2;
        }

        public void onSuccess(@Nullable Object object) {
        }

        public void onFailure(@NotNull Throwable throwable) {
            this.myModel.setAllOnline();
            this.myModel.myShowErrorDialog.accept(throwable, this.myModel.myProject);
        }
    }

    static final class EditValue {
        static final EditValue INSTANCE = new EditValue();

        private EditValue() {
        }

        @NotNull
        public String toString() {
            return "Edit";
        }
    }

    @VisibleForTesting
    static interface NewSetOnline {
        @NotNull
        public @NotNull FutureCallback<@NotNull Boolean> apply(@NotNull VirtualDeviceTableModel var1, @NotNull Key var2);
    }
}

