/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.devicemanager.ActivateDeviceFileExplorerWindowButtonTableCellEditor;
import com.android.tools.idea.devicemanager.ActivateDeviceFileExplorerWindowButtonTableCellRenderer;
import com.android.tools.idea.devicemanager.ActivateDeviceFileExplorerWindowValue;
import com.android.tools.idea.devicemanager.ApiTableCellRenderer;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanager.DeviceTable;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Devices;
import com.android.tools.idea.devicemanager.IconButtonTableCellRenderer;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.MergedTableColumn;
import com.android.tools.idea.devicemanager.PopUpMenuValue;
import com.android.tools.idea.devicemanager.Tables;
import com.android.tools.idea.devicemanager.virtualtab.BuildVirtualDeviceConfigurationWizardActionListener;
import com.android.tools.idea.devicemanager.virtualtab.DownloadButtonTableCellEditor;
import com.android.tools.idea.devicemanager.virtualtab.EditButtonTableCellEditor;
import com.android.tools.idea.devicemanager.virtualtab.LaunchOrStopButtonTableCellEditor;
import com.android.tools.idea.devicemanager.virtualtab.LaunchOrStopButtonTableCellRenderer;
import com.android.tools.idea.devicemanager.virtualtab.SizeOnDiskTableCellRenderer;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceAsyncSupplier;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceChangeListener;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceIconButtonTableCellRenderer;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePanel;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePopUpMenuButtonTableCellEditor;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTableCellRenderer;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTableModel;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceWatcherEvent;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceWatcherListener;
import com.android.tools.idea.devicemanager.virtualtab.VirtualTabPersistentStateComponent;
import com.android.tools.idea.devicemanager.virtualtab.VirtualTabState;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VirtualDeviceTable
extends DeviceTable<VirtualDevice>
implements VirtualDeviceWatcherListener,
Disposable {
    @NotNull
    private final VirtualDeviceAsyncSupplier myAsyncSupplier;
    @NotNull
    private final NewSetDevices myNewSetDevices;
    @Nullable
    private AndroidDebugBridge.IDeviceChangeListener myListener;
    @NotNull
    private final ActionListener myEmptyTextLinkListener;

    VirtualDeviceTable(@NotNull VirtualDevicePanel panel2) {
        this(panel2, panel2.getProject(), new VirtualDeviceAsyncSupplier(), VirtualDeviceTable::newSetDevices);
    }

    @VisibleForTesting
    VirtualDeviceTable(@NotNull VirtualDevicePanel panel2, @Nullable Project project, @NotNull VirtualDeviceAsyncSupplier asyncSupplier, @NotNull NewSetDevices newSetDevices) {
        super(new VirtualDeviceTableModel(project), VirtualDevice.class);
        this.myAsyncSupplier = asyncSupplier;
        this.myNewSetDevices = newSetDevices;
        this.initListener();
        this.setDefaultEditor(DeviceType.class, new DownloadButtonTableCellEditor(project));
        this.setDefaultEditor(VirtualDevice.State.class, new LaunchOrStopButtonTableCellEditor());
        this.setDefaultEditor(ActivateDeviceFileExplorerWindowValue.class, new ActivateDeviceFileExplorerWindowButtonTableCellEditor<VirtualDevice>(project, this, DeviceManagerEvent.EventKind.VIRTUAL_DEVICE_FILE_EXPLORER_ACTION));
        this.setDefaultEditor(VirtualDeviceTableModel.EditValue.class, new EditButtonTableCellEditor(panel2));
        this.setDefaultEditor(PopUpMenuValue.class, new VirtualDevicePopUpMenuButtonTableCellEditor(panel2));
        this.setDefaultRenderer(DeviceType.class, new VirtualDeviceIconButtonTableCellRenderer());
        this.setDefaultRenderer(Device.class, new VirtualDeviceTableCellRenderer());
        this.setDefaultRenderer(AndroidVersion.class, new ApiTableCellRenderer());
        this.setDefaultRenderer(Long.class, new SizeOnDiskTableCellRenderer());
        this.setDefaultRenderer(VirtualDevice.State.class, new LaunchOrStopButtonTableCellRenderer());
        this.setDefaultRenderer(ActivateDeviceFileExplorerWindowValue.class, new ActivateDeviceFileExplorerWindowButtonTableCellRenderer<VirtualDevice>(project, this));
        this.setDefaultRenderer(VirtualDeviceTableModel.EditValue.class, new IconButtonTableCellRenderer(AllIcons.Actions.Edit, "Edit this AVD"));
        this.setDefaultRenderer(PopUpMenuValue.class, new IconButtonTableCellRenderer(AllIcons.Actions.More, "More Actions"));
        this.setRowSorter(VirtualDeviceTable.newRowSorter(this.dataModel));
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.myEmptyTextLinkListener = new BuildVirtualDeviceConfigurationWizardActionListener((Component)((Object)this), project, this);
        this.getEmptyText().setText("Loading...");
        this.refreshAvds();
    }

    @VisibleForTesting
    @NotNull
    static @NotNull FutureCallback<@NotNull List<@NotNull VirtualDevice>> newSetDevices(@NotNull VirtualDeviceTable table2) {
        return new DeviceManagerFutureCallback<List<VirtualDevice>>(VirtualDeviceTable.class, devices2 -> {
            table2.getModel().setDevices((List<VirtualDevice>)devices2);
            table2.getEmptyText().clear().appendLine("No virtual devices added. Create a virtual device to test").appendLine("applications without owning a physical device.").appendLine("Create virtual device", SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, table2.myEmptyTextLinkListener);
            DeviceManagerEvent event = DeviceManagerEvent.newBuilder().setKind(DeviceManagerEvent.EventKind.VIRTUAL_DEVICE_COUNT).setVirtualDeviceCount(devices2.size()).build();
            DeviceManagerUsageTracker.log(event);
        });
    }

    private void initListener() {
        this.myListener = new VirtualDeviceChangeListener(this.getModel());
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myListener);
    }

    @NotNull
    private static @NotNull RowSorter<@NotNull TableModel> newRowSorter(@NotNull TableModel model2) {
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(model2);
        sorter.setComparator(1, Comparator.comparing(Device::getName, Collator.getInstance()));
        sorter.setComparator(2, Comparator.naturalOrder().reversed());
        sorter.setComparator(3, Comparator.naturalOrder().reversed());
        sorter.setSortable(4, false);
        sorter.setSortable(5, false);
        sorter.setSortable(6, false);
        sorter.setSortable(7, false);
        VirtualTabState tabState = VirtualTabPersistentStateComponent.getInstance().getState();
        sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(tabState.getSortColumn(), tabState.getSortOrder())));
        sorter.addRowSorterListener(event -> {
            List<RowSorter.SortKey> keys = sorter.getSortKeys();
            if (!keys.isEmpty()) {
                RowSorter.SortKey key = keys.get(0);
                VirtualTabPersistentStateComponent.getInstance().loadState(new VirtualTabState(key.getColumn(), key.getSortOrder()));
            }
        });
        return sorter;
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myListener);
    }

    @Override
    public void virtualDeviceAdded(@NotNull VirtualDeviceWatcherEvent event) {
        this.addDevice(event.getKey());
    }

    @NotNull
    @NotNull ListenableFuture<@NotNull Key> addDevice(@NotNull Key key) {
        return Futures.transform(this.myAsyncSupplier.get(key), this::add, (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    private Key add(@NotNull VirtualDevice device2) {
        this.getModel().add(device2);
        return device2.getKey();
    }

    @Override
    public void virtualDeviceChanged(@NotNull VirtualDeviceWatcherEvent event) {
        this.reloadDevice(event.getKey());
    }

    @NotNull
    @NotNull ListenableFuture<@NotNull Key> reloadDevice(@NotNull Key key) {
        return Futures.transform(this.myAsyncSupplier.get(key), this::set, (Executor)EdtExecutorService.getInstance());
    }

    @NotNull
    private Key set(@NotNull VirtualDevice device2) {
        this.getModel().set(device2);
        return device2.getKey();
    }

    @Override
    public void virtualDeviceRemoved(@NotNull VirtualDeviceWatcherEvent event) {
        this.getModel().remove(event.getKey());
    }

    @NotNull
    public VirtualDeviceTableModel getModel() {
        return (VirtualDeviceTableModel)this.dataModel;
    }

    @NotNull
    @NotNull Optional<@NotNull VirtualDevice> getSelectedDevice() {
        int viewRowIndex = this.getSelectedRow();
        if (viewRowIndex == -1) {
            return Optional.empty();
        }
        return Optional.of((VirtualDevice)this.getDeviceAt(viewRowIndex));
    }

    void setSelectedDevice(@NotNull Key key) {
        int modelRowIndex = Devices.indexOf(this.getModel().getDevices(), key);
        if (modelRowIndex == -1) {
            return;
        }
        int viewRowIndex = this.convertRowIndexToView(modelRowIndex);
        this.setRowSelectionInterval(viewRowIndex, viewRowIndex);
        this.scrollRectToVisible(this.getCellRect(viewRowIndex, this.deviceViewColumnIndex(), true));
    }

    @NotNull
    protected JTableHeader createDefaultTableHeader() {
        DefaultTableColumnModel model2 = new DefaultTableColumnModel();
        model2.addColumn(this.columnModel.getColumn(this.deviceIconViewColumnIndex()));
        model2.addColumn(this.columnModel.getColumn(this.deviceViewColumnIndex()));
        model2.addColumn(this.columnModel.getColumn(this.apiViewColumnIndex()));
        model2.addColumn(this.columnModel.getColumn(this.sizeOnDiskViewColumnIndex()));
        List<TableColumn> columns2 = List.of(this.columnModel.getColumn(this.launchOrStopViewColumnIndex()), this.columnModel.getColumn(this.activateDeviceFileExplorerWindowViewColumnIndex()), this.columnModel.getColumn(this.editViewColumnIndex()), this.columnModel.getColumn(this.popUpMenuViewColumnIndex()));
        MergedTableColumn column2 = new MergedTableColumn(columns2);
        column2.setHeaderValue("Actions");
        model2.addColumn(column2);
        JTableHeader header = super.createDefaultTableHeader();
        header.setColumnModel(model2);
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        return header;
    }

    public void doLayout() {
        Tables.setWidths(this.columnModel.getColumn(this.deviceIconViewColumnIndex()), VirtualDeviceIconButtonTableCellRenderer.getPreferredWidth((JTable)((Object)this), DeviceType.class));
        this.columnModel.getColumn(this.deviceViewColumnIndex()).setMinWidth(JBUIScale.scale((int)200));
        Tables.setWidths(this.columnModel.getColumn(this.apiViewColumnIndex()), Tables.getPreferredColumnWidth((JTable)((Object)this), this.apiViewColumnIndex(), JBUIScale.scale((int)65)), JBUIScale.scale((int)20));
        Tables.setWidths(this.columnModel.getColumn(this.sizeOnDiskViewColumnIndex()), Tables.getPreferredColumnWidth((JTable)((Object)this), this.sizeOnDiskViewColumnIndex(), JBUIScale.scale((int)65)), JBUIScale.scale((int)20));
        Tables.setWidths(this.columnModel.getColumn(this.launchOrStopViewColumnIndex()), IconButtonTableCellRenderer.getPreferredWidth((JTable)((Object)this), VirtualDevice.State.class));
        Tables.setWidths(this.columnModel.getColumn(this.activateDeviceFileExplorerWindowViewColumnIndex()), IconButtonTableCellRenderer.getPreferredWidth((JTable)((Object)this), ActivateDeviceFileExplorerWindowValue.class));
        Tables.setWidths(this.columnModel.getColumn(this.editViewColumnIndex()), IconButtonTableCellRenderer.getPreferredWidth((JTable)((Object)this), VirtualDeviceTableModel.EditValue.class));
        Tables.setWidths(this.columnModel.getColumn(this.popUpMenuViewColumnIndex()), IconButtonTableCellRenderer.getPreferredWidth((JTable)((Object)this), PopUpMenuValue.class));
        super.doLayout();
    }

    private int deviceIconViewColumnIndex() {
        return this.convertColumnIndexToView(0);
    }

    @Override
    protected int deviceViewColumnIndex() {
        return this.convertColumnIndexToView(1);
    }

    private int apiViewColumnIndex() {
        return this.convertColumnIndexToView(2);
    }

    private int sizeOnDiskViewColumnIndex() {
        return this.convertColumnIndexToView(3);
    }

    private int launchOrStopViewColumnIndex() {
        return this.convertColumnIndexToView(4);
    }

    private int activateDeviceFileExplorerWindowViewColumnIndex() {
        return this.convertColumnIndexToView(5);
    }

    private int editViewColumnIndex() {
        return this.convertColumnIndexToView(6);
    }

    private int popUpMenuViewColumnIndex() {
        return this.convertColumnIndexToView(7);
    }

    void refreshAvds() {
        Futures.addCallback(this.myAsyncSupplier.getAll(), this.myNewSetDevices.apply(this), (Executor)EdtExecutorService.getInstance());
    }

    @VisibleForTesting
    static interface NewSetDevices {
        @NotNull
        public @NotNull FutureCallback<@NotNull List<@NotNull VirtualDevice>> apply(@NotNull VirtualDeviceTable var1);
    }
}

