/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.devicemanager.DeviceManagerFutureCallback;
import com.android.tools.idea.devicemanager.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanager.DevicePanel;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.MenuItems;
import com.android.tools.idea.devicemanager.PopUpMenuButtonTableCellEditor;
import com.android.tools.idea.devicemanager.virtualtab.DeleteItem;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePanel;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePath;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTable;
import com.android.tools.idea.devicemanager.virtualtab.VirtualTabMessages;
import com.android.tools.idea.devicemanager.virtualtab.WipeDataItem;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDevicePopUpMenuButtonTableCellEditor
extends PopUpMenuButtonTableCellEditor {
    VirtualDevicePopUpMenuButtonTableCellEditor(@NotNull DevicePanel panel2) {
        super(panel2);
    }

    @NotNull
    VirtualDevicePanel getPanel() {
        return (VirtualDevicePanel)this.myPanel;
    }

    @NotNull
    VirtualDevice getDevice() {
        return (VirtualDevice)this.myDevice;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull JComponent> newItems() {
        ArrayList<JComponent> items2 = new ArrayList<JComponent>();
        items2.add(this.newColdBootNowItem());
        this.addPairDeviceItems(items2);
        items2.add(new JPopupMenu.Separator());
        items2.add(this.newDuplicateItem());
        items2.add((JComponent)((Object)new WipeDataItem(this)));
        items2.add((JComponent)((Object)new DeleteItem(this)));
        items2.add(new JPopupMenu.Separator());
        items2.add(MenuItems.newViewDetailsItem(this.myPanel));
        items2.add(this.newShowOnDiskItem());
        return items2;
    }

    @NotNull
    private JComponent newColdBootNowItem() {
        JBMenuItem item2 = new JBMenuItem("Cold Boot Now");
        item2.setToolTipText("Force one cold boot");
        item2.addActionListener(actionEvent -> {
            DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(DeviceManagerEvent.EventKind.VIRTUAL_COLD_BOOT_NOW_ACTION).build();
            DeviceManagerUsageTracker.log(deviceManagerEvent);
            Project project = this.myPanel.getProject();
            Futures.addCallback(AvdManagerConnection.getDefaultAvdManagerConnection().startAvdWithColdBoot(project, this.getDevice().getAvdInfo()), (FutureCallback)new ShowErrorDialogFutureCallback(project), (Executor)EdtExecutorService.getInstance());
        });
        return item2;
    }

    private void addPairDeviceItems(@NotNull @NotNull Collection<@NotNull JComponent> items2) {
        if (!((Boolean)StudioFlags.WEAR_OS_VIRTUAL_DEVICE_PAIRING_ASSISTANT_ENABLED.get()).booleanValue()) {
            return;
        }
        switch (this.myDevice.getType()) {
            case PHONE: 
            case WEAR_OS: {
                items2.add(this.newPairDeviceItem());
                this.newViewPairedDevicesItem(DeviceManagerEvent.EventKind.VIRTUAL_UNPAIR_DEVICE_ACTION).ifPresent(items2::add);
                break;
            }
        }
    }

    @NotNull
    private JComponent newPairDeviceItem() {
        JComponent item2 = this.newPairWearableItem(DeviceManagerEvent.EventKind.VIRTUAL_PAIR_DEVICE_ACTION);
        VirtualDevice device2 = this.getDevice();
        item2.setEnabled(device2.isPairable());
        item2.setToolTipText(device2.getPairingMessage());
        return item2;
    }

    @NotNull
    private JComponent newDuplicateItem() {
        JBMenuItem item2 = new JBMenuItem("Duplicate");
        item2.setToolTipText("Duplicate this AVD");
        item2.addActionListener(actionEvent -> {
            DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(DeviceManagerEvent.EventKind.VIRTUAL_DUPLICATE_ACTION).build();
            DeviceManagerUsageTracker.log(deviceManagerEvent);
            VirtualDeviceTable table2 = this.getPanel().getTable();
            AvdOptionsModel model2 = new AvdOptionsModel(this.getDevice().getAvdInfo());
            if (!AvdWizardUtils.createAvdWizardForDuplication((Component)((Object)table2), this.myPanel.getProject(), model2).showAndGet()) {
                return;
            }
            Futures.addCallback(table2.addDevice(new VirtualDevicePath(model2.getCreatedAvd().getId())), new DeviceManagerFutureCallback<Key>(VirtualDevicePopUpMenuButtonTableCellEditor.class, table2::setSelectedDevice), (Executor)EdtExecutorService.getInstance());
        });
        return item2;
    }

    @NotNull
    private JComponent newShowOnDiskItem() {
        JBMenuItem item2 = new JBMenuItem("Show on Disk");
        item2.setToolTipText("Open the location of this AVD's data files");
        item2.addActionListener(actionEvent -> {
            DeviceManagerEvent deviceManagerEvent = DeviceManagerEvent.newBuilder().setKind(DeviceManagerEvent.EventKind.VIRTUAL_SHOW_ON_DISK_ACTION).build();
            DeviceManagerUsageTracker.log(deviceManagerEvent);
            RevealFileAction.openDirectory((Path)this.getDevice().getAvdInfo().getDataFolderPath());
        });
        return item2;
    }

    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, int viewRowIndex, int viewColumnIndex) {
        super.getTableCellEditorComponent(table2, value2, selected, viewRowIndex, viewColumnIndex);
        this.myDevice = ((VirtualDeviceTable)((Object)table2)).getDeviceAt(viewRowIndex);
        return this.myButton;
    }

    private static final class ShowErrorDialogFutureCallback
    implements FutureCallback<Object> {
        @Nullable
        private final Project myProject;

        private ShowErrorDialogFutureCallback(@Nullable Project project) {
            this.myProject = project;
        }

        public void onSuccess(@Nullable Object result2) {
        }

        public void onFailure(@NotNull Throwable throwable) {
            VirtualTabMessages.showErrorDialog(throwable, this.myProject);
        }
    }
}

