/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDeviceTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

final class VirtualDeviceChangeListener
implements AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final @NotNull Supplier<@NotNull Application> myGetApplication;
    @NotNull
    private final Runnable mySetAllOnline;

    @UiThread
    VirtualDeviceChangeListener(@NotNull VirtualDeviceTableModel model2) {
        this(ApplicationManager::getApplication, model2::setAllOnline);
    }

    @VisibleForTesting
    VirtualDeviceChangeListener(@NotNull @NotNull Supplier<@NotNull Application> getApplication, @NotNull Runnable setAllOnline) {
        this.myGetApplication = getApplication;
        this.mySetAllOnline = setAllOnline;
    }

    @WorkerThread
    public void deviceConnected(@NotNull IDevice device2) {
        if (!device2.isEmulator()) {
            return;
        }
        Logger.getInstance(VirtualDeviceChangeListener.class).info(device2 + " connected");
    }

    @WorkerThread
    public void deviceDisconnected(@NotNull IDevice device2) {
        if (!device2.isEmulator()) {
            return;
        }
        Logger.getInstance(VirtualDeviceChangeListener.class).info(device2 + " disconnected");
    }

    @WorkerThread
    public void deviceChanged(@NotNull IDevice device2, int mask) {
        if (!device2.isEmulator()) {
            return;
        }
        if ((mask & 1) == 0) {
            return;
        }
        IDevice.DeviceState state2 = device2.getState();
        Logger.getInstance(VirtualDeviceChangeListener.class).info(device2 + " state changed to " + state2);
        if (state2 == null) {
            return;
        }
        switch (state2) {
            case OFFLINE: 
            case ONLINE: {
                this.myGetApplication.get().invokeLater(this.mySetAllOnline);
                break;
            }
        }
    }
}

