/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.annotations.concurrency.WorkerThread;
import com.android.repository.io.FileUtilKt;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Targets;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevice;
import com.android.tools.idea.devicemanager.virtualtab.VirtualDevicePath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

final class VirtualDeviceBuilder {
    @NotNull
    private final AvdInfo myDevice;
    @NotNull
    private final @NotNull Supplier<@NotNull Boolean> myIsAvdRunning;
    @NotNull
    private final @NotNull Supplier<@NotNull Long> myRecursiveSize;

    @WorkerThread
    VirtualDeviceBuilder(@NotNull AvdInfo device2) {
        this(device2, () -> AvdManagerConnection.getDefaultAvdManagerConnection().isAvdRunning(device2), () -> VirtualDeviceBuilder.recursiveSize(device2));
    }

    @VisibleForTesting
    VirtualDeviceBuilder(@NotNull AvdInfo device2, @NotNull @NotNull Supplier<@NotNull Boolean> isAvdRunning, @NotNull @NotNull Supplier<@NotNull Long> recursiveSize) {
        this.myDevice = device2;
        this.myIsAvdRunning = isAvdRunning;
        this.myRecursiveSize = recursiveSize;
    }

    private static long recursiveSize(@NotNull AvdInfo device2) {
        try {
            return FileUtilKt.recursiveSize((Path)device2.getDataFolderPath());
        }
        catch (IOException exception) {
            Logger.getInstance(VirtualDeviceBuilder.class).warn((Throwable)exception);
            return 0L;
        }
    }

    @WorkerThread
    @NotNull
    VirtualDevice build() {
        IdDisplay tag = this.myDevice.getTag();
        AndroidVersion version2 = this.myDevice.getAndroidVersion();
        VirtualDevice.Builder builder2 = new VirtualDevice.Builder().setKey(new VirtualDevicePath(this.myDevice.getId())).setType(VirtualDeviceBuilder.getType(tag)).setName(this.myDevice.getDisplayName()).setTarget(Targets.toString(version2, tag)).setCpuArchitecture(this.myDevice.getCpuArch()).setAndroidVersion(version2).setSizeOnDisk(this.myRecursiveSize.get()).setState(VirtualDevice.State.valueOf(this.myIsAvdRunning.get())).setAvdInfo(this.myDevice);
        if (AvdManagerConnection.isSystemImageDownloadProblem(this.myDevice.getStatus())) {
            builder2.setIcon(AllIcons.Actions.Download);
        }
        return builder2.build();
    }

    @NotNull
    private static DeviceType getType(@NotNull IdDisplay tag) {
        if (tag.equals((Object)SystemImage.WEAR_TAG)) {
            return DeviceType.WEAR_OS;
        }
        if (tag.equals((Object)SystemImage.ANDROID_TV_TAG)) {
            return DeviceType.TV;
        }
        if (tag.equals((Object)SystemImage.GOOGLE_TV_TAG)) {
            return DeviceType.TV;
        }
        if (tag.equals((Object)SystemImage.AUTOMOTIVE_TAG)) {
            return DeviceType.AUTOMOTIVE;
        }
        if (tag.equals((Object)SystemImage.AUTOMOTIVE_PLAY_STORE_TAG)) {
            return DeviceType.AUTOMOTIVE;
        }
        return DeviceType.PHONE;
    }
}

