/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanager.virtualtab;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.device.Resolution;
import com.android.tools.idea.devicemanager.Device;
import com.android.tools.idea.devicemanager.DeviceType;
import com.android.tools.idea.devicemanager.Key;
import com.android.tools.idea.devicemanager.StorageDevice;
import com.android.tools.idea.wearpairing.AndroidWearPairingBundle;
import icons.StudioIcons;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VirtualDevice
extends Device {
    @Nullable
    private final Icon myIcon;
    @NotNull
    private final String myCpuArchitecture;
    private final long mySizeOnDisk;
    @NotNull
    private final State myState;
    @NotNull
    private final AvdInfo myAvdInfo;

    private VirtualDevice(@NotNull Builder builder2) {
        super(builder2);
        this.myIcon = builder2.myIcon;
        assert (builder2.myCpuArchitecture != null);
        this.myCpuArchitecture = builder2.myCpuArchitecture;
        this.mySizeOnDisk = builder2.mySizeOnDisk;
        this.myState = builder2.myState;
        assert (builder2.myAvdInfo != null);
        this.myAvdInfo = builder2.myAvdInfo;
    }

    @NotNull
    VirtualDevice withState(@NotNull State state2) {
        return new Builder().setKey(this.myKey).setIcon(this.myIcon).setType(this.myType).setName(this.myName).setTarget(this.myTarget).setCpuArchitecture(this.myCpuArchitecture).setAndroidVersion(this.myAndroidVersion).setSizeOnDisk(this.mySizeOnDisk).setState(state2).setResolution(this.myResolution).setDensity(this.myDensity).addAllAbis((Collection<String>)this.myAbis).setStorageDevice(this.myStorageDevice).setAvdInfo(this.myAvdInfo).build();
    }

    @Override
    @NotNull
    public Icon getIcon() {
        if (this.myIcon == null) {
            return this.myType.getVirtualIcon();
        }
        return this.myIcon;
    }

    @Override
    public boolean isOnline() {
        return this.myState.myOnline;
    }

    @NotNull
    String getCpuArchitecture() {
        return this.myCpuArchitecture;
    }

    long getSizeOnDisk() {
        return this.mySizeOnDisk;
    }

    @NotNull
    State getState() {
        return this.myState;
    }

    boolean isPairable() {
        return this.newPairingState().myPairable;
    }

    @Nullable
    String getPairingMessage() {
        return this.newPairingState().myMessage;
    }

    @NotNull
    private PairingState newPairingState() {
        switch (this.myType) {
            case PHONE: {
                if (this.myAndroidVersion.getApiLevel() < 30) {
                    return new PairingState(false, AndroidWearPairingBundle.message("wear.assistant.device.list.tooltip.requires.api", 30));
                }
                if (!this.myAvdInfo.hasPlayStore()) {
                    return new PairingState(false, AndroidWearPairingBundle.message("wear.assistant.device.list.tooltip.requires.play", new Object[0]));
                }
                return new PairingState(true, AndroidWearPairingBundle.message("wear.assistant.device.list.tooltip.ok", new Object[0]));
            }
            case WEAR_OS: {
                if (this.myAndroidVersion.getApiLevel() < 28) {
                    return new PairingState(false, AndroidWearPairingBundle.message("wear.assistant.device.list.tooltip.requires.api", 28));
                }
                return new PairingState(true, AndroidWearPairingBundle.message("wear.assistant.device.list.tooltip.ok", new Object[0]));
            }
        }
        return new PairingState(false, null);
    }

    @NotNull
    public AvdInfo getAvdInfo() {
        return this.myAvdInfo;
    }

    public int hashCode() {
        int hashCode = this.myKey.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.myIcon);
        hashCode = 31 * hashCode + this.myType.hashCode();
        hashCode = 31 * hashCode + this.myName.hashCode();
        hashCode = 31 * hashCode + this.myTarget.hashCode();
        hashCode = 31 * hashCode + this.myCpuArchitecture.hashCode();
        hashCode = 31 * hashCode + this.myAndroidVersion.hashCode();
        hashCode = 31 * hashCode + Long.hashCode(this.mySizeOnDisk);
        hashCode = 31 * hashCode + this.myState.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.myResolution);
        hashCode = 31 * hashCode + this.myDensity;
        hashCode = 31 * hashCode + this.myAbis.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.myStorageDevice);
        hashCode = 31 * hashCode + this.myAvdInfo.hashCode();
        return hashCode;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof VirtualDevice)) {
            return false;
        }
        VirtualDevice device2 = (VirtualDevice)object;
        return this.myKey.equals(device2.myKey) && Objects.equals(this.myIcon, device2.myIcon) && this.myType.equals((Object)device2.myType) && this.myName.equals(device2.myName) && this.myTarget.equals(device2.myTarget) && this.myCpuArchitecture.equals(device2.myCpuArchitecture) && this.myAndroidVersion.equals((Object)device2.myAndroidVersion) && this.mySizeOnDisk == device2.mySizeOnDisk && this.myState.equals((Object)device2.myState) && Objects.equals(this.myResolution, device2.myResolution) && this.myDensity == device2.myDensity && this.myAbis.equals(device2.myAbis) && Objects.equals(this.myStorageDevice, device2.myStorageDevice) && this.myAvdInfo.equals((Object)device2.myAvdInfo);
    }

    private static final class PairingState {
        private final boolean myPairable;
        @Nullable
        private final String myMessage;

        private PairingState(boolean pairable, @Nullable String message2) {
            this.myPairable = pairable;
            this.myMessage = message2;
        }
    }

    static enum State {
        STOPPED(false, StudioIcons.Avd.RUN, "Launch this AVD in the emulator"){

            @Override
            boolean isEnabled(@NotNull VirtualDevice device2) {
                return device2.myAvdInfo.getStatus().equals((Object)AvdInfo.AvdStatus.OK);
            }
        }
        ,
        LAUNCHING(false, StudioIcons.Avd.RUN, "Launch this AVD in the emulator"){

            @Override
            boolean isEnabled(@NotNull VirtualDevice device2) {
                return false;
            }
        }
        ,
        LAUNCHED(true, StudioIcons.Avd.STOP, "Stop the emulator running this AVD"){

            @Override
            boolean isEnabled(@NotNull VirtualDevice device2) {
                return true;
            }
        }
        ,
        STOPPING(true, StudioIcons.Avd.STOP, "Stop the emulator running this AVD"){

            @Override
            boolean isEnabled(@NotNull VirtualDevice device2) {
                return false;
            }
        };

        private final boolean myOnline;
        @NotNull
        private final Icon myIcon;
        @NotNull
        private final String myTooltipText;

        private State(@NotNull boolean online, Icon icon2, String tooltipText) {
            this.myOnline = online;
            this.myIcon = icon2;
            this.myTooltipText = tooltipText;
        }

        @NotNull
        static State valueOf(boolean online) {
            return online ? LAUNCHED : STOPPED;
        }

        @NotNull
        final Icon getIcon() {
            return this.myIcon;
        }

        abstract boolean isEnabled(@NotNull VirtualDevice var1);

        @NotNull
        final String getTooltipText() {
            return this.myTooltipText;
        }
    }

    static final class Builder
    extends Device.Builder {
        @Nullable
        private Icon myIcon;
        @Nullable
        private String myCpuArchitecture;
        private long mySizeOnDisk;
        @NotNull
        private State myState = State.STOPPED;
        @Nullable
        private AvdInfo myAvdInfo;

        Builder() {
        }

        @NotNull
        Builder setKey(@NotNull Key key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        Builder setIcon(@Nullable Icon icon2) {
            this.myIcon = icon2;
            return this;
        }

        @NotNull
        Builder setType(@NotNull DeviceType type) {
            this.myType = type;
            return this;
        }

        @NotNull
        Builder setName(@NotNull String name) {
            this.myName = name;
            return this;
        }

        @NotNull
        Builder setTarget(@NotNull String target2) {
            this.myTarget = target2;
            return this;
        }

        @NotNull
        Builder setCpuArchitecture(@NotNull String cpuArchitecture) {
            this.myCpuArchitecture = cpuArchitecture;
            return this;
        }

        @NotNull
        Builder setAndroidVersion(@NotNull AndroidVersion androidVersion) {
            this.myAndroidVersion = androidVersion;
            return this;
        }

        @NotNull
        Builder setSizeOnDisk(long sizeOnDisk) {
            this.mySizeOnDisk = sizeOnDisk;
            return this;
        }

        @NotNull
        Builder setState(@NotNull State state2) {
            this.myState = state2;
            return this;
        }

        @NotNull
        Builder setResolution(@Nullable Resolution resolution2) {
            this.myResolution = resolution2;
            return this;
        }

        @NotNull
        Builder setDensity(int density) {
            this.myDensity = density;
            return this;
        }

        @NotNull
        Builder addAllAbis(@NotNull @NotNull Collection<@NotNull String> abis) {
            this.myAbis.addAll(abis);
            return this;
        }

        @NotNull
        Builder setStorageDevice(@Nullable StorageDevice storageDevice) {
            this.myStorageDevice = storageDevice;
            return this;
        }

        @NotNull
        Builder setAvdInfo(@NotNull AvdInfo avdInfo) {
            this.myAvdInfo = avdInfo;
            return this;
        }

        @Override
        @NotNull
        protected VirtualDevice build() {
            return new VirtualDevice(this);
        }
    }
}

